<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Подключаем определитель локации
    require_once(ENGINE_DIR . '/mods/location.php');

    // Подключение к базе данных
    require_once(ENGINE_DIR . '/data/dbconfig.php');

    // Инициализация переменной для сообщений
    $message = '';

    if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_feedback'])) {

        // Получаем вопрос безопасности и правильный ответ из базы данных
        $security_question_id = $_POST['security_question_id'];
        $user_answer = trim($_POST['security_answer']);

        // Получаем значения из формы
        $name = trim($_POST['name']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);
        $subject = trim($_POST['subject']);
        $message_content = trim($_POST['message']);
        $ip = $userIp; // Используем IP-адрес из location.php
        $city = $smarty->getTemplateVars('city'); // Получаем город из Smarty

        // Проверка, что все обязательные поля заполнены
        if (empty($name) || empty($email) || empty($phone) || empty($subject) || empty($message_content)) {
            $message = "Пожалуйста, заполните все обязательные поля.";
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $message = "Неверный формат электронной почты.";
        } elseif (!preg_match('/^[0-9\-\+\(\)\s]+$/', $phone)) {
            $message = "Неверный формат телефонного номера.";
        } elseif (strlen($message_content) < 10) {
            $message = "Сообщение должно содержать не менее 10 символов.";
        } else {

            $question = $db_connect->get("security_questions", "*", ["id" => $security_question_id]);

            // Проверка правильности ответа
            if ($question && $user_answer !== $question['answer']) {
                $message = "Неверный ответ на вопрос безопасности.";
            } else {
                $result = $db_connect->insert("feedback_orders", [
                    "name" => $name,
                    "email" => $email,
                    "phone" => $phone,
                    "subject" => $subject,
                    "ip" => $ip,
                    "city" => $city,
                    "message" => $message
                ]);

                // Отправка письма
                $to = $config['feedback_mail'];
                $subject_mail = "Новая заявка на обратную связь: " . $subject;
                $body = "Имя: $name\nЭлектронная почта: $email\nТема: $subject\nСообщение:\n$message_content";
                $headers = "From: " . mb_encode_mimeheader($email, "UTF-8") . "\r\n";
                $headers .= "Content-Type: text/plain; charset=utf-8\r\n";

                // Конвертируем содержание письма в UTF-8
                $subject_mail = mb_convert_encoding($subject_mail, "UTF-8");
                $body = mb_convert_encoding($body, "UTF-8");

                if (mail($to, $subject_mail, $body, $headers)) {
                    $message = "Спасибо! Ваш запрос отправлен!";
                } else {
                    $message = "Ошибка при отправке сообщения.";
                }
            }
        }
    }

    // Передача данных в шаблон
    $smarty->assign('message', $message);