<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    function insertTransaction($transactionId, $fullData, $userIdProp = null)
    {
        global $user_id, $db_connect;

        $db_connect->insert("transactions", [
            "transaction_id" => $transactionId,
            "user_id" => !empty($userIdProp) ? (int)$userIdProp : (int)$user_id,
            "status" => $fullData["status"],
            "action" => $fullData["action"],
            "sum" => (int)$fullData["sum"],
            "payment_method" => $fullData["payment_method"],
            "currency" => $_POST["currency"],
            "date" => $fullData["date"],
            "ip_address" => $fullData["requestFullInfo"]["ipAddress"],
            "location" => $fullData["requestFullInfo"]["location"],
            "device_info" => $fullData["requestFullInfo"]["deviceInfo"],
            "description" => ["description"],
            "commission_fee" => $fullData["fee"],
            "default_redirect" => $_SERVER["HTTP_REFERER"],
            "country" => $fullData["requestFullInfo"]["country"],
            "pdf_url" => $fullData["pdf_url"],
        ]);

        return $db_connect->id();
    }


    function updateTransactionStatus($transactionId, $status)
    {
        global $db_connect;

        $db_connect->update("transactions", [
            "status" => $status
        ], ["transaction_id" => $transactionId]);

    }

    function getTransactionDataByTransactionId($transactionId)
    {
        global $db_connect;
        return $db_connect->get("transactions", "*", ["transaction_id" => $transactionId]);
    }
