<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Сохранение данных в $config с использованием var_export
    $configContent = "<?php\n\$config = " . var_export($config, true) . ";\n";

    // Добавление строки для присвоения значения theme на основе skin
    $configContent .= "\$config['theme'] = '/templates/' . \$config['skin'];\n";

    // Добавление пробела между => и array
    $configContent = preg_replace("/=>\s*array/", "=> array", $configContent);

    // Разбивка на строки и добавление табуляции после первой
    $lines = explode("\n", $configContent);
    foreach ($lines as $i => $line) {
        if ($i !== 0 && trim($line) !== '') {
            $lines[$i] = "\t" . $line;
        }
    }
    $configContent = implode("\n", $lines);

    // Путь к файлу
    $configFilePath = ENGINE_DIR . '/data/config.php';

    // Запись в файл
    $result = file_put_contents($configFilePath, $configContent);

    if ($result === false) {
        die('❌ Не удалось записать в config.php');
    }

    // Очистка файлового кэша
    clearstatcache(true, $configFilePath);

    // Инвалидация OPcache (если включен)
    if (function_exists('opcache_invalidate')) {
        opcache_invalidate($configFilePath, true);
    }


    //sleep(3);