<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    function getUserAccessRights($userGroup) {
        global $db_connect;

        $result = [];
        if (!empty($userGroup)) {
            $rolePermissions = $db_connect->select("role_permissions", "*", ["role_id" => $userGroup]);
            if (!empty($rolePermissions)) {
                foreach ($rolePermissions as $rolePermission) {
                    $result[$db_connect->get("permissions", "code", ["id" => $rolePermission["permission_id"]])] = true;
                }
            }
        }

 /*       if ($result) {
            $create = $result["create"];
            $read = $result["read"];
            $update = $result["update"];
            $del = $result["del"];
            $vote = $result["vote"];
            $download = $result["download"];
            $mna = $result["mna"];
            $mnu = $result["mnu"];
            $mns = $result["mns"];
            $mnr = $result["mnr"];
        }*/
        return $result;
    }
    
    $accessRights = getUserAccessRights($userGroup ?? []) == [] ? [
        "mna" => false
    ] : getUserAccessRights($userGroup ?? []);
    $smarty->assign('access', $accessRights);