<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Инициализируем сессию для просмотра страниц, если еще нет
    if (!isset($_SESSION)) {
        session_start();
    }

    // Получаем alt_name страницы
    $alt_name = $moduletype['alt_name'];

    // Инициализируем сессию для просмотра страниц, если еще нет
    if (!isset($_SESSION['viewed'])) {
        $_SESSION['viewed'] = [];
    }

    $current_time = time();
    $one_day = 86400; // 24 часа в секундах

    // Если пользователь не заходил на эту страницу за последние 24 часа, увеличиваем счетчик
    if (!isset($_SESSION['viewed'][$alt_name]) || ($current_time - $_SESSION['viewed'][$alt_name]) > $one_day) {
        $updated = $db_connect->update('static_pages', [
            'views[+]' => 1 // Увеличиваем поле views на 1
        ], [
            'alt_name' => $alt_name // Условие для обновления
        ]);

// Проверка успешности обновления
        if ($updated) {
            $_SESSION['viewed'][$alt_name] = $current_time;
        } else {
            echo "Ошибка при обновлении количества просмотров: " . $db_connect->error()[2];
        }

// Обновляем время последнего просмотра страницы в сессии
    }