<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once(ENGINE_DIR . '/data/config.php');
require_once ENGINE_DIR.'/payment/systems/general_config.php';
require_once ENGINE_DIR.'/mods/delivery.php';
require_once ENGINE_DIR.'/mods/currency.php';

global $ps_config, $user;

$widgets = $db_connect->select("payment_widgets", "*");

$selectedWidget = $db_connect->get("widget_objects", "*", ["object_id" => $moduletype["id"], "object_name" => $moduleName]);

$selectedWidget = $selectedWidget == null ? [] : $selectedWidget;

$selectedWidgetInfo = [];
if (!empty($selectedWidget)) {
    foreach ($widgets as $widget) {
        if ($selectedWidget['widget_id'] == $widget['id']) {
            $selectedWidgetInfo = $widget;
            break;
        }
    }
}
$isPermittedAddDelete = false;
if (isset($user["name"]) && isset($moduletype["autor"]) && $moduletype["autor"] == $user["name"] || isset($moduletype["author"]) && $moduletype["author"] == $user["name"]) {
    $isPermittedAddDelete = true;
}

$selectedWidgetInfo["c_price"] = !empty($selectedWidgetInfo["price"]) ? convertAmount($selectedWidgetInfo["price"], $config["payment_info"]["default_currency"], getCurrentCurrency()) : 0;

$status = "";
if (!empty($_GET["status"]) && $_GET["status"] == "error") {
    $status = "error";
} else {
    $status = $_GET["status"] ?? "";
}

$smarty->assign("status", $status);
$smarty->assign("isPermitted", $isPermittedAddDelete);
$smarty->assign("currency", getCurrentCurrency());
$smarty->assign("payment_configs", $ps_config);
$smarty->assign("selectedWidgetInfo", count($selectedWidgetInfo) < 1 ? null : $selectedWidgetInfo);
$smarty->assign("selectedWidget", count($selectedWidget) < 1 ? null : $selectedWidget);
$smarty->assign("widgets", $widgets);