<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Запуск сессии
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }

    function loadLanguageFiles($lang_code) {
        global $smarty, $config;
        // Формируем пути к файлам на основе выбранного языка
        $cookiePath = ENGINE_DIR . "/lang/$lang_code/cookies.tpl";
        $policyPath = ENGINE_DIR . "/lang/$lang_code/policy.tpl";
        $termsPath = ENGINE_DIR . "/lang/$lang_code/terms.tpl";
        // Чтение содержимого файлов
        if (file_exists($cookiePath) && file_exists($policyPath) && file_exists($termsPath)) {
            // Если файлы существуют, загружаем их
            $cookieContent = file_get_contents($cookiePath);
            $policyContent = file_get_contents($policyPath);
            $termsContent = file_get_contents($termsPath);
        } else {
            // Если файлы не найдены, используем язык по умолчанию из $config['default_lang']
            $defaultLang = $config['default_lang'];
            $cookieContent = file_get_contents(ENGINE_DIR . "/lang/$defaultLang/cookies.tpl");
            $policyContent = file_get_contents(ENGINE_DIR . "/lang/$defaultLang/policy.tpl");
            $termsContent = file_get_contents(ENGINE_DIR . "/lang/$defaultLang/terms.tpl");
        }
        // Присвоение значений глобальным переменным Smarty
        $smarty->assign('cookies', $cookieContent);
        $smarty->assign('policy', $policyContent);
        $smarty->assign('terms', $termsContent);
        // Присвоение $config глобальной переменной Smarty
        $smarty->assign('config', $config);
    }
    
    // Пример вызова функции
    loadLanguageFiles($lang_code);