<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

global $config;
// Хешированные пароли
$hashPass = password_hash('mds1234', PASSWORD_DEFAULT);
$supportPassHash = password_hash('mds1234', PASSWORD_DEFAULT);
$enabledDatabase = $config["database_settings"]["enabled_database"];
$currentDatabaseSettings = $config["database_settings"][$enabledDatabase];

// Флаг для отслеживания успешности выполнения запросов
$successFlag = true;

if ($config["database_settings"]["enabled_database"] == 'mysql') {
    // Для MySQL
    $tables = $db_connect->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
} elseif ($config["database_settings"]["enabled_database"] == 'pgsql') {
    // Для PostgreSQL
  /*  $tables = $db_connect->query("
        SELECT tablename
        FROM pg_tables
        WHERE schemaname NOT IN ('pg_catalog', 'information_schema')
    ")->fetchAll(PDO::FETCH_COLUMN);*/

    $db_connect->query("DROP SCHEMA public CASCADE");
    $db_connect->query("CREATE SCHEMA public");

    $sql = <<<SQL
        DO $$
        DECLARE
            r RECORD;
        BEGIN
            FOR r IN (SELECT tablename FROM pg_tables WHERE schemaname = 'public') LOOP
                EXECUTE 'DROP TABLE IF EXISTS public.' || quote_ident(r.tablename) || ' CASCADE';
            END LOOP;
        END
        $$;
        SQL;

    $db_connect->query($sql);


} else {
    throw new Exception("Не поддерживаемый тип базы данных");
}

if ($config["database_settings"]["enabled_database"] == 'mysql') {
    $db_connect->query("SET FOREIGN_KEY_CHECKS = 0");
    // Удаляем каждую таблицу
    foreach ($tables as $table) {
        $db_connect->query("DROP TABLE IF EXISTS \"$table\" CASCADE");
    }
    $db_connect->query("SET FOREIGN_KEY_CHECKS = 1");
}

$createTablesPG = [
    'CREATE TABLE IF NOT EXISTS "comments" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор комментария
        "user_id" INT DEFAULT NULL, -- Идентификатор пользователя, который оставил комментарий (если зарегистрирован)
        "author" VARCHAR(255) DEFAULT NULL, -- Имя автора комментария (если оставил как гость)
        "entity_id" INT NOT NULL, -- Идентификатор сущности
        "entity_type" VARCHAR(50) NOT NULL, -- Тип сущности
        "comment_text" TEXT NOT NULL, -- Текст комментария
        "parent_id" INT DEFAULT NULL, -- Идентификатор родительского комментария
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания комментария
        "status" SMALLINT DEFAULT 0 -- Статус комментария (0 - не прочитано, 1 - прочитано)
    );',

    'CREATE TABLE IF NOT EXISTS "widget_objects" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор
        "object_name" VARCHAR(255) NOT NULL, -- Имя объекта
        "object_id" INT NOT NULL, -- Идентификатор объекта
        "widget_name" VARCHAR(255) NOT NULL, -- Имя виджета
        "widget_id" INT NOT NULL, -- Идентификатор виджета
        "active" BOOLEAN DEFAULT TRUE -- Флаг активности (TRUE - активен, FALSE - неактивен)
    );',

    'CREATE TABLE IF NOT EXISTS "deliveries" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор доставки
        "user_id" INT, -- Идентификатор пользователя, если доставка оформлена зарегистрированным пользователем
        "name" VARCHAR(255) NOT NULL, -- Имя получателя
        "country" VARCHAR(100) NOT NULL, -- Страна доставки
        "address" TEXT NOT NULL, -- Адрес доставки (улица, дом, квартира)
        "phone" VARCHAR(20) NOT NULL, -- Номер телефона получателя
        "order_id" VARCHAR(255) NOT NULL, -- Идентификатор заказа, связанного с доставкой
        "delivery_status" VARCHAR(50), -- Статус доставки (pending, shipped, delivered и т.д.)
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания записи
        "updated_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP -- Дата и время последнего обновления записи
    );',

    'CREATE TABLE IF NOT EXISTS "chat_history" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор записи
        "user_id" INT, -- Идентификатор пользователя
        "question" TEXT NOT NULL, -- Вопрос
        "answer" TEXT NOT NULL, -- Ответ
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP -- Дата и время создания записи
    );',

    'CREATE TABLE IF NOT EXISTS "feedback_orders" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор обратной связи
        "name" VARCHAR(255) NOT NULL, -- Имя клиента
        "email" VARCHAR(255) NOT NULL, -- Email клиента
        "phone" VARCHAR(255) NOT NULL, -- Телефон клиента
        "subject" VARCHAR(255), -- Тема сообщения
        "message" TEXT NOT NULL, -- Сообщение клиента
        "ip" VARCHAR(45) NOT NULL, -- IP-адрес клиента
        "city" VARCHAR(255) NOT NULL, -- Город клиента
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания заказа
        "status" BOOLEAN DEFAULT FALSE -- Статус обратной связи (FALSE - не прочитано, TRUE - прочитано)
    );',

    'CREATE TABLE IF NOT EXISTS "groups" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор группы
        "name" VARCHAR(50), -- Название группы
        "create" BOOLEAN DEFAULT FALSE, -- Разрешение на создание (FALSE - нет, TRUE - да)
        "read" BOOLEAN DEFAULT FALSE, -- Разрешение на чтение (FALSE - нет, TRUE - да)
        "update" BOOLEAN DEFAULT FALSE, -- Разрешение на обновление (FALSE - нет, TRUE - да)
        "del" BOOLEAN DEFAULT FALSE, -- Разрешение на удаление (FALSE - нет, TRUE - да)
        "vote" BOOLEAN DEFAULT FALSE, -- Разрешение на голосование (FALSE - нет, TRUE - да)
        "download" BOOLEAN DEFAULT FALSE, -- Разрешение на скачивание (FALSE - нет, TRUE - да)
        "mna" BOOLEAN DEFAULT FALSE, -- Разрешение на доступ в Admin Panel
        "mnu" BOOLEAN DEFAULT FALSE, -- Разрешение на управление пользователями
        "mns" BOOLEAN DEFAULT FALSE, -- Разрешение на управление настройками
        "mnr" BOOLEAN DEFAULT FALSE, -- Разрешение на управление ролями
        "is_static" BOOLEAN DEFAULT FALSE,
        "view_in_registration" BOOLEAN DEFAULT FALSE
    );',

    'CREATE TABLE IF NOT EXISTS "license_keys" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор лицензии
        "license_key" VARCHAR(255) NOT NULL UNIQUE, -- Ключ лицензии (уникальный)
        "domain" VARCHAR(255) NOT NULL, -- Домен, для которого выдана лицензия
        "cms_owner" VARCHAR(255), -- Владелец CMS
        "owner_email" VARCHAR(255), -- Email владельца лицензии
        "created_date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания лицензии
        "version" VARCHAR(255) NOT NULL -- Версия лицензии
    );',

    'CREATE TABLE IF NOT EXISTS "notifications" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор уведомления
        "sender_id" INT NOT NULL,
        "content" TEXT DEFAULT NULL,
        "module_id" INT NOT NULL,
        "module_url" VARCHAR(255) DEFAULT NULL,
        "svg_ico" TEXT DEFAULT NULL,
        "user_id" INT NOT NULL, -- Идентификатор пользователя, которому адресовано уведомление
        "module_type" VARCHAR(255) DEFAULT NULL, -- Тип модуля, к которому относится уведомление
        "language" VARCHAR(190) DEFAULT NULL, -- Язык уведомления
        "status" BOOLEAN DEFAULT FALSE, -- Статус уведомления (FALSE - не прочитано, TRUE - прочитано)
        "details" VARCHAR(255) DEFAULT NULL, -- Дополнительные детали уведомления
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP -- Дата и время создания уведомления
    );',

    'CREATE TABLE IF NOT EXISTS payment_widgets (
        id SERIAL PRIMARY KEY, -- Уникальный идентификатор платежного виджета
        s_date DATE DEFAULT NULL, -- Дата и время создания виджета и начальная дата списаний для рекуррентных платежей
        name VARCHAR(255) NOT NULL, -- Название платежного виджета
        price NUMERIC(10, 2) NOT NULL, -- Цена виджета (Валюта назначается та что по умолчанию из конфига в default_currency)
        price_model SMALLINT DEFAULT 0, -- Модель ценообразования для виджета
        w_type VARCHAR(50) NOT NULL, -- Тип виджета: sale, pay_for_hidden_data, donate
        p_type VARCHAR(50) NOT NULL, -- Тип оплаты: one_time, recurring
        period VARCHAR(50) DEFAULT NULL, -- Периодичность: once, daily, weekly, monthly, yearly
        notify_fr VARCHAR(50) DEFAULT NULL, -- Частота уведомлений: daily, weekly, monthly
        "limit" INT NOT NULL DEFAULT 0, -- Лимит количества проводимых платежей для данного виджета
        edited SMALLINT DEFAULT 0,
        template_name VARCHAR(255) NOT NULL,
        disable_promo BOOLEAN DEFAULT FALSE,
        disable_delivery BOOLEAN DEFAULT FALSE,
        super_donater_sum NUMERIC(10, 2) NOT NULL,
        disable_title BOOLEAN DEFAULT FALSE,
        pay_with_redirect BOOLEAN DEFAULT FALSE,
        disable_sum_input BOOLEAN DEFAULT FALSE,
        uniq_name VARCHAR(255) NOT NULL,
        btn_text VARCHAR(255) NOT NULL,
        settings JSON
    );',


    'CREATE TABLE IF NOT EXISTS "promocodes" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор промокодов
        "code" VARCHAR(20) NOT NULL UNIQUE, -- Код промокода (уникальное значение)
        "discount_percent" DECIMAL(5, 2) NOT NULL, -- Процент скидки
        "valid_from" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата начала действия промокода
        "valid_to" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата окончания действия промокода
        "usage_limit" INT NOT NULL, -- Ограничение на количество использований промокода
        "count" INT NOT NULL DEFAULT 0 -- Счетчик использований промокода
    );',

    'CREATE TABLE IF NOT EXISTS "reviewwidgets" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор виджета отзывов
        "title" VARCHAR(255) NOT NULL, -- Название виджета
        "social" VARCHAR(50) NOT NULL, -- Социальная сеть, связанная с виджетом
        "token" VARCHAR(255) NOT NULL, -- Токен для доступа к API или интеграции
        "resource" VARCHAR(255) NOT NULL, -- Ресурс, на который ссылается виджет
        "entries" VARCHAR(255) DEFAULT NULL, -- Количество записей виджета
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP -- Дата создания виджета
    );',
    'CREATE TABLE IF NOT EXISTS "social_sliders" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор слайдера
        "title" VARCHAR(255) NOT NULL, -- Название слайдера
        "social" VARCHAR(50) NOT NULL, -- Социальная сеть, связанная с слайдером
        "token" VARCHAR(255) NOT NULL, -- Токен для доступа к API или интеграции
        "resource" VARCHAR(255) NOT NULL, -- Ресурс, на который ссылается слайдер
        "rows" VARCHAR(255) DEFAULT NULL, -- Количество рядов слайдера
        "columns" VARCHAR(255) DEFAULT NULL, -- Количество столбцов слайдера
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP -- Дата создания слайдера
    );',

    'CREATE TABLE IF NOT EXISTS "static_pages" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор статической страницы
        "date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания страницы
        "alt_name" VARCHAR(190) DEFAULT NULL, -- Альтернативное имя (URL)
        "language" VARCHAR(190) DEFAULT NULL, -- Язык страницы
        "title" VARCHAR(100) DEFAULT NULL, -- Заголовок страницы
        "full_desc" TEXT DEFAULT NULL, -- Полное описание страницы
        "meta_desc" VARCHAR(300) DEFAULT NULL, -- Мета-описание страницы для SEO
        "meta_keys" TEXT DEFAULT NULL, -- Мета-ключевые слова для SEO
        "full_meta_desc" TEXT DEFAULT NULL, -- Полное описание страницы
        "views" INT DEFAULT 0 -- Количество просмотров страницы
    );',

    'CREATE TABLE IF NOT EXISTS "transactions" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор транзакции
        "user_id" INT DEFAULT NULL, -- Идентификатор пользователя, связанного с транзакцией
        "sum" DECIMAL(10, 2) DEFAULT NULL, -- Сумма транзакции
        "status" VARCHAR(20) DEFAULT NULL, -- Статус транзакции (pending, completed, failed, refunded)
        "action" VARCHAR(255) DEFAULT NULL, -- Тип действия (например, покупка, возврат, вывод)
        "transaction_id" VARCHAR(255) DEFAULT NULL, -- Уникальный идентификатор для внешних систем (платежный шлюз)
        "payment_method" VARCHAR(50) DEFAULT NULL, -- Метод оплаты (например, credit_card, paypal, bank_transfer, crypto)
        "currency" VARCHAR(10) DEFAULT NULL, -- Валюта транзакции (например, USD, EUR)
        "date" TIMESTAMP DEFAULT NULL, -- Дата и время совершения транзакции
        "description" TEXT DEFAULT NULL, -- Описание транзакции
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания записи
        "updated_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата последнего обновления записи
        "ip_address" VARCHAR(45) DEFAULT NULL, -- IP-адрес, с которого инициирована транзакция
        "device_info" TEXT DEFAULT NULL, -- Информация об устройстве пользователя (например, User-Agent)
        "location" VARCHAR(255) DEFAULT NULL, -- Местоположение пользователя (страна, город)
        "is_recurring" BOOLEAN DEFAULT FALSE, -- Флаг повторяющейся транзакции (например, подписка)
        "tax_amount" DECIMAL(10, 2) DEFAULT NULL, -- Сумма налога, если применимо
        "commission_fee" DECIMAL(10, 2) DEFAULT NULL, -- Комиссия за транзакцию, если применимо
        "default_redirect" VARCHAR(255) DEFAULT NULL, -- Тип действия (например, покупка, возврат, вывод)
        "country" VARCHAR(255) DEFAULT NULL,
        "referral_code" VARCHAR(50) DEFAULT NULL -- Реферальный код, использованный для транзакции
    );',

    'CREATE TABLE IF NOT EXISTS "users" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор пользователя
        "email" VARCHAR(50) DEFAULT NULL, -- Email пользователя
        "password" VARCHAR(255) DEFAULT NULL, -- Пароль пользователя (зашифрованный)
        -- "group" INT DEFAULT NULL, -- Группа пользователя (права доступа)
        "name" VARCHAR(50) DEFAULT NULL, -- Имя пользователя
        "age" SMALLINT DEFAULT NULL, -- Возраст пользователя
        "phone" VARCHAR(50) DEFAULT NULL, -- Телефон пользователя
        "city" VARCHAR(190) DEFAULT NULL, -- Город пользователя
        "gender" VARCHAR(20) DEFAULT NULL, -- Пол пользователя
        "balance" DECIMAL(10, 2) DEFAULT NULL, -- Баланс пользователя
        "avatar" VARCHAR(255) DEFAULT NULL, -- URL аватара пользователя
        "bg_image" VARCHAR(255) DEFAULT NULL, -- URL фонового изображения пользователя
        "followers" INT DEFAULT 0, -- Количество подписчиков
        "likes" INT DEFAULT 0, -- Количество лайков
        "views" INT DEFAULT 0, -- Количество просмотров профиля
        "bio" TEXT, -- Биография пользователя
        "pay_methods" TEXT, -- Способы оплаты, доступные для пользователя
        "purchases" INT DEFAULT 0, -- Количество покупок пользователя
        "sales" INT DEFAULT 0, -- Количество продаж пользователя
        "lastdate" TIMESTAMP DEFAULT NULL, -- Дата последнего визита пользователя
        "regdate" TIMESTAMP DEFAULT NULL, -- Дата регистрации пользователя
        "banned" BOOLEAN DEFAULT FALSE, -- Флаг заблокированного пользователя (TRUE - забанен, FALSE - нет)
        "allowpm" BOOLEAN DEFAULT TRUE, -- Разрешены ли личные сообщения (TRUE - да, FALSE - нет)
        "allpm" INT DEFAULT 0, -- Общее количество полученных личных сообщений
        "pmunread" INT DEFAULT 0, -- Количество непрочитанных личных сообщений
        "detected_location_id" INT DEFAULT 0,
        "auth_source" VARCHAR(20) DEFAULT NULL,
        "referral_code" VARCHAR(255) DEFAULT NULL, -- URL аватара пользователя
        "status" VARCHAR(255) DEFAULT NULL, -- URL фонового изображения пользователя
        "referrer_id" INT DEFAULT NULL -- Группа пользователя (права доступа)
    );',

    'CREATE TABLE IF NOT EXISTS "comment_subscriptions" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор подписки на комментарий
        "user_id" INTEGER NOT NULL, -- Идентификатор пользователя, который подписан
        "comment_id" INTEGER NOT NULL -- Идентификатор подписанного комментария
    );',

    'CREATE TABLE IF NOT EXISTS "flood" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор
        "user" INTEGER NOT NULL, -- Идентификатор пользователя
        "ip" VARCHAR(45) NOT NULL, -- IP-адрес пользователя
        "date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время активности
        "period" INTEGER NOT NULL, -- Период, в течение которого активность считается flood
        "reason" TEXT DEFAULT NULL -- Причина блокировки пользователя
    );',

    'CREATE TABLE IF NOT EXISTS "messages" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор сообщения
        "sender_id" INTEGER DEFAULT NULL, -- ID отправителя (пользователя)
        "sender_name" VARCHAR(190) DEFAULT NULL, -- Имя отправителя (пользователя)
        "receiver_id" INTEGER DEFAULT NULL, -- ID получателя (пользователя)
        "ticket_id" INTEGER DEFAULT NULL,
        "is_support" BOOLEAN DEFAULT FALSE, 
        "message" TEXT NOT NULL, -- Текст сообщения
        "file_path" VARCHAR(190) DEFAULT NULL,
        "img_path" VARCHAR(190) DEFAULT NULL,
        "del_for" INTEGER DEFAULT NULL,
        "reply_to_id" INTEGER DEFAULT NULL,
        "updated_at" TIMESTAMP DEFAULT NULL,
        "is_read" BOOLEAN DEFAULT FALSE, -- Статус прочтения сообщения (FALSE - не прочитано, TRUE - прочитано)
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP -- Дата создания сообщения
    );',

    'CREATE TABLE IF NOT EXISTS "sales" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор продажи
        "product_id" INTEGER NOT NULL, -- ID продаваемого продукта
        "user_id" INTEGER NOT NULL, -- ID пользователя, который совершил покупку
        "quantity" INTEGER NOT NULL, -- Количество проданного товара
        "sale_date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP -- Дата продажи
    );',
    'CREATE TABLE IF NOT EXISTS "security_questions" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор вопроса безопасности
        "language" VARCHAR(190) DEFAULT NULL, -- Язык вопроса безопасности
        "question" VARCHAR(255) NOT NULL, -- Текст вопроса безопасности
        "answer" VARCHAR(255) NOT NULL -- Ответ на вопрос безопасности
    );',

    'CREATE TABLE IF NOT EXISTS "spam" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор
        "user" INTEGER NOT NULL, -- Идентификатор пользователя
        "ip" VARCHAR(45) NOT NULL, -- IP-адрес пользователя
        "date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время активности
        "period" INTEGER NOT NULL, -- Период блокировки за спам
        "reason" TEXT DEFAULT NULL, -- Причина блокировки
        FOREIGN KEY ("user") REFERENCES "users"("id") -- Внешний ключ на пользователя
    );',

//    'CREATE TABLE IF NOT EXISTS "subscriptions" (
//        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор подписки
//        "user_id" INTEGER NOT NULL, -- Идентификатор пользователя, который подписан
//        "email" VARCHAR(255) NOT NULL, -- Email пользователя
//        "subject" INTEGER NOT NULL, -- Идентификатор подписанного модуля
//        "created_date" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, -- Дата, когда произошла подписка
//        "expiration" TIMESTAMP NULL, -- Дата истечения подписки
//        "type" VARCHAR(15) NOT NULL, -- Тип подписки (free, premium, pro)
//        "status" VARCHAR(15) NOT NULL, -- Статус подписки (active, inactive, canceled)
//        FOREIGN KEY ("user_id") REFERENCES "users"("id") -- Внешний ключ на пользователя
//    );',

    'CREATE TABLE IF NOT EXISTS "tasks" (
        "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор задачи
        "title" VARCHAR(100) DEFAULT NULL, -- Заголовок задачи
        "author" VARCHAR(50) DEFAULT NULL, -- Имя автора задачи
        "date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания задачи
        "description" TEXT DEFAULT NULL, -- Описание задачи
        "status" VARCHAR(10) NOT NULL, -- Статус задачи (например, "новая", "выполнена" и т.д.)
        "views" INTEGER DEFAULT 0 -- Количество просмотров задачи
    );',

    'CREATE TABLE IF NOT EXISTS "referral_rewards" (
        "reward_id" SERIAL PRIMARY KEY,
        "referrer_id" INT REFERENCES users(id),
        "referred_user_id" INT REFERENCES users(id),
        "transaction_id" INT REFERENCES transactions(id),
        "reward_amount" DECIMAL(10, 2) NOT NULL,
        "reward_percentage" DECIMAL(5, 2),
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "user_applications" (
        "id" SERIAL PRIMARY KEY,
        "user_id" INT NOT NULL,
        "group_id" INT NOT NULL,
        "json_data" JSON,
        "payed_status" VARCHAR(255),
        "status" VARCHAR(255)
    );',

    'CREATE TABLE IF NOT EXISTS "registration_custom_fields" (
        "id" SERIAL PRIMARY KEY,
        "name" VARCHAR(255) NOT NULL,
        "type" VARCHAR(255) NOT NULL,
        "options" TEXT,
        "required" BOOLEAN DEFAULT FALSE,
        "group_id" INT NOT NULL,
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "user_custom_fields" (
        "id" SERIAL PRIMARY KEY,
        "user_id" INT NOT NULL, 
        "field_id" INT NOT NULL, 
        "value" TEXT NOT NULL, 
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        CONSTRAINT fk_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        CONSTRAINT fk_field FOREIGN KEY (field_id) REFERENCES registration_custom_fields(id) ON DELETE CASCADE
    );',

    'CREATE TABLE IF NOT EXISTS "counters" (
        "id" SERIAL PRIMARY KEY,
        "name" VARCHAR(255) NOT NULL,  
        "value" INT NOT NULL DEFAULT 0,       -- Текущее значение
        "counter_type" VARCHAR(255),
        "object_type" VARCHAR(255),
        "widget_name" VARCHAR(255) UNIQUE NOT NULL,  -- Название счётчика (например, "users_registered")
        "counter_sub_object" VARCHAR(255),
        "from_count" INT NOT NULL DEFAULT 0,       -- От
        "to_count" INT NOT NULL DEFAULT 0,       -- До
        "uniq_name" VARCHAR(255),
        "template_name" VARCHAR(255),
        "active" BOOLEAN DEFAULT FALSE
    );',

    'CREATE TABLE IF NOT EXISTS "participations" (
        "id" SERIAL PRIMARY KEY,
        "name" VARCHAR(255) NOT NULL,  
        "group_id" INT NOT NULL DEFAULT 0, 
        "uniq_name" VARCHAR(255),
        "participation_type" VARCHAR(255),
        settings JSON,
        "template_name" VARCHAR(255) NOT NULL,
        "max_user_count" INT NOT NULL DEFAULT 0
    );',

    'CREATE TABLE IF NOT EXISTS "participation_users" (
        "id" SERIAL PRIMARY KEY,
        "participation_id" INT NOT NULL DEFAULT 0 REFERENCES participations(id) ON DELETE CASCADE, 
        "winned" INT NOT NULL DEFAULT 0, 
        "hash" VARCHAR(255),
        "user_id" INT NOT NULL DEFAULT 0
    );',

    'CREATE TABLE IF NOT EXISTS top_donaters (
        id SERIAL PRIMARY KEY,
        user_id INT NOT NULL DEFAULT 0,
        transaction_id INT NOT NULL DEFAULT 0
    );',


    'CREATE TABLE IF NOT EXISTS "subscriptions" (
        "id" SERIAL PRIMARY KEY,
        "name" VARCHAR(255) NOT NULL,
        "widget_id" INT NOT NULL,
        "duration_days" INT NOT NULL,
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "user_subscriptions" (
        "id" SERIAL PRIMARY KEY,
        "user_id" INT NOT NULL,
        "subscription_id" INT NOT NULL,
        "start_date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "end_date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "status" VARCHAR(255) NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS "referral_settings" (
        "id" SERIAL PRIMARY KEY,
        "object_name" VARCHAR(255) NOT NULL,
        "object_type" VARCHAR(100) NOT NULL,
        "object_id" BIGINT NOT NULL,
        "discount_percent" NUMERIC(5,2) DEFAULT 0.00,
        "discount_sum" NUMERIC(10,2) DEFAULT 0.00,
        "operations" JSON NOT NULL,
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "updated_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "tokens" (
        "id" SERIAL PRIMARY KEY,
        "user_id" INTEGER DEFAULT NULL,
        "guest_id" VARCHAR(255) DEFAULT NULL,
        "token" VARCHAR(255) NOT NULL,
        "target" VARCHAR(255),
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "active" BOOLEAN DEFAULT TRUE
    );',

    'CREATE TABLE IF NOT EXISTS "user_blocks" (
        "id" SERIAL PRIMARY KEY,
        "blocker_id" INTEGER NOT NULL,
        "blocked_id" INTEGER NOT NULL,
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "chat_deletions" (
        "id" SERIAL PRIMARY KEY,
        "user_id" INTEGER NOT NULL,        -- ID пользователя, который удаляет чат
        "chat_id" INTEGER NOT NULL,        -- ID чата
        "chat_type" VARCHAR(50),
        "deleted_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "user_relationships" (
        "id" SERIAL PRIMARY KEY,
        "user_id_from" INTEGER NOT NULL,
        "user_id_to" INTEGER NOT NULL,
        "can_message" BOOLEAN DEFAULT FALSE,
        "is_blocked" BOOLEAN DEFAULT FALSE,
        "is_mutual" BOOLEAN DEFAULT FALSE,
        "is_support" BOOLEAN DEFAULT FALSE,
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "updated_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "chat_groups" (
        "id" SERIAL PRIMARY KEY,
        "name" VARCHAR(255) NOT NULL,
        "is_private" BOOLEAN DEFAULT FALSE,
        "created_by" INTEGER NOT NULL,
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "group_members" (
        "id" SERIAL PRIMARY KEY,
        "group_id" INTEGER NOT NULL,
        "user_id" INTEGER DEFAULT NULL,
        "guest_id" VARCHAR(50) DEFAULT NULL,
        "role" VARCHAR(50),
        "joined_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "group_messages" (
        "id" SERIAL PRIMARY KEY,
        "group_id" INTEGER DEFAULT NULL,
        "sender_id" INTEGER DEFAULT NULL,
        "content" TEXT,
        "message_type" VARCHAR(50), 
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "updated_at" TIMESTAMP,
        "file_path" VARCHAR(255),
        "img_path" VARCHAR(255),
        "reply_to_id" INTEGER
    );',

    'CREATE TABLE IF NOT EXISTS "chat_complaints" (
        "id" SERIAL PRIMARY KEY,
        "message_id" BIGINT DEFAULT NULL,
        "reporter_user_id" BIGINT NOT NULL,
        "reported_user_id" BIGINT NOT NULL,
        "reason" TEXT,
        "status" VARCHAR(32),
        "chat_type" VARCHAR(32),
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "reviewed_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',


    'CREATE TABLE IF NOT EXISTS "tickets" (
        "id" SERIAL PRIMARY KEY,
        "user_id" INTEGER NOT NULL,
        "support_u_id" BIGINT NOT NULL,
        "subject" VARCHAR(255) NOT NULL,
        "title" VARCHAR(255) NOT NULL,
        "status" VARCHAR(50) DEFAULT NULL,
        "priority" VARCHAR(50) DEFAULT NULL,
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "updated_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "user_requests" (
        "id" SERIAL PRIMARY KEY,
        "request_sender_user_id" INTEGER NOT NULL,
        "request_type" VARCHAR(50) NOT NULL,
        "request_id" INT NOT NULL,
        "request_owner_user_id" BIGINT NOT NULL,
        "request_options" JSON NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS "walls" (
        "id" SERIAL PRIMARY KEY,
        "owner_id" INT NOT NULL,
        "title" VARCHAR(255),
        "uniq_name" VARCHAR(255),
        "template_name" VARCHAR(255),
        "description" TEXT,
        "visibility_type" SMALLINT DEFAULT NULL,     -- 1 = public, 2 = private, 3 = restricted
        "posting_access_type" SMALLINT DEFAULT NULL, -- 1 = all, 2 = followers, 3 = owner_only
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "settings" JSON,
        "updated_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "wall_followers" (
        "id" SERIAL PRIMARY KEY,
        "wall_id" INT NOT NULL,
        "user_id" INT NOT NULL,
        "role_type" SMALLINT DEFAULT 1, -- 1 = follower, 2 = editor, 3 = moderator
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "posts" (
        "id" SERIAL PRIMARY KEY,
        "wall_id" INT NOT NULL,
        "author_id" INT NOT NULL,
        "content" TEXT,
        "post_type" SMALLINT DEFAULT 1,   -- 1 = text, 2 = image, 3 = video, 4 = mixed, 5 = ad
        "status_type" SMALLINT DEFAULT 1, -- 1 = published, 2 = draft, 3 = archived
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        "updated_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS "post_media" (
        "id" SERIAL PRIMARY KEY,
        "post_id" INT NOT NULL,
        "media_type" SMALLINT DEFAULT 1, -- 1 = image, 2 = video
        "url" TEXT,
        "thumbnail_url" TEXT,
        "order_index" INT DEFAULT 0
    );',

    'CREATE TABLE IF NOT EXISTS "likes" (
        "id" SERIAL PRIMARY KEY,
        "post_id" INT NOT NULL,
        "user_id" INT NOT NULL,
        "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS client_version (
        id SERIAL PRIMARY KEY,
        version VARCHAR(255),
        client_url VARCHAR(255) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS quiz (
        id SERIAL PRIMARY KEY,
        uniq_name VARCHAR(255) NOT NULL UNIQUE,
        main_title VARCHAR(255) NOT NULL,
        type VARCHAR(50) NOT NULL,
        price INT NOT NULL DEFAULT 0,
        template_name VARCHAR(255) NOT NULL,
        by_country BOOLEAN NOT NULL DEFAULT FALSE
    );',

    'CREATE TABLE IF NOT EXISTS quiz_questions (
        id SERIAL PRIMARY KEY,
        quiz_id INT NOT NULL REFERENCES quiz(id) ON DELETE CASCADE,
        question TEXT NOT NULL,
        image VARCHAR(255),
        settings JSON NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS quiz_answers (
        id SERIAL PRIMARY KEY,
        quiz_question_id INT NOT NULL REFERENCES quiz_questions(id) ON DELETE CASCADE,
        answer TEXT NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS quiz_participations (
        id SERIAL PRIMARY KEY,
        user_id INT NOT NULL,
        quiz_question_id INT NOT NULL REFERENCES quiz_questions(id) ON DELETE CASCADE,
        country VARCHAR(255),
        selected_option VARCHAR(255) NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS versions (
        id SERIAL PRIMARY KEY,
        system_version VARCHAR(50) NOT NULL UNIQUE,
        release_date TIMESTAMP NOT NULL,
        description TEXT,
        file_path VARCHAR(255) NOT NULL,
        checksum_sum CHAR(64) NOT NULL,
        is_active BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS locations (
        id SERIAL PRIMARY KEY,
        parent_id INT DEFAULT NULL, -- без каскадов
        name VARCHAR(255) DEFAULT NULL,             -- Название ("США", "Пенсильвания", "Филадельфия")
        type VARCHAR(50) DEFAULT NULL,              -- Уровень: country, state, city, district, street
        slug VARCHAR(255),                      -- опционально: код ("US", "PA")
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS location_list (
        id SERIAL PRIMARY KEY,
        user_id INT DEFAULT NULL,                           -- кому принадлежит список
        location_id INT NOT NULL ,
        entity_id INT DEFAULT NULL,
        entity_type VARCHAR(50) DEFAULT NULL,
        list_type VARCHAR(20) DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS location_translations (
        id SERIAL PRIMARY KEY,
        location_id INT NOT NULL,
        language_code VARCHAR(20) NOT NULL,
        name VARCHAR(255) NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS access_control (
        id SERIAL PRIMARY KEY,
        group_id INT DEFAULT NULL,
        resource_id INT DEFAULT NULL,
        resource_type VARCHAR(50) DEFAULT NULL,
        list_type VARCHAR(50) DEFAULT NULL,
        location_id INT DEFAULT NULL,
        can_read BOOLEAN DEFAULT FALSE
    );',

    'CREATE TABLE IF NOT EXISTS punishment_types (
        id SERIAL PRIMARY KEY,
        name VARCHAR(250) NOT NULL,       -- "30min", "1hour", "1day", "1week", "forever"
        duration_seconds INT NOT NULL    -- длительность в секундах для удобного расчета
    );',

    'CREATE TABLE IF NOT EXISTS user_punishments (
        id SERIAL PRIMARY KEY,
        user_id INT DEFAULT NULL,             -- null для незарегистрированных
        ip_address VARCHAR(45) DEFAULT NULL,  -- для незарегистрированных
        comment_id INT DEFAULT NULL,          -- при нарушении конкретного комментария
        punishment_type_id INT NOT NULL,      -- ссылка на punishment_types
        expires_at TIMESTAMP NOT NULL,        -- время истечения наказания
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        CONSTRAINT fk_comment FOREIGN KEY (comment_id) REFERENCES comments(id) ON DELETE SET NULL,
        CONSTRAINT fk_punishment_type FOREIGN KEY (punishment_type_id) REFERENCES punishment_types(id) ON DELETE RESTRICT
    );',

    'CREATE INDEX idx_user_id ON user_punishments(user_id);',
    'CREATE INDEX idx_ip_address ON user_punishments(ip_address);',

    'CREATE TABLE IF NOT EXISTS banned_words (
        id SERIAL PRIMARY KEY,
        word VARCHAR(255) NOT NULL UNIQUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS punishment_logs (
        id SERIAL PRIMARY KEY,
        user_id INT DEFAULT NULL,
        ip_address VARCHAR(45) DEFAULT NULL,
        comment_id INT DEFAULT NULL,
        banned_word VARCHAR(255) NOT NULL,
        punishment_id INT DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        CONSTRAINT fk_punishment FOREIGN KEY (punishment_id) REFERENCES user_punishments(id) ON DELETE CASCADE
    );'


];
// Массив с запросами на создание таблиц
$createTablesMySQL = [
    'CREATE TABLE IF NOT EXISTS comments (
        id INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор комментария
        user_id INT DEFAULT NULL,           -- Идентификатор пользователя (если зарегистрирован)
        author VARCHAR(255) DEFAULT NULL,   -- Имя автора комментария (если гость)
        entity_id INT NOT NULL,             -- Идентификатор сущности
        entity_type VARCHAR(50) NOT NULL,   -- Тип сущности
        comment_text TEXT NOT NULL,         -- Текст комментария
        parent_id INT DEFAULT NULL,         -- Идентификатор родительского комментария
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания
        status SMALLINT DEFAULT 0,          -- Статус комментария (0 - не прочитано, 1 - прочитано)
    
        PRIMARY KEY (id),                   -- Обязательный первичный ключ
        INDEX comments_user_id_idx (user_id),
        INDEX comments_entity_idx (entity_id, entity_type),
        INDEX comments_parent_id_idx (parent_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;',

    'CREATE TABLE IF NOT EXISTS `widget_objects` (
            `id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
            `object_name` VARCHAR(255) NOT NULL, -- Имя объекта
            `object_id` INT(11) NOT NULL, -- Идентификатор объекта
            `widget_name` VARCHAR(255) NOT NULL, -- Имя виджета
            `widget_id` INT(11) NOT NULL, -- Идентификатор виджета
            `active` TINYINT(1) DEFAULT 1, -- Флаг активности (1 - активен, 0 - неактивен)
            PRIMARY KEY (`id`), -- Основной ключ
            INDEX (`object_id`), -- Индекс для ускорения поиска по object_id
            INDEX (`widget_id`) -- Индекс для ускорения поиска по widget_id
        ) ENGINE=INNODB DEFAULT CHARSET=utf8;',

    'CREATE TABLE IF NOT EXISTS `deliveries` (
            `id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор доставки
            `user_id` INT(11) DEFAULT NULL, -- Идентификатор пользователя, если доставка оформлена зарегистрированным пользователем
            `name` VARCHAR(255) NOT NULL, -- Имя получателя
            `country` VARCHAR(100) NOT NULL, -- Страна доставки
            `address` TEXT NOT NULL, -- Адрес доставки (улица, дом, квартира)
            `phone` VARCHAR(20) NOT NULL, -- Номер телефона получателя
            `order_id` VARCHAR(255) NOT NULL, -- Идентификатор заказа, связанного с доставкой
            `delivery_status` VARCHAR(50), -- Статус доставки (pending, shipped, delivered и т.д.)
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания записи
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, -- Дата и время последнего обновления записи
            PRIMARY KEY (`id`), -- Основной ключ (уникальный идентификатор доставки)
            INDEX (`user_id`), -- Индекс для ускорения поиска записей по идентификатору пользователя
            INDEX (`order_id`), -- Индекс для ускорения поиска записей по идентификатору заказа
            INDEX (`delivery_status`) -- Индекс для ускорения поиска записей по статусу доставки
        ) ENGINE=INNODB DEFAULT CHARSET=utf8;',

    'CREATE TABLE IF NOT EXISTS `chat_history` (
			`id` INT(11) NOT NULL AUTO_INCREMENT,
			`user_id` INT(11) DEFAULT NULL,
			`question` TEXT NOT NULL,
			`answer` TEXT NOT NULL,
			`created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `feedback_orders` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор обратной связи
			`name` VARCHAR(255) NOT NULL, -- Имя клиента
			`email` VARCHAR(255) NOT NULL, -- Email клиента
			`phone` VARCHAR(255) NOT NULL, -- Телефон клиента
			`subject` VARCHAR(255) DEFAULT NULL, -- Тема сообщения
			`message` TEXT NOT NULL, -- Сообщение клиента
			`ip` VARCHAR(45) NOT NULL, -- IP-адрес клиента
			`city` VARCHAR(255) NOT NULL, -- Город клиента
			`created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания заказа
			`status` TINYINT(1) DEFAULT 0, -- Статус обратной связи (0 - не прочитано, 1 - прочитано)
			PRIMARY KEY (`id`) -- Основной ключ (уникальный идентификатор)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS roles (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) NOT NULL UNIQUE,
        parent_id INT NULL,
        description TEXT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (parent_id) REFERENCES roles(id) ON DELETE SET NULL
    ) ENGINE=INNODB DEFAULT CHARSET=utf8;',

    'CREATE TABLE IF NOT EXISTS permissions (
        id INT AUTO_INCREMENT PRIMARY KEY,
        code VARCHAR(150) NOT NULL UNIQUE, -- Напр. user.create
        module VARCHAR(100) NOT NULL,      -- users, shop
        description TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=INNODB DEFAULT CHARSET=utf8;',

    'CREATE TABLE IF NOT EXISTS role_permissions (
        role_id INT NOT NULL,
        permission_id INT NOT NULL,
        allow TINYINT(1) NOT NULL,        -- 1 allow, 0 deny
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY(role_id, permission_id),
        FOREIGN KEY (role_id) REFERENCES roles(id) ON DELETE CASCADE,
        FOREIGN KEY (permission_id) REFERENCES permissions(id) ON DELETE CASCADE
    ) ENGINE=INNODB DEFAULT CHARSET=utf8;',

    'CREATE TABLE IF NOT EXISTS users_roles (
        user_id INT NOT NULL,
        role_id INT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=INNODB DEFAULT CHARSET=utf8;',

    'CREATE TABLE IF NOT EXISTS `license_keys` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор лицензии
			`license_key` VARCHAR(255) NOT NULL UNIQUE, -- Ключ лицензии (уникальный)
			`domain` VARCHAR(255) NOT NULL, -- Домен, для которого выдана лицензия
			`cms_owner` VARCHAR(255), -- Владелец CMS
			`owner_email` VARCHAR(255), -- Email владельца лицензии
			`created_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания лицензии
			`version` VARCHAR(255) NOT NULL, -- Версия лицензии
			PRIMARY KEY (`id`), -- Основной ключ (уникальный идентификатор)
			INDEX (`license_key`) -- Индекс для ускорения поиска по ключу лицензии
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `notifications` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор уведомления
            "sender_id" INT NOT NULL,
            "content" TEXT DEFAULT NULL,
            "module_id" INT NOT NULL,
            "module_url" VARCHAR(255) DEFAULT NULL,
            "svg_ico" TEXT DEFAULT NULL,
			`user_id` INT NOT NULL, -- Идентификатор пользователя, которому адресовано уведомление
			`module_type` VARCHAR(255) DEFAULT NULL, -- Тип модуля, к которому относится уведомление
			`language` VARCHAR(190) DEFAULT NULL, -- Язык уведомления
			`status` TINYINT(1) DEFAULT 0, -- Статус уведомления (0 - не прочитано, 1 - прочитано)
			`details` VARCHAR(255) DEFAULT NULL, -- Дополнительные детали уведомления
			`created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания уведомления
			PRIMARY KEY (`id`) -- Основной ключ (уникальный идентификатор)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `payment_widgets` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор платежного виджета
			`s_date` DATE DEFAULT NULL, -- Дата и время создания виджета и начальная дата списаний для рекуррентных платежей
			`name` VARCHAR(255) NOT NULL, -- Название платежного виджета
			`price` DECIMAL(10, 2) NOT NULL, -- Цена виджета (Валюта назначается та что по умолчанию из конфига в default_currency)
			`price_model` TINYINT(1) DEFAULT 0, -- Модель ценообразования для виджета
			`w_type` VARCHAR(50) NOT NULL, -- Тип виджета: sale (Продажа), pay_for_hidden_data (Оплата скрытых данных), donate (Донат)
			`p_type` VARCHAR(50) NOT NULL, -- Тип оплаты: one_time (единоразовый), recurring (рекуррентный)
			`period` VARCHAR(50) DEFAULT NULL, -- Периодичность: once (единоразовый), daily (ежедневно), weekly (еженедельно), monthly (ежемесячно), yearly (ежегодно)
			`notify_fr` VARCHAR(50) DEFAULT NULL, -- Частота уведомлений: daily (ежедневно), weekly (еженедельно), monthly (ежемесячно)
			`limit` INT(11) NOT NULL DEFAULT 0, -- Лимит количества проводимых платежей для данного виджета
			`edited` TINYINT(1) DEFAULT 0,
            `template_name` VARCHAR(255) NOT NULL,
            "disable_promo" BOOLEAN DEFAULT FALSE,
            "disable_delivery" BOOLEAN DEFAULT FALSE,
            `super_donater_sum` DECIMAL(10, 2) NOT NULL,
            "disable_title" BOOLEAN DEFAULT FALSE,
            "pay_with_redirect" BOOLEAN DEFAULT FALSE,
            "disable_sum_input" BOOLEAN DEFAULT FALSE,
            `uniq_name` VARCHAR(255) NOT NULL,
            `btn_text` VARCHAR(255) NOT NULL,
            `settings` JSON,
			PRIMARY KEY (`id`) -- Основной ключ (уникальный идентификатор)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `promocodes` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор промокодов
			`code` VARCHAR(20) NOT NULL, -- Код промокода
			`discount_percent` DECIMAL(5, 2) NOT NULL, -- Процент скидки
			`valid_from` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата начала действия промокода
			`valid_to` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата окончания действия промокода
			`usage_limit` INT NOT NULL, -- Ограничение на количество использований промокода
			`count` INT NOT NULL DEFAULT 0, -- Счетчик использований промокода
			PRIMARY KEY (`id`), -- Первичный ключ по идентификатору
			UNIQUE KEY (`code`) -- Уникальный индекс для кода промокода
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `reviewwidgets` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор виджета отзывов
			`title` VARCHAR(255) NOT NULL, -- Название виджета
			`social` VARCHAR(50) NOT NULL, -- Социальная сеть, связанная с виджетом
			`token` VARCHAR(255) NOT NULL, -- Токен для доступа к API или интеграции
			`resource` VARCHAR(255) NOT NULL, -- Ресурс, на который ссылается виджет
			`entries` VARCHAR(255) DEFAULT NULL, -- Количество записей виджета
			`created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания виджета
			PRIMARY KEY (`id`) -- Первичный ключ по идентификатору
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `social_sliders` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор слайдера
			`title` VARCHAR(255) NOT NULL, -- Название слайдера
			`social` VARCHAR(50) NOT NULL, -- Социальная сеть, связанная с слайдером
			`token` VARCHAR(255) NOT NULL, -- Токен для доступа к API или интеграции
			`resource` VARCHAR(255) NOT NULL, -- Ресурс, на который ссылается слайдер
			`rows` VARCHAR(255) DEFAULT NULL, -- Количество рядов слайдера
			`columns` VARCHAR(255) DEFAULT NULL, -- Количество столбцов слайдера
			`created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания слайдера
			PRIMARY KEY (`id`) -- Первичный ключ по идентификатору
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `static_pages` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор статической страницы
			`date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания страницы
			`alt_name` VARCHAR(190) DEFAULT NULL, -- Альтернативное имя (URL)
			`language` VARCHAR(190) DEFAULT NULL, -- Язык страницы
			`title` VARCHAR(100) DEFAULT NULL, -- Заголовок страницы
			`full_desc` MEDIUMTEXT DEFAULT NULL, -- Полное описание страницы
			`meta_desc` VARCHAR(300) DEFAULT NULL, -- Мета-описание страницы для SEO
			`meta_keys` TEXT DEFAULT NULL, -- Мета-ключевые слова для SEO
			`views` INT DEFAULT 0, -- Количество просмотров страницы
             `full_meta_desc` TEXT DEFAULT NULL, -- Полное описание страницы
			PRIMARY KEY (`id`) -- Первичный ключ по идентификатору
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `transactions` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор транзакции
			`user_id` INT(11) DEFAULT NULL, -- Идентификатор пользователя, связанного с транзакцией
			`sum` DECIMAL(10, 2) DEFAULT NULL, -- Сумма транзакции
			`status` VARCHAR(20) DEFAULT NULL, -- Статус транзакции (pending, completed, failed, refunded)
			`action` VARCHAR(255) DEFAULT NULL, -- Тип действия (например, покупка, возврат, вывод)
			`transaction_id` VARCHAR(255) DEFAULT NULL, -- Уникальный идентификатор для внешних систем (платежный шлюз)
			`payment_method` VARCHAR(50) DEFAULT NULL, -- Метод оплаты (например, credit_card, paypal, bank_transfer, crypto)
			`currency` VARCHAR(10) DEFAULT NULL, -- Валюта транзакции (например, USD, EUR)
			`date` DATETIME DEFAULT NULL, -- Дата и время совершения транзакции
			`description` TEXT DEFAULT NULL, -- Описание транзакции
			`created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время создания записи
			`updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, -- Дата последнего обновления записи
			`ip_address` VARCHAR(45) DEFAULT NULL, -- IP-адрес, с которого инициирована транзакция
			`device_info` TEXT DEFAULT NULL, -- Информация об устройстве пользователя (например, User-Agent)
			`location` VARCHAR(255) DEFAULT NULL, -- Местоположение пользователя (страна, город)
			`is_recurring` TINYINT(1) DEFAULT 0, -- Флаг повторяющейся транзакции (например, подписка)
			`tax_amount` DECIMAL(10, 2) DEFAULT NULL, -- Сумма налога, если применимо
			`commission_fee` DECIMAL(10, 2) DEFAULT NULL, -- Комиссия за транзакцию, если применимо
			`referral_code` VARCHAR(50) DEFAULT NULL, -- Реферальный код, использованный для транзакции
            `default_redirect` VARCHAR(255) DEFAULT NULL, -- Тип действия (например, покупка, возврат, вывод)
            `pdf_url` VARCHAR(255) DEFAULT NULL, 
            `country` VARCHAR(255) DEFAULT NULL,
			PRIMARY KEY (`id`) -- Первичный ключ по идентификатору транзакции
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `users` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор пользователя
			`email` VARCHAR(50) DEFAULT NULL, -- Email пользователя
			`password` VARCHAR(255) DEFAULT NULL, -- Пароль пользователя (зашифрованный)
			`group` INT(11) DEFAULT NULL, -- Группа пользователя (права доступа)
			`name` VARCHAR(50) DEFAULT NULL, -- Имя пользователя
			`age` SMALLINT(6) DEFAULT NULL, -- Возраст пользователя
			`phone` VARCHAR(50) DEFAULT NULL, -- Телефон пользователя
			`city` VARCHAR(190) DEFAULT NULL, -- Город пользователя
			`gender` VARCHAR(20) DEFAULT NULL, -- Пол пользователя
			`balance` DECIMAL(10,2) DEFAULT NULL, -- Баланс пользователя
			`avatar` VARCHAR(255) DEFAULT NULL, -- URL аватара пользователя
			`bg_image` VARCHAR(255) DEFAULT NULL, -- URL фонового изображения пользователя
			`followers` INT(11) DEFAULT 0, -- Количество подписчиков
			`likes` INT(11) DEFAULT 0, -- Количество лайков
			`views` INT(11) DEFAULT 0, -- Количество просмотров профиля
			`bio` TEXT, -- Биография пользователя
			`pay_methods` TEXT, -- Способы оплаты, доступные для пользователя
			`purchases` INT(11) DEFAULT 0, -- Количество покупок пользователя
			`sales` INT(11) DEFAULT 0, -- Количество продаж пользователя
			`lastdate` DATETIME DEFAULT NULL, -- Дата последнего визита пользователя
			`regdate` DATETIME DEFAULT NULL, -- Дата регистрации пользователя
			`banned` TINYINT(1) DEFAULT 0, -- Флаг заблокированного пользователя (1 - забанен, 0 - нет)
			`allowpm` TINYINT(1) DEFAULT 1, -- Разрешены ли личные сообщения (1 - да, 0 - нет)
			`allpm` INT(11) DEFAULT 0, -- Общее количество полученных личных сообщений
			`pmunread` INT(11) DEFAULT 0, -- Количество непрочитанных личных сообщений
            "detected_location_id" INT(11) DEFAULT 0,
            "auth_source" VARCHAR(20) DEFAULT NULL,
            "referral_code" VARCHAR(255) DEFAULT NULL, -- URL аватара пользователя
            "referrer_id" INT DEFAULT NULL, -- Группа пользователя (права доступа)
            "status" VARCHAR(255) DEFAULT NULL, -- URL фонового изображения пользователя
			PRIMARY KEY (`id`) -- Первичный ключ по идентификатору
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `comment_subscriptions` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор подписки на комментарий
			`user_id` INT(11) NOT NULL, -- Идентификатор пользователя, который подписан
			`comment_id` INT(11) NOT NULL, -- Идентификатор подписанного комментария
			PRIMARY KEY (`id`), -- Первичный ключ
			FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) -- Внешний ключ на пользователя
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `flood` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`user` INT(11) NOT NULL, -- Идентификатор пользователя
			`ip` VARCHAR(45) NOT NULL, -- IP-адрес пользователя
			`date` DATETIME DEFAULT NULL, -- Дата и время активности
			`period` INT(11) NOT NULL, -- Период, в течение которого активность считается flood
			`reason` TEXT DEFAULT NULL, -- Причина блокировки пользователя
			PRIMARY KEY (`id`), -- Первичный ключ
			FOREIGN KEY (`user`) REFERENCES `users`(`id`) -- Внешний ключ на пользователя
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `messages` (
        `id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор сообщения
        `sender_id` INT DEFAULT NULL, -- ID отправителя (пользователя)
        `sender_name` VARCHAR(190) DEFAULT NULL, -- Имя отправителя (пользователя)
        `receiver_id` INT DEFAULT NULL, -- ID получателя (пользователя)
        "ticket_id" INT DEFAULT NULL,
        `is_support` BOOLEAN DEFAULT FALSE, 
        `message` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL, -- Текст сообщения
        `is_read` TINYINT(1) DEFAULT 0, -- Статус прочтения сообщения (0 - не прочитано, 1 - прочитано)
        `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания сообщения
        `file_path` VARCHAR(190) DEFAULT NULL,
        `img_path` VARCHAR(190) DEFAULT NULL,
        `del_for` INT DEFAULT NULL,
        `updated_at` TIMESTAMP NULL DEFAULT NULL,
        `reply_to_id` INT DEFAULT NULL,
        PRIMARY KEY (`id`), -- Первичный ключ по идентификатору
        FOREIGN KEY (`sender_id`) REFERENCES `users`(`id`), -- Внешний ключ на таблицу пользователей (отправитель)
        FOREIGN KEY (`receiver_id`) REFERENCES `users`(`id`) -- Внешний ключ на таблицу пользователей (получатель)
    ) ENGINE=INNODB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ',

    'CREATE TABLE IF NOT EXISTS `sales` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор продажи
			`product_id` INT(11) NOT NULL, -- ID продаваемого продукта
			`user_id` INT(11) NOT NULL, -- ID пользователя, который совершил покупку
			`quantity` INT NOT NULL, -- Количество проданного товара
			`sale_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата продажи
			PRIMARY KEY (`id`), -- Первичный ключ по идентификатору
			FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) -- Внешний ключ на таблицу пользователей (продавец)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `security_questions` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор вопроса безопасности
			`language` VARCHAR(190) DEFAULT NULL, -- Язык вопроса безопасности
			`question` VARCHAR(255) NOT NULL, -- Текст вопроса безопасности
			`answer` VARCHAR(255) NOT NULL, -- Ответ на вопрос безопасности
			PRIMARY KEY (`id`) -- Первичный ключ по идентификатору
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `spam` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`user` INT(11) NOT NULL, -- Идентификатор пользователя
			`ip` VARCHAR(45) NOT NULL, -- IP-адрес пользователя
			`date` DATETIME DEFAULT NULL, -- Дата и время активности
			`period` INT(11) NOT NULL, -- Период блокировки за спам
			`reason` TEXT DEFAULT NULL, -- Причина блокировки
			PRIMARY KEY (`id`), -- Первичный ключ
			FOREIGN KEY (`user`) REFERENCES `users`(`id`) -- Внешний ключ на пользователя
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

//    'CREATE TABLE IF NOT EXISTS `subscriptions` (
//			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор подписки
//			`user_id` INT(11) NOT NULL, -- Идентификатор пользователя, который подписан
//			`email` VARCHAR(255) NOT NULL, -- Email пользователя
//			`subject` INT(11) NOT NULL, -- Идентификатор подписанного модуля
//			`created_date` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP, -- Дата, когда произошла подписка
//			`expiration` DATETIME NULL, -- Дата истечения подписки
//			`type` VARCHAR(15) NOT NULL, -- Тип подписки (free, premium, pro)
//			`status` VARCHAR(15) NOT NULL, -- Статус подписки (active, inactive, canceled)
//			PRIMARY KEY (`id`), -- Первичный ключ
//			FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) -- Внешний ключ на пользователя
//		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `tasks` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор задачи
			`title` VARCHAR(100) DEFAULT NULL, -- Заголовок задачи
			`author` VARCHAR(50) DEFAULT NULL, -- Имя автора задачи
			`date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания задачи
			`description` TEXT DEFAULT NULL, -- Описание задачи
			`status` VARCHAR(10) NOT NULL, -- Статус задачи (например, "новая", "выполнена" и т.д.)
			`views` INT DEFAULT 0, -- Количество просмотров задачи
			PRIMARY KEY (`id`) -- Первичный ключ по идентификатору
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS referral_rewards (
            reward_id INT AUTO_INCREMENT PRIMARY KEY,
            referrer_id INT NOT NULL,
            referred_user_id INT NOT NULL,
            transaction_id INT DEFAULT NULL,
            reward_amount DECIMAL(10, 2) NOT NULL,
            reward_percentage DECIMAL(5, 2) DEFAULT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (referrer_id) REFERENCES users(id) ON DELETE CASCADE,
            FOREIGN KEY (referred_user_id) REFERENCES users(id) ON DELETE CASCADE,
            FOREIGN KEY (transaction_id) REFERENCES transactions(id) ON DELETE SET NULL
        ) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS user_applications (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            group_id INT NOT NULL,
            json_data JSON,
            payed_status VARCHAR(255),
            status VARCHAR(255)
    );',

    "CREATE TABLE IF NOT EXISTS registration_custom_fields (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(255) NOT NULL, 
        type ENUM('text', 'number', 'date', 'checkbox', 'select') NOT NULL, 
        options TEXT NULL, 
        required BOOLEAN DEFAULT FALSE, 
        group_id INT NOT NULL, 
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );",

    'CREATE TABLE IF NOT EXISTS user_custom_fields (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT, 
        field_id INT, 
        value TEXT, 
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        FOREIGN KEY (field_id) REFERENCES registration_custom_fields(id) ON DELETE CASCADE
    );',

    'CREATE TABLE IF NOT EXISTS counters (
        id INT PRIMARY KEY AUTO_INCREMENT,
        name VARCHAR(255) NOT NULL,  
        value INT NOT NULL DEFAULT 0,       -- Текущее значение
        counter_type VARCHAR(255),
        object_type VARCHAR(255),
        widget_name VARCHAR(255),  -- Название счётчика (например, "users_registered")
        counter_sub_object VARCHAR(255),
        from_count INT NOT NULL DEFAULT 0,       -- От
        to_count INT NOT NULL DEFAULT 0,       -- До
        uniq_name VARCHAR(255),
        template_name VARCHAR(255),
        active BOOLEAN DEFAULT FALSE -- s
    );',

    'CREATE TABLE IF NOT EXISTS participations (
        id INT PRIMARY KEY AUTO_INCREMENT,
        name VARCHAR(255) NOT NULL,  
        group_id INT NOT NULL DEFAULT 0, 
        uniq_name VARCHAR(255),
        participation_type VARCHAR(255),
        settings JSON,
        template_name VARCHAR(255) NOT NULL,
        max_user_count INT NOT NULL DEFAULT 0
    );',

    'CREATE TABLE IF NOT EXISTS participation_users (
        id INT PRIMARY KEY AUTO_INCREMENT,
        participation_id INT NOT NULL DEFAULT 0, 
        winned INT NOT NULL DEFAULT 0, 
        hash VARCHAR(255),
        user_id INT NOT NULL DEFAULT 0
    );',

    'CREATE TABLE IF NOT EXISTS top_donaters (
        id INT PRIMARY KEY AUTO_INCREMENT,
        user_id INT NOT NULL DEFAULT 0, 
        transaction_id INT NOT NULL DEFAULT 0 
    );',

    'CREATE TABLE IF NOT EXISTS subscriptions (
        id INT PRIMARY KEY AUTO_INCREMENT,
        name VARCHAR(255) NOT NULL,
        widget_id INT NOT NULL,
        duration_days INT NOT NULL,
        discount_percent VARCHAR(255) NOT NULL,
        discount_sum VARCHAR(255) NOT NULL,
        created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS user_subscriptions (
        id INT PRIMARY KEY AUTO_INCREMENT,
        user_id INT NOT NULL,
        subscription_id INT NOT NULL,
        start_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        end_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        uniq_id VARCHAR(255) NOT NULL,
        email VARCHAR(255) NOT NULL,
        transaction_id VARCHAR(255) NOT NULL,
        status VARCHAR(255) NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS referral_settings (
        id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        object_name VARCHAR(255) NOT NULL,
        object_type VARCHAR(100) NOT NULL,
        object_id BIGINT UNSIGNED NOT NULL,
        discount_percent DECIMAL(5,2) DEFAULT 0.00,
        discount_sum DECIMAL(10,2) DEFAULT 0.00,
        operations JSON NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS quiz (
        id INT AUTO_INCREMENT PRIMARY KEY,
        uniq_name VARCHAR(255) NOT NULL UNIQUE,
        main_title VARCHAR(255) NOT NULL,
        type VARCHAR(50) NOT NULL,
        price INT NOT NULL DEFAULT 0,
        template_name VARCHAR(255) NOT NULL,
        by_country BOOLEAN NOT NULL DEFAULT FALSE
    );',

    'CREATE TABLE IF NOT EXISTS quiz_questions (
        id INT AUTO_INCREMENT PRIMARY KEY,
        quiz_id INT NOT NULL,
        question TEXT NOT NULL,
        image VARCHAR(255),
        settings JSON NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS quiz_answers (
        id INT AUTO_INCREMENT PRIMARY KEY,
        quiz_question_id INT NOT NULL,
        answer TEXT NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS quiz_participations (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        quiz_question_id INT NOT NULL,
        country VARCHAR(255),
        selected_option VARCHAR(255) NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS versions (
        id INT AUTO_INCREMENT PRIMARY KEY,
        system_version VARCHAR(50) NOT NULL UNIQUE,
        release_date DATETIME NOT NULL,
        description TEXT,
        file_path VARCHAR(255) NOT NULL,
        checksum_sum CHAR(64) NOT NULL,
        is_active BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS client_version (
        id INT AUTO_INCREMENT PRIMARY KEY,
        version VARCHAR(255),
        client_url VARCHAR(255) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS tokens (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        guest_id VARCHAR(255) DEFAULT NULL,
        token VARCHAR(255) NOT NULL,
        target VARCHAR(255),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        active BOOLEAN DEFAULT TRUE
    );',

    'CREATE TABLE IF NOT EXISTS user_blocks (
        id INT AUTO_INCREMENT PRIMARY KEY,
        blocker_id BIGINT NOT NULL,
        blocked_id BIGINT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS chat_deletions (
        id BIGINT AUTO_INCREMENT PRIMARY KEY,
        user_id BIGINT NOT NULL,        -- ID пользователя, который удаляет чат
        chat_id BIGINT NOT NULL,        -- ID чата
        chat_type VARCHAR(50),
        deleted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;',

    'CREATE TABLE IF NOT EXISTS user_relationships (
        id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        user_id_from BIGINT UNSIGNED NOT NULL,
        user_id_to BIGINT UNSIGNED NOT NULL,
        can_message BOOLEAN DEFAULT FALSE,
        is_blocked BOOLEAN DEFAULT FALSE,
        is_mutual BOOLEAN DEFAULT FALSE,
        is_support BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS chat_groups (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        is_private BOOLEAN DEFAULT FALSE,
        created_by INT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )',

    'CREATE TABLE IF NOT EXISTS group_members (
        id INT AUTO_INCREMENT PRIMARY KEY,
        group_id INT NOT NULL,
        user_id INT DEFAULT NULL,
        guest_id VARCHAR(50) DEFAULT NULL,
        role VARCHAR(50),
        joined_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )',

    'CREATE TABLE IF NOT EXISTS group_messages (
        id INT AUTO_INCREMENT PRIMARY KEY,
        group_id INT NOT NULL,
        sender_id INT,
        content TEXT,
        message_type VARCHAR(50),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP,
        file_path VARCHAR(255),
        img_path VARCHAR(255),
        reply_to_id INT
    )',


    'CREATE TABLE IF NOT EXISTS chat_complaints (
        id INT AUTO_INCREMENT PRIMARY KEY,
        message_id BIGINT DEFAULT NULL,
        reporter_user_id BIGINT NOT NULL,
        reported_user_id BIGINT NOT NULL,
        reason TEXT,
        STATUS VARCHAR(32),
        chat_type VARCHAR(32),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        reviewed_at TIMESTAMP NULL
    );',

    'CREATE TABLE IF NOT EXISTS tickets (
        id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        user_id BIGINT UNSIGNED NOT NULL,
        support_u_id BIGINT UNSIGNED DEFAULT NULL,
        subject VARCHAR(255) NOT NULL,
        title VARCHAR(255) NOT NULL,
        status VARCHAR(50) DEFAULT NULL,
        priority VARCHAR(50) DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;',



    'CREATE TABLE IF NOT EXISTS user_requests (
        id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        request_sender_user_id BIGINT UNSIGNED NOT NULL,
        request_type VARCHAR(50) NOT NULL,
        request_id INT NOT NULL,
        request_owner_user_id BIGINT NOT NULL,
        request_options JSON NOT NULL
    ) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;',

    'CREATE TABLE IF NOT EXISTS walls (
        id INT AUTO_INCREMENT PRIMARY KEY,
        owner_id INT NOT NULL,
        title VARCHAR(255),
        uniq_name VARCHAR(255),
        template_name VARCHAR(255),
        description TEXT,
        visibility_type TINYINT DEFAULT NULL,        -- 1 = public, 2 = private, 3 = restricted
        posting_access_type TINYINT DEFAULT NULL,    -- 1 = all, 2 = followers, 3 = owner_only
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        settings JSON,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;',

    'CREATE TABLE IF NOT EXISTS wall_followers (
        id INT AUTO_INCREMENT PRIMARY KEY,
        wall_id INT NOT NULL,
        user_id INT NOT NULL,
        role_type TINYINT DEFAULT 1,              -- 1 = follower, 2 = editor, 3 = moderator
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;',

    'CREATE TABLE IF NOT EXISTS posts (
        id INT AUTO_INCREMENT PRIMARY KEY,
        wall_id INT NOT NULL,
        author_id INT NOT NULL,
        content TEXT,
        post_type TINYINT DEFAULT 1,              -- 1 = text, 2 = image, 3 = video, 4 = mixed, 5 = ad
        status_type TINYINT DEFAULT 1,            -- 1 = published, 2 = draft, 3 = archived
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;',

    'CREATE TABLE IF NOT EXISTS post_media (
        id INT AUTO_INCREMENT PRIMARY KEY,
        post_id INT NOT NULL,
        media_type TINYINT DEFAULT 1,             -- 1 = image, 2 = video
        url TEXT,
        thumbnail_url TEXT,
        order_index INT DEFAULT 0
    ) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;',

    'CREATE TABLE IF NOT EXISTS likes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        post_id INT NOT NULL,
        user_id INT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS locations (
        id INT AUTO_INCREMENT PRIMARY KEY,
        parent_id INT,
        name VARCHAR(255) NOT NULL,             -- Название ("США", "Пенсильвания", "Филадельфия")
        "type" VARCHAR(50) NOT NULL,              -- Уровень: country, state, city, district, street
        slug VARCHAR(255),                      -- опционально: код ("US", "PA")
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS location_list (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT DEFAULT NULL,                           -- кому принадлежит список
        entity_id INT DEFAULT NULL,
        entity_type VARCHAR(50) DEFAULT NULL,
        location_id INT NOT NULL,
        list_type VARCHAR(255) DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    'CREATE TABLE IF NOT EXISTS location_translations (
        id INT AUTO_INCREMENT PRIMARY KEY,
        location_id INT NOT NULL,
        language_code VARCHAR(20) NOT NULL,  
        name VARCHAR(255) NOT NULL
    );',

    'CREATE TABLE IF NOT EXISTS access_control (
        id INT AUTO_INCREMENT PRIMARY KEY,
        group_id INT DEFAULT NULL,
        resource_id INT DEFAULT NULL,
        resource_type VARCHAR(50) DEFAULT NULL,
        list_type VARCHAR(50) DEFAULT NULL,
        location_id INT DEFAULT NULL,
        can_read BOOLEAN DEFAULT FALSE
    );',

    //Таблица типов наказаний
    'CREATE TABLE IF NOT EXISTS punishment_types (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(250) NOT NULL,        -- "30min", "1hour", "1day", "1week", "forever"
        duration_seconds INT NOT NULL      -- длительность в секундах для удобного расчета
    );',


    //Таблица наказаний
    'CREATE TABLE IF NOT EXISTS user_punishments (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `user_id` INT DEFAULT NULL,           -- null для незарегистрированных
        `ip_address` VARCHAR(45) DEFAULT NULL, -- для незарегистрированных
        `comment_id` INT DEFAULT NULL,        -- при нарушении конкретного комментария
        `punishment_type_id` INT NOT NULL,    -- ссылка на punishment_types
        `expires_at` DATETIME NOT NULL,       -- время истечения наказания
        `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX (`user_id`),
        INDEX (`ip_address`),
        FOREIGN KEY (`comment_id`) REFERENCES `comments`(`id`) ON DELETE SET NULL,
        FOREIGN KEY (`punishment_type_id`) REFERENCES `punishment_types`(`id`) ON DELETE RESTRICT
    );',

    //Таблица стоп-слов
    'CREATE TABLE IF NOT EXISTS banned_words (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `word` VARCHAR(255) NOT NULL UNIQUE,
        `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );',

    //Логи нарушений
    'CREATE TABLE IF NOT EXISTS punishment_logs (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `user_id` INT DEFAULT NULL,
        `ip_address` VARCHAR(45) DEFAULT NULL,
        `comment_id` INT DEFAULT NULL,
        `banned_word` VARCHAR(255) NOT NULL,
        `punishment_id` INT DEFAULT NULL,
        `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (`punishment_id`) REFERENCES `user_punishments`(`id`) ON DELETE CASCADE
    )',

    'CREATE TABLE IF NOT EXISTS ratings (
        id INT AUTO_INCREMENT,
        entity_type VARCHAR(50) NOT NULL,
        entity_id BIGINT UNSIGNED NOT NULL,
        user_id BIGINT UNSIGNED NULL,
        rating TINYINT NOT NULL,              -- 1–5 (или с шагом 0.5, если хочешь)
        review_text TEXT NULL,
        status VARCHAR(50) DEFAULT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
        INDEX idx_entity (entity_type, entity_id),
        INDEX idx_user (user_id),
    
        PRIMARY KEY (id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4',

    'CREATE TABLE IF NOT EXISTS rating_totals (
        id INT AUTO_INCREMENT,
        entity_type VARCHAR(50) NOT NULL,
        entity_id BIGINT UNSIGNED NOT NULL,
        total_rating INT NOT NULL DEFAULT 0,
        votes_count INT NOT NULL DEFAULT 0,
        average_rating FLOAT(4,2) AS (total_rating / votes_count) STORED,
    
        UNIQUE KEY uniq_entity (entity_type, entity_id),
        INDEX idx_entity (entity_type, entity_id),
    
        PRIMARY KEY (id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4',


    'CREATE TABLE IF NOT EXISTS qr_tokens (
        id INT AUTO_INCREMENT,
        -- Сам токен
        code CHAR(64) NOT NULL UNIQUE,
    
        -- К чему привязан
        target_type VARCHAR(50) NOT NULL,  -- coupon, order, ticket, user_pass и т.п.
        target_id   BIGINT UNSIGNED NOT NULL,
    
        -- Региональные и прочие ограничения
        region_code      VARCHAR(20) NULL,  -- если не нужно — NULL
        constraints_json JSON NULL,         -- общие условия (одноразовость, лимиты, и т.д.)
        metadata_json    JSON NULL,         -- любые доп. данные для модуля
    
        -- Срок действия
        expires_at DATETIME NULL,
    
        -- Использование
        usage_limit INT UNSIGNED NOT NULL DEFAULT 1,  -- 1 = одноразовый, >1 = многоразовый
        usage_count INT UNSIGNED NOT NULL DEFAULT 0,  -- сколько раз уже применён
        last_used_at DATETIME NULL,
        created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4',

    'CREATE TABLE IF NOT EXISTS widgets_translations (
        id INT AUTO_INCREMENT,
        widget_id INT NOT NULL,
        widget_type VARCHAR(50) NOT NULL,
        lang_code VARCHAR(50) NOT NULL,   -- en, ru, etc.
        name VARCHAR(255) NOT NULL,   -- ключ, например btn_text, title, description
        value TEXT NOT NULL,          -- текст на нужном языке
        UNIQUE KEY ux_widget_lang_name (widget_id, widget_type, lang_code, name),
        PRIMARY KEY (id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4',

    'CREATE TABLE IF NOT EXISTS bindings (
        id INT AUTO_INCREMENT,
        binding_name VARCHAR(255) DEFAULT NULL,
        parent_url VARCHAR(255) NOT NULL,
        module_url VARCHAR(255) NOT NULL,
        module_name VARCHAR(255) DEFAULT NULL,
        translate_parent VARCHAR(255) DEFAULT NULL,
        translate_child VARCHAR(255) DEFAULT NULL,
        parent_name VARCHAR(255) DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4',

    'CREATE TABLE IF NOT EXISTS co_buyings (
        id INT AUTO_INCREMENT,
        product_id INT NOT NULL,
        goal_amount DECIMAL(10,2) NOT NULL,
        current_amount DECIMAL(10,2) NOT NULL DEFAULT 0,
        status VARCHAR(20) DEFAULT NULL,
        owner_id INT NOT NULL,
        date_start DATETIME,
        date_end DATETIME,
        min_participants INT DEFAULT 1,
        max_participants INT DEFAULT NULL,
        PRIMARY KEY (id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4',

    'CREATE TABLE IF NOT EXISTS co_buyings_participants (
        id INT AUTO_INCREMENT PRIMARY KEY,
        co_buying_id INT NOT NULL,
        user_id INT NOT NULL,
        paid_amount DECIMAL(10,2) NOT NULL,
        date_paid DATETIME,
        FOREIGN KEY (co_buying_id) REFERENCES co_buyings(id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4',

    'CREATE TABLE IF NOT EXISTS `refund_requests` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,          -- Уникальный идентификатор запроса
        `transaction_id` VARCHAR(255) NOT NULL,       -- Связь с транзакцией из таблицы transactions
        `user_id` INT(11) NOT NULL,                   -- Кто запросил возврат
        `reason` TEXT NOT NULL,                        -- Причина возврата от пользователя
        `status` VARCHAR(20) DEFAULT NULL,        -- Статус: pending, approved, rejected
        `admin_id` INT(11) DEFAULT NULL,              -- Кто одобрил/отклонил (админ)
        `response_comment` TEXT DEFAULT NULL,         -- Комментарий админа к решению
        `requested_at` DATETIME DEFAULT CURRENT_TIMESTAMP, -- Дата запроса
        `responded_at` DATETIME DEFAULT NULL,         -- Дата ответа админа
        PRIMARY KEY (`id`)
    ) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS payment_bonuses (
        id INT AUTO_INCREMENT,
        payment_system VARCHAR(50) NOT NULL,      -- уникальный идентификатор платёжной системы
        name VARCHAR(100) NOT NULL,               -- название бонуса
        description TEXT,                          -- описание бонуса
        type VARCHAR(100) NOT NULL,    -- тип бонуса: процент или фиксированная сумма
        value DECIMAL(10,2) NOT NULL,             -- значение бонуса (процент или сумма)
        currency CHAR(3) DEFAULT NULL,           -- валюта, если тип fixed
        min_payment DECIMAL(10,2) DEFAULT 0.00,  -- минимальная сумма оплаты для использования бонуса
        max_uses_per_user INT UNSIGNED DEFAULT 0, -- сколько раз один пользователь может использовать бонус (0 = без ограничения)
        active TINYINT(1) DEFAULT 1,              -- активен ли бонус
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_payment_system (payment_system),
        INDEX idx_active (active),
        PRIMARY KEY (id)
    ) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `mailings` (
        `id` INT UNSIGNED NOT NULL AUTO_INCREMENT, -- ID рассылки
        `title` VARCHAR(255) NOT NULL,            -- Название рассылки
        `type` VARCHAR(50) NOT NULL,              -- Тип рассылки: sms_text, sms_audio, call_audio, email
        `status` VARCHAR(50) DEFAULT NULL, -- Статус: draft, queued, sending, done, failed
        `created_by` INT UNSIGNED NOT NULL,       -- ID пользователя, который создал рассылку
        `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, -- Дата создания
        `scheduled_at` DATETIME DEFAULT NULL,     -- Дата и время запланированной отправки
        PRIMARY KEY (`id`),
        INDEX `idx_status` (`status`),
        INDEX `idx_scheduled_at` (`scheduled_at`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;',

    'CREATE TABLE IF NOT EXISTS `mailing_contents` (
        `id` INT UNSIGNED NOT NULL AUTO_INCREMENT, -- ID контента
        `mailing_id` INT UNSIGNED NOT NULL,        -- ID рассылки
        `channel` VARCHAR(50) NOT NULL,           -- Канал: sms, call, email
        `text` TEXT DEFAULT NULL,                  -- Текст сообщения
        `media_url` VARCHAR(1024) DEFAULT NULL,   -- Ссылка на медиа (аудио/картинку)
        PRIMARY KEY (`id`),
        INDEX `idx_mailing_id` (`mailing_id`),
        CONSTRAINT `fk_mailing_contents_mailing` FOREIGN KEY (`mailing_id`) REFERENCES `mailings`(`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;',

    'CREATE TABLE IF NOT EXISTS `mailing_queue` (
        `id` INT UNSIGNED NOT NULL AUTO_INCREMENT, -- ID записи очереди
        `mailing_id` INT UNSIGNED NOT NULL,        -- ID рассылки
        `user_id` INT UNSIGNED NOT NULL,           -- ID пользователя получателя
        `channel` VARCHAR(50) NOT NULL,           -- Канал: sms, call, email
        `status` VARCHAR(50) DEFAULT NULL, -- Статус: pending, sent, failed
        `provider_message_id` VARCHAR(255) DEFAULT NULL, -- ID сообщения у провайдера
        `error` TEXT DEFAULT NULL,                 -- Ошибка отправки
        `sent_at` TIMESTAMP NULL DEFAULT NULL,     -- Время отправки
        PRIMARY KEY (`id`),
        INDEX `idx_mailing_user` (`mailing_id`,`user_id`),
        INDEX `idx_status` (`status`),
        CONSTRAINT `fk_mailing_queue_mailing` FOREIGN KEY (`mailing_id`) REFERENCES `mailings`(`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;',

    'CREATE TABLE IF NOT EXISTS balance_holds (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        amount INT NOT NULL,
        status VARCHAR(50) DEFAULT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;',

    'CREATE TABLE IF NOT EXISTS user_bonus_balance (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        balance BIGINT DEFAULT 0,
        status VARCHAR(50) DEFAULT NULL,
        withdraw_amount BIGINT DEFAULT 0,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;',

    'CREATE TABLE IF NOT EXISTS user_bonus_transactions (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT UNSIGNED NOT NULL,
        amount BIGINT NOT NULL,
        balance_after BIGINT NOT NULL,
        transaction_id VARCHAR(200) DEFAULT NULL,
        status VARCHAR(50) DEFAULT NULL, -- Статус: pending, sent, failed
        type VARCHAR(255) DEFAULT NULL,
        description VARCHAR(255) DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;'



];

$createTables = [];
if ($enabledDatabase == "mysql") {
    $createTables = $createTablesMySQL;
} elseif ($enabledDatabase == "pgsql") {
    $createTables = $createTablesPG;
}

$logFile = __DIR__ . '/info.log';

foreach ($createTables as $sql) {
   // error_log($sql . "\n", 3, $logFile);

    try {
        $db_connect->exec($sql); // Medoo позволяет raw query
    } catch (\PDOException $e) {
        $errorMsg = "Ошибка при создании таблицы: " . $e->getMessage();
        echo $errorMsg . "\n";
        error_log($errorMsg . "\n", 3, $logFile);
        $successFlag = false;
    }
}


$db_connect->insert('punishment_types', [
    ['name' => '30 Минут', 'duration_seconds' => 1800],
    ['name' => '1 Час', 'duration_seconds' => 3600],
    ['name' => '1 День', 'duration_seconds' => 86400],
    ['name' => '1 Неделя', 'duration_seconds' => 604800],
    ['name' => 'Навсегда', 'duration_seconds' => 0]
]);


$userMax = $db_connect->max("users", "id") == "" ? 0 : $db_connect->max("users", "id");

$db_connect->insert("users", [
    [
        "id" => $userMax + 2,
        "email" => 'megavusa@gmail.com',
        "password" => $hashPass,
     //   "group" => 1,
        "name" => 'Giorgi Basharuli',
        "age" => 33,
        "gender" => 'Мужчина',
        "phone" => '+19298994746',
        "city" => 'Minneapolis',
        "balance" => 100.00,
        "avatar" => 'uploads/profiles/default.svg',
        "bg_image" => 'uploads/profiles/2024/1/1/bg.jpg',
        "followers" => 0,
        "likes" => 0,
        "views" => 0,
        "bio" => 'BIO',
        "pay_methods" => 'Credit Card, PayPal',
        "purchases" => 0,
        "sales" => 0,
        "lastdate" => date("Y-m-d H:i:s"),
        "regdate" => date("Y-m-d H:i:s"),
        "banned" => 0,
        "allowpm" => 1,
        "allpm" => 0,
        "pmunread" => 0
    ],
    [
        "id" => $userMax + 3,
        "email" => 'armm.hambardzumyan@gmail.com',
        "password" => $hashPass,
        //   "group" => 1,
        "name" => 'Tigran Hambardzumyan',
        "age" => 33,
        "gender" => 'Мужчина',
        "phone" => '',
        "city" => 'Yerevan',
        "balance" => 100.00,
        "avatar" => 'uploads/profiles/default.svg',
        "bg_image" => 'uploads/profiles/2024/1/1/bg.jpg',
        "followers" => 0,
        "likes" => 0,
        "views" => 0,
        "bio" => 'BIO',
        "pay_methods" => 'Credit Card, PayPal',
        "purchases" => 0,
        "sales" => 0,
        "lastdate" => date("Y-m-d H:i:s"),
        "regdate" => date("Y-m-d H:i:s"),
        "banned" => 0,
        "allowpm" => 1,
        "allpm" => 0,
        "pmunread" => 0
    ],
    [
        "id" => $userMax + 4,
        "email" => 'mravivashchenko@gmail.com',
        "password" => $hashPass,
        //   "group" => 1,
        "name" => 'Mrav Ivashchenko',
        "age" => 33,
        "gender" => 'Мужчина',
        "phone" => '+37455258440',
        "city" => 'Yerevan',
        "balance" => 100.00,
        "avatar" => 'uploads/profiles/default.svg',
        "bg_image" => 'uploads/profiles/2024/1/1/bg.jpg',
        "followers" => 0,
        "likes" => 0,
        "views" => 0,
        "bio" => 'BIO',
        "pay_methods" => 'Credit Card, PayPal',
        "purchases" => 0,
        "sales" => 0,
        "lastdate" => date("Y-m-d H:i:s"),
        "regdate" => date("Y-m-d H:i:s"),
        "banned" => 0,
        "allowpm" => 1,
        "allpm" => 0,
        "pmunread" => 0
    ],
    [
        "id" => $userMax + 5,
        "email" => 'lilit.yeghiazaryan@gmail.com',
        "password" => $hashPass,
        //   "group" => 1,
        "name" => 'Lilit Yeghiazaryan',
        "age" => 33,
        "gender" => 'Женщина',
        "phone" => '',
        "city" => 'Yerevan',
        "balance" => 100.00,
        "avatar" => 'uploads/profiles/default.svg',
        "bg_image" => 'uploads/profiles/2024/1/1/bg.jpg',
        "followers" => 0,
        "likes" => 0,
        "views" => 0,
        "bio" => 'BIO',
        "pay_methods" => 'Credit Card, PayPal',
        "purchases" => 0,
        "sales" => 0,
        "lastdate" => date("Y-m-d H:i:s"),
        "regdate" => date("Y-m-d H:i:s"),
        "banned" => 0,
        "allowpm" => 1,
        "allpm" => 0,
        "pmunread" => 0
    ],
    [
        "id" => $userMax + 6,
        "email" => 'support1@inbox',
        "password" => $supportPassHash,
        //   "group" => 8,
        "name" => 'Support',
        "age" => 18,
        "gender" => '',
        "phone" => '+1(000)000-0000',
        "city" => 'Earth',
        "balance" => 0.00,
        "avatar" => 'uploads/profiles/default.svg',
        "bg_image" => 'uploads/profiles/2024/1/3/bg.jpg',
        "followers" => 0,
        "likes" => 0,
        "views" => 0,
        "bio" => 'DEMO BIOGRAPHY',
        "pay_methods" => 'Credit Card, Bitcoin',
        "purchases" => 0,
        "sales" => 0,
        "lastdate" => '2024-01-10 00:00:00',
        "regdate" => '2024-01-15 00:00:00',
        "banned" => 0,
        "allowpm" => 1,
        "allpm" => 0,
        "pmunread" => 0
    ],
    [
        "id" => $userMax + 7,
        "email" => 'support2@inbox',
        "password" => $supportPassHash,
        //   "group" => 8,
        "name" => 'Support #2',
        "age" => 18,
        "gender" => '',
        "phone" => '+1(000)000-0000',
        "city" => 'Earth',
        "balance" => 0.00,
        "avatar" => 'uploads/profiles/default.svg',
        "bg_image" => 'uploads/profiles/2024/1/3/bg.jpg',
        "followers" => 0,
        "likes" => 0,
        "views" => 0,
        "bio" => 'DEMO BIOGRAPHY',
        "pay_methods" => 'Credit Card, Bitcoin',
        "purchases" => 0,
        "sales" => 0,
        "lastdate" => '2024-01-10 00:00:00',
        "regdate" => '2024-01-15 00:00:00',
        "banned" => 0,
        "allowpm" => 1,
        "allpm" => 0,
        "pmunread" => 0
    ]
]);

$roles = [
    'Developer',
    'Admin',
    'Moderator',
    'Editor',
    'Support',
    'VIP',
    'User',
    'Guest',
];
$rolesInsert = [];

foreach ($roles as $role) {
    $rolesInsert[] = [
        'name' => $role,
    ];
}

foreach ($rolesInsert as $group) {
    $exists = $db_connect->get("roles", "id", ["name" => $group['name']]);
    if (!$exists) {
        $db_connect->insert('roles', $group);
    }
}

$usersRoles = [
  ["user_id" => 2, "role_id" => 2],
  ["user_id" => 3, "role_id" => 2],
  ["user_id" => 4, "role_id" => 2],
  ["user_id" => 5, "role_id" => 2],

  ["user_id" => 6, "role_id" => 5],
  ["user_id" => 7, "role_id" => 5],

];

foreach ($usersRoles as $roleAssoc) {
    $db_connect->insert("users_roles", $roleAssoc);
}

$permissions = [
    ['code' => 'user.create', 'module' => 'users', 'description' => 'Создание нового пользователя'],
    ['code' => 'user.edit', 'module' => 'users', 'description' => 'Редактирование данных пользователя'],
    ['code' => 'user.delete', 'module' => 'users', 'description' => 'Удаление пользователя'],
    ['code' => 'allmodules.view', 'module' => 'all', 'description' => 'Просмотр всех модулей'],
    ['code' => 'allmodules.edit', 'module' => 'all', 'description' => 'Редактирование всех модулей'],
    ['code' => 'allmodules.delete', 'module' => 'all', 'description' => 'Удаление всех модулей'],
    ['code' => 'allmodules.add', 'module' => 'all', 'description' => 'Добавление всех модулей'],

    ['code' => 'mna.create', 'module' => 'mna', 'description' => 'Доступ в ПУ'],
    ['code' => 'mnu.create', 'module' => 'mnu', 'description' => 'Управление пользователями'],
    ['code' => 'mnr.create', 'module' => 'mnr', 'description' => 'Управление ролями'],
    ['code' => 'mns.create', 'module' => 'mns', 'description' => 'Управление настройками'],
    ['code' => 'modules.create', 'module' => 'create', 'description' => 'Глобалное создание данных'],
    ['code' => 'modules.update', 'module' => 'update', 'description' => 'Глобалное редактирование данных'],
    ['code' => 'modules.del', 'module' => 'del', 'description' => 'Глобалное удаление данных'],

    ['code' => 'bindings.manage', 'module' => 'manage', 'description' => 'Управление привязками'],
    ['code' => 'locations.manage', 'module' => 'manage', 'description' => 'Управление локациями'],
    ['code' => 'extensions.manage', 'module' => 'manage', 'description' => 'Управление расширениями'],
    ['code' => 'modules.manage', 'module' => 'manage', 'description' => 'Управление модулями'],
    ['code' => 'cms_versions.manage', 'module' => 'manage', 'description' => 'Управление версиями CMS'],
    ['code' => 'cron_manager.manage', 'module' => 'manage', 'description' => 'CRON Менеджер'],

    ['code' => 'support_online_chat.manage', 'module' => 'manage', 'description' => 'Онлайн поддержка'],
    ['code' => 'tickets.manage', 'module' => 'manage', 'description' => 'Управление тикетамы'],

    ['code' => 'quiz_widget.manage',          'module' => 'manage', 'description' => 'Управление виджетами опросов'],
    ['code' => 'wall_widget.manage',          'module' => 'manage', 'description' => 'Управление виджетами стены'],
    ['code' => 'participation_widget.manage', 'module' => 'manage', 'description' => 'Управление виджетами участия'],
    ['code' => 'counter_widget.manage',       'module' => 'manage', 'description' => 'Управление виджетами счетчиков'],
    ['code' => 'payment_widget.manage',       'module' => 'manage', 'description' => 'Управление платежными виджетами'],
    ['code' => 'widgets.manage',              'module' => 'manage', 'description' => 'Управление всеми виджетами'],
    ['code' => 'payment_settings.manage', 'module' => 'manage', 'description' => 'Доступ к настройкам платежных систем'],
    ['code' => 'permissions.manage',      'module' => 'manage', 'description' => 'Управление правами'],
    ['code' => 'roles.manage',            'module' => 'manage', 'description' => 'Управление ролями'],

    ['code' => 'referrals.view',            'module' => 'view', 'description' => 'Просмотр реферальной системы в профиле'],

    ['code' => 'mailings.view',            'module' => 'view', 'description' => 'Просмотр рассылок'],
    ['code' => 'mailings.create',            'module' => 'create', 'description' => 'Создание рассылок'],
    ['code' => 'mailings.del',            'module' => 'del', 'description' => 'Удаление рассылок'],

    ['code' => 'mailings_logs.view',            'module' => 'view', 'description' => 'Просмотр логов и очередей рассылок'],

];

// Вставка в таблицу permissions
foreach ($permissions as $perm) {
    $db_connect->insert('permissions', $perm);
}

// Получаем id всех permissions после вставки
$allPermissions = $db_connect->select('permissions', ['id', 'code']);

// Маппинг code => id
$permMap = [];
foreach ($allPermissions as $p) {
    $permMap[$p['code']] = $p['id'];
}

// Данные для role_permissions
$role_permissions = [
    // role_id = 1 (developer)
    ['role_id' => 1, 'permission_id' => $permMap['user.create'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['user.edit'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['user.delete'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['allmodules.view'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['allmodules.edit'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['allmodules.delete'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['allmodules.add'], 'allow' => 1],

    ['role_id' => 1, 'permission_id' => $permMap['mna.create'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['mnu.create'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['mnr.create'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['mns.create'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['modules.create'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['modules.update'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['modules.del'], 'allow' => 1],

    ['role_id' => 1, 'permission_id' => $permMap['bindings.manage'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['locations.manage'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['extensions.manage'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['modules.manage'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['cms_versions.manage'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['cron_manager.manage'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['quiz_widget.manage'],          'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['wall_widget.manage'],          'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['participation_widget.manage'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['counter_widget.manage'],       'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['payment_widget.manage'],       'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['widgets.manage'],              'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['payment_settings.manage'], 'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['permissions.manage'],      'allow' => 1],
    ['role_id' => 1, 'permission_id' => $permMap['roles.manage'],            'allow' => 1],


    // role_id = 2 (admin)
    ['role_id' => 2, 'permission_id' => $permMap['user.create'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['user.edit'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['user.delete'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['allmodules.view'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['allmodules.edit'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['allmodules.delete'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['allmodules.add'], 'allow' => 1],

    ['role_id' => 2, 'permission_id' => $permMap['mna.create'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['mnu.create'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['mnr.create'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['mns.create'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['modules.create'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['modules.update'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['modules.del'], 'allow' => 1],

    ['role_id' => 2, 'permission_id' => $permMap['bindings.manage'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['locations.manage'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['extensions.manage'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['modules.manage'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['cms_versions.manage'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['cron_manager.manage'], 'allow' => 1],

    ['role_id' => 2, 'permission_id' => $permMap['quiz_widget.manage'],          'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['wall_widget.manage'],          'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['participation_widget.manage'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['counter_widget.manage'],       'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['payment_widget.manage'],       'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['widgets.manage'],              'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['payment_settings.manage'], 'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['permissions.manage'],      'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['roles.manage'],            'allow' => 1],

    ['role_id' => 2, 'permission_id' => $permMap['mailings.view'],            'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['mailings.create'],            'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['mailings.del'],            'allow' => 1],
    ['role_id' => 2, 'permission_id' => $permMap['mailings_logs.view'],            'allow' => 1],

    ['role_id' => 5, 'permission_id' => $permMap['mna.create'], 'allow' => 1],
    ['role_id' => 5, 'permission_id' => $permMap['support_online_chat.manage'], 'allow' => 1],
    ['role_id' => 5, 'permission_id' => $permMap['tickets.manage'], 'allow' => 1],

];

// Вставка в таблицу role_permissions
foreach ($role_permissions as $rp) {
    $db_connect->insert('role_permissions', $rp);
}

$data = [
    ['id' => 1, 'license_key' => '00000-00000-00000-00000-00000', 'domain' => 'megadigital.space', 'cms_owner' => 'Giorgi Basharuli', 'owner_email' => 'megavusa@gmail.com', 'created_date' => date("Y-m-d"), 'version' => 'lifetime'],
    ['id' => 2, 'license_key' => 'AFD3T-NLBMM-ZU4CA-2EQ1U-83IV3', 'domain' => 'mydigital.works', 'cms_owner' => 'Giorgi Basharuli', 'owner_email' => 'megavusa@gmail.com', 'created_date' => date("Y-m-d"), 'version' => 'lifetime'],
    ['id' => 3, 'license_key' => '189I1-WVJAZ-ABYS9-QXE3C-JK8W1', 'domain' => 'megadigital.studio', 'cms_owner' => 'Giorgi Basharuli', 'owner_email' => 'megavusa@gmail.com', 'created_date' => date("Y-m-d"), 'version' => 'lifetime'],
    ['id' => 4, 'license_key' => 'IOT03-5JO3C-PKW9G-9SOCH-R14B2', 'domain' => 'realtime.estate', 'cms_owner' => 'Giorgi Basharuli', 'owner_email' => 'megavusa@gmail.com', 'created_date' => date("Y-m-d"), 'version' => 'lifetime'],
    ['id' => 5, 'license_key' => '7VJMD-YD95F-C26I5-KZH8F-MA5VJ', 'domain' => 'each4other.space', 'cms_owner' => 'Giorgi Basharuli', 'owner_email' => 'megavusa@gmail.com', 'created_date' => date("Y-m-d"), 'version' => 'lifetime'],
  ];

foreach ($data as $row) {
    $exists = $db_connect->get("license_keys", "id", ["id" => $row['id']]);
    if (!$exists) {
        $db_connect->insert('license_keys', $row);
    }
}

function recordExists($db, $table, $conditions) {
    return $db->has($table, $conditions);
}

if (!recordExists($db_connect, "static_pages", ["id" => 1])) {
    $db_connect->insert("static_pages", [
        "id" => 1,
        "date" => date("Y-m-d H:i:s"),
        "alt_name" => "home",
        "language" => "russian",
        "title" => "Главная страница",
        "full_desc" => "<div class=\"row mb-2\">
                            <h4 class=\"text-center\">Добро пожаловать на наш сайт</h4>
                        </div>",
        "meta_desc" => "",
        "meta_keys" => "",
    ]);
}

if (!recordExists($db_connect, "static_pages", ["id" => 2])) {
    $data = [
        'id' => 2,
        'date' => date('Y-m-d H:i:s'),
        'alt_name' => 'home',
        'language' => 'english',
        'title' => 'Home page',
        'full_desc' => '<div class="row mb-2"> <h4 class="text-center">Welcome to our website</h4></div>',
        'meta_desc' => '',
        'meta_keys' => '',
        'views' => 0
    ];

    $db_connect->insert('static_pages', $data);
}

if (!recordExists($db_connect, "static_pages", ["id" => 3])) {
    $db_connect->insert("static_pages", [
        "id" => 3,
        "date" => date('Y-m-d H:i:s'),
        "alt_name" => "demonstration",
        "language" => "russian",
        "title" => "Демонстрация CMS Skills.Energy",
        "full_desc" => "Демонстрация CMS Skills.Energy.<br><br><b>Панель управления:</b> https://skills.energy/admin<br><b>Логин:</b>&nbsp;demo@skills.energy<br><b>Пароль:</b>&nbsp;sedemo",
        "meta_desc" => "",
        "meta_keys" => "",
        "views" => 0
    ]);
}

if (!recordExists($db_connect, "static_pages", ["id" => 4])) {
    $db_connect->insert("static_pages", [
        "id" => 4,
        "date" => date('Y-m-d H:i:s'),
        "alt_name" => "license_buy",
        "language" => "russian",
        "title" => "Купить лицензионный ключ для MDS CMS",
        "full_desc" => "Купить лицензионный ключ для MDS CMS",
        "meta_desc" => "",
        "meta_keys" => "",
        "views" => 0
    ]);
}

if (!recordExists($db_connect, "static_pages", ["id" => 5])) {
    $db_connect->insert("static_pages", [
        "id" => 5,
        "date" => date('Y-m-d H:i:s'),
        "alt_name" => "modules",
        "language" => "russian",
        "title" => "Модули",
        "full_desc" => "<div class=\"row\"><div class=\"col-12\"><p class=\"text-center mb-4\">Добро пожаловать на страницу, посвящённую нашим модулям. Здесь вы можете ознакомиться с функциональными возможностями каждого модуля, просмотреть их в действии и при желании скачать для использования на вашем сайте.</p></div><div class=\"col-6\"><div class=\"card mb-3\"><div class=\"card-body border-top border-success d-flex align-items-center\"><img src=\"system/assets/images/modules/ads.png\" class=\"module-actual-color height-70px\" alt=\"\"><div class=\"content w-100 ms-3\"><a href=\"https://ads.skills.energy\" class=\"float-end\" target=\"_blank\">Демо</a><div class=\"text\"><a href=\"/files/ads\" style=\"color: var(--theme-color2);\">Модуль объявлений</a></div><div class=\"number\">Version: <span id=\"adsVersion\"></span> | Update: <span id=\"adsDate\"></span></div></div></div><div class=\"card-footer py-2\"><p class=\"mb-0 fs-7\">Позволяет пользователям создавать, редактировать и управлять объявлениями, легко, удобно и быстро.</p></div></div></div><div class=\"col-6\"><div class=\"card mb-3\"><div class=\"card-body border-top border-success d-flex align-items-center\"><img src=\"system/assets/images/modules/files.png\" class=\"module-actual-color height-70px\" alt=\"\"><div class=\"content w-100 ms-3\"><a href=\"https://files.skills.energy\" class=\"float-end\" target=\"_blank\">Демо</a><div class=\"text\"><a href=\"/files/files\" style=\"color: var(--theme-color3);\">Модуль файлов</a></div><div class=\"number\">Version: <span id=\"filesVersion\"></span> | Update: <span id=\"filesDate\"></span></div></div></div><div class=\"card-footer py-2\"><p class=\"mb-0 fs-7\">Храните, управляйте и делятесь файлами. Поддержка загрузки, сортировки и облегченного поиска.</p></div></div></div><div class=\"col-6\"><div class=\"card mb-3\"><div class=\"card-body border-top border-success d-flex align-items-center\"><img src=\"system/assets/images/modules/movies.png\" class=\"module-actual-color height-70px\" alt=\"\"><div class=\"content w-100 ms-3\"><a href=\"https://movies.skills.energy\" class=\"float-end\" target=\"_blank\">Демо</a><div class=\"text\"><a href=\"/files/movies\" style=\"color: var(--theme-color4);\">Модуль фильмов</a></div><div class=\"number\">Version: <span id=\"moviesVersion\"></span> | Update: <span id=\"moviesDate\"></span></div></div></div><div class=\"card-footer py-2\"><p class=\"mb-0 fs-7\">Позволяет добавлять, редактировать и просматривать фильмы, предоставляя удобный просмотр контента.</p></div></div></div><div class=\"col-6\"><div class=\"card mb-3\"><div class=\"card-body border-top border-success d-flex align-items-center\"><img src=\"system/assets/images/modules/news.png\" class=\"module-actual-color height-70px\" alt=\"\"><div class=\"content w-100 ms-3\"><a href=\"https://news.skills.energy\" class=\"float-end\" target=\"_blank\">Демо</a><div class=\"text\"><a href=\"/files/news\" style=\"color: var(--theme-color5);\">Модуль новостей</a></div><div class=\"number\">Version: <span id=\"newsVersion\"></span> | Update: <span id=\"newsDate\"></span></div></div></div><div class=\"card-footer py-2\"><p class=\"mb-0 fs-7\">Позволяет добавлять, редактировать и публиковать новости. Удобная система категорий и комментариев для организации контента.</p></div></div></div><div class=\"col-6\"><div class=\"card mb-3\"><div class=\"card-body border-top border-success d-flex align-items-center\"><img src=\"system/assets/images/modules/products.png\" class=\"module-actual-color height-70px\" alt=\"\"><div class=\"content w-100 ms-3\"><a href=\"https://products.skills.energy\" class=\"float-end\" target=\"_blank\">Демо</a><div class=\"text\"><a href=\"/files/products\" style=\"color: var(--theme-color6);\">Модуль товаров</a></div><div class=\"number\">Version: <span id=\"productsVersion\"></span> | Update: <span id=\"productsDate\"></span></div></div></div><div class=\"card-footer py-2\"><p class=\"mb-0 fs-7\">Удобное управление товарами, категориями и онлайн-оплатой. Превратите свой сайт в торговую площадку.</p></div></div></div></div></div>",
        "meta_desc" => "",
        "meta_keys" => "",
        "views" => 0
    ]);
}

if (!recordExists($db_connect, "static_pages", ["id" => 6])) {
    $db_connect->insert('static_pages', [
        'id' => 6,
        'date' => date('Y-m-d H:i:s'),
        'alt_name' => 'contacts',
        'language' => 'russian',
        'title' => 'Контакты',
        'full_desc' => '<h5>Наши контакты:</h5> <div class="row"> <div class="col-12 col-md-6"> <p class="mb-0">Github: <a href="https://github.com/brain-skills" target="_blank">https://github.com/brain-skills</a></p> </div> <div class="col-12 col-md-6"> <p class="mb-0">E-mail: <a href="mailto:brain@skills.energy" target="_blank">brain@skills.energy</a></p> </div> <div class="col-12 col-md-6"> <p class="mb-0">Discord: <a href="https://discord.gg/ZUNJMqxC9f" target="_blank">https://discord.gg/ZUNJMqxC9f</a></p> </div> <div class="col-12 col-md-6"> <p class="mb-0">Telegram: <a href="https://t.me/gaga_usa" target="_blank">https://t.me/gaga_usa</a></p> </div> </div>',
        'meta_desc' => '',
        'meta_keys' => '',
        'views' => 0
    ]);
}

if (!recordExists($db_connect, "static_pages", ["id" => 7])) {
    $db_connect->insert('static_pages', [
        'id' => 7,
        'date' => date('Y-m-d H:i:s'),
        'alt_name' => 'license',
        'language' => 'russian',
        'title' => 'Лицензионное соглашение',
        'full_desc' => '&lt;p&gt;&lt;b&gt;Лицензионное соглашение для MDS CMS&lt;/b&gt;&lt;/p&gt;&lt;p&gt;ВНИМАНИЕ: Это лицензионное соглашение (далее - &quot;Соглашение&quot;) между вами (физическим или юридическим лицом) и владельцем проекта Skills Energy CMS (далее - &quot;Владелец&quot;). Пожалуйста, внимательно ознакомьтесь с условиями данного Соглашения перед использованием данного программного продукта.&lt;/p&gt;&lt;b&gt;1. Лицензионные ключи&lt;/b&gt;&lt;p&gt;1.1 Владелец предоставляет два типа лицензионных ключей для использования Skills Energy CMS: временный (на 1 год) и постоянный (навсегда).&lt;/p&gt;&lt;p&gt;1.2 Вам предоставляется право использовать Skills Energy CMS с лицензионным ключом в соответствии с условиями данного Соглашения.&lt;/p&gt;&lt;p&gt;&lt;b&gt;2. Коммерческое использование&lt;/b&gt;&lt;/p&gt;&lt;p&gt;2.1 Коммерческое использование Skills Energy CMS разрешено только при наличии соответствующего лицензионного ключа для конкретного домена.&lt;/p&gt;&lt;p&gt;2.2 Если у вас нет действующего лицензионного ключа для указанного домена, коммерческое использование Skills Energy CMS запрещено.&lt;/p&gt;&lt;p&gt;&lt;b&gt;3. Временный лицензионный ключ&lt;/b&gt;&lt;/p&gt;&lt;p&gt;3.1 Временный лицензионный ключ предоставляет вам право использовать Skills Energy CMS в коммерческих целях только на указанном домене в течение одного года с момента активации ключа.&lt;/p&gt;&lt;p&gt;3.2 По истечении срока действия временного лицензионного ключа, необходимо приобрести новый ключ или перейти на постоянный ключ для продолжения коммерческого использования на том же домене.&lt;/p&gt;&lt;p&gt;&lt;b&gt;4. Постоянный лицензионный ключ&lt;/b&gt;&lt;/p&gt;&lt;p&gt;4.1 Постоянный лицензионный ключ предоставляет вам бессрочное право на коммерческое использование Skills Energy CMS только на указанном домене.&lt;/p&gt;&lt;p&gt;4.2 Владелец оставляет за собой все права к данной Skills Energy CMS, и пользователь не получает прав на воспроизводство, распространение, продажу, взлом, модификации, или создание производных продуктов на основе Skills Energy CMS.&lt;/p&gt;&lt;p&gt;&lt;b&gt;5. Ограничения и обязанности пользователя&lt;/b&gt;&lt;/p&gt;&lt;p&gt;5.1 Вы обязуетесь не распространять, не изменять и не создавать производные продукты на основе Skills Energy CMS без письменного разрешения Владельца.&lt;/p&gt;&lt;p&gt;5.2 Запрещается продажа, взлом, модификации или попытки обхода лицензионных мер без письменного разрешения Владельца.&lt;/p&gt;&lt;p&gt;5.3 Нарушение условий данного Соглашения может привести к прекращению лицензии и предъявлению юридических претензий.&lt;/p&gt;&lt;p&gt;&lt;b&gt;6. Завершающие положения&lt;/b&gt;&lt;/p&gt;&lt;p&gt;6.1 Данное Соглашение считается заключенным и действительным с момента начала использования Skills Energy CMS.&lt;/p&gt;&lt;p&gt;6.2 Владелец оставляет за собой право в любой момент изменить условия данного Соглашения с предварительным уведомлением пользователя.&lt;/p&gt;&lt;p&gt;© 2024 Skills Energy CMS. Все права защищены.',
        'meta_desc' => '',
        'meta_keys' => '',
        'views' => 0
    ]);
}

if (!recordExists($db_connect, "static_pages", ["id" => 8])) {
    $db_connect->insert('static_pages', [
        'id' => 8,
        'date' => date('Y-m-d H:i:s'),
        'alt_name' => 'license',
        'language' => 'english',
        'title' => 'License Agreement',
        'full_desc' => '&lt;p&gt;&lt;b&gt;Skills Energy CMS License Agreement&lt;/b&gt;&lt;/p&gt;&lt;p&gt;ATTENTION: This is a license agreement (hereinafter referred to as the &quot;Agreement&quot;) between you (an individual or legal entity) and the owner of the Skills Energy CMS project (hereinafter referred to as the &quot;Owner&quot;). Please carefully read the terms of this Agreement before using this software product.&lt;/p&gt;&lt;p&gt;&lt;b&gt;1. License Keys&lt;/b&gt;&lt;/p&gt;&lt;p&gt;1.1 The Owner provides two types of license keys for using Skills Energy CMS: temporary (for 1 year) and permanent (forever).&lt;/p&gt;&lt;p&gt;1.2 You are granted the right to use Skills Energy CMS with a license key in accordance with the terms of this Agreement.&lt;/p&gt;&lt;p&gt;&lt;b&gt;2. Commercial Use&lt;/b&gt;&lt;/p&gt;&lt;p&gt;2.1 Commercial use of Skills Energy CMS is allowed only with the corresponding license key for a specific domain.&lt;/p&gt;&lt;p&gt;2.2 If you do not have a valid license key for the specified domain, commercial use of Skills Energy CMS is prohibited.&lt;/p&gt;&lt;p&gt;&lt;b&gt;3. Temporary License Key&lt;/b&gt;&lt;/p&gt;&lt;p&gt;3.1 The temporary license key gives you the right to use Skills Energy CMS for commercial purposes only on the specified domain for one year from the activation date.&lt;/p&gt;&lt;p&gt;3.2 Upon expiration of the temporary license key, you must purchase a new key or switch to a permanent key to continue commercial use on the same domain.&lt;/p&gt;&lt;p&gt;&lt;b&gt;4. Permanent License Key&lt;/b&gt;&lt;/p&gt;&lt;p&gt;4.1 The permanent license key grants you a perpetual right to use Skills Energy CMS only on the specified domain.&lt;/p&gt;&lt;p&gt;4.2 The Owner retains all rights to Skills Energy CMS, and the user does not have the right to reproduce, distribute, sell, hack, modify, or create derivative products based on Skills Energy CMS.&lt;/p&gt;&lt;p&gt;&lt;b&gt;5. Restrictions and User Responsibilities&lt;/b&gt;&lt;/p&gt;&lt;p&gt;5.1 You agree not to distribute, modify, or create derivative products based on Skills Energy CMS without the written permission of the Owner.&lt;/p&gt;&lt;p&gt;5.2 Sale, hacking, modification, or attempts to bypass license measures without the written permission of the Owner are strictly prohibited.&lt;/p&gt;&lt;p&gt;5.3 Violation of the terms of this Agreement may result in license termination and legal action.&lt;/p&gt;&lt;p&gt;&lt;b&gt;6. Concluding Provisions&lt;/b&gt;&lt;/p&gt;&lt;p&gt;6.1 This Agreement is considered concluded and valid from the moment of starting to use Skills Energy CMS.&lt;/p&gt;&lt;p&gt;6.2 The Owner reserves the right to change the terms of this Agreement at any time with prior notice to the user.&lt;/p&gt;&lt;p&gt;© 2024 Skills Energy CMS. All rights reserved.',
        'meta_desc' => '',
        'meta_keys' => '',
        'views' => 0
    ]);
}

if (!recordExists($db_connect, "security_questions", ["question" => "27+33+10"]) && !recordExists($db_connect, "security_questions", ["question" => "18+12+10"]) && !recordExists($db_connect, "security_questions", ["question" => "75+20-5"])) {
    $db_connect->insert("security_questions", [
        "language" => "russian",
        "question" => "27+33-10",
        "answer" => "50"
    ]);
    $db_connect->insert("security_questions", [
        "language" => "russian",
        "question" => "18+12+10",
        "answer" => "40"
    ]);
    $db_connect->insert("security_questions", [
        "language" => "russian",
        "question" => "75+20-5",
        "answer" => "90"
    ]);
}

$successFlag = true;



// Массив с запросами на добавление данных в таблицы
/*$addData = [
    // Добавление данных в таблицу `groups`
    "INSERT INTO `groups` (`id`,`name`,`create`,`read`,`update`,`del`,`vote`,`download`,`mna`,`mnu`,`mns`,`mnr`) VALUES (1, 'Admin', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)",
    "INSERT INTO `groups` (`id`,`name`,`create`,`read`,`update`,`del`,`vote`,`download`,`mna`,`mnu`,`mns`,`mnr`) VALUES (2, 'Moderator', 1, 1, 1, 1, 1, 1, 1, 1, 0, 1)",
    "INSERT INTO `groups` (`id`,`name`,`create`,`read`,`update`,`del`,`vote`,`download`,`mna`,`mnu`,`mns`,`mnr`) VALUES (3, 'Editor', 1, 1, 1, 1, 0, 0, 1, 0, 0, 0)",
    "INSERT INTO `groups` (`id`,`name`,`create`,`read`,`update`,`del`,`vote`,`download`,`mna`,`mnu`,`mns`,`mnr`) VALUES (4, 'Support', 0, 1, 0, 0, 0, 0, 1, 0, 0, 0)",
    "INSERT INTO `groups` (`id`,`name`,`create`,`read`,`update`,`del`,`vote`,`download`,`mna`,`mnu`,`mns`,`mnr`) VALUES (5, 'VIP', 0, 1, 0, 0, 1, 1, 0, 0, 0, 0)",
    "INSERT INTO `groups` (`id`,`name`,`create`,`read`,`update`,`del`,`vote`,`download`,`mna`,`mnu`,`mns`,`mnr`) VALUES (6, 'User', 0, 1, 0, 0, 1, 0, 0, 0, 0, 0)",
    "INSERT INTO `groups` (`id`,`name`,`create`,`read`,`update`,`del`,`vote`,`download`,`mna`,`mnu`,`mns`,`mnr`) VALUES (7, 'Guest', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0)",
    "INSERT INTO `groups` (`id`,`name`,`create`,`read`,`update`,`del`,`vote`,`download`,`mna`,`mnu`,`mns`,`mnr`) VALUES (8, 'Demo', 0, 1, 0, 0, 0, 0, 1, 0, 0, 0)",

    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (1, '00000-00000-00000-00000-00000', 'skills.energy', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (2, 'AB12C-DE34F-GH56I-JK78L-MN90O', 'webdigital.space', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (3, 'PQ12R-ST34U-VW56X-YZ78A-BC90D', 'wanted.expert', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (4, 'EF12G-HI34J-KL56M-NO78P-QR90S', 'myresume.space', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (5, 'TU12V-WX34Y-ZA56B-CD78E-FG90H', 'myexpert.works', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (6, 'IJ12K-LM34N-OP56Q-RS78T-UV90W', 'myoffers.us', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (7, 'RW5WK-USE5X-WPMXE-DRXK5-LAKKY', 'mylive.email', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (8, 'TGILJ-R2NKQ-VK5RQ-H7I7X-V3JB4', 'megadigital.space', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (9, 'DO1G6-U5DU6-F3DMO-H7NAN-7OKXJ', 'ninobasharuli.live', 'Nino Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (10, 'HCS11-Q38AS-NDZ81-P96WQ-8OQ6S', 'camvision.live', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (11, '694M5-CHHVF-1OZXY-RNFW3-YI885', 'myincome.space', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (12, 'K43QK-E8HIB-BHYWT-BKA6K-RRUTJ', 'watrix.space', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (13, 'P4VL6-QB14L-IO4I3-WPB7S-3QA6V', 'adverts.review', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (14, 'NOVPA-UBTV0-J97J6-9YRIV-1D5LE', 'webdigital.studio', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (15, 'AFD3T-NLBMM-ZU4CA-2EQ1U-83IV3', 'mydigital.works', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (16, '189I1-WVJAZ-ABYS9-QXE3C-JK8W1', 'megadigital.studio', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (17, 'XGKXF-T989S-YF1IO-3UHTM-QY78L', 'mykino.club', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (18, 'IOT03-5JO3C-PKW9G-9SOCH-R14B2', 'realtime.estate', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (19, '7VJMD-YD95F-C26I5-KZH8F-MA5VJ', 'exterior.works', 'Giorgi Basharuli', 'brain@skills.energy', '2024-09-17', 'lifetime')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (20, 'KSC8Y-BRUIS-HSLV9-AR1T0-7JZ17', 'daffodilhome.care', 'Lela Vashakidze', 'lelavusa@gmail.com', '2024-10-25', 'yearly')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (21, 'Z4X9C-V3N1B-T6R8M-Y7L0P-Q2K4J', 'lelaspositive.team', 'Lela Vashakidze', 'lelavusa@gmail.com', '2024-10-25', 'yearly')",
    "INSERT INTO `license_keys` (`id`, `license_key`, `domain`, `cms_owner`, `owner_email`, `created_date`, `version`) VALUES (22, 'A9B3F-2G6H7-KL4M8-9P0Q2-R5S6D', 'marcy.works', 'Lela Vashakidze', 'lelavusa@gmail.com', '2024-10-25', 'yearly')",

    // Добавление данных в таблицу `static_pages`
    "INSERT INTO `static_pages` (`id`,`date`,`alt_name`,`language`,`title`,`full_desc`,`meta_desc`,`meta_keys`,`views`) VALUES (1, NOW(), 'home', 'Russian', 'Главная страница', '&lt;div class=&quot;row mb-2&quot;&gt; &lt;h4 class=&quot;text-center&quot;&gt;Уникальные возможности Skills Energy CMS&lt;/h4&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Простота использования&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Создайте сайт без необходимости в знаниях программирования, используя модули для различных задач.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Модульная архитектура&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Легко интегрируйте модули: объявления, файлы, фильмы, новости и товары, подстраивая их под нужды проекта.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Аналитика и контроль&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Получайте детализированную статистику и мониторинг для эффективного управления всеми модулями.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Управление шаблонами&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Редактируйте шаблоны, css стили и js скрипты сайта через CMS, без необходимости обращаться к исходному коду.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Скорость работы&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Высокая скорость работы и минимальная нагрузка на сервер благодаря оптимизированным процессам.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Надёжность и развитие&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Устойчивая работа, надёжность и возможность масштабирования в соответствии с изменяющимися потребностями.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;d-grid gap-2&quot;&gt; &lt;button class=&quot;btn btn-outline-primary&quot;&gt;Подробнее о всех возможностях&lt;/button&gt; &lt;/div&gt; &lt;/div&gt; &lt;hr class=&quot;my-4-5&quot;&gt; &lt;div class=&quot;row&quot;&gt; &lt;h4 class=&quot;text-center&quot;&gt;3 шага для создания сайта&lt;/h4&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-body border-top border-success&quot;&gt; &lt;h5&gt;&lt;i class=&quot;fa fa-download text-success me-2&quot;&gt;&lt;/i&gt; Скачиваете&lt;/h5&gt; &lt;p class=&quot;mb-0&quot;&gt;Скачиваете дистрибутив с сайта&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-body border-top border-success&quot;&gt; &lt;h5&gt;&lt;i class=&quot;fa fa-upload text-success me-2&quot;&gt;&lt;/i&gt; Загружаете&lt;/h5&gt; &lt;p class=&quot;mb-0&quot;&gt;Загружаете файлы на свой хостинг&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-body border-top border-success&quot;&gt; &lt;h5&gt;&lt;i class=&quot;fa fa-cogs text-success me-2&quot;&gt;&lt;/i&gt; Устанавливаете&lt;/h5&gt; &lt;p class=&quot;mb-0&quot;&gt;Следуете инструкциям в браузере&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;hr class=&quot;my-4-5&quot;&gt; &lt;div class=&quot;row mt-2&quot;&gt; &lt;h4 class=&quot;text-center&quot;&gt;Стоимость и типы лицензии&lt;/h4&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h5 class=&quot;float-start&quot;&gt;&lt;i class=&quot;fa fa-file-text-o text-danger me-2&quot;&gt;&lt;/i&gt; Лицензия на год&lt;/h5&gt; &lt;span class=&quot;float-end border border-danger py-0 px-2&quot;&gt;200 $&lt;/span&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-danger&quot;&gt; &lt;ul class=&quot;list-group list-group-flush mb-2&quot;&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Лицензия на год, для одного домена.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Полный доступ к модам и расширениям.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Новые версии в течение года бесплатно&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Постоянная тех поддержка&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Открытый исходный код&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Разрешено снятие копирайтов&lt;/li&gt; &lt;/ul&gt; &lt;div class=&quot;d-grid gap-2&quot;&gt; &lt;button class=&quot;btn btn-outline-danger&quot;&gt;Купить сейчас&lt;/button&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h5 class=&quot;float-start&quot;&gt;&lt;i class=&quot;fa fa-file-text-o text-danger me-2&quot;&gt;&lt;/i&gt; Постоянная лицензия&lt;/h5&gt; &lt;span class=&quot;float-end border border-danger py-0 px-2&quot;&gt;1000 $&lt;/span&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-danger&quot;&gt; &lt;ul class=&quot;list-group list-group-flush mb-2&quot;&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Постоянная лицензия, для одного домена.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Полный доступ к модам и расширениям.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Новые версии неограниченно бесплатно&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Постоянная тех поддержка&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Открытый исходный код&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Разрешено снятие копирайтов&lt;/li&gt; &lt;/ul&gt; &lt;div class=&quot;d-grid gap-2&quot;&gt; &lt;button class=&quot;btn btn-outline-danger&quot;&gt;Купить сейчас&lt;/button&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt;', '', '', 0)",
    "INSERT INTO `static_pages` (`id`,`date`,`alt_name`,`language`,`title`,`full_desc`,`meta_desc`,`meta_keys`,`views`) VALUES (2, NOW(), 'home', 'English', 'Home page', '&lt;div class=&quot;row mb-2&quot;&gt; &lt;h4 class=&quot;text-center&quot;&gt;Unique Features of Skills Energy CMS&lt;/h4&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Ease of Use&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Create a website without the need for programming knowledge, using modules for various tasks.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Modular Architecture&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Easily integrate modules: ads, files, movies, news, and products, tailoring them to project needs.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Analytics and Control&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Receive detailed statistics and monitoring for effective management of all modules.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Template Management&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Edit website templates, CSS styles, and JS scripts via CMS without accessing the source code.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Performance&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;High performance and minimal server load thanks to optimized processes.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4 mb-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h6&gt;&lt;i class=&quot;fa fa-bars text-primary me-2&quot;&gt;&lt;/i&gt; Reliability and Scalability&lt;/h6&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-primary&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Stable operation, reliability, and scalability to meet changing needs.&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;d-grid gap-2&quot;&gt; &lt;button class=&quot;btn btn-outline-primary&quot;&gt;Learn more about all features&lt;/button&gt; &lt;/div&gt; &lt;/div&gt; &lt;hr class=&quot;my-4-5&quot;&gt; &lt;div class=&quot;row&quot;&gt; &lt;h4 class=&quot;text-center&quot;&gt;3 Steps to Create a Website&lt;/h4&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-body border-top border-success&quot;&gt; &lt;h5&gt;&lt;i class=&quot;fa fa-download text-success me-2&quot;&gt;&lt;/i&gt; Download&lt;/h5&gt; &lt;p class=&quot;mb-0&quot;&gt;Download the distribution from the website&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-body border-top border-success&quot;&gt; &lt;h5&gt;&lt;i class=&quot;fa fa-upload text-success me-2&quot;&gt;&lt;/i&gt; Upload&lt;/h5&gt; &lt;p class=&quot;mb-0&quot;&gt;Upload the files to your hosting&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6 col-lg-4&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-body border-top border-success&quot;&gt; &lt;h5&gt;&lt;i class=&quot;fa fa-cogs text-success me-2&quot;&gt;&lt;/i&gt; Install&lt;/h5&gt; &lt;p class=&quot;mb-0&quot;&gt;Follow the instructions in your browser&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;hr class=&quot;my-4-5&quot;&gt; &lt;div class=&quot;row mt-2&quot;&gt; &lt;h4 class=&quot;text-center&quot;&gt;License Types and Pricing&lt;/h4&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h5 class=&quot;float-start&quot;&gt;&lt;i class=&quot;fa fa-file-text-o text-danger me-2&quot;&gt;&lt;/i&gt; 1-Year License&lt;/h5&gt; &lt;span class=&quot;float-end border border-danger py-0 px-2&quot;&gt;200 $&lt;/span&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-danger&quot;&gt; &lt;ul class=&quot;list-group list-group-flush mb-2&quot;&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; 1-year license for one domain.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Full access to mods and extensions.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Free updates for one year&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Continuous technical support.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Open source code&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Copyright removal allowed&lt;/li&gt; &lt;/ul&gt; &lt;div class=&quot;d-grid gap-2&quot;&gt; &lt;button class=&quot;btn btn-outline-danger&quot;&gt;Buy Now&lt;/button&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-sm-12 col-md-6&quot;&gt; &lt;div class=&quot;card&quot;&gt; &lt;div class=&quot;card-header&quot;&gt; &lt;h5 class=&quot;float-start&quot;&gt;&lt;i class=&quot;fa fa-file-text-o text-danger me-2&quot;&gt;&lt;/i&gt; Lifetime License&lt;/h5&gt; &lt;span class=&quot;float-end border border-danger py-0 px-2&quot;&gt;1000 $&lt;/span&gt; &lt;/div&gt; &lt;div class=&quot;card-body border-top border-danger&quot;&gt; &lt;ul class=&quot;list-group list-group-flush mb-2&quot;&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Lifetime license for one domain.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Full access to mods and extensions.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Free updates indefinitely&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Continuous technical support.&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Open source code&lt;/li&gt; &lt;li class=&quot;list-group-item&quot;&gt;&lt;i class=&quot;fa fa-check me-2&quot;&gt;&lt;/i&gt; Copyright removal allowed&lt;/li&gt; &lt;/ul&gt; &lt;div class=&quot;d-grid gap-2&quot;&gt; &lt;button class=&quot;btn btn-outline-danger&quot;&gt;Buy Now&lt;/button&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt;', '', '', 0)",
    "INSERT INTO `static_pages` (`id`,`date`,`alt_name`,`language`,`title`,`full_desc`,`meta_desc`,`meta_keys`,`views`) VALUES (3, NOW(), 'demonstration', 'Russian', 'Демонстрация CMS Skills.Energy', 'Демонстрация CMS Skills.Energy.&lt;br&gt;&lt;br&gt;&lt;b&gt;Панель управления:&lt;/b&gt; https://skills.energy/admin&lt;br&gt;&lt;b&gt;Логин:&lt;/b&gt;&amp;nbsp;demo@skills.energy&lt;br&gt;&lt;b&gt;Пароль:&lt;/b&gt;&amp;nbsp;sedemo', '', '', 0)",
    "INSERT INTO `static_pages` (`id`,`date`,`alt_name`,`language`,`title`,`full_desc`,`meta_desc`,`meta_keys`,`views`) VALUES (4, NOW(), 'license_buy', 'Russian', 'Купить лицензионный ключ для CMS Skills Energy', 'Купить лицензионный ключ для CMS Skills Energy', '', '', 0)",
    "INSERT INTO `static_pages` (`id`,`date`,`alt_name`,`language`,`title`,`full_desc`,`meta_desc`,`meta_keys`,`views`) VALUES (5, NOW(), 'modules', 'Russian', 'Модули', '&lt;div class=&quot;row&quot;&gt;&lt;div class=&quot;col-12&quot;&gt;&lt;p class=&quot;text-center mb-4&quot;&gt;Добро пожаловать на страницу, посвящённую нашим модулям. Здесь вы можете ознакомиться с функциональными возможностями каждого модуля, просмотреть их в действии и при желании скачать для использования на вашем сайте.&lt;/p&gt;&lt;/div&gt;&lt;div class=&quot;col-6&quot;&gt;&lt;div class=&quot;card mb-3&quot;&gt;&lt;div class=&quot;card-body border-top border-success d-flex align-items-center&quot;&gt;&lt;img src=&quot;system/assets/images/modules/ads.png&quot; class=&quot;module-actual-color height-70px&quot; alt=&quot;&quot;&gt;&lt;div class=&quot;content w-100 ms-3&quot;&gt;&lt;a href=&quot;https://ads.skills.energy&quot; class=&quot;float-end&quot; target=&quot;_blank&quot;&gt;Демо&lt;/a&gt;&lt;div class=&quot;text&quot;&gt;&lt;a href=&quot;/files/ads&quot; style=&quot;color: var(--theme-color2);&quot;&gt;Модуль объявлений&lt;/a&gt;&lt;/div&gt;&lt;div class=&quot;number&quot;&gt;Version: &lt;span id=&quot;adsVersion&quot;&gt;&lt;/span&gt; | Update: &lt;span id=&quot;adsDate&quot;&gt;&lt;/span&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;card-footer py-2&quot;&gt;&lt;p class=&quot;mb-0 fs-7&quot;&gt;Позволяет пользователям создавать, редактировать и управлять объявлениями, легко, удобно и быстро.&lt;/p&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;col-6&quot;&gt;&lt;div class=&quot;card mb-3&quot;&gt;&lt;div class=&quot;card-body border-top border-success d-flex align-items-center&quot;&gt;&lt;img src=&quot;system/assets/images/modules/files.png&quot; class=&quot;module-actual-color height-70px&quot; alt=&quot;&quot;&gt;&lt;div class=&quot;content w-100 ms-3&quot;&gt;&lt;a href=&quot;https://files.skills.energy&quot; class=&quot;float-end&quot; target=&quot;_blank&quot;&gt;Демо&lt;/a&gt;&lt;div class=&quot;text&quot;&gt;&lt;a href=&quot;/files/files&quot; style=&quot;color: var(--theme-color3);&quot;&gt;Модуль файлов&lt;/a&gt;&lt;/div&gt;&lt;div class=&quot;number&quot;&gt;Version: &lt;span id=&quot;filesVersion&quot;&gt;&lt;/span&gt; | Update: &lt;span id=&quot;filesDate&quot;&gt;&lt;/span&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;card-footer py-2&quot;&gt;&lt;p class=&quot;mb-0 fs-7&quot;&gt;Храните, управляйте и делятесь файлами. Поддержка загрузки, сортировки и облегченного поиска.&lt;/p&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;col-6&quot;&gt;&lt;div class=&quot;card mb-3&quot;&gt;&lt;div class=&quot;card-body border-top border-success d-flex align-items-center&quot;&gt;&lt;img src=&quot;system/assets/images/modules/movies.png&quot; class=&quot;module-actual-color height-70px&quot; alt=&quot;&quot;&gt;&lt;div class=&quot;content w-100 ms-3&quot;&gt;&lt;a href=&quot;https://movies.skills.energy&quot; class=&quot;float-end&quot; target=&quot;_blank&quot;&gt;Демо&lt;/a&gt;&lt;div class=&quot;text&quot;&gt;&lt;a href=&quot;/files/movies&quot; style=&quot;color: var(--theme-color4);&quot;&gt;Модуль фильмов&lt;/a&gt;&lt;/div&gt;&lt;div class=&quot;number&quot;&gt;Version: &lt;span id=&quot;moviesVersion&quot;&gt;&lt;/span&gt; | Update: &lt;span id=&quot;moviesDate&quot;&gt;&lt;/span&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;card-footer py-2&quot;&gt;&lt;p class=&quot;mb-0 fs-7&quot;&gt;Позволяет добавлять, редактировать и просматривать фильмы, предоставляя удобный просмотр контента.&lt;/p&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;col-6&quot;&gt;&lt;div class=&quot;card mb-3&quot;&gt;&lt;div class=&quot;card-body border-top border-success d-flex align-items-center&quot;&gt;&lt;img src=&quot;system/assets/images/modules/news.png&quot; class=&quot;module-actual-color height-70px&quot; alt=&quot;&quot;&gt;&lt;div class=&quot;content w-100 ms-3&quot;&gt;&lt;a href=&quot;https://news.skills.energy&quot; class=&quot;float-end&quot; target=&quot;_blank&quot;&gt;Демо&lt;/a&gt;&lt;div class=&quot;text&quot;&gt;&lt;a href=&quot;/files/news&quot; style=&quot;color: var(--theme-color5);&quot;&gt;Модуль новостей&lt;/a&gt;&lt;/div&gt;&lt;div class=&quot;number&quot;&gt;Version: &lt;span id=&quot;newsVersion&quot;&gt;&lt;/span&gt; | Update: &lt;span id=&quot;newsDate&quot;&gt;&lt;/span&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;card-footer py-2&quot;&gt;&lt;p class=&quot;mb-0 fs-7&quot;&gt;Позволяет добавлять, редактировать и публиковать новости. Удобная система категорий и комментариев для организации контента.&lt;/p&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;col-6&quot;&gt;&lt;div class=&quot;card mb-3&quot;&gt;&lt;div class=&quot;card-body border-top border-success d-flex align-items-center&quot;&gt;&lt;img src=&quot;system/assets/images/modules/products.png&quot; class=&quot;module-actual-color height-70px&quot; alt=&quot;&quot;&gt;&lt;div class=&quot;content w-100 ms-3&quot;&gt;&lt;a href=&quot;https://products.skills.energy&quot; class=&quot;float-end&quot; target=&quot;_blank&quot;&gt;Демо&lt;/a&gt;&lt;div class=&quot;text&quot;&gt;&lt;a href=&quot;/files/products&quot; style=&quot;color: var(--theme-color6);&quot;&gt;Модуль товаров&lt;/a&gt;&lt;/div&gt;&lt;div class=&quot;number&quot;&gt;Version: &lt;span id=&quot;productsVersion&quot;&gt;&lt;/span&gt; | Update: &lt;span id=&quot;productsDate&quot;&gt;&lt;/span&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;card-footer py-2&quot;&gt;&lt;p class=&quot;mb-0 fs-7&quot;&gt;Удобное управление товарами, категориями и онлайн-оплатой. Превратите свой сайт в торговую площадку.&lt;/p&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;', '', '', 0)",
    "INSERT INTO `static_pages` (`id`,`date`,`alt_name`,`language`,`title`,`full_desc`,`meta_desc`,`meta_keys`,`views`) VALUES (6, NOW(), 'contacts', 'Russian', 'Контакты', '&lt;h5&gt;Наши контакты:&lt;/h5&gt; &lt;div class=&quot;row&quot;&gt; &lt;div class=&quot;col-12 col-md-6&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Github: &lt;a href=&quot;https://github.com/brain-skills&quot; target=&quot;_blank&quot;&gt;https://github.com/brain-skills&lt;/a&gt;&lt;/p&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-md-6&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;E-mail: &lt;a href=&quot;mailto:brain@skills.energy&quot; target=&quot;_blank&quot;&gt;brain@skills.energy&lt;/a&gt;&lt;/p&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-md-6&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Discord: &lt;a href=&quot;https://discord.gg/ZUNJMqxC9f&quot; target=&quot;_blank&quot;&gt;https://discord.gg/ZUNJMqxC9f&lt;/a&gt;&lt;/p&gt; &lt;/div&gt; &lt;div class=&quot;col-12 col-md-6&quot;&gt; &lt;p class=&quot;mb-0&quot;&gt;Telegram: &lt;a href=&quot;https://t.me/gaga_usa&quot; target=&quot;_blank&quot;&gt;https://t.me/gaga_usa&lt;/a&gt;&lt;/p&gt; &lt;/div&gt; &lt;/div&gt;', '', '', 0)",
    "INSERT INTO `static_pages` (`id`,`date`,`alt_name`,`language`,`title`,`full_desc`,`meta_desc`,`meta_keys`,`views`) VALUES (7, NOW(), 'license', 'Russian', 'Лицензионное соглашение', '&lt;p&gt;&lt;b&gt;Лицензионное соглашение для Skills Energy CMS&lt;/b&gt;&lt;/p&gt;&lt;p&gt;ВНИМАНИЕ: Это лицензионное соглашение (далее - &quot;Соглашение&quot;) между вами (физическим или юридическим лицом) и владельцем проекта Skills Energy CMS (далее - &quot;Владелец&quot;). Пожалуйста, внимательно ознакомьтесь с условиями данного Соглашения перед использованием данного программного продукта.&lt;/p&gt;&lt;b&gt;1. Лицензионные ключи&lt;/b&gt;&lt;p&gt;1.1 Владелец предоставляет два типа лицензионных ключей для использования Skills Energy CMS: временный (на 1 год) и постоянный (навсегда).&lt;/p&gt;&lt;p&gt;1.2 Вам предоставляется право использовать Skills Energy CMS с лицензионным ключом в соответствии с условиями данного Соглашения.&lt;/p&gt;&lt;p&gt;&lt;b&gt;2. Коммерческое использование&lt;/b&gt;&lt;/p&gt;&lt;p&gt;2.1 Коммерческое использование Skills Energy CMS разрешено только при наличии соответствующего лицензионного ключа для конкретного домена.&lt;/p&gt;&lt;p&gt;2.2 Если у вас нет действующего лицензионного ключа для указанного домена, коммерческое использование Skills Energy CMS запрещено.&lt;/p&gt;&lt;p&gt;&lt;b&gt;3. Временный лицензионный ключ&lt;/b&gt;&lt;/p&gt;&lt;p&gt;3.1 Временный лицензионный ключ предоставляет вам право использовать Skills Energy CMS в коммерческих целях только на указанном домене в течение одного года с момента активации ключа.&lt;/p&gt;&lt;p&gt;3.2 По истечении срока действия временного лицензионного ключа, необходимо приобрести новый ключ или перейти на постоянный ключ для продолжения коммерческого использования на том же домене.&lt;/p&gt;&lt;p&gt;&lt;b&gt;4. Постоянный лицензионный ключ&lt;/b&gt;&lt;/p&gt;&lt;p&gt;4.1 Постоянный лицензионный ключ предоставляет вам бессрочное право на коммерческое использование Skills Energy CMS только на указанном домене.&lt;/p&gt;&lt;p&gt;4.2 Владелец оставляет за собой все права к данной Skills Energy CMS, и пользователь не получает прав на воспроизводство, распространение, продажу, взлом, модификации, или создание производных продуктов на основе Skills Energy CMS.&lt;/p&gt;&lt;p&gt;&lt;b&gt;5. Ограничения и обязанности пользователя&lt;/b&gt;&lt;/p&gt;&lt;p&gt;5.1 Вы обязуетесь не распространять, не изменять и не создавать производные продукты на основе Skills Energy CMS без письменного разрешения Владельца.&lt;/p&gt;&lt;p&gt;5.2 Запрещается продажа, взлом, модификации или попытки обхода лицензионных мер без письменного разрешения Владельца.&lt;/p&gt;&lt;p&gt;5.3 Нарушение условий данного Соглашения может привести к прекращению лицензии и предъявлению юридических претензий.&lt;/p&gt;&lt;p&gt;&lt;b&gt;6. Завершающие положения&lt;/b&gt;&lt;/p&gt;&lt;p&gt;6.1 Данное Соглашение считается заключенным и действительным с момента начала использования Skills Energy CMS.&lt;/p&gt;&lt;p&gt;6.2 Владелец оставляет за собой право в любой момент изменить условия данного Соглашения с предварительным уведомлением пользователя.&lt;/p&gt;&lt;p&gt;© 2024 Skills Energy CMS. Все права защищены.', '', '', 0)",
    "INSERT INTO `static_pages` (`id`,`date`,`alt_name`,`language`,`title`,`full_desc`,`meta_desc`,`meta_keys`,`views`) VALUES (8, NOW(), 'license', 'English', 'License Agreement', '&lt;p&gt;&lt;b&gt;Skills Energy CMS License Agreement&lt;/b&gt;&lt;/p&gt;&lt;p&gt;ATTENTION: This is a license agreement (hereinafter referred to as the &quot;Agreement&quot;) between you (an inpidual or legal entity) and the owner of the Skills Energy CMS project (hereinafter referred to as the &quot;Owner&quot;). Please carefully read the terms of this Agreement before using this software product.&lt;/p&gt;&lt;p&gt;&lt;b&gt;1. License Keys&lt;/b&gt;&lt;/p&gt;&lt;p&gt;1.1 The Owner provides two types of license keys for using Skills Energy CMS: temporary (for 1 year) and permanent (forever).&lt;/p&gt;&lt;p&gt;1.2 You are granted the right to use Skills Energy CMS with a license key in accordance with the terms of this Agreement.&lt;/p&gt;&lt;p&gt;&lt;b&gt;2. Commercial Use&lt;/b&gt;&lt;/p&gt;&lt;p&gt;2.1 Commercial use of Skills Energy CMS is allowed only with the corresponding license key for a specific domain.&lt;/p&gt;&lt;p&gt;2.2 If you do not have a valid license key for the specified domain, commercial use of Skills Energy CMS is prohibited.&lt;/p&gt;&lt;p&gt;&lt;b&gt;3. Temporary License Key&lt;/b&gt;&lt;/p&gt;&lt;p&gt;3.1 The temporary license key gives you the right to use Skills Energy CMS for commercial purposes only on the specified domain for one year from the activation date.&lt;/p&gt;&lt;p&gt;3.2 Upon expiration of the temporary license key, you must purchase a new key or switch to a permanent key to continue commercial use on the same domain.&lt;/p&gt;&lt;p&gt;&lt;b&gt;4. Permanent License Key&lt;/b&gt;&lt;/p&gt;&lt;p&gt;4.1 The permanent license key grants you a perpetual right to use Skills Energy CMS only on the specified domain.&lt;/p&gt;&lt;p&gt;4.2 The Owner retains all rights to Skills Energy CMS, and the user does not have the right to reproduce, distribute, sell, hack, modify, or create derivative products based on Skills Energy CMS.&lt;/p&gt;&lt;p&gt;&lt;b&gt;5. Restrictions and User Responsibilities&lt;/b&gt;&lt;/p&gt;&lt;p&gt;5.1 You agree not to distribute, modify, or create derivative products based on Skills Energy CMS without the written permission of the Owner.&lt;/p&gt;&lt;p&gt;5.2 Sale, hacking, modification, or attempts to bypass license measures without the written permission of the Owner are strictly prohibited.&lt;/p&gt;&lt;p&gt;5.3 Violation of the terms of this Agreement may result in license termination and legal action.&lt;/p&gt;&lt;p&gt;&lt;b&gt;6. Concluding Provisions&lt;/b&gt;&lt;/p&gt;&lt;p&gt;6.1 This Agreement is considered concluded and valid from the moment of starting to use Skills Energy CMS.&lt;/p&gt;&lt;p&gt;6.2 The Owner reserves the right to change the terms of this Agreement at any time with prior notice to the user.&lt;/p&gt;&lt;p&gt;© 2024 Skills Energy CMS. All rights reserved.', '', '', 0)",

    // Добавление данных в таблицу `users`
    "INSERT INTO `users` (`id`, `email`, `password`, `group`, `name`, `age`, `gender`, `phone`, `city`, `balance`, `avatar`, `bg_image`, `followers`, `likes`, `views`, `bio`, `pay_methods`, `purchases`, `sales`, `lastdate`, `regdate`, `banned`, `allowpm`, `allpm`, `pmunread`)
    VALUES (1, 'brain@skills.energy', '$hashPass', 1, 'Admin', 33, 'Мужчина', '+995571911137', 'Minneapolis', '100.00', CONCAT('uploads/profiles/2024/1/1/avatar.jpg'), 'uploads/profiles/2024/1/1/bg.jpg', 0, 0, 0, 'BIO', 'Credit Card, PayPal', 0, 0, '2024-01-10 10:00:00', '2024-01-15 10:00:00', 0, 1, 0, 0)",
    "INSERT INTO `users` (`id`, `email`, `password`, `group`, `name`, `age`, `gender`, `phone`, `city`, `balance`, `avatar`, `bg_image`, `followers`, `likes`, `views`, `bio`, `pay_methods`, `purchases`, `sales`, `lastdate`, `regdate`, `banned`, `allowpm`, `allpm`, `pmunread`)
    VALUES (2, 'marixurtcidze93@mail.ru', '$hashPass', 2, 'Mariami', 30, 'Женщина', '+995571011137', 'Los Angeles', '400.00', CONCAT('uploads/profiles/2024/1/2/avatar.jpg'), 'uploads/profiles/2024/1/2/bg.jpg', 0, 0, 0, 'BIO', 'Cash, Apple Pay', 0, 0, '2024-01-10 00:00:00', '2024-01-15 00:00:00', 0, 1, 0, 0)",
    "INSERT INTO `users` (`id`, `email`, `password`, `group`, `name`, `age`, `gender`, `phone`, `city`, `balance`, `avatar`, `bg_image`, `followers`, `likes`, `views`, `bio`, `pay_methods`, `purchases`, `sales`, `lastdate`, `regdate`, `banned`, `allowpm`, `allpm`, `pmunread`)
    VALUES (3, 'demo@skills.energy', '$demoHashPass', 8, 'Demo profile', 18, '', '+1(000)000-0000', 'Earth', '0.00', CONCAT('uploads/profiles/2024/1/3/avatar.jpg'), 'uploads/profiles/2024/1/3/bg.jpg', 0, 0, 0, 'DEMO BIOGRAPHY', 'Credit Card, Bitcoin', 0, 0, '2024-01-10 00:00:00', '2024-01-15 00:00:00', 0, 1, 0, 0)",

    // Добавление данных в таблицу `security_questions`
    "INSERT INTO `security_questions` (`language`, `question`, `answer`) VALUES ('Russian', 'Сколько минут в 1 часу', '60')",
    "INSERT INTO `security_questions` (`language`, `question`, `answer`) VALUES ('Russian', 'Сколько ног у кошки?', '4')",
    "INSERT INTO `security_questions` (`language`, `question`, `answer`) VALUES ('Russian', 'Сколько месяцев в году?', '12')",
    "INSERT INTO `security_questions` (`language`, `question`, `answer`) VALUES ('Russian', 'Сколько рук у человека?', '2')",

    // Добавление данных в таблицу `tasks`
    "INSERT INTO `tasks` (`id`, `title`, `author`, `date`, `description`, `status`, `views`) VALUES (1, 'Изучить документацию', 'Admin', NOW(), 'Пожалуйста, ознакомьтесь с &lt;a href=&quot;https://docs.skills.energy/&quot; target=&quot;_blank&quot;&gt;документацией&lt;/a&gt; по нашей CMS, чтобы лучше понять её функциональность, возможности и особенности.', 'pending', 0)",
];*/



// Выполнение запросов
/*foreach ($addData as $sql) {
    if ($db_connect->query($sql) !== TRUE) {
        error_log("Ошибка при добавлении данных: " . $db_connect->error . "\n", 3, 'errors.log');
        $successFlag = false;
    }
}*/

// Проверяем флаг и выводим сообщение
if ($successFlag) {
    // После установки обновляем значение в конфиге
    $config['cms_installed'] = true;
    require_once(ENGINE_DIR . '/mods/current_date.php');
    require_once(ENGINE_DIR . '/mods/update_config.php');
    // Вывод результата
    echo "
			<script>
				alert('Данные успешно добавлены');
				window.location.href = window.location.href;
			</script>
		";
}