<!doctype html>
<html lang="en">
<head>
	<title>{$data.title}</title>
	<meta charset="{$charset}">
	<meta http-equiv="X-UA-Compatible" content="IE=Edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="{$description}">
	<meta name="keyword" content="{$keywords}">
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/streamsaver@2.0.0/stream-saver.min.js"></script>

	{include file="./tpl/head/default.tpl"}
	{if $adminaction == 'website-templates' || $adminaction == 'email-templates-edit' || $adminaction == 'language-settings'}
	{include file="./tpl/head/codemirror.tpl"}
	{/if}
	{if $adminaction == 'settings'}
	<script src="../system/assets/js/custom.js"></script>
	{/if}
	{if $adminaction == 'payment-systems'}
	{include file="./tpl/head/payment_systems_sprites.tpl"}
	{/if}
</head>

<body data-bvite="theme-CeruleanBlue" class="layout-border svgstroke-a layout-default box-layout app-chat rightbar-hide">
	<!-- start: main grid layout -->
	<div id="global-spinner" class="spinner-overlay hidden">
		<div class="spinner-border text-primary" role="status">
			<span class="visually-hidden">Загрузка...</span>
		</div>
	</div>
	<style>
		.spinner-overlay {
			position: fixed;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			background: rgba(255, 255, 255, 0.3); /* Полупрозрачный фон */
			backdrop-filter: blur(3px); /* Размытие фона */
			display: flex;
			justify-content: center;
			align-items: center;
			z-index: 9999;
		}

		.spinner-border-lg {
			width: 3rem;
			height: 3rem;
			border-width: 0.3em;
		}

		.spinner-border-sm {
			width: 1rem;
			height: 1rem;
			border-width: 0.15em;
		}

		.hidden {
			display: none !important;
		}
	</style>
	<main class="container-fluid px-0 no-grid-rows">
		<!-- start: project logo -->
		<div class="px-md-3 px-3 py-3 brand d-flex justify-content-center" data-bs-theme="none">
			<div class="d-flex flex-column justify-content-between align-items-center">
				<div class="d-flex align-items-center">
					<button class="btn d-inline-flex d-xl-none border-0 p-0 pe-2" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvas_Navbar">
						<svg class="svg-stroke" xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 24 24" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
							<path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
							<path d="M4 6l16 0"></path>
							<path d="M4 12l16 0"></path>
							<path d="M4 18l16 0"></path>
						</svg>
					</button>
					<img src="../system/assets/svg/large.svg" alt="large logo" class="d-none d-xl-flex w-100" onclick="window.location.href='{$currentDir}'" style="cursor:pointer;">
					<img src="../system/assets/svg/middle.svg" alt="middle logo" class="d-none d-md-flex d-xl-none w-75" onclick="window.location.href='{$currentDir}'" style="cursor:pointer;">
					<img src="../system/assets/svg/short-logo.svg" alt="short logo" class="d-sm-flex d-md-none w-75" onclick="window.location.href='{$currentDir}'" style="cursor:pointer;">
				</div>
				<ul class="nav border border-1 rounded-1 d-none d-xl-inline-flex w-100" role="tablist">
					<li class="nav-item" role="presentation">
						<a type="button" class="btn border-0 bg-transparent rounded-1 text-muted fs-8 py-1 px-2"><i class="fa fa-linode"></i> BEST SOLID PRINCIPLES CMS</a>
					</li>
				</ul>
			</div>
		</div>
		<!-- start: page header -->
		<header class="px-md-4 px-3" data-bs-theme="none">
			<div class="d-flex justify-content-between align-items-center py-2 w-100">
				{include file="./tpl/megamenu.tpl"}
				{include file="./tpl/search.tpl"}

				<ul class="header-menu flex-grow-1">
					{if $config.users_setting.notifications}
						{include file="./tpl/notifications.tpl"}
						<li class="nav-item px-2">
							<div class="vr d-flex h-100 mx-2"></div>
						</li>
					{/if}
					{if $config.users_setting.messages}
						{include file="./tpl/messages.tpl"}
						<li class="nav-item px-2">
							<div class="vr d-flex h-100 mx-2"></div>
						</li>
					{/if}

					<li class="nav-item">
						<a class="gray-6" href="/" target="_blank" title="Site">
							<svg class="svg-stroke" xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
								<path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
								<path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0"></path>
								<path d="M3.6 9h16.8"></path>
								<path d="M3.6 15h16.8"></path>
								<path d="M11.5 3a17 17 0 0 0 0 18"></path>
								<path d="M12.5 3a17 17 0 0 1 0 18"></path>
							</svg>
						</a>
					</li>
					<li class="nav-item px-2">
						<div class="vr d-flex h-100 mx-2"></div>
					</li>
					{include file="./tpl/notifications.tpl"}
					<li class="nav-item px-2">
						<div class="vr d-flex h-100 mx-2"></div>
					</li>
					{include file="./tpl/theme.tpl"}
					<li class="nav-item px-2">
						<div class="vr d-flex h-100 mx-2"></div>
					</li>
					{include file="./tpl/language.tpl"}
					<li class="nav-item px-1">
						<div class="vr d-flex h-100 mx-2"></div>
					</li>
					{include file="./tpl/profile.tpl"}
				</ul>
			</div>
		</header>

		<!-- start: page menu link -->
		<aside class="ps-3 pe-2 py-3 sidebar" data-bs-theme="none">
			<nav class="navbar navbar-expand-xl py-0">
				<div class="offcanvas offcanvas-start" data-bs-scroll="true" tabindex="-1" id="offcanvas_Navbar">
					<div class="offcanvas-header">
						<img src="../system/assets/svg/large.svg" alt="large logo" class="w-50">
						<button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
					</div>
					<div class="offcanvas-body flex-column custom_scroll ps-4 ps-xl-0">
						{include file="./tpl/leftside.tpl"}
						{include file="./tpl/license/button.tpl"}
					</div>
				</div>
			</nav>
		</aside>

		{include file="./tpl/rightbar.tpl"}

		<!-- start: page header area -->
		<div class="px-md-4 px-3 py-2 page-header" data-bs-theme="none">
			<div class="d-flex align-items-center">
				<button class="btn d-none d-xl-inline-flex me-3 px-0 sidebar-toggle" type="button">
					<svg class="svg-stroke" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
						<path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
						<path d="M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z"></path>
						<path d="M9 4v16"></path>
						<path d="M15 10l-2 2l2 2"></path>
					</svg>
				</button>
				<ol class="breadcrumb mb-0 bg-transparent d-md-flex">
					<li class="breadcrumb-item"><a href="{$currentDir}" title="{$lang.topmenu.homepage}"><img src="{$stheme}/svg/home.svg" alt=""></a></li>
					{$page_name}
				</ol>
			</div>
			{include file="./tpl/breadcrumbs.tpl"}
		</div>

		<!-- start: page body area -->
		<div class="ps-md-4 pe-md-3 px-3 py-3 page-body">
			{$content}
		</div>

		<!-- start: page footer -->
		<footer class="px-md-4 px-3">
			<p class="mb-0 text-muted">© 2024 <a href="https://megadigital.studio/" target="_blank" title="Mega Digital Studio">Mega Digital Studio</a>, All Rights Reserved.</p>
		</footer>
	</main>

	{include file="./tpl/modal.tpl"}
	{include file="./tpl/license/block.tpl"}
	{include file="./tpl/bodyend/task_form.tpl"}

	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	{if !isset($add_page)}
		{include file="./tpl/bodyend/default.tpl"}
	{/if}
	{if isset($add_page)}
		{if $add_page == 'add_page'}
			{include file="./tpl/bodyend/add_page.tpl"}
			{include file="./tpl/bodyend/slugify.tpl"}
		{/if}
	{/if}
	{include file="./tpl/bodyend/neutral.tpl"}
</body>
</html>