$(function () {

    let currentUserToken = null;
    let wsUrl = null;
    let ws;
    let chats;
    let activeUser = 0;

    $.ajax({
        url: '/engine/ajax/lib/notification/get_token.php', // Замените на ваш маршрут
        type: 'GET',
        data: { },
        dataType: 'json',
        success: function(response) {
            if (response.token !== false) {
                currentUserToken = response.token;
                wsUrl = response.ws_config.web_socket_url;
                connectToWebSocket();
            }
        },
        error: function(xhr) {
        }
    });


    function connectToWebSocket() {

        ws = new WebSocket(wsUrl + '?usr_token=' + currentUserToken);

        ws.onopen = function () {
            ws.send(JSON.stringify({
                type: 'support',
                from_user_token: currentUserToken,
                action: "connect",
                //globalLang: window.globalLang
            }));
        };

        ws.onmessage = function (event) {
            const data = JSON.parse(event.data);

            if (data.type === "support" && data.action === "connect") {
                chats = data.chatDataList;
                $.each(chats, function(key, value) {
                    chats[key].sort(function(a, b) {
                        return new Date(b.c) - new Date(a.date);
                    });
                });



                $('#userList').empty(); // очищаем текущий список
                data.chatUsers.forEach(function(user, index) {
                    const isActive = index === 0 ? 'active' : ''; // Первый пользователь активный
                    const userItem = `
                                <li class="chat-user-item ${isActive}" data-user="${user.id}">
                                    <img src="${user.avatar}" alt="${user.name}" class="chat-user-avatar" />
                                    <div class="chat-user-info">
                                        <div class="chat-user-name">${user.name}</div>
                                        <div class="chat-user-last-message"></div>
                                    </div>
                                    <div class="chat-user-time"></div>
                                </li>
                            `;
                    $('#userList').append(userItem);
                });


                $('#requestList').empty(); // очищаем текущий список

                data.userRequests.forEach(function(userRequest, index) {
                    const isActive = index === 0 ? 'active' : ''; // Первый пользователь активный
                    const userItem = `
                                    <li class="chat-user-item ${isActive}" data-user="${userRequest.user.id}">
                                        <img src="${userRequest.user.avatar}" alt="${userRequest.user.name}" class="chat-user-avatar" />
                                        <div class="chat-user-info">
                                            <div class="chat-user-name">${userRequest.user.name}</div>
                                            <div class="chat-user-last-message"></div>
                                        </div>
                                        <div class="chat-user-time"></div>
                                        <button class="btn btn-sm btn-outline-primary accept-user-btn" data-request-id="${userRequest.id}">Принять</button>
                                    </li>
                                `;
                    $('#requestList').append(userItem);


                });
                if (data.userRequests.length > 0) {
                    $('#requestCountBadge').text(data.userRequests.length).show();
                } else {
                    $('#requestCountBadge').hide();
                }

                const first = Object.values(data.chatUsers)[0];

                if (first) {
                    activeUser = first.id;
                }

                renderChat(activeUser);
            } else if (data.type === "support" && data.action === "sendMessage") {

                if (data.connectedUserType === "support") {
                    addMessage('user', 'Вы', data.message.message);
                    $('#messageInput').val('');
                } else {
                    if (data.toUserId == activeUser) {
                     /*   chats[activeUser] = chats[activeUser] || [];
                        chats[activeUser].push({ from, name, text, file });

                        renderChat(activeUser);
                        const $chat = $('#chatMessages');
                        //  let msgContent = text;

                        const $msg = $(`
                                      <div class="message from-them">
                                        <strong>${data.message.sender_name}:</strong> ${data.message.message}
                                      </div>
                                    `);

                        $chat.append($msg);
                        // Автоскролл вниз
                        $chat.scrollTop($chat[0].scrollHeight);*/

                        addMessage('them', data.message.sender_name, data.message.message);

                    }

                }


            } else if (data.type === "support" && data.action === "getUserChat") {

                let chatData = data.chatDataList[activeUser];
                chatData.sort(function(a, b) {
                    return new Date(b.c) - new Date(a.date);
                });
                chats[activeUser] = chatData;

                renderChat(activeUser);

            }

        }

    }

    $('#right-chat').on('click', '.accept-user-btn', function () {
        const requestId = $(this).data('request-id');

        ws.send(JSON.stringify({
            type: 'support',
            from_user_token: currentUserToken,
            action: "connect",
            subAction: "acceptUserRequest",
            requestId: requestId
            //globalLang: window.globalLang
        }));
    });

    $("#chat-request-tab").on("click", function () {

        $(".chat-messages").css("display", "none");
        $(".chat-input-area").css("display", "none");

    });
    $("#chat-list-tab").on("click", function () {

        $(".chat-messages").css("display", "flex");
        $(".chat-input-area").css("display", "flex");

    });

    function renderChat(userKey) {
        const messages = chats[userKey] || [];
        const $chat = $('#chatMessages');
        $chat.empty();
        messages.forEach(({ from, name, text, file }) => {
            let msgContent = '';
            if (file) {
                msgContent = `<em class="file-message">Файл: ${file}</em>`;
            } else {
                msgContent = text;
            }
            const $msg = $(`
                                                  <div class="message from-${from}">
                                                    <strong>${name}:</strong> ${msgContent}
                                                  </div>
                                                `);
            $chat.append($msg);
        });
        // Автоскролл вниз
        $chat.scrollTop($chat[0].scrollHeight);
    }

    //    renderChat(activeUser);

    $('#userList').on('click', '.chat-user-item', function () {
        if ($(this).hasClass('active')) return;

        $('.chat-user-item.active').removeClass('active');
        $(this).addClass('active');

        activeUser = $(this).data('user');

        ws.send(JSON.stringify({
            type: 'support',
            from_user_token: currentUserToken,
            action: "getUserChat",
            userId: activeUser
            //globalLang: window.globalLang
        }));

        renderChat(activeUser);

    });

    $('#chatSearch').on('input', function () {
        const val = $(this).val().toLowerCase();
        $('#userList .chat-user-item').each(function () {
            const name = $(this).find('.chat-user-name').text().toLowerCase();
            $(this).toggle(name.indexOf(val) !== -1);
        });
    });

    // Отправка сообщений и файлов
    function addMessage(from, name, text, file = null) {
        chats[activeUser] = chats[activeUser] || [];
        chats[activeUser].push({ from, name, text, file });
        renderChat(activeUser);

        // Обновляем последний текст в списке пользователей
        const lastMsgText = file ? `Файл: ${file}` : text;
        const now = new Date();
        const hours = now.getHours().toString().padStart(2, '0');
        const minutes = now.getMinutes().toString().padStart(2, '0');

        const $activeUserLi = $('#userList').find(`.chat-user-item[data-user="${activeUser}"]`);
        $activeUserLi.find('.chat-user-last-message').text(lastMsgText);
        $activeUserLi.find('.chat-user-time').text(`${hours}:${minutes}`);
    }

    $('#sendBtn').click(function () {
        const messageText = $('#messageInput').val().trim();
        const fileInput = $('#fileInput')[0];
        if (!messageText && fileInput.files.length === 0) {
            return; // ничего не отправляем, если пусто
        }

        ws.send(JSON.stringify({
            type: 'support',
            from_user_token: currentUserToken,
            action: "sendMessage",
            to_user_id_sup: activeUser,
            message: messageText
            //globalLang: window.globalLang
        }));
        /*
                                                    if (fileInput.files.length > 0) {
                                                        // Отправляем файл (отображаем имя)
                                                        const fileName = fileInput.files[0].name;
                                                        addMessage('user', 'Вы', '', fileName);
                                                        fileInput.value = '';
                                                    }

                                                    if (messageText) {

                                                    }*/
    });

    // Отправка по Enter (если поле ввода в фокусе)
    $('#messageInput').on('keypress', function (e) {
        if (e.which === 13 && !e.shiftKey) {
            e.preventDefault();
            $('#sendBtn').click();
        }
    });
});
