$(document).ready(function() {
    /*$('#file-select').select2({
        placeholder: "Выберите файл задачи",
        width: '100%'
    });*/

    const phpPath = '/usr/bin/php';
    const scriptPath = $("#cron-jobs-path").val();

    $('#file-select').on('change', function () {
        const filename = $(this).val();
        if (filename) {
            $('#command').val(`${phpPath} ${scriptPath}${filename}`);
        } else {
            $('#command').val('');
        }
    });

    function updateDescription() {
        let min = $('input[name="min"]').val();
        let hour = $('input[name="hour"]').val();
        let day = $('input[name="day"]').val();
        let month = $('input[name="month"]').val();
        let weekday = $('input[name="weekday"]').val();

        let expr = `${min} ${hour} ${day} ${month} ${weekday}`;
        try {
            const human = cronstrue.toString(expr, { locale: 'ru' });
            $('#cron-description').text(human);
        } catch (e) {
            $('#cron-description').text('Ошибка в расписании');
        }
    }

    $('input').on('input', updateDescription);
    updateDescription();

    $('#cron-form').on('submit', function(e) {
        e.preventDefault();

        $.post('/engine/ajax/lib/cron/save_cron.php', $(this).serialize(), function(res) {
            Swal.fire({
                title: 'Info',
                text: res,
                icon: 'info',
                confirmButtonText: 'OK'
            }).then((result) => {
                if (result.isConfirmed) {
                    location.reload();
                }
            });
            $('#cron-form')[0].reset();
            $('#cron-submit-btn').text('💾 Добавить задачу');
            $('#cron-cancel-btn').hide();
            $('input[name="edit_id"]').remove();
            $('#file-select').val('').trigger('change');
            updateDescription();

        });
    });

    $('#cron-table tbody tr').each(function() {
        const cronExpr = $(this).find('.cron-expr').text().trim();
        try {
            const desc = cronstrue.toString(cronExpr);
            $(this).find('.cron-desc').text(desc);
        } catch(e) {
            $(this).find('.cron-desc').text('Ошибка в выражении');
        }
    });


    $('.delete-btn').click(function () {
        if (!confirm("Удалить эту задачу?")) return;
        const id = $(this).closest('tr').data('id');
        $.post('/engine/ajax/lib/cron/delete_cron.php', { id }, function (res) {
            Swal.fire({
                title: 'Info',
                text: res,
                icon: 'info',
                confirmButtonText: 'OK'
            }).then((result) => {
                if (result.isConfirmed) {
                    location.reload();
                }
            });

        });
    });

    $('#cron-cancel-btn').on('click', function () {
        // Очистка всех полей
        $('#cron-form')[0].reset();

        // Сброс описания
        updateDescription();

        // Очистка скрытого поля edit_id
        $('input[name="edit_id"]').remove();

        // Сброс текста кнопки
        $('#cron-submit-btn').text('💾 Добавить задачу');

        // Сброс select
        $('#file-select').val('').trigger('change');

        // Скрыть кнопку отмены
        $(this).hide();
    });


    $('.edit-btn').click(function () {
        const id = $(this).closest('tr').data('id');
        $('#cron-submit-btn').text('💾 Сохранить');
        $('#cron-cancel-btn').show();

        $.getJSON('/engine/ajax/lib/cron/get_task.php', { id }, function (data) {
            if (data.success) {
                // Заполняем форму
                $('input[name="min"]').val(data.min);
                $('input[name="hour"]').val(data.hour);
                $('input[name="day"]').val(data.day);
                $('input[name="month"]').val(data.month);
                $('input[name="weekday"]').val(data.weekday);
                $('#command').val(data.command);
                const phpPrefix = '/usr/bin/php ';
                const scriptPrefix = $("#cron-jobs-path").val();

                $('#file-select').val('').trigger('change'); // сброс

                if (data.command.startsWith(phpPrefix + scriptPrefix)) {
                    const fileName = data.command.substring((phpPrefix + scriptPrefix).length);
                    $('#file-select').val(fileName).trigger('change');
                }					$('<input>').attr({ type: 'hidden', name: 'edit_id', value: id }).appendTo('#cron-form');
                updateDescription();
                window.scrollTo(0, 0);
            } else {
                Swal.fire({
                    title: 'Info',
                    text: "Ошибка при получении задачи",
                    icon: 'info',
                    confirmButtonText: 'ok'
                });
            }
        });
    });

    var toolsSection = document.getElementById('toolsSection');
    toolsSection.classList.add('active');
    var tools = document.getElementById('tools');
    tools.classList.add('show');
    var currentLink = document.getElementById('cronJobs');
    currentLink.classList.add('active');
});
