$(document).ready(function() {
    let currentPath = $("#currentPath").val();

    /* $("#back_a").on('click', function (e) {
         let previousPath = $(this).data("action");
         updateTable(previousPath)
     })*/

    function updateTable(currentPath) {
        document.getElementById("loadingOverlay").style.display = "flex"; // Показываем оверлей загрузки

        $.ajax({
            url: 'engine/ajax/lib/fileManager/get_table_data.php', // Укажите путь к вашему обработчику
            type: 'POST',
            data: { currentPath: currentPath },
            success: function (response) {
                let json = JSON.parse(response);
                $('#tbody').html(json.html);
                $('#back_a').attr('data-action', json.pathWithoutLast);
                $('#stats_folders').html(json.directoryStats.folders);
                $('#status_files').html(json.directoryStats.files);
                $('#directory-size').html(json.directoryStats.total_size);
                selectedData = [];
                dataPath = "";
                dataName = "";

                $('#manager-table tr').click(function() {
                    // Проверяем, есть ли чекбокс в текущей строке
                    var checkbox = $(this).find('.checkbox-container');
                    dataPath = $(this).data("path");
                    dataName = $(this).data("name");
                    // Если чекбокс есть, удаляем его (по клику по той же строке)
                    if (checkbox.length > 0) {
                        checkbox.remove();
                        for (let i = selectedData.length - 1; i >= 0; i--) {
                            if (selectedData[i].dataName === dataName) {
                                selectedData.splice(i, 1);
                            }
                        }
                        dataPath = "";
                        dataName = "";
                        $(this).attr("style", "");
                    } else {
                        if (dataName && dataPath) {
                            selectedData.push({
                                dataName: dataName,
                                dataPath: dataPath
                            })
                            // Если чекбокс нет, добавляем его в начало этой строки
                            var checkboxHtml = '<td hidden="hidden" class="checkbox-container"><input hidden="hidden" type="checkbox" checked></td>';
                            $(this).css("border", "1px dashed white")
                            $(this).find("#content").prepend(checkboxHtml);
                        }
                    }
                });
                $('#loadingOverlay').hide();
            },
            error: function () {
                alert('Ошибка при обновлении таблицы');
            }
        });
    }

    function showNotification(message, type, duration) {
        duration = 10000;//(typeof duration === 'undefined') duration = 5000; // Значение по умолчанию
        if (typeof type === 'undefined') type = 'success'; // Значение по умолчанию

        var container = document.getElementById('notification-container');

        // Создаем элемент уведомления
        var notification = document.createElement('div');
        notification.className = 'notification ' + type; // Используем конкатенацию вместо шаблонных строк
        notification.innerHTML =
            '<span>' + message + '</span>' +
            '<button class="close-btn" onclick="this.parentElement.remove()">×</button>';

        container.appendChild(notification);

        // Удаляем уведомление через заданное время
        setTimeout(function () {
            notification.style.animation = 'fadeOut 0.3s ease';
            notification.addEventListener('animationend', function () {
                notification.remove();
            });
        }, duration);
    }


    const $contextMenu = $('#contextMenu');
    let selectedTd = null;
    $contextMenu.hide();

    // Ожидаем правый клик по ячейке внутри tbody
    $('tbody').on('contextmenu', 'tr', function(event) {
        event.preventDefault();  // Отменяем стандартное контекстное меню
        selectedTd = $(this);
        let dataPath = $(this).data("path")
        let dataName = $(this).data("name")

        selectedData = [];

        selectedData.push({
            dataName: dataName,
            dataPath: dataPath
        })

        // Позиционируем кастомное меню в месте клика
        $contextMenu.css({
            left: event.pageX,
            top: event.pageY
        }).show();  // Показываем меню
    });

    // Скрываем меню при клике на любое место страницы
    $(document).on('click', function() {
        $contextMenu.hide();
    });

    // Обработка кликов на пунктах меню
    $('#menuOption1').on('click', function() {
        alert('Вы выбрали Опцию 1');
        $contextMenu.hide(); // Закрываем меню
    });

    $('#menuOption2').on('click', function() {
        alert('Вы выбрали Опцию 2');
        $contextMenu.hide(); // Закрываем меню
    });

    $('#menuOption3').on('click', function() {
        alert('Эта опция неактивна');
    });

    $('#menuOption4').on('click', function() {
        if (selectedTd) {
            let path = selectedTd.data("path");
            alert('Атрибут data-path удален из выбранной ячейки');
        }
        $contextMenu.hide(); // Закрываем меню
    });

    let name = "";
    $('#new_folder').click(function() {
        $('#myModal').modal('show');
        changeModalTitle('New folder');
        changeModalButtonText('Confirm');
        $("#extensions").attr("hidden", "hidden")
        $(".modal-button").attr("id", "okNewFolder");
        $("#modalInput").val("");

    });

    $(document).on('click', '#okNewFolder', function () {
        let currentPath = $("#currentPath").val();
        name = $("#modalInput").val();

        if (name != "") {
            $.ajax({
                url: 'engine/ajax/lib/fileManager/new_folder.php',
                type: 'POST',
                dataType: 'json',
                data: { name: name , currentPath: currentPath},
                success: function (response) {
                    $("#modalInput").val("");
                    if (response.status === false) {
                        showNotification('Ошибка: ' + response.message, 'error', 5000);
                        $('#myModal').modal('hide');
                    } else {
                        showNotification('Успех: ' + response.message, 'success', 5000);
                        updateTable(currentPath);
                        $('#myModal').modal('hide');
                    }

                },
                error: function (xhr, status, error) {
                    $("#modalInput").val("");
                    showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                    $('#myModal').modal('hide');
                    return;
                }
            });
        }
        name = "";

    });


    $('#new_file').click(function() {
        $('#myModal').modal('show');
        changeModalTitle('New file');
        changeModalButtonText('Confirm');
        $("#extensions").removeAttr("hidden");
        $(".modal-button").attr("id", "okNewFile")

    });

    $(document).on('click', '#okNewFile', function () {
        let name = $("#modalInput").val();
        let currentPath = $("#currentPath").val();
        let extension = $("#extensions").val();

        $.ajax({
            url: 'engine/ajax/lib/fileManager/new_file.php',
            type: 'POST',
            dataType: 'json',
            data: { name: name , currentPath: currentPath, extension: extension},
            success: function (response) {
                $("#modalInput").val("");
                if (response.status === false) {
                    showNotification('Ошибка: ' + response.message, 'error', 5000);
                    $('#myModal').modal('hide');
                    return;
                } else {
                    showNotification('Успех: ' + response.message, 'success', 5000);
                    updateTable(currentPath);
                    $('#myModal').modal('hide');
                }

            },
            error: function (xhr, status, error) {
                $("#modalInput").val("");
                showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                $('#myModal').modal('hide');
                return;
            }
        });

    });


    function changeModalTitle(newTitle) {
        $('#modalTitle').text(newTitle);
    }

    // Функция для изменения текста кнопки OK
    function changeModalButtonText(newText) {
        $('#modalOkBtn').text(newText);
    }

    var dataPath = "";
    var dataName = "";
    var selectedData = [];
    $('#manager-table tr').click(function() {
        // Проверяем, есть ли чекбокс в текущей строке
        var checkbox = $(this).find('.checkbox-container');
        dataPath = $(this).data("path");
        dataName = $(this).data("name");
        // Если чекбокс есть, удаляем его (по клику по той же строке)
        if (checkbox.length > 0) {
            checkbox.remove();
            for (let i = selectedData.length - 1; i >= 0; i--) {
                if (selectedData[i].dataName === dataName) {
                    selectedData.splice(i, 1);
                }
            }
            dataPath = "";
            dataName = "";
            $(this).attr("style", "");

        } else {
            if (dataName && dataPath) {
                selectedData.push({
                    dataName: dataName,
                    dataPath: dataPath
                })
                // Если чекбокс нет, добавляем его в начало этой строки
                var checkboxHtml = '<td hidden="hidden" class="checkbox-container"><input hidden="hidden" type="checkbox" checked></td>';
                $(this).css("border", "1px dashed white")
                $(this).find("#content").prepend(checkboxHtml);
            }
        }
    });

    $('#rename').click(function() {
        if (selectedData.length > 1) {
            showNotification("Для редактирования выберите не более одного обекта", 'error', 5000);
            return;
        } else if (selectedData.length < 1) {
            showNotification("Для редактирования выберите обект", 'error', 5000);
            return;
        }

        $('#myModal').modal('show');
        changeModalTitle('Edit '+selectedData[0].dataName);
        changeModalButtonText('Confirm');
        $("#extensions").attr("hidden", "hidden")
        $(".modal-button").attr("id", "okEdit");
        $("#modalInput").val("");


    });

    $(document).on('click', '#okEdit', function () {
        let name = $("#modalInput").val();
        let currentPath = $("#currentPath").val();

        $.ajax({
            url: 'engine/ajax/lib/fileManager/edit.php',
            type: 'POST',
            dataType: 'json',
            data: { name: name , currentPath: currentPath, dataName: selectedData[0].dataName, dataPath: selectedData[0].dataPath},
            success: function (response) {
                if (response.status === false) {
                    showNotification('Ошибка: ' + response.message, 'error', 5000);
                    $('#myModal').modal('hide');
                    return;
                } else {
                    showNotification('Успех: ' + response.message, 'success', 5000);
                    $('#myModal').modal('hide');
                    updateTable(currentPath);
                }

            },
            error: function (xhr, status, error) {
                showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                $('#myModal').modal('hide');
                return;
            }
        });

    });


    $('#copy').click(function() {
        if (selectedData.length < 1) {
            showNotification("Для копирования выберите обект", 'error', 5000);
            return;
        }
        $('#copyModal').modal('show');

        $('#okCopy').click(function() {
            let destination = $("#destination").val();
            let currentPath = $("#currentPath").val();

            $.ajax({
                url: 'engine/ajax/lib/fileManager/copy.php',
                type: 'POST',
                dataType: 'json',
                data: { destination: destination , currentPath: currentPath, selectedData: selectedData},
                success: function (response) {
                    if (response.status === false) {
                        showNotification('Ошибка: ' + response.message, 'error', 5000);
                        $('#copyModal').modal('hide');
                        return;
                    } else {
                        showNotification('Успех: ' + response.message, 'success', 5000);
                        updateTable(currentPath);
                        $('#copyModal').modal('hide');
                    }

                },
                error: function (xhr, status, error) {
                    showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                    $('#copyModal').modal('hide');
                    return;
                }
            });

        });
    });

    $('#move').click(function() {
        if (selectedData.length < 1) {
            showNotification("Для перемещения выберите обект", 'error', 5000);
            return;
        }
        $('#copyModal').modal('show');

        $('#okCopy').click(function() {
            let destination = $("#destination").val();
            let currentPath = $("#currentPath").val();

            $.ajax({
                url: 'engine/ajax/lib/fileManager/move.php',
                type: 'POST',
                dataType: 'json',
                data: { destination: destination , currentPath: currentPath, selectedData: selectedData},
                success: function (response) {
                    if (response.status === false) {
                        showNotification('Ошибка: ' + response.message, 'error', 5000);
                        $('#copyModal').modal('hide');
                        return;
                    } else {
                        showNotification('Успех: ' + response.message, 'success', 5000);
                        $('#copyModal').modal('hide');
                        updateTable(currentPath);
                    }

                },
                error: function (xhr, status, error) {
                    showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                    $('#copyModal').modal('hide');
                    return;
                }
            });

        });
    });


    $('.archive').click(function() {
        if (selectedData.length < 1) {
            showNotification("Для архивации выберите минимум один обект", 'error', 5000);
            return;
        }

        let currentPath = $("#currentPath").val();

        $.ajax({
            url: 'engine/ajax/lib/fileManager/zip_archive.php',
            type: 'POST',
            dataType: 'json',
            data: { currentPath: currentPath, selectedData: selectedData},
            success: function (response) {
                if (response.status === false) {
                    showNotification('Ошибка: ' + response.message, 'error', 5000);
                    return;
                } else {
                    var $link = $('<a>')
                        .attr('href', response.filename) // Путь к файлу
                        .attr('download', 'archive_1735848482.zip') // Устанавливаем имя файла для скачивания
                        .css('display', 'none'); // Прячем ссылку

                    // Добавляем ссылку в DOM
                    $('body').append($link);

                    // Программно инициируем клик по ссылке для автоматического скачивания
                    $link[0].click();

                    // Удаляем ссылку после скачивания
                    $link.remove();
                }

                updateTable(currentPath);

            },
            error: function (xhr, status, error) {
                showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                return;
            }
        });

    });

    $('#permissions').click(function() {
        if (selectedData.length < 1) {
            showNotification("Для редактирования прав выберите обект", 'error', 5000);
            return;
        } else if (selectedData.length > 1) {
            showNotification("Для редактирования прав нужно выбрать не более одного обекта", 'error', 5000);
            return;
        }
        $.ajax({
            url: 'engine/ajax/lib/fileManager/get_permissions.php',
            type: 'POST',
            dataType: 'json',
            data: { selectedData: selectedData},
            success: function (response) {
                if (response.status === false) {
                    showNotification('Ошибка: ' + response.message, 'error', 5000);
                    return;
                } else {
                    $('#read').prop('checked', response.read);
                    $('#write').prop('checked', response.write);
                    $('#execute').prop('checked', response.execute);
                    $('#perms').val(response.permissions)
                }

            },
            error: function (xhr, status, error) {
                showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                return;
            }
        });
        $('#permissionsModal').modal('show');

        $('#okPermissions').click(function() {

            $.ajax({
                url: 'engine/ajax/lib/fileManager/set_permissions.php',
                type: 'POST',
                dataType: 'json',
                data: { selectedData: selectedData, read: $('#read').val(), write: $('#write').val(), execute: $('#execute').val(), perms: $('#perms').val()  },
                success: function (response) {

                    if (response.status === false) {
                        showNotification('Ошибка: ' + response.message, 'error', 5000);
                        $('#permissionsModal').modal('hide');
                        return;
                    } else {
                        showNotification('Успех: ' + response.message, 'success', 5000);
                        updateTable(currentPath);
                        $('#permissionsModal').modal('hide');
                    }

                },
                error: function (xhr, status, error) {
                    showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                    $('#permissionsModal').modal('hide');
                    return;
                }
            });

        });
    });

    $('.trash').click(function() {


        if (selectedData.length < 1) {
            showNotification("Для удаления выберите обект", 'error', 5000);
            return;
        }

        if (!confirm("Вы уверены что хотите удалить объект?")) {
            return;
        }

        $.ajax({
            url: 'engine/ajax/lib/fileManager/delete.php',
            type: 'POST',
            dataType: 'json',
            data: { selectedData: selectedData},
            success: function (response) {

                for (let i = 0; i < response.length; i++) {
                    if (response.status === false) {
                        showNotification('Ошибка: ' + response[i].message, 'error', 5000);
                        return;
                    } else {
                        showNotification('Успех: ' + response[i].message, 'success', 5000);
                    }
                }
                updateTable(currentPath);

            },
            error: function (xhr, status, error) {

                //showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                updateTable(currentPath);
                return;
            }
        });
        selectedData = [];
        dataPath = "";
        dataName = "";
    });

    $('#upload').click(function() {
        $('#uploadModal').modal('show');

        $('#okUpload').click(function() {

            var formData = new FormData();
            var currentPath = $("#currentPath").val();

            // Получаем все файлы с формы
            var files = document.getElementById('file-input').files;
            for (var i = 0; i < files.length; i++) {
                formData.append('files[]', files[i]);
                formData.append('targetPath', currentPath);
            }
            $.ajax({
                url: 'engine/ajax/lib/fileManager/upload.php',
                type: 'POST',
                dataType: 'json',
                contentType: false,
                processData: false,
                data: formData,
                success: function (response) {

                    if (response.success) {
                        showNotification('Файлы успешно загружены', 'success', 5000);
                        updateTable(currentPath);
                        $('#uploadModal').modal('hide');
                    } else if (response.error) {
                        showNotification('Ошибка: ' + response.error, 'error', 5000);
                        updateTable(currentPath);
                        $('#uploadModal').modal('hide');
                    }

                },
                error: function (xhr, status, error) {
                    showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                    updateTable(currentPath);
                    return;
                }
            });

        });
    });

    $('#restore_form_trash').click(function() {

        if (selectedData.length < 1) {
            showNotification("Для восноновления выберите обект", 'error', 5000);
            return;
        }

        $.ajax({
            url: 'engine/ajax/lib/fileManager/restore_from_trash.php',
            type: 'POST',
            dataType: 'json',
            data: { selectedData: selectedData },
            success: function (response) {

                if (response.status === false) {
                    showNotification('Ошибка: ' + response.message, 'error', 5000);
                    return;
                } else {
                    showNotification('Успех: ' + response.message, 'success', 5000);
                }
                updateTable(currentPath);

            },
            error: function (xhr, status, error) {

                //showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                updateTable(currentPath);
                return;
            }
        });
        selectedData = [];
        dataPath = "";
        dataName = "";
    });

    $('#remove_from_trash').click(function() {

        if (selectedData.length < 1) {
            showNotification("Для удаления выберите обект", 'error', 5000);
            return;
        }

        $.ajax({
            url: 'engine/ajax/lib/fileManager/remove_from_trash.php',
            type: 'POST',
            dataType: 'json',
            data: { selectedData: selectedData },
            success: function (response) {

                if (response.status === false) {
                    showNotification('Ошибка: ' + response.message, 'error', 5000);
                    return;
                } else {
                    showNotification('Успех: ' + response.message, 'success', 5000);
                }
                updateTable(currentPath);

            },
            error: function (xhr, status, error) {

                //showNotification('Ошибка: ' + xhr.responseText, 'error', 5000);
                updateTable(currentPath);
                return;
            }
        });
        selectedData = [];
        dataPath = "";
        dataName = "";
    });


    $('#search-files').on('input', function() {

        let query = $(this).val().trim(); // Получаем введенный текст

        if (query.length >= 1 || query.length == 0) { // Начинаем поиск, если введено хотя бы 3 символа
            document.getElementById("loadingOverlay").style.display = "flex"; // Показываем оверлей загрузки

            $.ajax({
                url: 'engine/ajax/lib/fileManager/search.php',  // Путь к обработчику PHP
                method: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({ query: query, currentPath: currentPath }), // Отправляем введенный текст
                success: function(data) {
                    let json = JSON.parse(data);
                    $('#tbody').html(json.html);
                    $('#back_a').attr('data-action', json.pathWithoutLast);
                    $('#stats_folders').html(json.directoryStats.folders);
                    $('#status_files').html(json.directoryStats.files);
                    $('#directory-size').html(json.directoryStats.total_size);

                    $('#manager-table tr').click(function() {
                        // Проверяем, есть ли чекбокс в текущей строке

                        var checkbox = $(this).find('.checkbox-container');
                        dataPath = $(this).data("path");
                        dataName = $(this).data("name");
                        // Если чекбокс есть, удаляем его (по клику по той же строке)
                        if (checkbox.length > 0) {
                            checkbox.remove();
                            for (let i = selectedData.length - 1; i >= 0; i--) {
                                if (selectedData[i].dataName === dataName) {
                                    selectedData.splice(i, 1);
                                }
                            }
                            dataPath = "";
                            dataName = "";
                        } else {
                            selectedData.push({
                                dataName: dataName,
                                dataPath: dataPath
                            })
                            // Если чекбокс нет, добавляем его в начало этой строки
                            var checkboxHtml = '<td class="checkbox-container"><input type="checkbox" checked></td>';
                            $(this).find("#content").prepend(checkboxHtml);
                        }
                    });
                    $('#loadingOverlay').hide();
                },
                error: function(xhr, status, error) {

                    console.error('Ошибка:', error);
                }
            });
        } else {
            $('#search-results').empty(); // Очищаем результаты, если запрос пустой или слишком короткий
        }
    });
});