const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

const popoverTriggerList = document.querySelectorAll('[data-bs-toggle="popover"]')
const popoverList = [...popoverTriggerList].map(popoverTriggerEl => new bootstrap.Popover(popoverTriggerEl))

// general js project js
$(function () {
    "use strict";
    const root = document.documentElement;

    // main sidebar menu toggle js
    $('.sidebar-toggle').on('click', function () {
        $('body').toggleClass('sidebar-hide')
    });
    $('.rightbar-toggle').on('click', function () {
        $('body').toggleClass('rightbar-hide')
    });

    // card full screen js
    const DIV_CARD = 'div.card';
    $('.card-fullscreen').on('click', function (e) {
        const $card = $(this).closest(DIV_CARD);
        $card.toggleClass('fullscreen');
        e.preventDefault();
        return false;
    });

    /** Function for remove card */
    $('[data-toggle="card-remove"]').on('click', function (e) {
        var $card = $(this).closest(DIV_CARD);
        $card.remove();
        e.preventDefault();
        return false;
    });

    // Box layout toggle
    // const checkbox = document.querySelector('.boxlayout-toggle input[type="checkbox"]');
    // checkbox.addEventListener('click', () => {
    //     const main = document.querySelector('main');
    //     const body = document.querySelector('body');
    //     if (checkbox.checked) {
    //         main.classList.add('container');
    //         main.classList.remove('container-fluid');
    //         body.classList.add('box-layout', 'rightbar-hide');
    //     } else {
    //         main.classList.add('container-fluid');
    //         main.classList.remove('container');
    //         body.classList.remove('box-layout', 'rightbar-hide');
    //     }
    // });

    // Monochrome Mode
    $('.monochrome-toggle input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('body').addClass("monochrome");
        } else {
            $('body').removeClass("monochrome");
        }
    });

    // code-show
    $('.card-toggle-one input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.card-main-one').addClass("show");
        } else {
            $('.card-main-one').removeClass("show");
        }
    });

    $('.card-toggle-two input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.card-main-two').addClass("show");
        } else {
            $('.card-main-two').removeClass("show");
        }
    });

    $('.card-toggle-three input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.card-main-three').addClass("show");
        } else {
            $('.card-main-three').removeClass("show");
        }
    });

    $('.card-toggle-four input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.card-main-four').addClass("show");
        } else {
            $('.card-main-four').removeClass("show");
        }
    });

    // table-show
    $('.table-toggle-one input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.table-main-one').addClass("show");
        } else {
            $('.table-main-one').removeClass("show");
        }
    });

    $('.table-toggle-two input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.table-main-two').addClass("show");
        } else {
            $('.table-main-two').removeClass("show");
        }
    });

    $('.table-toggle-three input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.table-main-three').addClass("show");
        } else {
            $('.table-main-three').removeClass("show");
        }
    });

    $('.table-toggle-four input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.table-main-four').addClass("show");
        } else {
            $('.table-main-four').removeClass("show");
        }
    });

    $('.table-toggle-five input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.table-main-five').addClass("show");
        } else {
            $('.table-main-five').removeClass("show");
        }
    });

    $('.table-toggle-six input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('.table-main-six').addClass("show");
        } else {
            $('.table-main-six').removeClass("show");
        }
    });


    // gradient active
    $('.gradient-active input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('body').addClass("gradient");
        } else {
            $('body').removeClass("gradient");
        }
    });

    // radius-0
    $('.radius-toggle input:checkbox').on('click', function () {
        if ($(this).is(":checked")) {
            $('body').addClass("radius-0");
        } else {
            $('body').removeClass("radius-0");
        }
    });

    // Layout section light/dark toggle js
    function toggleTheme(selector) {
        const element = $(selector);
        if (element.attr('data-bs-theme') === 'none') {
            element.attr('data-bs-theme', 'dark');
        } else {
            element.attr('data-bs-theme', 'none');
        }
    }
    $('.brand-toggle input:checkbox').on('click', function () { toggleTheme('.brand'); });
    $('.sidebar-toggle input:checkbox').on('click', function () { toggleTheme('.sidebar'); });
    $('.header-toggle input:checkbox').on('click', function () { toggleTheme('header'); });
    $('.pheader-toggle input:checkbox').on('click', function () { toggleTheme('.page-header'); });
    $('.rightbar-toggle input:checkbox').on('click', function () { toggleTheme('.rightbar'); });

    // layout option toggle js
    $('.layout-option input:radio').on('click', function () {
        var others = $("[name='" + this.name + "']").map(function () {
            return this.value
        }).get().join(" ")
        console.log(others)
        $('body').removeClass(others).addClass(this.value)
    });
    // svg icon stroke
    $('.svg-stroke input:radio').on('click', function () {
        var others = $("[name='" + this.name + "']").map(function () {
            return this.value
        }).get().join(" ")
        console.log(others)
        $('body').removeClass(others).addClass(this.value)
    });
    // main layout border toggle js
    $('.border-toggle input:checkbox').on('click', function () {
        $('body').toggleClass('layout-border')
    });
    // sidebar icon color
    $('.svg-icon-color input:checkbox').on('click', function () {
        $('.menu-list').toggleClass('icon-color')
    });
    // card box shadow
    $('.cb-shadow input:checkbox').on('click', function () {
        $('.card').toggleClass('shadow-active')
    });


    // Password Meter
    $(".password-meter .form-control").on("input", function () {
        var matchedCriteria = 0;
        var password = $(this).val();
        var upperCase = new RegExp('[A-Z]');
        var lowerCase = new RegExp('[a-z]');
        var numbers = new RegExp('[0-9]');
        var specialChars = new RegExp('^(?=.*?[#?!@$%^&*-]).{1,}$');
        if (password.length > 7) {
            matchedCriteria++;
        }
        if (password.length > 0 && password.match(upperCase)) {
            matchedCriteria++;
        }
        if (password.length > 0 && password.match(lowerCase)) {
            matchedCriteria++;
        }
        if (password.length > 0 && password.match(numbers)) {
            matchedCriteria++;
        }
        if (password.length > 0 && password.match(specialChars)) {
            matchedCriteria++;
        }
        $(".password-meter .progress-bar")[0].style.width = (matchedCriteria * 20) + "%";
    })
    // Image file input
    $(".image-input .form-control").on("change", function () {
        var url = URL.createObjectURL(this.files[0]);
        $(this).parent().parent().children(".avatar-wrapper")[0].style.background = "url(" + url + ") no-repeat";
    })
    // table select all checkbox js
    $(".select-all.form-check-input").on('change', function () {
        //row-selectable
        var isChecked = $(this).is(":checked")
        var rows = $(this).parent().parent().parent().parent().parent().find(".row-selectable");
        if (rows.length > 0) {
            rows.each(function (index) {
                $(this).find(".form-check-input")[0].checked = isChecked;
            });
        }
    })

});

window.initApexChart = function (element, options) {
    if (element) {
        return new ApexCharts(element, options).render();
    }
    return null;
}

// rightbar tab: Tasks Analysis
initApexChart(document.querySelector("#Apex_TaskAssignin"), {
    chart: {
        height: 240,
        type: 'bar',
        toolbar: {
            show: false,
        },
    },
    colors: ['var(--theme-color1)', 'var(--theme-color2)', 'var(--theme-color4)'],
    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: '80%',
            endingShape: 'rounded'
        },
    },
    dataLabels: {
        enabled: false
    },
    stroke: {
        show: true,
        width: 2,
        colors: ['transparent']
    },
    series: [{
        name: 'Pending',
        data: [44, 55, 57, 56, 61, 58, 63, 60, 66]
    }, {
        name: 'In Progress',
        data: [76, 85, 101, 98, 87, 105, 91, 114, 94]
    }, {
        name: 'Completed',
        data: [35, 41, 36, 26, 45, 48, 52, 53, 41]
    }],
    xaxis: {
        categories: ['Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct'],
    },
    fill: {
        opacity: 1

    },
});

if (document.getElementById('calendar')) {
    var calendar = new tui.Calendar('#calendar', {
        defaultView: 'month',
        taskView: true,
        template: {
            monthDayname: function (dayname) {
                return '<span class="calendar-week-dayname-name">' + dayname.label + '</span>';
            }
        }
    });
}

$(document).ready(function () {
    let urlParams = new URLSearchParams(window.location.search);
    let status = urlParams.get("status");

    if (status === "success" || status === "error") {
        let message = status === "success" ? "Платеж прошел успешно!" : "Ошибка платежа!";
        let bgColor = status === "success" ? "#4CAF50" : "#F44336";

        let alertBox = $(`
            <div class="custom-alert">${message}</div>
        `);

        $("body").append(alertBox);

        // Стилизация
        $(".custom-alert").css({
            "position": "fixed",
            "top": "20px",
            "right": "20px",
            "background": bgColor,
            "color": "#fff",
            "padding": "15px 20px",
            "border-radius": "8px",
            "box-shadow": "0px 4px 10px rgba(0,0,0,0.2)",
            "z-index": "9999",
            "font-size": "16px",
            "font-weight": "bold",
            "opacity": "0",
            "transition": "opacity 0.5s ease-in-out"
        });

        // Плавное появление
        setTimeout(() => $(".custom-alert").css("opacity", "1"), 100);

        // Автоудаление через 5 секунд
        setTimeout(() => {
            $(".custom-alert").css("opacity", "0");
            setTimeout(() => $(".custom-alert").remove(), 500);
        }, 10000);

        // Удаляем ?status=success или ?status=error из URL
        let newUrl = window.location.pathname + window.location.hash;
        window.history.replaceState(null, "", newUrl);
    }

    $(document).ready(function() {
        $('#uploadButton').on('click', function(e) {
            document.getElementById("global-spinner").classList.remove("hidden");

            e.preventDefault();

            let fileInput = document.getElementById('versionUpload');
            if (!fileInput.files.length) {
                alert('Выберите ZIP-файл перед загрузкой!');
                return;
            }

            let formData = new FormData();
            formData.append('zip_file', fileInput.files[0]); // Добавляем файл в formData

            $.ajax({
                url: 'engine/ajax/lib/systemSettings/upload_cms_new_version.php',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    document.getElementById("global-spinner").classList.add("hidden");
                    window.location.reload();
                },
                error: function(xhr) {
                    alert('Ошибка загрузки файла!');
                }
            });
        });

        $("#check_update").on("click", function () {
            document.getElementById("global-spinner").classList.remove("hidden");

            $.ajax({
                url: 'engine/ajax/lib/systemSettings/update_system_version.php',
                type: 'POST',
                data: {
                    excludeLang: $("#exclude_lang_files").prop("checked"),
                    excludeConfigFile: $("#exclude_config_file").prop("checked"),
                    excludeTemplates: $("#exclude_templates").prop("checked"),
                },
                success: function(response) {
                    document.getElementById("global-spinner").classList.add("hidden");

                    window.location.reload();
                },
                error: function(xhr) {
                    alert('Ошибка загрузки файла!');
                }
            });
        });


    });

    async function checkLatestVersion() {
        try {
            let response = await fetch('https://megadigital.space/engine/api/current_version/check_new_version.php?check');
            let data = await response.json();

            if (data.version) {
                $("#version_block").html(data.version);
                $("#version_main").css("display", "block");

            } else {
                console.log("Ошибка получения версии.");
            }
        } catch (error) {
            //console.log("Ошибка запроса:");
        }
    }

    async function downloadUpdate() {
        try {
            //document.getElementById("global-spinner").classList.remove("hidden");

            let response = await fetch('https://megadigital.space/engine/api/current_version/check_new_version.php?check');

            if (!response.ok) throw new Error("Ошибка загрузки файла!");
            let data = response.json();

            $('#global-spinner').preloader({
                texts: [],
                textInterval: 10000,
                spinnerColor: 'text-danger',
                spinnerSize: 'spinner-border-lg',
                overlayOpacity: 0.5,
                blurAmount: 5,
                classes: {
                    text: 'mt-3 fs-5 text-muted'
                },
                onShow: function() {
                    console.log('Preloader shown');
                },
                onHide: function() {
                    console.log('Preloader hidden');
                }
            });
            $('#global-spinner').preloader('show');

            window.location.href = data.update_url;
           // let blob = await response.blob();
            $('#global-spinner').preloader('hide');

          /*  let link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = "update.zip";  // Имя сохраняемого файла
            document.body.appendChild(link);
            link.click();
            document.getElementById("global-spinner").classList.add("hidden");
            document.body.removeChild(link);*/
        } catch (error) {
            console.error("Ошибка загрузки:", error);
        }
    }

    (function($) {
        $.fn.preloader = function(options, methodParams) {
            const self = this;
            const instance = self.data('preloader-instance');

            // Методы управления
            if (typeof options === 'string') {
                switch(options) {
                    case 'show':
                        if (instance) instance.show(methodParams);
                        return self;
                    case 'hide':
                        if (instance) instance.hide();
                        return self;
                    case 'destroy':
                        if (instance) instance.destroy();
                        return self;
                }
            }

            // Инициализация
            if (!instance) {
                const newInstance = new Preloader(self, options);
                self.data('preloader-instance', newInstance);
            }

            return self;
        };

        class Preloader {
            constructor(element, options) {
                this.element = element;
                this.settings = $.extend(true, {}, this.defaults(), options);
                this.timer = null;
                this.currentTextIndex = 0;
                this.init();
            }

            defaults() {
                return {
                    texts: ['Загрузка...'], // Массив текстов или строка
                    textInterval: 3000,     // Интервал смены текста
                    spinnerColor: 'text-primary', // Цвет спиннера
                    spinnerSize: null,      // Размер (например: 'spinner-border-sm')
                    overlayOpacity: 0.3,    // Прозрачность фона
                    blurAmount: 3,          // Уровень размытия
                    styles: {               // Дополнительные стили
                        overlay: {},
                        spinner: {},
                        text: {}
                    },
                    classes: {             // Дополнительные классы
                        overlay: '',
                        spinner: '',
                        text: ''
                    },
                    onShow: null,         // Коллбэк при показе
                    onHide: null           // Коллбэк при скрытии
                };
            }

            init() {
                this.createElements();
                this.applySettings();
            }

            createElements() {
                this.overlay = this.element;
                this.spinner = this.overlay.find('.spinner-border').first();

                // Создаем контейнер для текста
                if (!this.overlay.find('.preloader-text').length) {
                    this.textElement = $('<div>', {
                        class: 'preloader-text ' + this.settings.classes.text
                    });
                    this.spinner.after(this.textElement);
                }
            }

            applySettings() {
                // Применяем стили оверлея
                this.overlay.css({
                    'background': `rgba(255, 255, 255, ${this.settings.overlayOpacity})`,
                    'backdrop-filter': `blur(${this.settings.blurAmount}px)`,
                    ...this.settings.styles.overlay
                }).addClass(this.settings.classes.overlay);

                // Настраиваем спиннер
                this.spinner
                    .addClass(this.settings.spinnerColor)
                    .addClass(this.settings.spinnerSize)
                    .css(this.settings.styles.spinner);

                // Настраиваем текст
                this.textElement
                    .css(this.settings.styles.text)
                    .addClass(this.settings.classes.text);
            }

            show(customTexts) {
                // Обновляем тексты если переданы
                if (customTexts) {
                    this.settings.texts = Array.isArray(customTexts) ?
                        customTexts :
                        [customTexts];
                }

                // Запускаем смену текста
                this.startTextRotation();

                // Показываем прелоадер
                this.overlay.removeClass('hidden');

                // Вызываем коллбэк
                if (typeof this.settings.onShow === 'function') {
                    this.settings.onShow();
                }
            }

            hide() {
                // Скрываем прелоадер
                this.overlay.addClass('hidden');

                // Останавливаем смену текста
                this.stopTextRotation();

                // Вызываем коллбэк
                if (typeof this.settings.onHide === 'function') {
                    this.settings.onHide();
                }
            }

            startTextRotation() {
                if (this.settings.texts.length > 1) {
                    this.updateText();
                    this.timer = setInterval(() => this.updateText(), this.settings.textInterval);
                } else {
                    this.textElement.text(
                        Array.isArray(this.settings.texts) ?
                            this.settings.texts[0] :
                            this.settings.texts
                    );
                }
            }

            updateText() {
                this.currentTextIndex =
                    (this.currentTextIndex + 1) % this.settings.texts.length;
                this.textElement
                    .fadeOut(200, () => {
                        this.textElement
                            .text(this.settings.texts[this.currentTextIndex])
                            .fadeIn(200);
                    });
            }

            stopTextRotation() {
                if (this.timer) {
                    clearInterval(this.timer);
                    this.timer = null;
                }
                this.currentTextIndex = 0;
            }

            destroy() {
                this.stopTextRotation();
                this.overlay.removeData('preloader-instance');
                this.element = null;
            }
        }
    })(jQuery);

    $(".activateVersion").on("click", function () {
        document.getElementById("global-spinner").classList.remove("hidden");

        $.ajax({
            url: 'engine/ajax/lib/systemSettings/activate_version.php',
            type: 'POST',
            data: {
                versionId: $(this).data("id")
            },
            success: function(response) {
                document.getElementById("global-spinner").classList.add("hidden");

                window.location.reload();
            },
            error: function(xhr) {
                //alert('Ошибка загрузки файла!');
            }
        });
    })

    checkLatestVersion();
    $("#downloadUpdate").on("click", downloadUpdate);


    $(".reinstall_cms").on("click", function () {
        document.getElementById("global-spinner").classList.remove("hidden");

        $.ajax({
            url: 'engine/ajax/lib/systemSettings/reinstall_cms.php',
            type: 'POST',
            data: {
               // versionId: $(this).data("id")
            },
            success: function(response) {
                document.getElementById("global-spinner").classList.add("hidden");

                window.location.reload();
            },
            error: function(xhr) {
                //alert('Ошибка загрузки файла!');
            }
        });
    })


});


// document.addEventListener("DOMContentLoaded", () => {
//     const setColor = (index, color) => 
//     Array.from(document.getElementsByClassName(`fl${index}`))
//     .forEach(e => e.innerHTML = e.innerHTML.replace(/^(\S)/, `<span style='color:${color}'>$1</span>`));
//     for (let i = 1; i <= 6; i++) setColor(i, `var(--theme-color${i})`);
//   });