// JS: универсальная фабрика + загрузка. Подключи jQuery перед этим кодом.
(function($){

    const descs = document.getElementById('descs-block');

    // Реакция на активацию любого таба
    document.querySelectorAll('[data-bs-toggle="tab"]').forEach(function (tabEl) {
        tabEl.addEventListener('shown.bs.tab', function (e) {
            if (e.target.id === 'accesses-tab') {
                descs.classList.add('d-none'); // скрыть
            } else {

            }
        });
    });

    // Начальное состояние при загрузке страницы
    const activeTab = document.querySelector('.nav-link.active[data-bs-toggle="tab"]');
    if (activeTab && activeTab.id === 'accesses-tab') {
        descs.classList.add('d-none');
    } else { 
    }


    // createTree фабрика
    function createTree(opts){
        var $container = $(opts.container);
        var $template = $(opts.template);
        var index = opts.locationsIndex;

        function buildFragment(parentId, depth){
            var pid = (parentId === null || typeof parentId === 'undefined') ? 'root' : parentId;
            var items = index[pid] || [];
            var $frag = $(document.createDocumentFragment());

            items.forEach(function(item){
                // клонируем целый node
                var $node = $template.find('.node').first().clone(true, true);
                // элементы внутри
                var $row = $node.find('> .tree-item').first();
                var $childrenContainer = $node.find('> .children').first();

                $row.attr('data-id', item.id);
                $row.attr('data-parent-id', item.parent_id);

                // checkbox: клонируем шаблонный и настраиваем
                var $cb = $row.find('input.tree-checkbox').first().clone();
                var cbName = opts.checkboxName || 'view_locations[]';
                var cbId = (cbName.replace(/\W/g,'') || 'cb') + '_' + item.id;
                $cb.attr('id', cbId).attr('name', cbName).attr('value', item.id);
                // заменить в $row
                $row.find('input.tree-checkbox').first().replaceWith($cb);

                // label
                $row.find('label.tree-label').first().attr('for', cbId).text(item.name || ('#' + item.id));

                // meta
                var metaTxt = (item.type ? item.type : '') + (item.slug ? (' • ' + item.slug) : '');
                $row.find('.small-meta').first().text(metaTxt);

                // mark no-children if none (for visibility)
                if(!(index[item.id] && index[item.id].length)){
                    $row.addClass('no-children');
                } else {
                    $row.removeClass('no-children');
                }

                // рекурсивно собрать детей и поместить внутрь текущего node.children
                if(index[item.id] && index[item.id].length){
                    var $childFrag = buildFragment(item.id, depth + 1);
                    $childrenContainer.append($childFrag);
                }

                // добавляем готовый node в фрагмент
                $frag.append($node);
            });

            return $frag;
        }

        function render(){
            $container.empty();
            $container.append(buildFragment(null, 0));
            // по умолчанию скрываем все children
            $container.find('> .node > .children').hide();
            // выставим стрелки (стрелка находится внутри .tree-item)
            $container.find('.tree-item').each(function(){
                var $r = $(this);
                if($r.hasClass('no-children')){
                    $r.find('.toggle-btn').css('visibility','hidden');
                } else {
                    $r.find('.toggle-btn').css('visibility','visible').text('▸');
                }
            });
        }

        // публичный API
        function getSelected(){
            return $container.find('input.tree-checkbox:checked').map(function(){ return $(this).val(); }).get();
        }

        // делегирование событий — поведение локально для контейнера
        $container.on('click', '.toggle-btn', function(e){
            e.stopPropagation();
            var $btn = $(this);
            var $node = $btn.closest('.node');
            var $children = $node.find('> .children');
            if($children.length){
                $children.slideToggle(120);
                $btn.text($btn.text() === '▾' ? '▸' : '▾');
            }
        });

        $container.on('click', '.tree-item', function(e){
            if($(e.target).is('input, .toggle-btn, label')) return;
            var $cb = $(this).find('input.tree-checkbox').first();
            $cb.prop('checked', !$cb.prop('checked')).trigger('change');
        });

        $container.on('change', 'input.tree-checkbox', function(){
            var $cb = $(this);
            var checked = $cb.prop('checked');
            var $row = $cb.closest('.tree-item');
            var $node = $row.closest('.node');

            // синхронизировать всех потомков в этом node
            $node.find('> .children input.tree-checkbox').each(function(){
                $(this).prop('checked', checked);
                this.indeterminate = false;
            });

            // обновить родителей (локально по контейнеру)
            updateParents($row);
        });

        function updateParents($row){
            var parentId = $row.attr('data-parent-id');
            if(!parentId && parentId !== 0) return;

            var $parentRow = $container.find('.tree-item[data-id="' + parentId + '"]').first();
            if(!$parentRow.length) return;
            var $parentNode = $parentRow.closest('.node');
            var $childCbs = $parentNode.find('> .children input.tree-checkbox');
            var total = $childCbs.length, checked = $childCbs.filter(':checked').length;
            var $parentCb = $parentRow.find('> input.tree-checkbox').first();

            if(total === 0){
                // ничего
            } else if(checked === 0){
                $parentCb.prop('checked', false).prop('indeterminate', false);
            } else if(checked === total){
                $parentCb.prop('checked', true).prop('indeterminate', false);
            } else {
                $parentCb.prop('checked', false).prop('indeterminate', true);
            }

            // рекурсивно выше
            updateParents($parentRow);
        }

        // внутри createTree добавь метод
        function setDisabled(ids, disabled){
            ids.forEach(function(id){
                var $row = $container.find('.tree-item[data-id="' + id + '"]');
                if(!$row.length) return;

                var $cb = $row.find('> input.tree-checkbox');
                $cb.prop('disabled', disabled);

                // рекурсивно всем детям
                $row.closest('.node').find('.children input.tree-checkbox').each(function(){
                    $(this).prop('disabled', disabled);
                });
            });
        }

        function collectRelatedIds($node){
            let ids = [];

            // сам элемент
            ids.push($node.find('> input.tree-checkbox').val());

            // все дети рекурсивно
            $node.find('.children input.tree-checkbox').each(function(){
                ids.push($(this).val());
            });

            // все родители до корня
            $node.parents('.node').each(function(){
                ids.push($(this).find('> input.tree-checkbox').val());
            });

            return ids;
        }


// возвращаем наружу
        return { render: render, getSelected: getSelected, setDisabled: setDisabled, $container: $container };

    }


    // ---------- загрузка locations и создание деревьев ----------
    $.ajax({
        url: '/engine/ajax/lib/locationsControl/getLocations.php',
        method: 'GET',
        dataType: 'json',
        success: function(data){
            var locations = data.locations || [];
            var index = {};
            locations.forEach(function(item){
                var pid = (item.parent_id === null || typeof item.parent_id === 'undefined') ? 'root' : item.parent_id;
                if(!index[pid]) index[pid] = [];
                index[pid].push(item);
            });

            var includeTree = createTree({
                container: '#include_locations_tree',
                template: '#option-template',
                checkboxName: 'include_locations[]',
                locationsIndex: index
            });
            var excludeTree = createTree({
                container: '#exclude_locations_tree',
                template: '#option-template',
                checkboxName: 'exclude_locations[]',
                locationsIndex: index
            });

            let pageId = $("#page_id").val();

            if (pageId) {
                $.ajax({
                    url: '/engine/ajax/lib/locationsControl/getPageLocations.php',
                    method: 'GET',
                    data: { page_id: pageId, page_type: $("#page_type").val() }, // передаёшь id редактируемой страницы
                    dataType: 'json',
                    success: function(resp){
                        var includeIds = resp.include || [];
                        var excludeIds = resp.exclude || [];

                        // сначала отмечаем include
                        applyPreselected(includeTree, includeIds);
                        // потом exclude (чтобы syncTrees не всё заблокировал)
                        applyPreselected(excludeTree, excludeIds);
                    },
                    error: function(){
                        console.error('Не удалось загрузить сохранённые локации');
                    }
                });
            }

            includeTree.render();
            excludeTree.render();

            function applyPreselected(tree, ids) {
                ids.forEach(function(id){
                    var $cb = tree.$container.find('input.tree-checkbox[value="' + id + '"]');
                    if ($cb.length) {
                        $cb.prop('checked', true).trigger('change');
                    }
                });
            }

            // синхронизация между деревьями
            function syncTrees(treeA, treeB){
                treeA.$container.on('change', 'input.tree-checkbox', function(){
                    var id = $(this).val();
                    var checked = $(this).is(':checked');

                    // собрать id + всех детей (чтобы отключить рекурсивно)
                    var ids = [];
                    var $node = $(this).closest('.node');
                    ids.push(id);
                    $node.find('.children input.tree-checkbox').each(function(){
                        ids.push($(this).val());
                    });

                    treeB.setDisabled(ids, checked);
                });
            }

            syncTrees(includeTree, excludeTree);
            syncTrees(excludeTree, includeTree);


            // fallback: если деревья вне формы — сгенерируем скрытые поля на submit (не повредит, если чекбоксы уже в форме)
            $('#page-save-form').on('submit', function(){
                var $form = $(this);
                $form.find('input._generated').remove();

                includeTree.getSelected().forEach(function(id){
                    $('<input>').attr({type:'hidden', name:'include_locations[]', value: id}).addClass('_generated').appendTo($form);
                });
                excludeTree.getSelected().forEach(function(id){
                    $('<input>').attr({type:'hidden', name:'exclude_locations[]', value: id}).addClass('_generated').appendTo($form);
                });
            });
        },
        error: function(){
            alert('Ошибка при загрузке locations');
        }
    });

})(jQuery);
