$(document).ready(function () {

    let currentUserToken = null;
    let wsUrl = null;
    let ws;

    $.ajax({
        url: '/engine/ajax/lib/notification/get_token.php', // Замените на ваш маршрут
        type: 'GET',
        data: { },
        dataType: 'json',
        success: function(response) {
            if (response.token !== false) {
                currentUserToken = response.token;
                wsUrl = response.ws_config.web_socket_url;
                ws = new WebSocket(wsUrl + '?usr_token=' + currentUserToken);

                ws.onopen = function () {
                    ws.send(JSON.stringify({
                        type: 'notification',
                        from_user_token: currentUserToken,
                        action: "connect"
                    }));
                };

            }
        },
        error: function(xhr) {
        }
    });

    $(".editUser").on("click", function () {
        let userId = $(this).attr("data-user-id");
        const editUserModal = $("#editUserModal");

        editUserModal.attr("data-id", userId);

        $.ajax({
            url: '/engine/ajax/lib/user/get_user_data.php', // Замените на ваш маршрут
            type: 'POST',
            data: {userId: userId},
            dataType: 'json',
            success: function(response) {
                debugger;

                if (response) {
                    editUserModal.find("#email_edit").val(response.email);

                    editUserModal.find("#name_edit").val(response.name);
                    editUserModal.find("#group_edit").val(response.group);
                    editUserModal.find("#age_edit").val(response.age);
                    editUserModal.find("#phone_edit").val(response.phone);
                    editUserModal.find("#city_edit").val(response.city);
                    editUserModal.find("#gender_edit").val(response.gender);
                    editUserModal.find("#bio_edit").val(response.bio);
                    editUserModal.find("#user_avatar_edit").val(response.avatar)
                    editUserModal.find("#user_bg_image_edit").val(response.bg_image)

                }

            },
            error: function(xhr) {
            }
        });


        const modal = new bootstrap.Modal(document.getElementById('editUserModal'));
        modal.show();
    });

    $("#editUserModal form").on("submit", function (e) {
        e.preventDefault(); // не даём форме перезагрузить страницу

        let form = this;
        let formData = new FormData(form);

        // userId из data-id модалки
        formData.append("user_id", $("#editUserModal").attr("data-id"));

        $.ajax({
            url: '/engine/ajax/lib/user/update_user.php',
            type: 'POST',
            data: formData,
            processData: false, // обязательно для FormData
            contentType: false, // обязательно для FormData
            success: function (response) {
                try {
                    let res = JSON.parse(response);

                    if (res.success) {
                        bootstrap.Modal.getInstance(document.getElementById('editUserModal')).hide();
                        location.reload(); // перезагрузка страницы или обновить таблицу
                    } else {
                        alert("Ошибка: " + res.message);
                    }
                } catch (e) {
                    console.error("Некорректный ответ сервера:", response);
                }
            },
            error: function (xhr) {
                console.error("Ошибка AJAX:", xhr.responseText);
            }
        });
    });

/*    $(".send_notification").on("click", function () {
        let userId = $(this).attr("data-id");

        $("#sendNotificationForm").attr("data-id", userId);
        const modal = new bootstrap.Modal(document.getElementById('sendNotificationModal'));
        modal.show();
    })*/
/*
    $('#sendNotificationForm').on('submit', function (e) {
        e.preventDefault();
        let userId = $(this).attr("data-id");

        const data = {
            type: "notification",
            action: "send",
            user_id: userId,
            from_user_token: currentUserToken,
            module_type: $('#module_type').val(),
            content: $('#content').val()
        };


        ws.send(JSON.stringify(data));

        bootstrap.Modal.getInstance(document.getElementById('sendNotificationModal')).hide();

    });*/

    $('#image').on("change", function(event) {
        let file = event.target.files[0];
        if (!file) return;

        let img = new Image();
        img.src = URL.createObjectURL(file);
        img.onload = function() {
            if (img.width < 300 || img.height < 300) {
                document.getElementById("error").style.display = "block";
                event.target.value = ""; // Очистка файла
            } else {
                document.getElementById("error").style.display = "none";
            }
        };
    });

    var usersSection = document.getElementById('usersSection');
    usersSection.classList.add('active');
    var usersBlock = document.getElementById('usersBlock');
    usersBlock.classList.add('show');
    var currentLink = document.getElementById('userManagement');
    currentLink.classList.add('active');


});