<div class="chart-grid row gap-3">
    <div id="chart-user-activity" class="chart-container col-5"></div>
    <div id="chart-behavior" class="chart-container col-6"></div>
    <div id="chart-traffic-sources" class="chart-container col-3"></div>
    <div id="chart-user-flow" class="chart-container col-6"></div>
    <div id="chart-content-activity" class="chart-container col-6"></div>
</div>

<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.1/dist/apexcharts.min.js"></script>
<script>
    const userActivityOptions = {
        series: [{
            name: 'Active Users',
            data: [100, 120, 150, 170, 200, 220, 250, 270, 300, 320]
        }],
        chart: {
            type: 'area',
            height: 250,
            toolbar: { show: false }
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 0.8,
                opacityFrom: 0.5,
                opacityTo: 0.1,
                stops: [0, 90, 100]
            }
        },
        colors: ['#28a745'],
        xaxis: {
            categories: ['W1', 'W2', 'W3', 'W4', 'W5', 'W6', 'W7', 'W8', 'W9', 'W10']
        },
        title: {
            text: '1. Активность пользователей',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-user-activity"), userActivityOptions).render();

    const behaviorOptions = {
        series: [{
            name: 'Page Views',
            data: [1500, 2000, 1800, 2500, 2300, 2800, 3000, 3500, 4000, 4200]
        }],
        chart: {
            type: 'heatmap',
            height: 250,
            toolbar: { show: false }
        },
        title: {
            text: '2. Поведение на сайте',
            align: 'left'
        },
        colors: ['#2196F3']
    };
    new ApexCharts(document.querySelector("#chart-behavior"), behaviorOptions).render();

    const trafficSourcesOptions = {
        series: [50, 30, 15, 5],
        chart: {
            type: 'donut',
            height: 250,
            toolbar: { show: false }
        },
        labels: ['Organic Search', 'Direct', 'Referral', 'Social Media'],
        title: {
            text: '3. Источники трафика',
            align: 'left'
        },
        colors: ['#34C38F', '#FF5733', '#FF9800', '#00BCD4'],
        dataLabels: {
            enabled: true,
            formatter: function (val, opts) {
                return opts.w.globals.labels[opts.seriesIndex] + ': ' + Math.round(val) + '%';
            }
        },
        legend: {
            position: 'bottom'
        }
    };
    new ApexCharts(document.querySelector("#chart-traffic-sources"), trafficSourcesOptions).render();

    const userFlowOptions = {
        series: [{
            name: 'Path A',
            data: [25, 45, 35, 50, 75]
        }, {
            name: 'Path B',
            data: [15, 20, 25, 30, 40]
        }],
        chart: {
            type: 'bar',
            height: 250,
            toolbar: { show: false }
        },
        plotOptions: {
            bar: {
                horizontal: true,
                columnWidth: '40%',
                endingShape: 'rounded'
            }
        },
        colors: ['#FF9800', '#2196F3'],
        xaxis: {
            categories: ['Step 1', 'Step 2', 'Step 3', 'Step 4', 'Step 5'],
        },
        title: {
            text: '4. Пути переходов',
            align: 'left'
        },
        dataLabels: { enabled: false }
    };
    new ApexCharts(document.querySelector("#chart-user-flow"), userFlowOptions).render();

    const contentActivityOptions = {
        series: [{
            name: 'Videos',
            data: [100, 150, 180, 220, 250]
        }, {
            name: 'Blogs',
            data: [80, 100, 120, 150, 180]
        }, {
            name: 'Articles',
            data: [60, 90, 100, 140, 170]
        }],
        chart: {
            type: 'bar',
            height: 250,
            stacked: true,
            toolbar: { show: false }
        },
        plotOptions: {
            bar: {
                horizontal: true,
                columnWidth: '45%',
                endingShape: 'rounded'
            }
        },
        colors: ['#34C38F', '#FF9800', '#2196F3'],
        xaxis: {
            categories: ['W1', 'W2', 'W3', 'W4', 'W5'],
        },
        title: {
            text: '5. Активность по типам контента',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-content-activity"), contentActivityOptions).render();

</script>