<div class="chart-grid row gap-3">
    <div id="chart-participant-activity" class="chart-container col-6"></div>
    <div id="chart-action-effectiveness" class="chart-container col-4"></div>
    <div id="chart-user-feedback" class="chart-container col-5"></div>
    <div id="chart-employee-performance" class="chart-container col-6"></div>
</div>

<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.1/dist/apexcharts.min.js"></script>
<script>
    const participantActivityOptions = {
        series: [{
            name: 'Active Participants',
            data: [120, 150, 180, 210, 250, 300, 350, 400, 450, 500]
        }],
        chart: {
            type: 'line',
            height: 250,
            toolbar: { show: false }
        },
        stroke: {
            width: 3,
            curve: 'smooth'
        },
        colors: ['#FF9800'],
        xaxis: {
            categories: ['W1', 'W2', 'W3', 'W4', 'W5', 'W6', 'W7', 'W8', 'W9', 'W10']
        },
        title: {
            text: '1. Активность участников',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-participant-activity"), participantActivityOptions).render();

    const actionEffectivenessOptions = {
        series: [80],
        chart: {
            type: 'radialBar',
            height: 250,
            toolbar: { show: false }
        },
        plotOptions: {
            radialBar: {
                hollow: {
                    size: '70%'
                },
                dataLabels: {
                    show: true,
                    name: {
                        fontSize: '18px',
                        fontWeight: 'bold',
                        color: '#3e3e3e'
                    },
                    value: {
                        fontSize: '16px',
                        color: '#4CAF50',
                        fontWeight: 'bold'
                    }
                }
            }
        },
        colors: ['#4CAF50'],
        title: {
            text: '2. Эффективность действий',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-action-effectiveness"), actionEffectivenessOptions).render();

    const userFeedbackOptions = {
        series: [60, 30, 10],
        chart: {
            type: 'donut',
            height: 250,
            toolbar: { show: false }
        },
        labels: ['Positive', 'Neutral', 'Negative'],
        title: {
            text: '3. Отзывы пользователей',
            align: 'left'
        },
        colors: ['#34C38F', '#FF9800', '#F44336'],
        dataLabels: {
            enabled: true,
            formatter: function (val, opts) {
                return opts.w.globals.labels[opts.seriesIndex] + ': ' + Math.round(val) + '%';
            }
        },
        legend: {
            position: 'bottom'
        }
    };
    new ApexCharts(document.querySelector("#chart-user-feedback"), userFeedbackOptions).render();

    const employeePerformanceOptions = {
        series: [{
            name: 'Performance',
            data: [80, 85, 90, 92, 88, 95, 97, 94, 98, 100]
        }],
        chart: {
            type: 'bar',
            height: 250,
            toolbar: { show: false }
        },
        plotOptions: {
            bar: {
                horizontal: true,
                columnWidth: '45%',
                endingShape: 'rounded'
            }
        },
        colors: ['#2196F3'],
        xaxis: {
            categories: ['Employee A', 'Employee B', 'Employee C', 'Employee D', 'Employee E', 'Employee F', 'Employee G', 'Employee H', 'Employee I', 'Employee J']
        },
        title: {
            text: '4. Эффективность персонала',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-employee-performance"), employeePerformanceOptions).render();

</script>
