{if $access["bindings.manage"] || $user.name == 'Demo profile'}
	<div class="row">
		<div class="container">

			{* --- Добавление привязки --- *}
			<!-- Кнопка -->
			<button type="button" class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#addStaticPageModal">
				Добавить
			</button>

			<!-- EDIT MODAL (ONE FOR ALL) -->
			<div class="modal fade" id="editBindingModal" tabindex="-1" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content">

						<div class="modal-header">
							<h5 class="modal-title">Редактировать привязку</h5>
							<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
						</div>

						<div class="modal-body">
							<form method="POST">
								<input type="hidden" name="edit_id" id="edit_id">

								<div class="mb-3">
									<label class="form-label">Название привязки</label>
									<input type="text" class="form-control" name="binding_name" id="edit_binding_name">
								</div>

								<div class="mb-3">
									<label class="form-label">Переводы</label>
									<div class="row g-2">
										<div class="col-md-6">
											<input type="text" class="form-control" name="translate_parent" id="edit_translate_parent">
										</div>
										<div class="col-md-6">
											<input type="text" class="form-control" name="translate_child" id="edit_translate_child">
										</div>
									</div>
								</div>

								<div class="mb-3">
									<label class="form-label">Parent URL</label>
									<input type="text" class="form-control" name="parent_url" id="edit_parent_url">
								</div>

								<div class="mb-3">
									<label class="form-label">Модуль</label>
									<select class="form-select" name="module_url" id="edit_module_url">
										{foreach ['news','events','coupons','auctions','products','shops','ads'] as $mod}
											<option value="{$mod}">{$mod}</option>
										{/foreach}
									</select>
								</div>

								<button type="submit" class="btn btn-primary">Сохранить</button>
							</form>
						</div>

					</div>
				</div>
			</div>

			<!-- Modal -->
			<div class="modal fade" id="addStaticPageModal" tabindex="-1" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content">

						<div class="modal-header">
							<h5 class="modal-title">Добавить привязку</h5>
							<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
						</div>

						<div class="modal-body">
							<form id="addStaticPageForm" method="POST">

								<div class="mb-3">
									<label class="form-label">Название привязки</label>
									<input type="text" class="form-control" name="binding_name" placeholder="Биржа рекламы">
								</div>

								<div class="mb-3">
									<label class="form-label">Перевод названия страницы</label>
									<div class="row g-2">
										<div class="col-md-6">
											<input type="text" class="form-control" name="translate_parent" placeholder="header (родитель)">
										</div>
										<div class="col-md-6">
											<input type="text" class="form-control" name="translate_child" placeholder="title (дочерний)">
										</div>
									</div>
								</div>

								<div class="mb-3">
									<label class="form-label">URL статичной страницы</label>
									<input type="text" class="form-control" name="parent_url" placeholder="/about">
								</div>

								<div class="mb-3">
									<label class="form-label">Выбор модуля</label>
									<select class="form-select" name="module_url">
										<option value="">Выберите модуль</option>
										{foreach ['news','events','coupons','auctions','products','shops','ads'] as $mod}
											<option value="{$mod}">{$mod}</option>
										{/foreach}
									</select>
								</div>
								<button type="submit" class="btn btn-primary" id="saveStaticPageBtn">Сохранить</button>

							</form>
						</div>

						<div class="modal-footer">
							<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Закрыть</button>
						</div>

					</div>
				</div>
			</div>


			{* --- Список привязок --- *}
			<div class="binding-list max-w-3xl mx-auto bg-white shadow-md rounded-md overflow-hidden">
				{include file='main/datatable.tpl' tableTitle="Привязки"
				theads=["id", "binding_name", "parent_url", "module_name", "actions"]
				data=$bindings }
			</div>

			{* --- Breadcrumbs --- *}
	{*		<nav class="breadcrumbs text-sm text-gray-500 mt-6 max-w-3xl mx-auto">
				<ul class="flex gap-2 items-center flex-wrap">
					{foreach $breadcrumbs as $b}
						<li><a href="{$b.url}" class="hover:underline">{$b.title}</a> /</li>
					{/foreach}
					<li>{$moduleName}</li>
				</ul>
			</nav>*}

		</div>
	</div>



	{else}
	<h3>Доступ запрещен</h3>
{/if}
<script>

	document.getElementById('editBindingModal').addEventListener('show.bs.modal', function (event) {

		const btn = event.relatedTarget;

		document.getElementById('edit_id').value = btn.dataset.id;
		document.getElementById('edit_binding_name').value = btn.dataset.name;
		document.getElementById('edit_parent_url').value = btn.dataset.parentUrl;
		document.getElementById('edit_module_url').value = btn.dataset.moduleUrl;
		document.getElementById('edit_translate_parent').value = btn.dataset.trParent;
		document.getElementById('edit_translate_child').value = btn.dataset.trChild;
	});
	var toolsSection = document.getElementById('toolsSection');
	toolsSection.classList.add('active');
	var tools = document.getElementById('tools');
	tools.classList.add('show');
	var currentLink = document.getElementById('bindingsControl');
	currentLink.classList.add('active');
</script>