{if $access["cms_versions.manage"] || $user.name == 'Demo profile'}

<div class="col-12">
	<div class="row g-12">
		<!-- Новый блок управления версиями -->
		<div class="card shadow-lg h-100">
			<div class="card-header">
				<h3 class="mb-0"><i class="bi bi-cloud-upload-fill me-2"></i>Управление версиями</h3>
			</div>

			<div class="card-body">
				<h5 class="mb-3" style="font-size: 15px"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" class="bi bi-check2-circle" viewBox="0 0 16 16">
						<path d="M2.5 8a5.5 5.5 0 0 1 8.25-4.764.5.5 0 0 0 .5-.866A6.5 6.5 0 1 0 14.5 8a.5.5 0 0 0-1 0 5.5 5.5 0 1 1-11 0"/>
						<path d="M15.354 3.354a.5.5 0 0 0-.708-.708L8 9.293 5.354 6.646a.5.5 0 1 0-.708.708l3 3a.5.5 0 0 0 .708 0z"/>
					</svg> <span>Активная версия: </span> {if !empty($activeVersion.system_version)} {$activeVersion.system_version} {else} 0 {/if}</h5>
				<h5 class="mb-3" style="font-size: 15px"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" class="bi bi-clock-history" viewBox="0 0 16 16">
						<path d="M8.515 1.019A7 7 0 0 0 8 1V0a8 8 0 0 1 .589.022zm2.004.45a7 7 0 0 0-.985-.299l.219-.976q.576.129 1.126.342zm1.37.71a7 7 0 0 0-.439-.27l.493-.87a8 8 0 0 1 .979.654l-.615.789a7 7 0 0 0-.418-.302zm1.834 1.79a7 7 0 0 0-.653-.796l.724-.69q.406.429.747.91zm.744 1.352a7 7 0 0 0-.214-.468l.893-.45a8 8 0 0 1 .45 1.088l-.95.313a7 7 0 0 0-.179-.483m.53 2.507a7 7 0 0 0-.1-1.025l.985-.17q.1.58.116 1.17zm-.131 1.538q.05-.254.081-.51l.993.123a8 8 0 0 1-.23 1.155l-.964-.267q.069-.247.12-.501m-.952 2.379q.276-.436.486-.908l.914.405q-.24.54-.555 1.038zm-.964 1.205q.183-.183.35-.378l.758.653a8 8 0 0 1-.401.432z"/>
						<path d="M8 1a7 7 0 1 0 4.95 11.95l.707.707A8.001 8.001 0 1 1 8 0z"/>
						<path d="M7.5 3a.5.5 0 0 1 .5.5v5.21l3.248 1.856a.5.5 0 0 1-.496.868l-3.5-2A.5.5 0 0 1 7 9V3.5a.5.5 0 0 1 .5-.5"/>
					</svg> <span>Дата релиза активированной версии: </span> {if !empty($activeVersion.release_date)} {$activeVersion.release_date} {else} 0 {/if}</h5>
				<div class="mb-4">
					<form id="uploadZipForm" enctype="multipart/form-data">
						<h5 class="text-primary mb-3"><i class="bi bi-upload me-2"></i>Загрузить новую версию</h5>
						<div class="input-group">
							<input type="file" class="form-control" name="zip_file" accept=".zip" id="versionUpload">
							<button class="btn btn-primary" type="button" id="uploadButton">Загрузить ZIP</button>

						</div>
						<small class="text-muted">Поддерживаемый формат: .zip</small>
					</form>
				</div>
				<a href="/admin?action=backup-system-files" class="mb-3 btn btn-success"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-zip" viewBox="0 0 16 16">
						<path d="M6.5 7.5a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v.938l.4 1.599a1 1 0 0 1-.416 1.074l-.93.62a1 1 0 0 1-1.109 0l-.93-.62a1 1 0 0 1-.415-1.074l.4-1.599zm2 0h-1v.938a1 1 0 0 1-.03.243l-.4 1.598.93.62.93-.62-.4-1.598a1 1 0 0 1-.03-.243z"/>
						<path d="M2 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2zm5.5-1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9v1H8v1h1v1H8v1h1v1H7.5V5h-1V4h1V3h-1V2h1z"/>
					</svg> Скачать ZIP проекта</a>

				<div class="mt-auto">
					<h5 class="text-primary mb-3"><i class="bi bi-clock-history me-2"></i>История версий</h5>
					<div class="list-group">
						{include file='main/datatable.tpl' tableTitle=""
						theads=[{$lang.datatable.uniq_id}, {$lang.datatable.system_version}, {$lang.datatable.release_date}, {$lang.datatable.actions}]
						data=$versions }
					{*	{foreach $versions as $version}
							<a href="{$version.file_path}" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
								v{$version.system_version}
								<span class="badge bg-primary rounded-pill">{$version.release_date}</span>
							</a>
						{/foreach}*}
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	var toolsSection = document.getElementById('toolsSection');
	toolsSection.classList.add('active');
	var tools = document.getElementById('tools');
	tools.classList.add('show');
	var currentLink = document.getElementById('versionControl');
	currentLink.classList.add('active');
</script>

{else}
	<h3>Доступ запрещен</h3>
{/if}