<div class="col-12">
    <table class="table mt-4 mb-3">
        <thead class="border-success" style="bottom: 25px; position: relative;">
            <tr>
                <th class="border-end text-center" width="60px">ID</th>
                <th class="border-end">{$lang.datatable.author}</th>
                <th class="border-end">{$lang.datatable.comment}</th>
                <th class="border-end">{$lang.datatable.entity}</th>
                <th class="border-end">{$lang.datatable.date}</th>
                <th class="border-end">{$lang.datatable.status}</th>
                <th class="text-center" width="70px">{$lang.datatable.actions}</th>
            </tr>
        </thead>
        <tbody>
            {foreach $comments as $comment}
                <tr>
                    <td class="border-end text-center">{$comment.id}</td>
                    <td class="border-end">{$comment.author|default:'Guest'}</td>
                    <td class="border-end">{$comment.comment_text|truncate:50}</td>
                    <td class="border-end">{$comment.entity_type} [{$comment.entity_id}]</td>
                    <td class="border-end">{$comment.created_at}</td>
                    <td class="border-end">{if $comment.status == 1}Read{else}Unread{/if}</td>
                    <td class="text-center">
                        <div class="btn-group">
                            <button type="button" class="btn btn-link" onclick="largeModal('commentEdit{$comment.id}')">
                                <i class="fa fa-edit text-warning"></i>
                            </button>
                            <form method="POST" action="#" style="display:inline;">
                                <input type="hidden" name="delete_comment_id" value="{$comment.id}">
                                <button type="submit" class="btn btn-link" onclick="return confirm('Удалить этот комментарий?');">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <div id="commentEdit{$comment.id}" class="hidden">
                    <h5 class="mt-0">Редактирование комментария ID: {$comment.id}</h5>
                    <form method="POST" action="#">
                        <input type="hidden" name="comment_id" value="{$comment.id}">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-12">
                                    <label class="col-form-label mt-1">Автор</label>
                                    <input type="text" class="form-control" name="author" value="{$comment.author|default:''}">
                                </div>
                                <div class="col-12">
                                    <label class="col-form-label mt-1">Текст комментария</label>
                                    <textarea class="form-control" name="comment_text">{$comment.comment_text}</textarea>
                                </div>
                                <div class="col-6">
                                    <label class="col-form-label mt-1">Статус</label>
                                    <select class="form-control" name="status">
                                        <option value="0" {if $comment.status == 0}selected{/if}>Unread</option>
                                        <option value="1" {if $comment.status == 1}selected{/if}>Read</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
                            <button type="submit" class="btn btn-success">Сохранить изменения</button>
                        </div>
                    </form>
                </div>
            {/foreach}
        </tbody>
    </table>
</div>
<script>
	var oaaSection = document.getElementById('oaaSection');
	oaaSection.classList.add('active');
	var ordersAndApplications = document.getElementById('ordersAndApplications');
	ordersAndApplications.classList.add('show');
	var currentLink = document.getElementById('commentsControl');
	currentLink.classList.add('active');
</script>