{if $access["cron_manager.manage"] || $user.name == 'Demo profile'}

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

<div class="col-12">
	<h1 class="mb-4">CRON менеджер</h1>
	<input type="hidden" value="{$config.cron_jobs_path}" id="cron-jobs-path">
	<form id="cron-form" class="row g-3">
		<div class="col-md-2">
			<label>Минуты</label>
			<input type="text" name="min" class="form-control" value="*">
		</div>
		<div class="col-md-2">
			<label>Часы</label>
			<input type="text" name="hour" class="form-control" value="*">
		</div>
		<div class="col-md-2">
			<label>День месяца</label>
			<input type="text" name="day" class="form-control" value="*">
		</div>
		<div class="col-md-2">
			<label>Месяц</label>
			<input type="text" name="month" class="form-control" value="*">
		</div>
		<div class="col-md-2">
			<label>День недели</label>
			<input type="text" name="weekday" class="form-control" value="*">
		</div>
		<div class="col-6">
			<label>Файл задачи (выбор из папки /engine/jobs/)</label>
			<select id="file-select" class="form-control">
				<option value="">Выберите PHP-файл...</option>
				{foreach from=$taskFiles item=filename}
					<option value="{$filename}">{$filename}</option>
				{/foreach}
			</select>
		</div>

		<div class="col-6">
			<label>Команда</label>
			<input type="text" name="command" id="command" class="form-control" placeholder="/usr/bin/php ..." readonly>
		</div>
		<div class="col-12">
			<label>Описание расписания</label>
			<div id="cron-description" class="text-primary fw-bold mt-1"></div>
		</div>
		<div class="col-12 d-flex gap-2">
			<button type="submit" id="cron-submit-btn" class="btn btn-success">
				<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-save2" viewBox="0 0 16 16">
					<path d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9.5a1 1 0 0 0-1 1v4.5h2a.5.5 0 0 1 .354.854l-2.5 2.5a.5.5 0 0 1-.708 0l-2.5-2.5A.5.5 0 0 1 5.5 6.5h2V2a2 2 0 0 1 2-2H14a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h2.5a.5.5 0 0 1 0 1z"/>
				</svg>
				Добавить задачу
			</button>
			<button type="button" id="cron-cancel-btn" class="btn btn-secondary" style="display: none;">
				<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-circle" viewBox="0 0 16 16">
					<path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
					<path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
				</svg>
				Отмена
			</button>
		</div>

	</form>

	<hr>

	<h3>
		<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="currentColor" class="bi bi-list-task" viewBox="0 0 16 16">
			<path fill-rule="evenodd" d="M2 2.5a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5V3a.5.5 0 0 0-.5-.5zM3 3H2v1h1z"/>
			<path d="M5 3.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5M5.5 7a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1zm0 4a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1z"/>
			<path fill-rule="evenodd" d="M1.5 7a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5H2a.5.5 0 0 1-.5-.5zM2 7h1v1H2zm0 3.5a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5zm1 .5H2v1h1z"/>
		</svg>
		Текущие задачи
	</h3>
	<table class="table table-bordered bg-white" id="cron-table">
		<thead>
		<tr>
			<th>CRON</th>
			<th>Периодичность</th>
			<th>Команда</th>
			<th>Действия</th>
		</tr>
		</thead>
		<tbody>
		{foreach from=$tasks item=task}
			<tr data-id="{$task.id}">
				<td class="cron-expr"><code>{$task.expr|escape}</code></td>
				<td class="cron-desc"></td>
				<td>{$task.command|escape}</td>
				<td>
					<button class="btn btn-primary edit-btn">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pen" viewBox="0 0 16 16">
							<path d="m13.498.795.149-.149a1.207 1.207 0 1 1 1.707 1.708l-.149.148a1.5 1.5 0 0 1-.059 2.059L4.854 14.854a.5.5 0 0 1-.233.131l-4 1a.5.5 0 0 1-.606-.606l1-4a.5.5 0 0 1 .131-.232l9.642-9.642a.5.5 0 0 0-.642.056L6.854 4.854a.5.5 0 1 1-.708-.708L9.44.854A1.5 1.5 0 0 1 11.5.796a1.5 1.5 0 0 1 1.998-.001m-.644.766a.5.5 0 0 0-.707 0L1.95 11.756l-.764 3.057 3.057-.764L14.44 3.854a.5.5 0 0 0 0-.708z"/>
						</svg>
					</button>
					<button class="btn btn-danger delete-btn">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
							<path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
							<path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
						</svg>
					</button>
				</td>
			</tr>
		{/foreach}
		</tbody>
	</table>
</div>



<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://unpkg.com/cronstrue@latest/dist/cronstrue.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="{$stheme}/js/ajax/cron/cron-management.js"></script>


{else}
	<h3>Доступ запрещен</h3>
{/if}