<div class="col-12">
	<style>
		.card {
			transition: transform 0.3s ease, box-shadow 0.3s ease;
		}
		.card:hover {
			transform: translateY(-5px);
			box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
		}
		.card-title {
			font-size: 1.5rem;
			font-weight: bold;
		}
		.card-text {
			color: #555;
		}
		.btn-primary {
			background-color: #0d6efd;
			border: none;
			transition: background-color 0.3s ease;
		}
		.btn-primary:hover {
			background-color: #0b5ed7;
		}
	</style>
	<h3>{$lang.datatable.email_templates}</h3><hr>
	<div class="row row-cols-1 row-cols-md-3 g-4">
		{foreach $emailTemplates as $key=>$emailTemplate}


			<div class="col">
				<div class="card h-100">
					<div class="card-body">
						<h5 class="card-title">{$emailTemplate.name}</h5>
						<p class="card-text">Template name: {$emailTemplate.normal_path}/main.tpl</p>
						<a href="/admin?action=email-templates-edit&path={$emailTemplate.normal_path}" class="btn btn-primary"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
								<path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
								<path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z"/>
							</svg> {$lang.datatable.edit}</a>
						<button id="openModal-{$emailTemplate.name}" onclick="largeModal(`htmlPreview-{$emailTemplate.name}`)" type="button" class="btn btn-primary"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-eye-fill" viewBox="0 0 16 16">
								<path d="M10.5 8a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0"/>
								<path d="M0 8s3-5.5 8-5.5S16 8 16 8s-3 5.5-8 5.5S0 8 0 8m8 3.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7"/>
							</svg> {$lang.datatable.open_show_html}</button>
					</div>
				</div>
			</div>
			<div id="htmlPreview-{$emailTemplate.name}" class="hidden">
				<h5 class="mt-0">{$lang.datatable.show_html}:</h5>
				<iframe id="previewFrame-{$emailTemplate.name}"></iframe>

			</div>
			<script>
				$(document).ready(function() {
					$('#openModal-{$emailTemplate.name}').on('click', function() {
						var previewHtml = `{$emailTemplate.html}`;
						let iframe = $('#previewFrame-{$emailTemplate.name}')[0];
						let doc = iframe.contentDocument || iframe.contentWindow.document;
						doc.open();
						doc.write(previewHtml);
						doc.close();
					//	$('#modal').fadeIn();
					});

					$('.close').on('click', function() {
						$('#modal').fadeOut();
					});
				});
			</script>

		{/foreach}
	</div>


</div>
<style>
/*	.modal {
		display: none;
		position: fixed;
		z-index: 1000;
		left: 0;
		top: 0;
		width: 100%;
		height: 100%;
		background-color: rgba(0, 0, 0, 0.5);
	}
	.modal-content {
		margin: 10% auto;
		padding: 20px;
		width: 80%;
		max-width: 600px;
		box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
		position: relative;
	}
	.close {
		position: absolute;
		top: 10px;
		right: 15px;
		font-size: 20px;
		cursor: pointer;
	}*/
	iframe {
		width: 100%;
		height: 300px;
		border: none;
	}
</style>{*
<div id="modal" class="modal">
	<div class="modal-content">
		<span class="close">&times;</span>
		<iframe id="previewFrame"></iframe>
	</div>
</div>*}

<script>


	var fatSection = document.getElementById('fatSection');
	fatSection.classList.add('active');
	var filesAndTemplates = document.getElementById('filesAndTemplates');
	filesAndTemplates.classList.add('show');
	var currentLink = document.getElementById('emailTemplates');
	currentLink.classList.add('active');
</script>