<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#classModal" onclick="openCreateClassModal()">
    {$lang.education.class_add}
</button>

<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addTeacherModal" onclick="">
    {$lang.education.teacher_bind_to_class}
</button>

<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addStudentModal" onclick="">
    {$lang.education.student_bind_to_class}
</button>


<div class="modal fade" id="classModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="classForm" method="post">
                <div class="modal-header">
                    <h5 class="modal-title">{$lang.education.class_add}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="class_id" name="id">

                    <div class="mb-3">
                        <label for="name" class="form-label">{$lang.education.class_name}</label>
                        <input type="text" name="name" id="name" class="form-control"
                               placeholder="{$lang.education.class_name_placeholder}">
                        <div class="text-danger small" id="error-name"></div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        {$lang.general.close}
                    </button>
                    <button type="submit" class="btn btn-primary">
                        {$lang.general.save}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="viewStudentsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="viewStudentsForm" method="post">
                <div class="modal-header">
                    <h5 class="modal-title">{$lang.education.students_view}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body view-students-body"></div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        {$lang.general.close}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="addTeacherModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="addTeacherForm" method="post">
                <div class="modal-header">
                    <h5 class="modal-title">{$lang.education.teacher_bind_title}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="teacher_id" name="id">

                    <div class="mb-3">
                        <label class="form-label">{$lang.education.class_list} *</label>
                        <select name="selected_class" class="form-select">
                            <option value="" disabled selected>{$lang.general.select_class}</option>
                            {foreach $classes as $class}
                                <option value="{$class.id}">{$class.name}</option>
                            {/foreach}
                        </select>
                        <div class="text-danger small" id="1-error-selected_class"></div>

                    </div>

                    <div class="mb-3">
                        <label class="form-label">{$lang.education.teacher_list} *</label>
                        <select name="selected_teacher" class="form-select">
                            <option value="" disabled selected>{$lang.general.select_teacher}</option>
                            {foreach $teachers as $teacher}
                                <option value="{$teacher.id}">{$teacher.name}</option>
                            {/foreach}
                        </select>
                        <div class="text-danger small" id="1-error-selected_teacher"></div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        {$lang.general.close}
                    </button>
                    <button type="submit" class="btn btn-primary">
                        {$lang.general.save}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="addStudentModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="addStudentForm" method="post">
                <div class="modal-header">
                    <h5 class="modal-title">{$lang.education.student_bind_title}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="student_id" name="id">

                    <div class="mb-3">
                        <label class="form-label">{$lang.education.class_list} *</label>
                        <select name="selected_class" class="form-select">
                            <option value="" disabled selected>{$lang.general.select_class}</option>
                            {foreach $classes as $class}
                                <option value="{$class.id}">{$class.name}</option>
                            {/foreach}
                        </select>
                        <div class="text-danger small" id="2-error-selected_class"></div>

                    </div>

                    <div class="mb-3">
                        <label class="form-label">{$lang.education.student_list} *</label>
                        <select name="selected_student" class="form-select">
                            <option value="" disabled selected>{$lang.general.select_student}</option>
                            {foreach $students as $student}
                                <option value="{$student.id}">{$student.name}</option>
                            {/foreach}
                        </select>
                        <div class="text-danger small" id="2-error-selected_student"></div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        {$lang.general.close}
                    </button>
                    <button type="submit" class="btn btn-primary">
                        {$lang.general.save}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="col-12">
    {include file='main/datatable.tpl' tableTitle="{$lang.education.all_classes}"
    theads=["id", $lang.datatable.name, $lang.datatable.date, "teachers", $lang.datatable.actions]
    data=$classes }
</div>

<script>

    $(document).ready(function() {

        $(document).on("click", ".delete-ico", function (e) {
            e.preventDefault();

            const dataId = $(this).data("id");

            if (!confirm("Вы уверены, что хотите удалить класс?")) {
                return;
            }

            $.ajax({
                url: 'engine/ajax/lib/education/delete_class.php',
                type: 'POST',
                dataType: 'json',
                data: {literal} {id: dataId} {/literal},
                success: function (response) {

                    if (response) {
                        window.location.reload();
                    } else {

                    }

                },
                error: function (xhr, status, error) {
                    return;
                }
            });
        });

        $(".view-students-ico").on("click", function () {
            debugger;

            const dataId = $(this).data("id");

            if (dataId) {
                $.ajax({
                    url: 'engine/ajax/lib/education/students_datatable.php',
                    type: 'POST',
                    dataType: 'json',
                    data: {literal}{id: dataId} {/literal},
                    success: function (response) {

                        if (response) {
                            const modal = new bootstrap.Modal(document.getElementById('viewStudentsModal'));
                            modal.show();

                            $(".view-students-body").html(response.html);
                        }

                    },
                    error: function (xhr, status, error) {
                        return;
                    }
                });
            }
        });

        $(".edit-ico").on("click", function () {
            debugger;

            const dataId = $(this).data("id");

            if (dataId) {
                $.ajax({
                    url: 'engine/ajax/lib/education/get_class_data.php',
                    type: 'POST',
                    dataType: 'json',
                    data: {literal}{id: dataId} {/literal},
                    success: function (response) {

                        if (response) {
                            openEditClassModal(response)
                        }

                    },
                    error: function (xhr, status, error) {
                        return;
                    }
                });
            }
        });

        $("#addTeacherForm").on("submit", function(e) {
            debugger;
            e.preventDefault();

            let formData = $(this).serialize();
            let id = $("#class_id").val();
            let url = id ? "engine/ajax/lib/education/update_school_class.php" : "engine/ajax/lib/education/attach_teacher_class.php";

            $(".text-danger.small").text(""); // сброс ошибок

            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        location.reload(); // или обнови таблицу
                    } else if (response.errors) {
                        $.each(response.errors, function(field, msg) {
                            $("#1-error-" + field).text(msg);
                        });
                    }
                }
            });
        });

        $("#addStudentForm").on("submit", function(e) {
            debugger;
            e.preventDefault();

            let formData = $(this).serialize();
            let id = $("#student_id").val();
            let url = id ? "engine/ajax/lib/education/update_school_class.php" : "engine/ajax/lib/education/attach_student_class.php";

            $(".text-danger.small").text(""); // сброс ошибок

            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        location.reload(); // или обнови таблицу
                    } else if (response.errors) {
                        $.each(response.errors, function(field, msg) {
                            $("#2-error-" + field).text(msg);
                        });
                    }
                }
            });
        });

        $("#classForm").on("submit", function(e) {
            debugger;
            e.preventDefault();

            let formData = $(this).serialize();
            let id = $("#class_id").val();
            let url = id ? "engine/ajax/lib/education/update_school_class.php" : "engine/ajax/lib/education/create_school_class.php";

            $(".text-danger.small").text(""); // сброс ошибок

            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        location.reload(); // или обнови таблицу
                    } else if (response.errors) {
                        $.each(response.errors, function(field, msg) {
                            $("#error-" + field).text(msg);
                        });
                    }
                }
            });
        });

        function openEditClassModal(school_class) {
            $("#classModalTitle").text("Редактировать класс");

            $("#class_id").val(school_class.id);
            $("#name").val(school_class.name);

            $(".text-danger.small").text("");

            const modal = new bootstrap.Modal(document.getElementById('classModal'));
            modal.show();
        }

        function openStudentsListModal(html) {
            $("#classModalTitle").text("Просмотр учеников");

            $("#class_id").val(school_class.id);
            $("#name").val(school_class.name);

            $(".text-danger.small").text("");
            $("#classModal").modal("show");
        }
    });
    function openCreateClassModal() {
        $("#classModalTitle").text("Создать класс");
        $("#classForm")[0].reset();
        $("#class_id").val("");
        $(".text-danger.small").text("");
        const modal = new bootstrap.Modal(document.getElementById('classModal'));
        modal.show();
    }
</script>