<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#studentModal"
        onclick="openCreateModal('student', '{$lang.education.student_add}')">
    {$lang.education.student_add}
</button>

<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#parentModal"
        onclick="openCreateModal('parent', '{$lang.education.parent_add}')">
    {$lang.education.parent_add}
</button>

<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#student_parent_relModal"
        onclick="openCreateModal('student_parent_rel', '{$lang.education.student_parent_assign}')">
    {$lang.education.student_parent_assign}
</button>


<div class="modal fade" id="studentModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="studentForm" method="post">
                <div class="modal-header">
                    <h5 class="modal-title" id="studentModalTitle"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="student_id" name="id">

                    <div class="row mb-3">
                        <div class="col-6">
                            <label for="first_name" class="form-label">{$lang.general.first_name} *</label>
                            <input type="text" id="first_name" name="first_name" class="form-control">
                            <div class="text-danger small" id="error-first_name"></div>
                        </div>

                        <div class="col-6">
                            <label for="last_name" class="form-label">{$lang.general.last_name} *</label>
                            <input type="text" id="last_name" name="last_name" class="form-control">
                            <div class="text-danger small" id="error-last_name"></div>
                        </div>

                    </div>

                    <div class="row mb-3">
                        <div class="col-6">
                            <label for="age" class="form-label">{$lang.general.age} *</label>
                            <input type="number" id="age" name="age" min="5" max="100" class="form-control">
                            <div class="text-danger small" id="error-age"></div>
                        </div>

                        <div class="col-6">
                            <label for="email" class="form-label">{$lang.general.email_optional}</label>
                            <input type="email" id="email" name="email" class="form-control">
                            <div class="text-danger small" id="error-email"></div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-6">
                            <label for="gender" class="form-label">{$lang.general.gender} *</label>
                            <select id="gender" name="gender" class="form-control">
                                <option value="male">{$lang.general.gender_male}</option>
                                <option value="female">{$lang.general.gender_female}</option>
                            </select>
                            <div class="text-danger small" id="error-gender"></div>
                        </div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        {$lang.general.close}
                    </button>
                    <button type="submit" class="btn btn-primary">
                        {$lang.general.save}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="parentModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="parentForm" method="post">
                <div class="modal-header">
                    <h5 class="modal-title" id="parentModalTitle"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="parent_id" name="id">

                    <div class="row mb-3">
                        <div class="col-6">
                            <label for="parent_first_name" class="form-label">{$lang.general.first_name} *</label>
                            <input type="text" id="parent_first_name" name="first_name" class="form-control">
                            <div class="text-danger small" id="parent-error-first_name"></div>
                        </div>

                        <div class="col-6">
                            <label for="parent_last_name" class="form-label">{$lang.general.last_name} *</label>
                            <input type="text" id="parent_last_name" name="last_name" class="form-control">
                            <div class="text-danger small" id="parent-error-last_name"></div>
                        </div>

                    </div>

                    <div class="row mb-3">
                        <div class="col-6">
                            <label for="parent_age" class="form-label">{$lang.general.age}</label>
                            <input type="number" id="parent_age" name="age" min="5" max="100" class="form-control">
                            <div class="text-danger small" id="parent-error-age"></div>
                        </div>

                        <div class="col-6">
                            <label for="parent_email" class="form-label">{$lang.general.email} *</label>
                            <input type="email" id="parent_email" name="email" class="form-control">
                            <div class="text-danger small" id="parent-error-email"></div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-6">
                            <label for="parent_gender" class="form-label">{$lang.general.gender} *</label>
                            <select id="parent_gender" name="gender" class="form-control">
                                <option value="male">{$lang.general.gender_male}</option>
                                <option value="female">{$lang.general.gender_female}</option>
                            </select>
                            <div class="text-danger small" id="parent-error-gender"></div>
                        </div>
                        <div class="col-6">
                            <label for="phone" class="form-label">{$lang.general.phone}</label>
                            <input type="tel" id="phone" name="phone" class="form-control">
                            <div class="text-danger small" id="error-phone"></div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        {$lang.general.close}
                    </button>
                    <button type="submit" class="btn btn-primary">
                        {$lang.general.save}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="student_parent_relModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="student_parent_relForm" method="post">
                <div class="modal-header">
                    <h5 class="modal-title" id="student_parent_relModalTitle"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="student_parent_rel_id" name="id">

                    <div class="row mb-3">
                        <div class="col-6">
                            <label class="form-label">{$lang.education.parent}</label>
                            <select name="selected_parent" class="form-control">
                                <option value="" disabled selected>{$lang.general.not_selected}</option>
                                {foreach $parentsDataList as $parentsDataAssoc}
                                    <option value="{$parentsDataAssoc.id}">{$parentsDataAssoc.name}</option>
                                {/foreach}
                            </select>
                            <div class="text-danger small" id="student_parent-error-selected_parent"></div>

                        </div>

                        <div class="col-6">
                            <label class="form-label">{$lang.education.student}</label>
                            <select name="selected_student" class="form-control">
                                <option value="" disabled selected>{$lang.general.not_selected}</option>
                                {foreach $studentsDataList as $studentsDataAssoc}
                                    <option value="{$studentsDataAssoc.id}">{$studentsDataAssoc.name}</option>
                                {/foreach}
                            </select>
                            <div class="text-danger small" id="student_parent-error-selected_student"></div>

                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        {$lang.general.close}
                    </button>
                    <button type="submit" class="btn btn-primary">
                        {$lang.general.save}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="col-12">
    {include file='main/datatable.tpl'
    tableTitle="{$lang.education.all_students_parents}"
    theads=["id", $lang.datatable.name, $lang.datatable.date, "parents", $lang.datatable.actions]
    data=$students
    }
</div>


<script>

    $(document).ready(function() {

        $(document).on("click", ".delete-ico", function (e) {
            e.preventDefault();

            const dataId = $(this).data("id");

            if (!confirm("Вы уверены, что хотите удалить ученика?")) {
                return;
            }

            $.ajax({
                url: 'engine/ajax/lib/education/students/delete_student.php',
                type: 'POST',
                dataType: 'json',
                data: {literal} {id: dataId} {/literal},
                success: function (response) {

                    if (response) {
                        window.location.reload();
                    } else {

                    }

                },
                error: function (xhr, status, error) {
                    return;
                }
            });
        });

        $(".edit-ico").on("click", function () {
            debugger;

            const dataId = $(this).data("id");

            if (dataId) {
                $.ajax({
                    url: 'engine/ajax/lib/education/students/get_student_data.php',
                    type: 'POST',
                    dataType: 'json',
                    data: {literal}{id: dataId} {/literal},
                    success: function (response) {

                        if (response) {
                            openEditStudentModal(response)
                        }

                    },
                    error: function (xhr, status, error) {
                        return;
                    }
                });
            }
        });

        $("#studentForm").on("submit", function(e) {
            debugger;
            e.preventDefault();

            let formData = $(this).serialize();
            let id = $("#student_id").val();
            let url = id ? "engine/ajax/lib/education/students/update_student.php" : "engine/ajax/lib/education/students/create_student.php";

            $(".text-danger.small").text(""); // сброс ошибок

            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        location.reload(); // или обнови таблицу
                    } else if (response.errors) {
                        $.each(response.errors, function(field, msg) {
                            $("#error-" + field).text(msg);
                        });
                    }
                }
            });
        });


        $("#parentForm").on("submit", function(e) {
            debugger;
            e.preventDefault();

            let formData = $(this).serialize();
            let id = $("#parent_id").val();
            let url = id ? "engine/ajax/lib/education/parents/update_parent.php" : "engine/ajax/lib/education/parents/create_parent.php";

            $(".text-danger.small").text(""); // сброс ошибок

            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        location.reload(); // или обнови таблицу
                    } else if (response.errors) {
                        $.each(response.errors, function(field, msg) {
                            $("#parent-error-" + field).text(msg);
                        });
                    }
                }
            });
        });

        $("#student_parent_relForm").on("submit", function(e) {
            debugger;
            e.preventDefault();

            let formData = $(this).serialize();
            let id = $("#student_parent_rel_id").val();
            let url = id ? "engine/ajax/lib/education/students_parents/update_student_parent_rel.php" : "engine/ajax/lib/education/students_parents/create_student_parent_rel.php";

            $(".text-danger.small").text(""); // сброс ошибок

            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        location.reload(); // или обнови таблицу
                    } else if (response.errors) {
                        $.each(response.errors, function(field, msg) {
                            $("#student_parent-error-" + field).text(msg);
                        });
                    }
                }
            });
        });

        function openEditStudentModal(studentData) {
            debugger;
            $("#studentModalTitle").text("Редактировать ученика");

            $("#studentModal").find("#student_id").val(studentData.id);
            $("#studentModal").find("#first_name").val(studentData.first_name);

            $("#studentModal").find("#age").val(studentData.age);
            $("#studentModal").find("#gender").val(studentData.gender);


            $("#studentModal").find("#last_name").val(studentData.last_name);
            $("#studentModal").find("#email").val(studentData.email);

            $("#studentModal").find(".text-danger.small").text("");
            $("#studentModal").modal("show");
        }
    });
    function openCreateModal(object, title) {
        $('#'+object+"ModalTitle").text(title);
        $('#'+object+"Form")[0].reset();
        $('#'+object+"_id").val("");
        $(".text-danger.small").text("");
        $('#'+object+"Modal").modal("show");
    }
</script>