<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#teacherModal" onclick="openCreateTeacherModal()">{$lang.education.add_teacher}</button>


<div class="modal fade" id="teacherModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="teacherForm" method="post">
                <div class="modal-header">
                    <h5 class="modal-title" id="teacherModalTitle">{$lang.education.add_teacher}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <input type="hidden" id="teacher_id" name="id">

                    <div class="row">
                        <div class="col-6">
                            <label for="first_name" class="form-label">{$lang.general.first_name} *</label>
                            <input type="text" name="first_name" id="first_name" class="form-control" placeholder="">
                            <div class="text-danger small" id="error-first_name"></div>
                        </div>
                        <div class="col-6">
                            <label for="last_name" class="form-label">{$lang.general.last_name} *</label>
                            <input type="text" name="last_name" id="last_name" class="form-control" placeholder="">
                            <div class="text-danger small" id="error-last_name"></div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-6">
                            <label for="email" class="form-label">{$lang.general.email} *</label>
                            <input type="email" name="email" id="email" class="form-control" placeholder="">
                            <div class="text-danger small" id="error-email"></div>
                        </div>

                        <div class="col-6">
                            <label for="phone" class="form-label">{$lang.general.phone} *</label>
                            <input type="tel" id="phone" name="phone" class="form-control">
                            <div class="text-danger small" id="error-phone"></div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{$lang.general.close}</button>
                    <button type="submit" class="btn btn-primary" id="roleSubmitBtn">{$lang.general.save}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="col-12">
    {include file='main/datatable.tpl' tableTitle="{$lang.education.all_teachers}"
    theads=["id", $lang.datatable.name, $lang.datatable.email, "classes", $lang.datatable.actions]
    data=$teachers }
</div>


<script>

    $(document).ready(function() {

        $(document).on("click", ".delete-ico", function (e) {
            e.preventDefault();

            const dataId = $(this).data("id");

            if (!confirm("Вы уверены, что хотите удалить учителя?")) {
                return;
            }

            $.ajax({
                url: 'engine/ajax/lib/education/teachers/delete_teacher.php',
                type: 'POST',
                dataType: 'json',
                data: {literal} {id: dataId} {/literal},
                success: function (response) {

                    if (response) {
                        window.location.reload();
                    } else {

                    }

                },
                error: function (xhr, status, error) {
                    return;
                }
            });
        });

        $(".edit-ico").on("click", function () {
            debugger;

            const dataId = $(this).data("id");

            if (dataId) {
                $.ajax({
                    url: 'engine/ajax/lib/education/teachers/get_teacher_data.php',
                    type: 'POST',
                    dataType: 'json',
                    data: {literal}{id: dataId} {/literal},
                    success: function (response) {

                        if (response) {
                            openEditTeacherModal(response)
                        }

                    },
                    error: function (xhr, status, error) {
                        return;
                    }
                });
            }
        });

        $("#teacherForm").on("submit", function(e) {
            debugger;
            e.preventDefault();

            let formData = $(this).serialize();
            let id = $("#teacher_id").val();
            let url = id ? "engine/ajax/lib/education/teachers/update_teacher.php" : "engine/ajax/lib/education/teachers/create_teacher.php";

            $(".text-danger.small").text(""); // сброс ошибок

            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        location.reload(); // или обнови таблицу
                    } else if (response.errors) {
                        $.each(response.errors, function(field, msg) {
                            $("#error-" + field).text(msg);
                        });
                    }
                }
            });
        });

        /*$("#classForm").on("submit", function(e) {
            debugger;
            e.preventDefault();

            let formData = $(this).serialize();
            let id = $("#class_id").val();
            let url = id ? "engine/ajax/lib/education/update_school_class.php" : "engine/ajax/lib/education/create_school_class.php";

            $(".text-danger.small").text(""); // сброс ошибок

            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        location.reload(); // или обнови таблицу
                    } else if (response.errors) {
                        $.each(response.errors, function(field, msg) {
                            $("#error-" + field).text(msg);
                        });
                    }
                }
            });
        });
*/
        function openEditTeacherModal(school_class) {
            $("#teacherModalTitle").text("Редактировать учителя");

            $("#teacher_id").val(school_class.id);
            $("#first_name").val(school_class.first_name);
            $("#last_name").val(school_class.last_name);
            $("#email").val(school_class.email);

            $(".text-danger.small").text("");
            $("#teacherModal").modal("show");
        }
    });
    function openCreateTeacherModal() {
        $("#teacherModalTitle").text("Создать учителя");
        $("#teacherForm")[0].reset();
        $("#teacher_id").val("");
        $(".text-danger.small").text("");
        $("#teacherModal").modal("show");
    }
</script>