<link href="https://cdn.lineicons.com/3.0/lineicons.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet" />
<script src="system/assets/js/ajax/fileManager/main.js"></script>

<div id="loadingOverlay" class="loading-overlay">
    <div class="spinner"></div>
</div>
<div id="notification-container" class="notification-container"></div>
<style>
    .loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0, 0, 0, 0.5);
        display: none;
        justify-content: center;
        align-items: center;
        z-index: 9999;
    }

    .spinner {
        border: 4px solid rgba(255, 255, 255, 0.3);
        border-top: 4px solid #fff;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    .notification-container {
        position: fixed;
        top: 10px;
        right: 100px; /* Смещаем контейнер вправо */
        z-index: 1050;
        width: 300px; /* Ширина уведомлений */
    }

    .notification {
        align-items: center;
        justify-content: space-between;
        padding: 10px 15px;
        margin-bottom: 10px;
        border-radius: 5px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        color: #fff;
    }

    .card.shadow-sm {
    box-shadow: none !important;
}

    .card {
        box-shadow: none !important;
    }

    .notification .close-btn {
        background: none;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
    }

    .notification.error {
        background-color: #e6231e; /* Цвет для ошибок */
    }

    .notification.success {
        background-color: #28a745; /* Цвет для успеха */
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateX(10%);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    @keyframes fadeOut {
        from {
            opacity: 1;
            transform: translateX(0);
        }
        to {
            opacity: 0;
            transform: translateX(10%);
        }
    }

</style>
<div class="row">
    <div class="col-12 col-lg-3 border-end">
        <div class="card shadow-sm border-0 mb-0">
            <div class="card-body">
                <div class="d-grid gap-3">
                    <div class="d-flex flex-row flex-lg-column flex-xl-row  w-100 gap-2">
                        <a href="javascript:;" id="new_folder" class="btn btn-primary file-management-btn d-flex align-items-center justify-content-center w-100">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-folder me-2" viewBox="0 0 16 16">
                                <path d="M.54 3.87.5 3a2 2 0 0 1 2-2h3.672a2 2 0 0 1 1.414.586l.828.828A2 2 0 0 0 9.828 3h3.982a2 2 0 0 1 1.992 2.181l-.637 7A2 2 0 0 1 13.174 14H2.826a2 2 0 0 1-1.991-1.819l-.637-7a2 2 0 0 1 .342-1.31zM2.19 4a1 1 0 0 0-.996 1.09l.637 7a1 1 0 0 0 .995.91h10.348a1 1 0 0 0 .995-.91l.637-7A1 1 0 0 0 13.81 4zm4.69-1.707A1 1 0 0 0 6.172 2H2.5a1 1 0 0 0-1 .981l.006.139q.323-.119.684-.12h5.396z"/>
                            </svg>
                            Folder
                        </a>
                        <a href="javascript:;" id="new_file" class="btn btn-primary file-management-btn d-flex align-items-center justify-content-center w-100">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-file-earmark-plus me-2" viewBox="0 0 16 16">
                                <path d="M8 6.5a.5.5 0 0 1 .5.5v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 .5-.5"/>
                                <path d="M14 4.5V14a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h5.5zm-3 0A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V4.5z"/>
                            </svg>
                            File
                        </a>
                    </div>
                    <a href="?action=file-management&path=.trash" class="btn btn-danger file-management-btn d-flex align-items-center justify-content-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-trash me-2" viewBox="0 0 16 16">
                            <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                            <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                        </svg>
                        Trash Bin
                    </a>
                </div>
            </div>
        </div>
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <h5 class="mb-0 text-primary fw-bold">Directory Size <span id="directory-size">{$stats.total_size}</span> MB</h5>
                <div class="progress mt-3" style="height: 10px;">
                    <div class="progress-bar bg-primary" role="progressbar" id="progress-bar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                <script>
                    document.addEventListener("DOMContentLoaded", function () {
                        const totalSize = parseFloat(document.getElementById('directory-size').textContent) || 0;
                        const maxSize = 1000; // Max size in MB for 100% progress
                        const percentage = Math.min((totalSize / maxSize) * 100, 100);
                        const progressBar = document.getElementById('progress-bar');
                        progressBar.style.width = percentage + '%';
                        progressBar.setAttribute('aria-valuenow', percentage.toFixed(2));
                    });
                </script>
                <div class="mt-4">
                    <div class="d-flex align-items-center mb-3 border-bottom">
                        <div class="icon-box bg-light-primary text-primary p-3 rounded-circle"><i class="bx bx-folder"></i></div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="mb-0">Folders</h6>
                            <p class="mb-0 text-secondary">Total Folders</p>
                        </div>
                        <h6 class="text-primary mb-0" id="stats_folders">{$stats.folders}</h6>
                    </div>
                    <div class="d-flex align-items-center">
                        <div class="icon-box bg-light-success text-success p-3 rounded-circle"><i class="bx bxs-file-doc"></i></div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="mb-0">Files</h6>
                            <p class="mb-0 text-secondary">Total Files</p>
                        </div>
                        <h6 class="text-primary mb-0" id="status_files">{$stats.files}</h6>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12 col-lg-9">
        <div class="card">
            <div class="card-body">
                <div class="fm-search d-flex justify-content-between align-items-center">
                    <div class="mb-0">
                        <div class="input-group">	<span class="input-group-text bg-transparent"><i class="fa fa-search"></i></span>
                            <input type="text" id="search-files" name="query" class="form-control" placeholder="Search the files">
                        </div>
                    </div>
                    <div class="d-flex align-items-center">
                        <div class="ms-auto">
                            <a href="#" id="rename"><i style="font-size: 30px" class='bx bx-edit'></i></a>
                            <a href="#" id="copy"><i style="font-size: 30px" class='bx bx-copy'></i></a>
                            <a href="#" id="move"><i style="font-size: 30px" class='bx bxs-arrow-to-right'></i></a>
                            <a href="#" id="permissions"><i style="font-size: 30px" class='bx bx-key'></i></a>
                            <a href="#" class="archive"><i style="font-size: 30px" class='bx bx-archive'></i></a>
                            <a href="#" class="trash"><i style="font-size: 30px" class='bx bx-trash-alt'></i></a>
                            {*<a href="#" id="download"><i style="font-size: 30px" class='bx bx-download'></i></a>*}
                            <a href="#" id="upload"><i style="font-size: 30px" class='bx bx-upload'></i></a>

                        </div>
                    </div>
                </div><hr>

                <div class="table-responsive mt-3">
                    <table class="table table-columned table-hover table-sm mb-0" id="manager-table">
                        <thead>
                        <tr>
                            <th>Name
                            </th>
                            <th>Permissions</th>
                            <th>Size</th>
                        </tr>
                        </thead>
                        <h6>Текущая директория: {if $currentPath == ""} Корневая директория {else} {$currentPath} {/if}</h6>
                        <a id="back_a" data-action="{$pathWithoutLast}" href="?action=file-management&path={$pathWithoutLast}">
                            <i class="bx bx-up-arrow-alt ms-2"></i> Назад
                        </a>
                        {if $currentPath == ".trash"}
                            <a href="#" style="color: green; margin-left: 10px" id="restore_form_trash">
                                <i class='bx bx-refresh'></i> Востановить выбранные обекты
                            </a>
                            <a href="#" style="color: green; margin-left: 10px" id="remove_from_trash">
                                <i class='bx bx-x-circle'></i> Удалить навсегда выбранные обекты
                            </a>
                        {/if}
                </div><br><br>

                <tbody id="tbody">
                {foreach $files as $file}

                    <tr data-path="{$file.normal_path|escape}" data-name="{$file.name}">
                        <td>
                            <div id="content" class="d-flex align-items-center">
                                <div>
                                    {if $file.extension == "git" || $file.extension == "gitignore"}
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-github" viewBox="0 0 16 16">
                                            <path d="M8 0C3.58 0 0 3.58 0 8c0 3.54 2.29 6.53 5.47 7.59.4.07.55-.17.55-.38 0-.19-.01-.82-.01-1.49-2.01.37-2.53-.49-2.69-.94-.09-.23-.48-.94-.82-1.13-.28-.15-.68-.52-.01-.53.63-.01 1.08.58 1.23.82.72 1.21 1.87.87 2.33.66.07-.52.28-.87.51-1.07-1.78-.2-3.64-.89-3.64-3.95 0-.87.31-1.59.82-2.15-.08-.2-.36-1.02.08-2.12 0 0 .67-.21 2.2.82.64-.18 1.32-.27 2-.27s1.36.09 2 .27c1.53-1.04 2.2-.82 2.2-.82.44 1.1.16 1.92.08 2.12.51.56.82 1.27.82 2.15 0 3.07-1.87 3.75-3.65 3.95.29.25.54.73.54 1.48 0 1.07-.01 1.93-.01 2.2 0 .21.15.46.55.38A8.01 8.01 0 0 0 16 8c0-4.42-3.58-8-8-8"/>
                                        </svg>
                                    {elseif $file.extension == "php"}
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-filetype-php" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M14 4.5V14a2 2 0 0 1-2 2h-1v-1h1a1 1 0 0 0 1-1V4.5h-2A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v9H2V2a2 2 0 0 1 2-2h5.5zM1.6 11.85H0v3.999h.791v-1.342h.803q.43 0 .732-.173.305-.175.463-.474a1.4 1.4 0 0 0 .161-.677q0-.375-.158-.677a1.2 1.2 0 0 0-.46-.477q-.3-.18-.732-.179m.545 1.333a.8.8 0 0 1-.085.38.57.57 0 0 1-.238.241.8.8 0 0 1-.375.082H.788V12.48h.66q.327 0 .512.181.185.182.185.522m4.48 2.666V11.85h-.79v1.626H4.153V11.85h-.79v3.999h.79v-1.714h1.682v1.714zm.703-3.999h1.6q.433 0 .732.179.3.175.46.477.158.302.158.677t-.161.677q-.159.299-.463.474a1.45 1.45 0 0 1-.733.173H8.12v1.342h-.791zm2.06 1.714a.8.8 0 0 0 .084-.381q0-.34-.184-.521-.184-.182-.513-.182h-.66v1.406h.66a.8.8 0 0 0 .375-.082.57.57 0 0 0 .237-.24Z"/>
                                        </svg>
                                    {elseif $file.extension == "js"}
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-filetype-js" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M14 4.5V14a2 2 0 0 1-2 2H8v-1h4a1 1 0 0 0 1-1V4.5h-2A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v9H2V2a2 2 0 0 1 2-2h5.5zM3.186 15.29a1.2 1.2 0 0 1-.111-.449h.765a.58.58 0 0 0 .255.384q.105.073.249.114.143.041.319.041.246 0 .413-.07a.56.56 0 0 0 .255-.193.5.5 0 0 0 .085-.29.39.39 0 0 0-.153-.326q-.151-.12-.462-.193l-.619-.143a1.7 1.7 0 0 1-.539-.214 1 1 0 0 1-.351-.367 1.1 1.1 0 0 1-.123-.524q0-.366.19-.639.19-.272.528-.422.336-.15.776-.149.457 0 .78.152.324.153.5.41.18.255.2.566h-.75a.56.56 0 0 0-.12-.258.6.6 0 0 0-.247-.181.9.9 0 0 0-.369-.068q-.325 0-.513.152a.47.47 0 0 0-.184.384q0 .18.143.3a1 1 0 0 0 .405.175l.62.143q.327.075.566.211.24.136.375.358t.135.56q0 .37-.188.656a1.2 1.2 0 0 1-.539.439q-.351.158-.858.158-.381 0-.665-.09a1.4 1.4 0 0 1-.478-.252 1.1 1.1 0 0 1-.29-.375m-3.104-.033A1.3 1.3 0 0 1 0 14.791h.765a.6.6 0 0 0 .073.27.5.5 0 0 0 .454.246q.285 0 .422-.164.138-.165.138-.466v-2.745h.79v2.725q0 .66-.357 1.005-.354.345-.984.345a1.6 1.6 0 0 1-.569-.094 1.15 1.15 0 0 1-.407-.266 1.1 1.1 0 0 1-.243-.39"/>
                                        </svg>
                                    {elseif $file.extension == "json"}
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-filetype-json" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M14 4.5V11h-1V4.5h-2A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v9H2V2a2 2 0 0 1 2-2h5.5zM4.151 15.29a1.2 1.2 0 0 1-.111-.449h.764a.58.58 0 0 0 .255.384q.105.073.25.114.142.041.319.041.245 0 .413-.07a.56.56 0 0 0 .255-.193.5.5 0 0 0 .084-.29.39.39 0 0 0-.152-.326q-.152-.12-.463-.193l-.618-.143a1.7 1.7 0 0 1-.539-.214 1 1 0 0 1-.352-.367 1.1 1.1 0 0 1-.123-.524q0-.366.19-.639.192-.272.528-.422.337-.15.777-.149.456 0 .779.152.326.153.5.41.18.255.2.566h-.75a.56.56 0 0 0-.12-.258.6.6 0 0 0-.246-.181.9.9 0 0 0-.37-.068q-.324 0-.512.152a.47.47 0 0 0-.185.384q0 .18.144.3a1 1 0 0 0 .404.175l.621.143q.326.075.566.211a1 1 0 0 1 .375.358q.135.222.135.56 0 .37-.188.656a1.2 1.2 0 0 1-.539.439q-.351.158-.858.158-.381 0-.665-.09a1.4 1.4 0 0 1-.478-.252 1.1 1.1 0 0 1-.29-.375m-3.104-.033a1.3 1.3 0 0 1-.082-.466h.764a.6.6 0 0 0 .074.27.5.5 0 0 0 .454.246q.285 0 .422-.164.137-.165.137-.466v-2.745h.791v2.725q0 .66-.357 1.005-.355.345-.985.345a1.6 1.6 0 0 1-.568-.094 1.15 1.15 0 0 1-.407-.266 1.1 1.1 0 0 1-.243-.39m9.091-1.585v.522q0 .384-.117.641a.86.86 0 0 1-.322.387.9.9 0 0 1-.47.126.9.9 0 0 1-.47-.126.87.87 0 0 1-.32-.387 1.55 1.55 0 0 1-.117-.641v-.522q0-.386.117-.641a.87.87 0 0 1 .32-.387.87.87 0 0 1 .47-.129q.265 0 .47.129a.86.86 0 0 1 .322.387q.117.255.117.641m.803.519v-.513q0-.565-.205-.973a1.46 1.46 0 0 0-.59-.63q-.38-.22-.916-.22-.534 0-.92.22a1.44 1.44 0 0 0-.589.628q-.205.407-.205.975v.513q0 .562.205.973.205.407.589.626.386.217.92.217.536 0 .917-.217.384-.22.589-.626.204-.41.205-.973m1.29-.935v2.675h-.746v-3.999h.662l1.752 2.66h.032v-2.66h.75v4h-.656l-1.761-2.676z"/>
                                        </svg>
                                    {elseif $file.extension == "lock"}
                                        <i class='bx bx-code-block' ></i>
                                    {elseif $file.extension == "tpl"}
                                        <i class='bx bxl-html5' ></i>
                                    {elseif $file.extension == "css"}
                                        <i class='bx bxs-file-css' ></i>
                                    {else}
                                        <i class='bx bx-folder' ></i>

                                    {/if}
                                </div>
                                {if $file.is_dir}
                                    <div class="font-weight-bold"><a href="?action=file-management&path={$file.normal_path|escape}">
                                            <i class="bi bi-folder"></i>  &nbsp;{$file.name}
                                        </a>
                                    </div>
                                {else}
                                    <div class="font-weight-bold"><a href="{$file.full_path|escape}">
                                            <i class="bi bi-folder"></i>  &nbsp;{$file.name}
                                        </a>
                                    </div>
                                {/if}

                            </div>
                        </td>
                        <td>{$file.permissions}</td>
                        <td>{$file.size}</td>
                        {*<td><i class="fa fa-ellipsis-h font-24"></i>*}
                        </td>
                    </tr>

                {/foreach}
                </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
</div>
</div>
<div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Заголовок модального окна -->
            <div class="modal-header">
                <h5 class="modal-title" id="modalTitle">Modal Title</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <!-- Тело модального окна -->
            <div class="modal-body">
                <input type="text" id="modalInput" class="form-control" placeholder="Type something..."><br>

                <select class="form-control" id="extensions" hidden="hidden" name="extensions">
                    <option value="php">PHP</option>
                    <option value="js">Java Script</option>
                    <option value="json">JSON</option>
                    <option value="tpl">Smarty TPL</option>
                </select>
            </div>

            <input type="hidden" value="{$currentPath}" id="currentPath">
            <!-- Подвал модального окна -->
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary modal-button" id="modalOkBtn">OK</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="copyModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Заголовок модального окна -->
            <div class="modal-header">
                <h5 class="modal-title" id="modalTitle">Copy</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <!-- Тело модального окна -->
            <div class="modal-body">
                <form id="copyForm">
                    <label for="destination">Путь назначения:</label>
                    <input class="form-control" type="text" id="destination" value="{$currentPath}" name="destination" required>
                    <input type="hidden" value="{$currentPath}" id="currentPath"><br>

                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button id="okCopy" class="btn btn-secondary" type="submit">Копировать</button>
                </form>
            </div>

        </div>
    </div>
</div>
<div class="modal fade" id="permissionsModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Заголовок модального окна -->
            <div class="modal-header">
                <h5 class="modal-title" id="modalTitle">Управление правами доступа</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <!-- Тело модального окна -->
            <div class="modal-body">

                <form method="POST" action="set_permissions.php">
                    <fieldset class="mb-3">
                        <legend>Установить права:</legend>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="read" name="read">
                            <label class="form-check-label" for="read">Чтение</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="write" name="write">
                            <label class="form-check-label" for="write">Запись</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="execute" name="execute">
                            <label class="form-check-label" for="execute">Выполнение</label>
                        </div><br>
                        <label class="form-label" for="perms">Текущие права</label>
                        <input class="form-control" type="text" id="perms" name="perms">
                    </fieldset>

                    <br><br>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button id="okPermissions" class="btn btn-secondary" type="button">Изменить</button>
                </form>
            </div>

        </div>
    </div>
</div>
<div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Заголовок модального окна -->
            <div class="modal-header">
                <h5 class="modal-title" id="modalTitle">Upload</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <!-- Тело модального окна -->
            <div class="modal-body">
                <form id="file-form">
                    <input class="form-control" type="file" id="file-input" multiple />
                    <input type="hidden" value="{$currentPath}" id="currentPath"><br>

                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button id="okUpload" class="btn btn-secondary" type="button">Загрузить файлы</button>
                </form>
            </div>

        </div>
    </div>
</div>
{*
<ul >
    <li id="menuOption1">Опция 1</li>
    <li id="menuOption2">Опция 2</li>
    <li id="menuOption3" class="disabled">Опция 3 (Неактивная)</li>
    <li id="menuOption4">Удалить</li>
</ul>
*}


<div id="dropdown">
    <ul class="dropdown-menu" role="menu" aria-labelledby="dropdownMenu" id="contextMenu">
        <li><a tabindex="-1" href="#" class="trash"><i class='bx bx-trash-alt'></i> Удалить</a></li>
        <li><a tabindex="-1" href="#" class="archive"><i class='bx bx-archive'></i> Архивировать</a></li>
        <li class="divider"></li>
        <li><a tabindex="-1" disabled="true" href="#">Сведения</a></li>
    </ul>
</div>

<script>

</script>

<style>

    #dropdown .dropdown-menu {
        display: block;
        list-style: none;
        padding: 0;
        margin: 0;
    }

    #dropdown .dropdown-menu li {
        display: block;
    }

    #dropdown .dropdown-menu li a {
        display: block;
        padding: 8px 16px;
        text-decoration: none;
    }

    #dropdown .dropdown-menu .divider {
        height: 1px;
        margin: 0.5rem 0;
        overflow: hidden;
        background-color: #e9ecef;
    }
    .form-container {
        max-width: 600px;
        margin: auto;
        padding: 20px;
        border: 1px solid #ccc;
        border-radius: 5px;
        background-color: #f9f9f9;
    }
    .form-container label {
        display: block;
        margin-bottom: 10px;
        font-weight: bold;
    }
    .form-container input[type="text"] {
        width: 100%;
        padding: 8px;
        margin-bottom: 20px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }
    .form-container input[type="checkbox"] {
        margin-right: 10px;
    }
    .form-container button {
        padding: 10px 20px;
        background-color: #4CAF50;
        color: white;
        border: none;
        border-radius: 4px;
        cursor: pointer;
    }
    .form-container button:hover {
        background-color: #45a049;
    }
    /* Стили для контекстного меню в стиле Windows 11 */
    /*  #contextMenu {
          position: absolute;
          display: none;
          background-color: #ffffff;
          border-radius: 8px;
          box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
          z-index: 1000;
          padding: 4px 0;
          min-width: 160px;
          font-size: 14px;
          color: #333;
          list-style-type: none; !* Убираем маркеры списка *!
          margin: 0; !* Убираем отступы *!
      }

      #contextMenu li {
          padding: 8px 16px;
          cursor: pointer;
          border-radius: 4px;
          transition: background-color 0.2s ease, color 0.2s ease;
      }

      #contextMenu li:hover {
          background-color: #0078d4;
          color: #ffffff;
      }

      #contextMenu li:active {
          background-color: #005a9e;
      }

      !* Разделители между пунктами меню *!
      #contextMenu li + li {
          border-top: 1px solid #e1e1e1;
      }

      !* Стиль для "Скопировать" пункта *!
      #contextMenu .disabled {
          color: #aaa;
          cursor: not-allowed;
      }*/
    #manager-table tr {
        cursor: pointer;
    }

    .checkbox-container {
        display: inline-block;
        margin-right: 10px;
    }

    .checkbox-container input[type="checkbox"] {
        transform: scale(1.5); /* Увеличиваем чекбокс */
        border-radius: 50%;    /* Делаем чекбокс круглым */
    }

    .card {
        position: relative;
        display: flex;
        flex-direction: column;
        min-width: 0;
        word-wrap: break-word;
        background-clip: border-box;
        border: 0px solid rgba(0, 0, 0, 0);
        border-radius: .25rem;
        margin-bottom: 1.5rem;
    }
    .fm-file-box {
        font-size: 25px;
        width: 44px;
        height: 44px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: .25rem;
    }
    .ms-2 {
        margin-left: .5rem!important;
    }

    .fm-menu .list-group a {
        font-size: 16px;
        color: #5f5f5f;
        display: flex;
        align-items: center;
    }
    .list-group-flush>.list-group-item {
        border-width: 0 0 1px;
    }
    .list-group-item+.list-group-item {
        border-top-width: 0;
    }
    .py-1 {
        padding-top: .25rem!important;
        padding-bottom: .25rem!important;
    }
    .list-group-item {
        position: relative;
        display: block;
        padding: .5rem 1rem;
        text-decoration: none;
        border: 1px solid rgba(0, 0, 0, .125);
    }

    .radius-15 {
        border-radius: 15px;
    }
    .fm-icon-box {
        font-size: 32px;
        width: 52px;
        height: 52px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: .25rem;
    }
    .font-24 {
        font-size: 24px;
    }
    .ms-auto {
        margin-left: auto!important;
    }
    .font-30 {
        font-size: 30px;
    }
    .user-groups img {
        margin-left: -14px;
        border: 1px solid #e4e4e4;
        padding: 2px;
        cursor: pointer;
    }

    .rounded-circle {
        border-radius: 50%!important;
    }
</style>
<script>
    var fatSection = document.getElementById('fatSection');
    fatSection.classList.add('active');
    var filesAndTemplates = document.getElementById('filesAndTemplates');
    filesAndTemplates.classList.add('show');
    var currentLink = document.getElementById('fileManagement');
    currentLink.classList.add('active');
</script>