<div class="chart-grid row gap-3">
    <div id="chart-revenue-expenses" class="chart-container col-4"></div>
    <div id="chart-cash-flows" class="chart-container col-6"></div>
    <div id="chart-revenue-structure" class="chart-container col-6"></div>
    <div id="chart-payment-methods" class="chart-container col-3"></div>
</div>

<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.1/dist/apexcharts.min.js"></script>
<script>
    const revenueExpensesOptions = {
        series: [{
            name: 'Доходы',
            data: [300, 300, 300, 200, 200, 150]
        }, {
            name: 'Расходы',
            data: [50, 20, 80, 90, 100, 2500]
        }],
        chart: {
            type: 'bar',
            height: 250,
            toolbar: { show: false }
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '40%',
                endingShape: 'rounded'
            }
        },
        colors: ['#4CAF50', '#FF5733'],
        xaxis: {
            categories: ['January', 'February', 'March', 'April', 'May', 'June'],
        },
        title: {
            text: '1. Доходы и расходы',
            align: 'left'
        },
        dataLabels: { enabled: false },
        legend: {
            position: 'top',
            horizontalAlign: 'right'
        }
    };
    new ApexCharts(document.querySelector("#chart-revenue-expenses"), revenueExpensesOptions).render();

    const cashFlowsOptions = {
        series: [{
            name: 'Cash Flow',
            data: [200, 220, 180, 250, 300, 310, 350, 400, 420, 500]
        }],
        chart: {
            type: 'line',
            height: 250,
            toolbar: { show: false }
        },
        stroke: {
            width: 3,
            curve: 'smooth'
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 0.8,
                opacityFrom: 0.5,
                opacityTo: 0.1,
                stops: [0, 90, 100]
            }
        },
        colors: ['#1E90FF'],
        xaxis: {
            categories: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October'],
            title: { text: 'Месяцы' }
        },
        title: {
            text: '2. Финансовые потоки',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-cash-flows"), cashFlowsOptions).render();

    const revenueStructureOptions = {
        series: [{
            data: [
                { x: 'Product A', y: 40 },
                { x: 'Product B', y: 25 },
                { x: 'Consulting', y: 20 },
                { x: 'Subscriptions', y: 10 },
                { x: 'Advertising', y: 5 }
            ]
        }],
        chart: {
            type: 'treemap',
            height: 250,
            toolbar: { show: false }
        },
        title: {
            text: '3. Структура доходов',
            align: 'left'
        },
        colors: ['#34C38F', '#FF9800', '#2196F3', '#FF5722', '#9C27B0'],
        plotOptions: {
            treemap: {
                distributed: true,
                enableShades: true,
                shadeIntensity: 0.5
            }
        }
    };
    new ApexCharts(document.querySelector("#chart-revenue-structure"), revenueStructureOptions).render();

    const paymentMethodsOptions = {
        series: [65, 15, 10, 10],
        chart: {
            type: 'donut',
            height: 250,
            toolbar: { show: false }
        },
        labels: ['Credit Card', 'Bank Transfer', 'PayPal', 'Cash'],
        title: {
            text: '4. Методы оплат',
            align: 'left'
        },
        colors: ['#4CAF50', '#FFC107', '#FF5722', '#00BCD4'],
        dataLabels: {
            enabled: true,
            formatter: function (val, opts) {
                return opts.w.globals.labels[opts.seriesIndex] + ': ' + Math.round(val) + '%';
            }
        },
        legend: {
            position: 'bottom'
        }
    };
    new ApexCharts(document.querySelector("#chart-payment-methods"), paymentMethodsOptions).render();

</script>