<div class="chart-grid row gap-3">
    <div id="chart-general" class="chart-container col-3"></div>
    <div id="chart-geo" class="chart-container col-6"></div>
    <div id="chart-pages" class="chart-container col-6"></div>
    <div id="chart-online" class="chart-container col-3"></div>
    <div id="chart-dynamics" class="chart-container col-6"></div>
</div>

<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.1/dist/apexcharts.min.js"></script>
<script>
    const generalStatsOptions = {
        series: [44, 55, 13, 43, 22],
        chart: { type: 'donut', height: 250 },
        labels: ['Organic Search', 'Direct', 'Referral', 'Social Media', 'Other'],
        title: { text: '1. Общая статистика системы', align: 'left' }
    };
    new ApexCharts(document.querySelector("#chart-general"), generalStatsOptions).render();


    const geoActivityOptions = {
        series: [{
            name: 'Sales Volume',
            data: [400, 430, 448, 470, 540, 580, 690, 1100, 1200, 1380]
        }],
        chart: { type: 'bar', height: 250, toolbar: { show: false } },
        xaxis: {
            categories: [
                'South Korea', 'Canada', 'UK', 'Netherlands', 'Italy',
                'France', 'Japan', 'US', 'China', 'Germany'
            ],
        },
        title: { text: '2. Геоактивность', align: 'left' },
        dataLabels: { enabled: false },
    };
    new ApexCharts(document.querySelector("#chart-geo"), geoActivityOptions).render();


    const popularPagesOptions = {
        series: [{ name: 'Page Views', data: [5200, 4500, 3800, 3100, 2500] }],
        chart: { type: 'bar', height: 250 , toolbar: { show: false }},
        xaxis: { categories: ['/products', '/blog', '/pricing', '/about', '/contact'] },
        title: { text: '3. Популярные страницы', align: 'left' },
        plotOptions: { bar: { columnWidth: '60%' } }
    };
    new ApexCharts(document.querySelector("#chart-pages"), popularPagesOptions).render();


    const onlineActivityOptions = {
        series: [78],
        chart: { height: 250, type: 'radialBar' },
        plotOptions: { radialBar: { hollow: { size: '70%' } } },
        title: { text: '4. Онлайн-активность', align: 'left' }
    };
    new ApexCharts(document.querySelector("#chart-online"), onlineActivityOptions).render();


    const dynamicsOptions = {
        series: [{
            name: 'Total Users',
            data: [30, 40, 45, 50, 49, 60, 70, 75, 82, 90]
        }],
        chart: {
            height: 250,
            type: 'area',
            toolbar: { show: false }
        },
        stroke: { curve: 'smooth' },
        xaxis: { categories: ['W1', 'W2', 'W3', 'W4', 'W5', 'W6', 'W7', 'W8', 'W9', 'W10'] },
        title: { text: '5. Динамика за период', align: 'left' }
    };
    new ApexCharts(document.querySelector("#chart-dynamics"), dynamicsOptions).render();

</script>