<div class="sub-layout d-flex flex-row">
    <div class="order-1 custom_scroll">
        {if isset($lang_files) && count($lang_files) > 0}
            <h6 class="border-bottom pb-2">Языковые пакеты:</h6>
            {foreach $lang_files as $lang_file => $file_type}
                {assign var="file_path" value=$langDirectory|cat:$current_dir|cat:'/'|cat:$lang_file}
                {if $file_type === 'dir'}
                    <div class="accordion" id="accordion_{$lang_file|replace:'/':'_'}">
                        <div class="accordion-item">
                            <h3 class="accordion-header" id="heading_{$lang_file|replace:'/':'_'}">
                                <a class="accordion-button collapsed p-1" type="button" data-bs-toggle="collapse" data-bs-target="#collapse_{$lang_file|replace:'/':'_'}" aria-expanded="false" aria-controls="collapse_{$lang_file|replace:'/':'_'}">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-folder" viewBox="0 0 16 16">
                                        <path d="M8 1a1 1 0 0 1 1 1v1h6a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1h4V1z"/>
                                    </svg>
                                    <span class="ps-1">{$lang_file}</span>
                                </a>
                            </h3>
                            <div id="collapse_{$lang_file|replace:'/':'_'}" class="accordion-collapse collapse" aria-labelledby="heading_{$lang_file|replace:'/':'_'}" data-bs-parent="#accordion_{$lang_file|replace:'/':'_'}">
                                <div class="accordion-body py-2">
                                    {assign var="subfolder_files" value=getFilesInDirectory($langDirectory|cat:$current_dir|cat:'/'|cat:$lang_file)}
                                    {foreach $subfolder_files as $subfolder_file => $subfolder_type}
                                        {if $subfolder_type === 'file'}
                                            <p class="mb-0">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24">
                                                    <path fill="currentColor" d="M5.615 19h12.77q.269 0 .442-.173t.173-.442V9.613L14.387 5H5.615q-.269 0-.442.173T5 5.615v12.77q0 .269.173.442t.442.173m0 1q-.67 0-1.143-.472Q4 19.056 4 18.385V5.615q0-.67.472-1.143Q4.944 4 5.615 4h9.173L20 9.212v9.173q0 .67-.472 1.143q-.472.472-1.143.472zM7.5 16h9v-1h-9zm0-3.5h9v-1h-9zm0-3.5h5.73V8H7.5zM5 19V5z"/>
                                                </svg>
                                                <a href="admin?action=language-settings&sub_action=edit&lang_file={$current_dir}/{$lang_file}/{$subfolder_file}">{$subfolder_file}</a>
                                            </p>
                                        {/if}
                                    {/foreach}
                                </div>
                            </div>
                        </div>
                    </div>
                {elseif $file_type === 'file'}
                    <li class="list-group-item">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M5.615 19h12.77q.269 0 .442-.173t.173-.442V9.613L14.387 5H5.615q-.269 0-.442.173T5 5.615v12.77q0 .269.173.442t.442.173m0 1q-.67 0-1.143-.472Q4 19.056 4 18.385V5.615q0-.67.472-1.143Q4.944 4 5.615 4h9.173L20 9.212v9.173q0 .67-.472 1.143q-.472.472-1.143.472zM7.5 16h9v-1h-9zm0-3.5h9v-1h-9zm0-3.5h5.73V8H7.5zM5 19V5z"/>
                        </svg>
                        <a href="admin?action=language-settings&sub_action=edit&lang_file={$current_dir}/{$lang_file}">{$lang_file}</a>
                    </li>
                {/if}
            {/foreach}
        {else}
            <p>Нет доступных языковых файлов.</p>
        {/if}
    </div>
    <div class="order-2 flex-grow-1 custom_scroll border-start ps-3">
        {if isset($lang_file)}
            <h6>Название файла: {$lang_file}</h6>
            <textarea class="editor" id="editor" name="editor" readonly>{if isset($lang_content)}{$lang_content}{/if}</textarea><br>
            <button type="button" class="btn btn-success" {if $access['modules.update']}onclick="saveChanges('{$lang_file}'){/if}">Сохранить изменения</button>
            <div id="status"></div>
            <script>
                // Инициализация редактора
                var editor;
                // Функция для инициализации CodeMirror с нужной темой
                function initializeEditor() {
                    var theme = document.documentElement.getAttribute('data-bs-theme') === 'dark' ? 'dracula' : 'default';
                    if (editor) {
                        // Если редактор уже инициализирован, просто меняем тему
                        editor.setOption("theme", theme);
                    } else {
                        // Инициализация CodeMirror с нумерацией строк
                        editor = CodeMirror.fromTextArea(document.getElementById('editor'), {
                            lineNumbers: true,
                            mode: "text/x-php",
                            theme: theme,
                            matchBrackets: true,
                            viewportMargin: Infinity
                        });
                        // Добавляем границы снизу ко всем строкам
                        addBottomBorderToAllLines();
                    }
                }
                // Функция для добавления границы снизу ко всем строкам
                function addBottomBorderToAllLines() {
                    var totalLines = editor.lineCount();
                    for (var i = 0; i < totalLines; i++) {
                        editor.addLineClass(i, 'wrap', 'editor-line-border-bottom');
                    }
                }
                // Инициализация редактора при загрузке страницы
                initializeEditor();
                // Отслеживание изменений атрибута data-bs-theme
                var observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.attributeName === 'data-bs-theme') {
                            // При изменении атрибута перезапускаем редактор с новой темой
                            initializeEditor();
                        }
                    });
                });
                // Наблюдаем за изменениями атрибутов <html>
                observer.observe(document.documentElement, {
                    attributes: true
                });
            </script>
            {if $access['modules.update']}
            <script>
                // Функция сохранения
                function saveChanges() {
                    var langContent = editor.getValue(); // Получаем контент из CodeMirror
                    var langFile = '{$lang_file}';
                    var langDirectory = '{$langDirectory}';
                    var xhr = new XMLHttpRequest();
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4 && xhr.status === 200) {
                            document.getElementById('status').innerHTML = xhr.responseText;
                        }
                    };
                    xhr.open('POST', 'admin?action=language-settings&sub_action=save', true);
                    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
                    xhr.send('lang_file=' + encodeURIComponent(langFile) + '&lang_content=' + encodeURIComponent(langContent));
                }
            </script>
            {/if}
        {/if}
    </div>
</div>

<script>
	var currentLink = document.getElementById('languageSettings');
	currentLink.classList.add('active');
</script>