{if $access["locations.manage"] || $user.name == 'Demo profile'}

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="col-12 locations-block">

    <div class="alert alert-info d-flex align-items-center">
        <i class="fas fa-info-circle me-2"></i>
        <div>
            <strong>{$lang.locations_control.instruction}:</strong> {$lang.locations_control.instruction_desc}
        </div>
    </div>

    <div class="card mb-2 shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center"
             data-bs-toggle="collapse"
             data-bs-target="#root-location-collapse"
             role="button"
             aria-expanded="false"
             aria-controls="root-location-collapse">
            <div class="d-flex align-items-center">
                <i class="fas fa-plus-circle me-2"></i>
                <h5 class="">{$lang.locations_control.add_location}</h5>
            </div>
            <i class="fas fa-chevron-down collapse-arrow"></i>
        </div>

        <div id="root-location-collapse" class="collapse">
            <div class="card-body">
                <div class="input-group">
                    <input type="text" id="root-location-input" class="form-control form-control-lg" placeholder="{$lang.locations_control.write_location_name}">
                    <select id="language-select" class="form-select">
                        <option value="" disabled selected>{$lang.locations_control.select_lang}</option>
                        {foreach from=$available_languages item=language}
                            <option value="{$language}">{$language}</option>
                        {/foreach}
                    </select>
                    <button id="add-root-btn" class="btn btn-success btn-lg">
                        <i class="fas fa-plus me-1"></i> {$lang.locations_control.add}
                    </button>
                </div>
            </div>
        </div>
    </div>



    <div class="locations-hierarchy mb-5">
        <h2 class="d-flex align-items-center">
            <i class="fas fa-sitemap me-3"></i>
            <span>{$lang.locations_control.locations_structure}</span>
        </h2>
        <div id="locations-container">
            <div class="empty-state">
                <i class="fas fa-map-marked-alt"></i>
                <h4>{$lang.locations_control.empty_locations}</h4>
                <p class="mb-0">{$lang.locations_control.add_main_location_notice}</p>
            </div>
        </div>
    </div>

    <div class="actions shadow-sm">
        <div class="d-flex justify-content-between">
            <div>
                <button id="expand-all-btn" class="btn btn-outline-primary">
                    <i class="fas fa-expand me-1"></i> {$lang.locations_control.collapse_on}
                </button>
                <button id="collapse-all-btn" class="btn btn-outline-primary ms-2">
                    <i class="fas fa-compress me-1"></i> {$lang.locations_control.collapse_off}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Шаблон локации -->
<template id="location-template">
    <div class="location-item" data-id="" data-name="" data-level="" data-type="" data-slug="" data-lang="">
        <div class="location-header">
            <div class="toggle-btn"><i class="fas fa-chevron-down"></i></div>
            <div class="level-indicator"></div>
            <span class="location-name"></span>
            <div class="location-actions">
                <div class="action-btn add-lang" title="{$lang.locations_control.add_lang}"><i class="fas fa-language"></i></div>
                <div class="action-btn add-btn" title="{$lang.locations_control.add_child_location}"><i class="fas fa-plus"></i></div>
                <div class="action-btn remove-btn" title="{$lang.locations_control.delete_location}"><i class="fas fa-times"></i></div>
            </div>
        </div>
        <div class="location-container mt-3"></div>
    </div>
</template>


<template id="notificationItem">
    <li class="pe-2" onclick="">
        <a class="d-flex p-lg-3 p-2 rounded-3" href="javascript:void(0);">
            <div class="avatar sm">

            </div>
            <div class="flex-fill ms-3">
                        <span class="d-flex justify-content-between">
                            <small class="text-primary"></small>
                            <small class="text-muted"></small>
                        </span>
                <p class="mb-0 mt-1"></p>
            </div>
        </a>
    </li>
</template>


<template id="alert-template">
    <div class="alert alert-dismissible fade show" role="alert">
        <span class="alert-message"></span>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
</template>
<template id="empty-state-template">
    <div class="empty-state">
        <i class="fas fa-map-marked-alt"></i>
        <h4>{$lang.locations_control.empty_locations}</h4>
        <p class="mb-0">{$lang.locations_control.add_main_location_notice}</p>
    </div>
</template>

<div class="modal fade" id="addLocationModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{$lang.locations_control.add_child_location}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{$lang.locations_control.close}"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">{$lang.locations_control.name}</label>
                    <input type="text" id="modal-location-name" class="form-control">
                </div>
                <div class="mb-3">
                    <label class="form-label">{$lang.locations_control.select_lang}</label>
                    <select id="modal-language-select" class="form-select">
                        <option value="" disabled selected>{$lang.locations_control.select_lang}</option>
                        {foreach from=$available_languages item=language}
                            <option value="{$language}">{$language}</option>
                        {/foreach}
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">{$lang.locations_control.location_type}</label>
                    <select id="modal-location-type" class="form-select">
                        <option value="" disabled selected>{$lang.locations_control.select_type}</option>
                        <option value="country">{$lang.locations_control.country}</option>
                        <option value="state">{$lang.locations_control.state}</option>
                        <option value="region">{$lang.locations_control.region}</option>
                        <option value="city">{$lang.locations_control.city}</option>
                        <option value="district">{$lang.locations_control.district}</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">{$lang.locations_control.short_name}</label>
                    <input type="text" id="modal-location-slug" class="form-control">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{$lang.locations_control.cancel}</button>
                <button type="button" id="modal-add-btn" class="btn btn-primary">{$lang.locations_control.add}</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="addLangModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{$lang.locations_control.add_lang_to_location}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Закрыть"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">{$lang.locations_control.lang_val}</label>
                    <input type="text" id="modal-lang-name" class="form-control">
                </div>
                <div class="mb-3">
                    <label class="form-label">{$lang.locations_control.select_lang}</label>
                    <select id="modal-lang-language-select" class="form-select">
                        <option value="" disabled selected>{$lang.locations_control.select_lang}</option>
                        {foreach from=$available_languages item=language}
                            <option value="{$language}">{$language}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{$lang.locations_control.cancel}</button>
                <button type="button" id="modal-lang-add-btn" class="btn btn-primary">{$lang.locations_control.add}</button>
            </div>
        </div>
    </div>
</div>

<style>
    .collapse-arrow {
        transition: transform 0.3s ease;
    }
    .card-header[aria-expanded="true"] .collapse-arrow {
        transform: rotate(180deg);
    }
    .location-container {
        border-left: 2px solid #dee2e6;
        padding-left: 25px;
        margin-left: 15px;
        transition: all 0.3s;
    }
    .location-item {
        /*
        border: 1px solid #dee2e6;
        */
        border-radius: 5px;
        padding: 12px 15px;
        margin-bottom: 10px;
        position: relative;
        transition: all 0.3s;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    .location-item:hover {
        border-color: #ced4da;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }

    .location-item.collapsed > .location-container {
        display: none;
    }

    .location-item.collapsed .toggle-btn i {
        transform: rotate(-90deg); /* стрелка влево вместо вниз */
    }

    .location-header {
        display: flex;
        align-items: center;
        cursor: pointer;
    }
    .toggle-btn {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 10px;
        cursor: pointer;
        transition: all 0.2s;
    }
    .toggle-btn:hover {
        background-color: #dee2e6;
        transform: scale(1.05);
    }
    .location-name {
        font-weight: 500;
        flex-grow: 1;
        padding: 5px 0;
    }
    .location-actions {
        display: flex;
        gap: 8px;
    }
    .action-btn {
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        cursor: pointer;

</style>

<script src="{$stheme}/js/ajax/locationsControl/locations-control.js"></script>

    {else}
    <h3>Доступ запрещен</h3>
{/if}