<div class="row mt-2 mb-2">
    <h6 style="color: var(--theme-color1)">{$lang.sections.main.site_info}:</h6>
    <div class="col-4 mb-3">
        <table class="table table-hover mb-0">
            <tbody>
                <tr>
                    <td>{$lang.sections.main.site_status}:</td>
                    <td class="border-start text-center text-muted">
                        {if $config.site_offline}
                            {$lang.cms.site_disabled}
                        {else}
                            {$lang.cms.site_enabled}
                        {/if}
                    </td>
                </tr>
                <tr>
                    <td>{$lang.sections.main.default_language}:</td>
                    <td class="border-start text-center"><span class="text-muted">{$default_lang}</span></td>
                </tr>
                <tr>
                    <td class="border-bottom-0">{$lang.sections.main.charset}:</td>
                    <td class="border-start border-bottom-0 text-center"><span class="text-muted">{$charset}</span></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="col-4 mb-3">
        <table class="table table-hover mb-0">
            <tbody>
                <tr>
                    <td>{$lang.sections.main.license_type}:</td>
                    <td class="border-start text-center"><span class="text-muted">{$version_type}</span></td>
                </tr>
                <tr>
                    <td>{$lang.sections.main.license_expiry}:</td>
                    <td class="border-start text-center"><span class="text-muted">{$remaining_days}</span></td>
                </tr>
                <tr>
                    <td class="border-bottom-0">{$lang.sections.main.database_size}:</td>
                    <td class="border-start border-bottom-0 text-center">
                        <span class="text-muted">{$databaseSize} {$databaseSizeUnit}</span>
                        <div class="progress mt-1" style="height: 2px;">
                            <div class="progress-bar bg-primary" role="progressbar" aria-valuenow="{$databaseSize}*10" aria-valuemin="0" aria-valuemax="100" {$progressdatabaseSize}></div>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="col-4 mb-3">
        <table class="table table-hover mb-0">
            <tbody>
                <tr>
                    <td>{$lang.sections.main.your_ip}:</td>
                    <td class="border-start text-center"><span class="text-muted">{$externalIp}</span></td>
                </tr>
                <tr>
                    <td>{$lang.sections.main.city_by_ip}:</td>
                    <td class="border-start text-center"><span class="text-muted">{$city}</span></td>
                </tr>
                <tr>
                    <td class="border-bottom-0">{$lang.sections.main.smarty_cache}:</td>
                    <td class="border-start border-bottom-0 text-center">
                        <form method="post" id="deleteCache">
                            <input type="hidden" name="form_id" value="deleteCache">
                            <span class="text-muted">{$directorysize} MB</span>
                            <input type="hidden" name="delete_current_url" value="{$current_url}">
                            <button type="submit" class="text-danger" style="background:none;border:none;padding:0;" onclick="return confirm('Вы уверены, что хотите очистить кэш?');">
                                <i class="fa fa-times"></i>
                            </button>
                        </form>                        
                        <div class="progress mt-1" style="height: 2px;">
                            <div class="progress-bar bg-primary" role="progressbar" aria-valuenow="{$directorysize}*10" aria-valuemin="0" aria-valuemax="100" {$progressdirectorysize}></div>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<hr class="mt-0 mb-3" style="color: var(--theme-color1)">

<div class="row mt-2 mb-2">
    <h6 style="color: var(--theme-color1)">{$lang.sections.main.notifications}:</h6>
    <div class="col-12 col-md-4 mb-1">
        <table class="table table-hover mb-0">
            <tbody>
                <tr>
                    <td>{$lang.sections.main.feedback_requests}:</td>
                    <td class="border-start text-center" width="70px"><span class="text-muted">0</span></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="col-12 col-md-4 mb-1">
        <table class="table table-hover mb-0">
            <tbody>
                <tr>
                    <td>{$lang.sections.main.support_requests}:</td>
                    <td class="border-start text-center" width="70px"><span class="text-muted">0</span></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="col-12 col-md-4 mb-1">
        <table class="table table-hover mb-0">
            <tbody>
                <tr>
                    <td>{$lang.sections.main.complaints_received}:</td>
                    <td class="border-start text-center" width="70px"><span class="text-muted">0</span></td>
                </tr>
            </tbody>
        </table>
    </div>
    {if $productsAvailable && $productsUsed}
    <div class="col-12 col-md-4 mb-1">
        <table class="table table-hover mb-0">
            <tbody>
                <tr>
                    <td>{$lang.sections.main.orders_completed}:</td>
                    <td class="border-start text-center" width="70px"><span class="text-muted">0</span></td>
                </tr>
            </tbody>
        </table>
    </div>
    {/if}
    <div class="col-12 col-md-4 mb-1">
        <table class="table table-hover mb-0">
            <tbody>
                <tr>
                    <td>{$lang.sections.main.unverified_comments}:</td>
                    <td class="border-start text-center" width="70px"><span class="text-muted">0</span></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<hr class="mt-0 mb-3" style="color: var(--theme-color1)">

<div class="row mt-2">
    <div class="col mb-3">
        <h6 style="color: var(--theme-color1)">{$lang.sections.main.user_count}:</h6>
        <div class="card card-stats">
            <div class="card-body custom_scroll" style="height: 174px;">
                <table class="table table-hover mb-0">
                    <tbody>
                        <tr>
                            <td>{$lang.sections.main.total_users}</td>
                            <td class="border-start text-center" width="60px"><span class="text-muted">{$usersCount}</span></td>
                        </tr>
                        <tr>
                            <td>{$lang.sections.main.male_users}</td>
                            <td class="border-start text-center" width="60px"><span class="text-muted">{$data.maleCount}</span></td>
                        </tr>
                        <tr>
                            <td>{$lang.sections.main.female_users}</td>
                            <td class="border-start text-center" width="60px"><span class="text-muted">{$data.femaleCount}</span></td>
                        </tr>
                        <tr>
                            <td class="border-bottom-0">{$lang.sections.main.unspecified_gender}</td>
                            <td class="border-start border-bottom-0 text-center" width="60px"><span class="text-muted">{$data.unknownCount}</span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col mb-3">
        <h6 style="color: var(--theme-color1)">{$lang.sections.main.users_by_age}:</h6>
        <div class="card card-stats">
            <div class="card-body custom_scroll" style="height: 174px;">
                <table class="table table-hover mb-0">
                    <tbody>
                        {foreach $data.ageData as $ageItem}
                        <tr>
                            <td>{$ageItem.age} {$lang.sections.main.years_old}</td>
                            <td class="text-end"><span class="text-muted">{$ageItem.count}</span></td>
                        </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col mb-3">
        <h6 style="color: var(--theme-color1)">{$lang.sections.main.users_by_city}:</h6>
        <div class="card card-stats">
            <div class="card-body custom_scroll" style="height: 174px;">
                <table class="table table-hover mb-0">
                    <tbody>
                        {foreach $data.cityData as $cityItem}
                        <tr>
                            <td>{$cityItem.city}</td>
                            <td class="text-end"><span class="text-muted">{$cityItem.count}</span></td>
                        </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<hr class="mt-0 mb-3" style="color: var(--theme-color1)">

<div class="row mt-2">
    <h6 style="color: var(--theme-color1)">{$lang.sections.main.all_sections}:</h6>
    
    {if $adsAvailable && $adsUsed}
        <div class="col-12 col-md-4 mb-1">
            <table class="table table-hover mb-0">
                <tbody>
                    <tr>
                        <td>{$lang.sections.main.ads_count}</td>
                        <td class="border-start text-center" width="70px"><span class="text-muted">{$adsCount}</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    {/if}

    {if $filesAvailable && $filesUsed}
        <div class="col-12 col-md-4 mb-1">
            <table class="table table-hover mb-0">
                <tbody>
                    <tr>
                        <td>{$lang.sections.main.files_count}</td>
                        <td class="border-start text-center" width="70px"><span class="text-muted">{$filesCount}</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    {/if}

    {if $moviesAvailable && $moviesUsed}
        <div class="col-12 col-md-4 mb-1">
            <table class="table table-hover mb-0">
                <tbody>
                    <tr>
                        <td>{$lang.sections.main.movies_count}</td>
                        <td class="border-start text-center" width="70px"><span class="text-muted">{$moviesCount}</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    {/if}

    {if $newsAvailable && $newsUsed}
        <div class="col-12 col-md-4 mb-1">
            <table class="table table-hover mb-0">
                <tbody>
                    <tr>
                        <td>{$lang.sections.main.news_count}</td>
                        <td class="border-start text-center" width="70px"><span class="text-muted">{$newsCount}</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    {/if}

    {if $productsAvailable && $productsUsed}
        <div class="col-12 col-md-4 mb-1">
            <table class="table table-hover mb-0">
                <tbody>
                    <tr>
                        <td>{$lang.sections.main.products_count}</td>
                        <td class="border-start text-center" width="70px"><span class="text-muted">{$productsCount}</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    {/if}
    
    {if $eventsAvailable && $eventsUsed}
        <div class="col-12 col-md-4 mb-1">
            <table class="table table-hover mb-0">
                <tbody>
                    <tr>
                        <td>{$lang.sections.main.events_count}</td>
                        <td class="border-start text-center" width="70px"><span class="text-muted">{$eventsCount}</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    {/if}

    <div class="col-12 col-md-4 mb-1">
        <table class="table table-hover mb-0">
            <tbody>
                <tr>
                    <td>{$lang.sections.main.pages_count}</td>
                    <td class="border-start text-center" width="70px"><span class="text-muted">{$pagesCount}</span></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<script>
	var commonCharts = document.getElementById('generalinformation');
	commonCharts.classList.add('active');
</script>