{if $access["extensions.manage"] || $user.name == 'Demo profile'}
	<script>
		function submitForm(button) {
			button.form.submit();
			button.disabled = true;
		}
	</script>

	<style>
		.multi-select {
			border: 1px solid #ddd;
			border-radius: 6px;
			padding: 8px;
			cursor: pointer;
			position: relative;
		}
		.multi-select-display {
			color: #555;
			min-height: 24px;
			display: flex;
			flex-wrap: wrap;
			gap: 6px;
		}
		.multi-select-tag {
			background: #0d6efd;
			color: #fff;
			padding: 3px 8px;
			border-radius: 10px;
			font-size: 12px;
		}
		.multi-select-dropdown {
			display: none;
			position: absolute;
			top: 100%;
			left: 0;
			right: 0;
			border: 1px solid #ddd;
			border-top: none;
			z-index: 50;
			padding: 10px;
			border-radius: 0 0 6px 6px;
			background-color: #fff;
			margin-top: 10px;
		}
		.multi-select.open .multi-select-dropdown {
			display: block;
		}
		.multi-select-dropdown label {
			display: block;
			padding: 4px 0;
			font-size: 14px;
			cursor: pointer;
		}
	</style>

	<div class="row">
		<div class="container">
			<h2 class="fw-bold mb-4">Управление расширениями</h2>

			<div class="row g-4">

				<div class="col-md-3 col-sm-6">
					<div class="card shadow-sm border-0 text-center p-3 h-100">
						<div class="mb-3">
<svg xmlns="http://www.w3.org/2000/svg" width="130" height="130" fill="currentColor" class="bi bi-star-half" viewBox="0 0 16 16">
  <path d="M5.354 5.119 7.538.792A.516.516 0 0 1 8 .5c.183 0 .366.097.465.292l2.184 4.327 4.898.696A.537.537 0 0 1 16 6.32a.548.548 0 0 1-.17.445l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256a.52.52 0 0 1-.146.05c-.342.06-.668-.254-.6-.642l.83-4.73L.172 6.765a.55.55 0 0 1-.171-.403.58.58 0 0 1 .085-.302.513.513 0 0 1 .37-.245l4.898-.696zM8 12.027a.5.5 0 0 1 .232.056l3.686 1.894-.694-3.957a.565.565 0 0 1 .162-.505l2.907-2.77-4.052-.576a.525.525 0 0 1-.393-.288L8.001 2.223 8 2.226v9.8z"/>
</svg>
						</div>
						<h4 class="fw-bold mb-3">Рейтинги</h4>
						<p class="text-muted small mb-3">Пользователи оценивают контент, формируется топ.</p>

						{foreach $extensions as $extensionKey => $selectedModules}
							{if $extensionKey == "ratings"}
								<div class="multi-select" data-placeholder="Выберите модули" data-extension="{$extensionKey}">
									<div class="multi-select-display"></div>
									<div class="multi-select-dropdown">
										{foreach ['news','events','coupons','auctions','products','shops','ads'] as $mod}
											<label>
												<input type="checkbox"
													   value="{$mod}"
													   data-extension="{$extensionKey}"
													   data-textn="{if $mod=='news'}Новости{elseif $mod=='events'}Мероприятия{elseif $mod=='coupons'}Купоны{elseif $mod=='auctions'}Аукцион{elseif $mod=='products'}Товары{elseif $mod=='shops'}Магазин{elseif $mod=='ads'}Объявления{/if}"
													   {if in_array($mod, $selectedModules.modules)}checked{/if}
												>
												{if $mod=='news'}Новости{elseif $mod=='events'}Мероприятия{elseif $mod=='coupons'}Купоны{elseif $mod=='auctions'}Аукцион{elseif $mod=='products'}Товары{elseif $mod=='shops'}Магазин{elseif $mod=='ads'}Объявления{/if}
											</label>
										{/foreach}
									</div>
								</div>
							{/if}
						{/foreach}

					</div>
				</div>

				<div class="col-md-3 col-sm-6">
					<div class="card shadow-sm border-0 text-center p-3 h-100">
						<div class="mb-3">
							<svg xmlns="http://www.w3.org/2000/svg" width="130" height="130" fill="currentColor" class="bi bi-qr-code" viewBox="0 0 16 16">
								<path d="M2 2h2v2H2z"/>
								<path d="M6 0v6H0V0zM5 1H1v4h4zM4 12H2v2h2z"/>
								<path d="M6 10v6H0v-6zm-5 1v4h4v-4zm11-9h2v2h-2z"/>
								<path d="M10 0v6h6V0zm5 1v4h-4V1zM8 1V0h1v2H8v2H7V1zm0 5V4h1v2zM6 8V7h1V6h1v2h1V7h5v1h-4v1H7V8zm0 0v1H2V8H1v1H0V7h3v1zm10 1h-1V7h1zm-1 0h-1v2h2v-1h-1zm-4 0h2v1h-1v1h-1zm2 3v-1h-1v1h-1v1H9v1h3v-2zm0 0h3v1h-2v1h-1zm-4-1v1h1v-2H7v1z"/>
								<path d="M7 12h1v3h4v1H7zm9 2v2h-3v-1h2v-1z"/>
							</svg>
						</div>
						<h4 class="fw-bold mb-3">API QR Код</h4>
						<p class="text-muted small mb-3">API QR Код.</p>

						{foreach $extensions as $extensionKey => $selectedModules}
							{if $extensionKey == "api_qr_code"}
								<div class="multi-select" data-placeholder="Выберите модули" data-extension="{$extensionKey}">
									<div class="multi-select-display"></div>
									<div class="multi-select-dropdown">
										{foreach ['news','events','coupons','auctions','products','shops','ads'] as $mod}
											<label>
												<input type="checkbox"
													   value="{$mod}"
													   data-extension="{$extensionKey}"
													   data-textn="{if $mod=='news'}Новости{elseif $mod=='events'}Мероприятия{elseif $mod=='coupons'}Купоны{elseif $mod=='auctions'}Аукцион{elseif $mod=='products'}Товары{elseif $mod=='shops'}Магазин{elseif $mod=='ads'}Объявления{/if}"
													   {if in_array($mod, $selectedModules.modules)}checked{/if}
												>
												{if $mod=='news'}Новости{elseif $mod=='events'}Мероприятия{elseif $mod=='coupons'}Купоны{elseif $mod=='auctions'}Аукцион{elseif $mod=='products'}Товары{elseif $mod=='shops'}Магазин{elseif $mod=='ads'}Объявления{/if}
											</label>
										{/foreach}
									</div>
								</div>
							{/if}
						{/foreach}
					</div>
				</div>

				<div class="col-md-3 col-sm-6">
					<div class="card shadow-sm border-0 text-center p-3 h-100">
						<div class="mb-3">
							<svg xmlns="http://www.w3.org/2000/svg" width="130" height="130" fill="currentColor" class="bi bi-qr-code" viewBox="0 0 16 16">
								<path d="M2 2h2v2H2z"/>
								<path d="M6 0v6H0V0zM5 1H1v4h4zM4 12H2v2h2z"/>
								<path d="M6 10v6H0v-6zm-5 1v4h4v-4zm11-9h2v2h-2z"/>
								<path d="M10 0v6h6V0zm5 1v4h-4V1zM8 1V0h1v2H8v2H7V1zm0 5V4h1v2zM6 8V7h1V6h1v2h1V7h5v1h-4v1H7V8zm0 0v1H2V8H1v1H0V7h3v1zm10 1h-1V7h1zm-1 0h-1v2h2v-1h-1zm-4 0h2v1h-1v1h-1zm2 3v-1h-1v1h-1v1H9v1h3v-2zm0 0h3v1h-2v1h-1zm-4-1v1h1v-2H7v1z"/>
								<path d="M7 12h1v3h4v1H7zm9 2v2h-3v-1h2v-1z"/>
							</svg>
						</div>
						<h4 class="fw-bold mb-3">QR код страницы</h4>
						<p class="text-muted small mb-3">Позволяет сохранять объекты в личный список для быстрого доступа.</p>

						{foreach $extensions as $extensionKey => $selectedModules}
							{if $extensionKey == "qr_codes"}
								<div class="multi-select" data-placeholder="Выберите модули" data-extension="{$extensionKey}">
									<div class="multi-select-display"></div>
									<div class="multi-select-dropdown">
										{foreach ['news','events','coupons','auctions','products','shops','ads'] as $mod}
											<label>
												<input type="checkbox"
													   value="{$mod}"
													   data-extension="{$extensionKey}"
													   data-textn="{if $mod=='news'}Новости{elseif $mod=='events'}Мероприятия{elseif $mod=='coupons'}Купоны{elseif $mod=='auctions'}Аукцион{elseif $mod=='products'}Товары{elseif $mod=='shops'}Магазин{elseif $mod=='ads'}Объявления{/if}"
													   {if in_array($mod, $selectedModules.modules)}checked{/if}
												>
												{if $mod=='news'}Новости{elseif $mod=='events'}Мероприятия{elseif $mod=='coupons'}Купоны{elseif $mod=='auctions'}Аукцион{elseif $mod=='products'}Товары{elseif $mod=='shops'}Магазин{elseif $mod=='ads'}Объявления{/if}
											</label>
										{/foreach}
									</div>
								</div>
							{/if}
						{/foreach}
					</div>
				</div>
				<div class="col-md-3 col-sm-6">
					<div class="card shadow-sm border-0 text-center p-3 h-100">
						<div class="mb-3">
							<svg xmlns="http://www.w3.org/2000/svg" width="130" height="130" fill="currentColor" class="bi bi-backpack3" viewBox="0 0 16 16">
								<path d="M4.04 7.43a4 4 0 0 1 7.92 0 .5.5 0 1 1-.99.14 3 3 0 0 0-5.94 0 .5.5 0 1 1-.99-.14M4 9.5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 .5.5v4a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5zm1 .5v3h6v-3h-1v.5a.5.5 0 0 1-1 0V10z"/>
								<path d="M6 2.341V2a2 2 0 1 1 4 0v.341c.465.165.904.385 1.308.653l.416-1.247a1 1 0 0 1 1.748-.284l.77 1.027a1 1 0 0 1 .15.917l-.803 2.407C13.854 6.49 14 7.229 14 8v5.5a2.5 2.5 0 0 1-2.5 2.5h-7A2.5 2.5 0 0 1 2 13.5V8c0-.771.146-1.509.41-2.186l-.802-2.407a1 1 0 0 1 .15-.917l.77-1.027a1 1 0 0 1 1.748.284l.416 1.247A6 6 0 0 1 6 2.34ZM7 2v.083a6 6 0 0 1 2 0V2a1 1 0 1 0-2 0m5.941 2.595.502-1.505-.77-1.027-.532 1.595q.447.427.8.937M3.86 3.658l-.532-1.595-.77 1.027.502 1.505q.352-.51.8-.937M8 3a5 5 0 0 0-5 5v5.5A1.5 1.5 0 0 0 4.5 15h7a1.5 1.5 0 0 0 1.5-1.5V8a5 5 0 0 0-5-5"/>
							</svg>
						</div>
						<h4 class="fw-bold mb-3">Образовательное расширение</h4>
						<p class="text-muted small mb-3">Для школьного фукционала.</p>

						{foreach $extensions as $extensionKey => $selectedModules}
							{if $extensionKey == "education"}
								{if $selectedModules.enabled === true}
									<form method="post" id="disable-education">
										<input type="hidden" name="deactivate_extension" value="education">
										<button type="submit" class="btn btn-danger btn-sm">{$lang.tools.deactivate}</button>
									</form>
								{else}
									<form method="post" id="enable-education">
										<input type="hidden" name="extension" value="education">
										<button type="submit" class="btn btn-primary btn-sm">{$lang.tools.activate}</button>
									</form>
								{/if}
							{/if}
						{/foreach}
					</div>
				</div>

				{if $config['extensions']['education']['enabled'] === true }
					<div class="col-md-3 col-sm-6">
						<div class="card shadow-sm border-0 text-center p-3 h-100">
							<div class="mb-3">
								<svg xmlns="http://www.w3.org/2000/svg" width="130" height="130" fill="currentColor" class="bi bi-mortarboard" viewBox="0 0 16 16">
									<path d="M8.211 2.047a.5.5 0 0 0-.422 0l-7.5 3.5a.5.5 0 0 0 .025.917l7.5 3a.5.5 0 0 0 .372 0L14 7.14V13a1 1 0 0 0-1 1v2h3v-2a1 1 0 0 0-1-1V6.739l.686-.275a.5.5 0 0 0 .025-.917zM8 8.46 1.758 5.965 8 3.052l6.242 2.913z"/>
									<path d="M4.176 9.032a.5.5 0 0 0-.656.327l-.5 1.7a.5.5 0 0 0 .294.605l4.5 1.8a.5.5 0 0 0 .372 0l4.5-1.8a.5.5 0 0 0 .294-.605l-.5-1.7a.5.5 0 0 0-.656-.327L8 10.466zm-.068 1.873.22-.748 3.496 1.311a.5.5 0 0 0 .352 0l3.496-1.311.22.748L8 12.46z"/>
								</svg>
							</div>
							<h4 class="fw-bold mb-3">Успеваемость</h4>
							<p class="text-muted small mb-3">Каждый преподаватель указывает успеваемость каждому ученику отдельно и все родители его учеников видят её в своих профилях.</p>

							{foreach $extensions as $extensionKey => $selectedModules}
								{if $extensionKey == "grades"}
									{if $selectedModules.enabled === true}
										<form method="post" id="disable-grades">
											<input type="hidden" name="deactivate_extension" value="grades">
											<button type="submit" class="btn btn-danger btn-sm">{$lang.tools.deactivate}</button>
										</form>
									{else}
										<form method="post" id="enable-grades">
											<input type="hidden" name="extension" value="grades">
											<button type="submit" class="btn btn-primary btn-sm">{$lang.tools.activate}</button>
										</form>
									{/if}
								{/if}
							{/foreach}
						</div>
					</div>
					<div class="col-md-3 col-sm-6">
						<div class="card shadow-sm border-0 text-center p-3 h-100">
							<div class="mb-3">
								<svg xmlns="http://www.w3.org/2000/svg" width="130" height="130" fill="currentColor" class="bi bi-calendar-check" viewBox="0 0 16 16">
									<path d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0"/>
									<path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5M1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4z"/>
								</svg>
							</div>
							<h4 class="fw-bold mb-3">Расширение "Расписания"</h4>
							<p class="text-muted small mb-3">Через профиль преподователь создаёт расписание и все родители его учеников видят её в своих профилях.</p>

							{foreach $extensions as $extensionKey => $selectedModules}
								{if $extensionKey == "schedules"}
									{if $selectedModules.enabled === true}
										<form method="post" id="disable-schedules">
											<input type="hidden" name="deactivate_extension" value="schedules">
											<button type="submit" class="btn btn-danger btn-sm">{$lang.tools.deactivate}</button>
										</form>
									{else}
										<form method="post" id="enable-schedules">
											<input type="hidden" name="extension" value="schedules">
											<button type="submit" class="btn btn-primary btn-sm">{$lang.tools.activate}</button>
										</form>
									{/if}
								{/if}
							{/foreach}
						</div>
					</div>
					<div class="col-md-3 col-sm-6">
						<div class="card shadow-sm border-0 text-center p-3 h-100">
							<div class="mb-3">
								<svg xmlns="http://www.w3.org/2000/svg" width="130" height="130" fill="currentColor" class="bi bi-activity" viewBox="0 0 16 16">
									<path fill-rule="evenodd" d="M6 2a.5.5 0 0 1 .47.33L10 12.036l1.53-4.208A.5.5 0 0 1 12 7.5h3.5a.5.5 0 0 1 0 1h-3.15l-1.88 5.17a.5.5 0 0 1-.94 0L6 3.964 4.47 8.171A.5.5 0 0 1 4 8.5H.5a.5.5 0 0 1 0-1h3.15l1.88-5.17A.5.5 0 0 1 6 2"/>
								</svg>
							</div>
							<h4 class="fw-bold mb-3">Расширение "Активность"</h4>
							<p class="text-muted small mb-3">---.</p>

							{foreach $extensions as $extensionKey => $selectedModules}
								{if $extensionKey == "student_progress"}
									{if $selectedModules.enabled === true}
										<form method="post" id="disable-student_progress">
											<input type="hidden" name="deactivate_extension" value="student_progress">
											<button type="submit" class="btn btn-danger btn-sm">{$lang.tools.deactivate}</button>
										</form>
									{else}
										<form method="post" id="enable-student_progress">
											<input type="hidden" name="extension" value="student_progress">
											<button type="submit" class="btn btn-primary btn-sm">{$lang.tools.activate}</button>
										</form>
									{/if}
								{/if}
							{/foreach}
						</div>
					</div>

				{/if}

		{*		<div class="col-md-3 col-sm-6">
					<div class="card shadow-sm border-0 text-center p-3 h-100">
						<div class="mb-3">
							<svg xmlns="http://www.w3.org/2000/svg" width="130" height="130" fill="currentColor" class="bi bi-heart-pulse" viewBox="0 0 16 16">
								<path d="m8 2.748-.717-.737C5.6.281 2.514.878 1.4 3.053.918 3.995.78 5.323 1.508 7H.43c-2.128-5.697 4.165-8.83 7.394-5.857q.09.083.176.171a3 3 0 0 1 .176-.17c3.23-2.974 9.522.159 7.394 5.856h-1.078c.728-1.677.59-3.005.108-3.947C13.486.878 10.4.28 8.717 2.01zM2.212 10h1.315C4.593 11.183 6.05 12.458 8 13.795c1.949-1.337 3.407-2.612 4.473-3.795h1.315c-1.265 1.566-3.14 3.25-5.788 5-2.648-1.75-4.523-3.434-5.788-5"/>
								<path d="M10.464 3.314a.5.5 0 0 0-.945.049L7.921 8.956 6.464 5.314a.5.5 0 0 0-.88-.091L3.732 8H.5a.5.5 0 0 0 0 1H4a.5.5 0 0 0 .416-.223l1.473-2.209 1.647 4.118a.5.5 0 0 0 .945-.049l1.598-5.593 1.457 3.642A.5.5 0 0 0 12 9h3.5a.5.5 0 0 0 0-1h-3.162z"/>
							</svg>
						</div>
						<h4 class="fw-bold mb-3">Медицинское расширение</h4>
						<p class="text-muted small mb-3">---.</p>

						{foreach $extensions as $extensionKey => $selectedModules}
							{if $extensionKey == "medicine"}
								{if $selectedModules.enabled === true}
									<form method="post" id="disable-medicine">
										<input type="hidden" name="deactivate_extension" value="medicine">
										<button type="submit" class="btn btn-danger btn-sm">{$lang.tools.deactivate}</button>
									</form>
								{else}
									<form method="post" id="install-medicine">
										<input type="hidden" name="extension" value="medicine">
										<button type="submit" class="btn btn-primary btn-sm">{$lang.tools.activate}</button>
									</form>
								{/if}
							{/if}
						{/foreach}
					</div>
				</div>

				<div class="col-md-3 col-sm-6">
					<div class="card shadow-sm border-0 text-center p-3 h-100">
						<div class="mb-3">
							<svg xmlns="http://www.w3.org/2000/svg" width="130" height="130" fill="currentColor" class="bi bi-buildings" viewBox="0 0 16 16">
								<path d="M14.763.075A.5.5 0 0 1 15 .5v15a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5V14h-1v1.5a.5.5 0 0 1-.5.5h-9a.5.5 0 0 1-.5-.5V10a.5.5 0 0 1 .342-.474L6 7.64V4.5a.5.5 0 0 1 .276-.447l8-4a.5.5 0 0 1 .487.022M6 8.694 1 10.36V15h5zM7 15h2v-1.5a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 .5.5V15h2V1.309l-7 3.5z"/>
								<path d="M2 11h1v1H2zm2 0h1v1H4zm-2 2h1v1H2zm2 0h1v1H4zm4-4h1v1H8zm2 0h1v1h-1zm-2 2h1v1H8zm2 0h1v1h-1zm2-2h1v1h-1zm0 2h1v1h-1zM8 7h1v1H8zm2 0h1v1h-1zm2 0h1v1h-1zM8 5h1v1H8zm2 0h1v1h-1zm2 0h1v1h-1zm0-2h1v1h-1z"/>
							</svg>
						</div>
						<h4 class="fw-bold mb-3">Юридическое расширение</h4>
						<p class="text-muted small mb-3">---.</p>

						{foreach $extensions as $extensionKey => $selectedModules}
							{if $extensionKey == "law"}
								{if $selectedModules.enabled === true}
									<form method="post" id="disable-law">
										<input type="hidden" name="deactivate_extension" value="law">
										<button type="submit" class="btn btn-danger btn-sm">{$lang.tools.deactivate}</button>
									</form>
								{else}
									<form method="post" id="install-law">
										<input type="hidden" name="extension" value="law">
										<button type="submit" class="btn btn-primary btn-sm">{$lang.tools.activate}</button>
									</form>
								{/if}
							{/if}
						{/foreach}
					</div>
				</div>*}

			</div>
		</div>
	</div>

	{literal}
		<script>
			const multiSelectData = {};

			// Обновление отображения выбранных элементов
			function updateDisplay(select, index) {
				const display = select.querySelector(".multi-select-display");
				const placeholder = select.dataset.placeholder;
				const key = select.dataset.extension || `extension_${index}`;

				const checked = select.querySelectorAll("input:checked");
				display.innerHTML = "";

				if (checked.length === 0) {
					display.innerHTML = `<span class="text-muted">${placeholder}</span>`;
					multiSelectData[key] = [];
					return;
				}

				const selectedValues = [];
				checked.forEach(ch => {
					let tag = document.createElement("span");
					tag.className = "multi-select-tag";
					tag.textContent = ch.dataset.textn;
					display.appendChild(tag);
					selectedValues.push(ch.value);
				});

				multiSelectData[key] = selectedValues;
			}

			// Инициализация всех multi-select
			function initMultiSelects() {
				document.querySelectorAll(".multi-select").forEach((select, index) => {
					if (select.dataset.inited) return; // защита от повторной инициализации
					select.dataset.inited = "true";

					const key = select.dataset.extension || `extension_${index}`;

					// Если есть данные из multiSelectData, проставляем checked
					if (multiSelectData[key] && Array.isArray(multiSelectData[key])) {
						select.querySelectorAll("input").forEach(input => {
							input.checked = multiSelectData[key].includes(input.value);
						});
					}

					// Клик на селекте
					select.addEventListener("click", (e) => {
						if (e.target.tagName !== "INPUT") {
							select.classList.toggle("open");
						}
					});

					// Изменение чекбоксов
					select.querySelectorAll("input").forEach(input => {
						input.addEventListener("change", () => {
							updateDisplay(select, index);

							// Если ratings, сохраняем через AJAX без перезапуска init
								$.ajax({
									url: '/engine/ajax/lib/extensions/save_extensions.php',
									type: 'POST',
									data: { extensionsData: multiSelectData },
									dataType: 'json',
									success: function(response) {

									},
									error: function(xhr) { console.error(xhr); }
								});
						});
					});

					// Инициалное обновление отображения
					updateDisplay(select, index);
				});
			}

			// Подгрузка данных через AJAX
			function loadMultiSelectDataFromAjax(data) {
				Object.assign(multiSelectData, data);
				// обновляем только checked и display, не заново все обработчики
				document.querySelectorAll(".multi-select").forEach((select, index) => {
					const key = select.dataset.extension || `extension_${index}`;
					if (multiSelectData[key] && Array.isArray(multiSelectData[key])) {
						select.querySelectorAll("input").forEach(input => {
							input.checked = multiSelectData[key].includes(input.value);
						});
					}
					updateDisplay(select, index);
				});
			}

			// Инициализация при первой загрузке
			initMultiSelects();

		</script>
	{/literal}


{else}
	<h3>Доступ запрещен</h3>
{/if}


<script>
	var toolsSection = document.getElementById('toolsSection');
	toolsSection.classList.add('active');
	var tools = document.getElementById('tools');
	tools.classList.add('show');
	var currentLink = document.getElementById('extensionsLink');
	currentLink.classList.add('active');
</script>