{if $access['mailings.view']}

	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tom-select/dist/css/tom-select.css">
	<script src="https://cdn.jsdelivr.net/npm/tom-select/dist/js/tom-select.complete.min.js"></script>

	<div>
		<h2 class="mb-4">Управление рассылками</h2>

		<div class="row mb-3">
			<div class="col-md-3">
				<select id="filter-status" class="form-select" onchange="location.href='/admin?action=message-distribution-managing&status='+this.value">
					<option value="">Все статусы</option>
					<option value="draft" {if $filter_status=='draft'}selected{/if}>Черновик</option>
					<option value="queued" {if $filter_status=='queued'}selected{/if}>В очереди</option>
					<option value="sending" {if $filter_status=='sending'}selected{/if}>Отправляется</option>
					<option value="done" {if $filter_status=='done'}selected{/if}>Завершено</option>
				</select>
			</div>
			{if $access['mailings.create']}
				<div class="col-md-3">
					<button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#mailingModal">
						Создать рассылку
					</button>
				</div>
			{/if}
			<div class="col-md-3 d-flex align-items-center justify-content-end">
				<span style="font-size: 16px; color: #2a9d8f;">
					Баланс счета Twilio: <strong>{$twilio_balance} {$twilio_currency}</strong>
				</span>
			</div>
		</div>


		{include file='main/datatable.tpl' tableTitle="Рассылки"
		theads=["id", $lang.datatable.title, $lang.datatable.creator_name, $lang.datatable.type, $lang.datatable.status, $lang.datatable.scheduled_at, $lang.datatable.actions]
		data=$mailings }
	</div>
	<div class="modal fade" id="mailingModal" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog modal-xl modal-dialog-centered">
			<div class="modal-content rounded-4 shadow">
				<div class="modal-header border-0 pb-0">
					<h5 class="modal-title fw-semibold" id="mailingModalLabel">
						{if $mailing.id}Редактировать{else}Создать{/if} рассылку
					</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Закрыть"></button>
				</div>

				<div class="modal-body pt-0">
					<form method="post" enctype="multipart/form-data" id="mailingForm">
						<input type="hidden" name="mailing_id" value="{$mailing.id|default:''}">

						<!-- Название и тип рассылки -->
						<div class="row mb-3">
							<div class="col-md-4">
								<label class="form-label">Название рассылки</label>
								<input type="text" name="title" class="form-control" value="{$mailing.title|default:''}" required>
							</div>
							<div class="col-md-4">
								<label class="form-label">Тип рассылки</label>
								<select name="type" class="form-select" id="mailingType" required>
									<option value="sms_text" {if $mailing.type=='sms_text'}selected{/if}>Текстовое SMS</option>
									<option value="sms_audio" {if $mailing.type=='sms_audio'}selected{/if}>Аудио SMS</option>
									<option value="call_audio" {if $mailing.type=='call_audio'}selected{/if}>Аудио звонок</option>
									<option value="text_to_speech" {if $mailing.type=='text_to_speech'}selected{/if}>Текстовой аудиозвонок</option>
									<option value="text_graphic_sms" {if $mailing.type=='text_graphic_sms'}selected{/if}>Текстово/графическое сообщение (в виде MMS)</option>
									<option value="email" {if $mailing.type=='email'}selected{/if}>Эл. почта</option>
								</select>
							</div>
							<div class="col-md-4">
								<label class="form-label">Запланировать на</label>
								<input type="datetime-local" name="scheduled_at" class="form-control" value="{$mailing.scheduled_at|default:''}">
							</div>
							<!-- Контент -->
							<div class="mb-3" id="textContentBlock">
								<label class="form-label">Текст сообщения</label>
								<textarea name="content_text" class="form-control" rows="4">{$mailing.content_text|default:''}</textarea>
							</div>

							<div class="mb-3 d-none" id="audioContentBlock">
								<label class="form-label">Аудио сообщение</label>
								<div class="d-flex align-items-center gap-2 mb-2">
									<button type="button" class="btn btn-outline-primary btn-sm" id="startRecording">Записать</button>
									<button type="button" class="btn btn-outline-danger btn-sm" id="stopRecording" disabled>Стоп</button>
									<span id="recordingStatus" class="text-muted">Не записано</span>
								</div>
								<audio id="audioPlayback" controls class="w-100" style="display:none"></audio>
								<input type="hidden" name="content_audio" id="contentAudio">
							</div>

							<!-- Новый блок для изображения -->
							<div class="mb-3 d-none" id="imageContentBlock">
								<label class="form-label">Изображение</label>
								<input type="file" name="content_image" accept="image/*" class="form-control">
							</div>


							<!-- Получатели -->
						<!-- Получатели -->
						<div class="row mb-3">
							<div class="row g-2">

								<div class="col-md-4">
									<label class="form-label">Получатели</label>
									<select id="roleSelect" name="role_id" class="form-select">
										<option value="">Все роли</option>
										{foreach $roles as $role}
											<option value="{$role.id}">{$role.name}</option>
										{/foreach}
									</select>
								</div>

								<div class="col-md-4">
									<label class="form-label">Пользователи</label>
									<select id="userSelect" name="user_ids[]" multiple placeholder="Выберите пользователя"></select>
								</div>

								<div class="col-md-4 d-none" id="classSelectBlock">
									<label class="form-label">Классы</label>

									<select name="class_id" class="form-select">
										<option value="">Все классы</option>
										{foreach $classes as $grade}
											<option value="{$grade.id}" {if $mailing.grade==$grade.name}selected{/if}>{$grade.name} класс</option>
										{/foreach}
									</select>
								</div>
							</div>
						</div>


						<!-- Дата и время отправки -->


						<!-- Действия -->
						<div class="d-flex gap-2">
							<button type="submit" name="action" value="add_to_schedule" class="btn btn-success">Добавить в очередь</button>
{*
							<button type="submit" name="action" value="send_now" class="btn btn-primary">Отправить сейчас</button>
*}
							<button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Отмена</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	</div>

	<script>
		const userSelect = new TomSelect('#userSelect', {
			valueField: 'id',
			labelField: 'text',
			searchField: 'text',
			plugins: ['remove_button'],
			persist: false,
			create: false,
			maxItems: null,
			preload: false,

			load: function (query, callback) {
				const roleId = document.getElementById('roleSelect').value;


				{literal}
				fetch(`/engine/ajax/lib/mailing/get_users_by_role.php?role_id=${roleId}&q=${encodeURIComponent(query)}`)
						.then(r => r.json())
						.then(data => callback(data))
						.catch(() => callback());
				{/literal}
			}
		});


		document.getElementById('roleSelect').addEventListener('change', function () {
			userSelect.clear();
			userSelect.clearOptions();

			if (!this.value) return;
			userSelect.load('');

		});

		let mediaRecorder;
		let audioChunks = [];

		const startBtn = document.getElementById('startRecording');
		const stopBtn = document.getElementById('stopRecording');
		const statusText = document.getElementById('recordingStatus');
		const audioPlayback = document.getElementById('audioPlayback');
		const contentAudioInput = document.getElementById('contentAudio');
		const mailingTypeSelect = document.getElementById('mailingType');
		const textContentBlock = document.getElementById('textContentBlock');
		const audioContentBlock = document.getElementById('audioContentBlock');
		const roleSelect = document.getElementById('roleSelect');
		const classSelectBlock = document.getElementById('classSelectBlock');
		const mailingForm = document.getElementById('mailingForm');
		const imageContentBlock = document.getElementById('imageContentBlock');

		mailingTypeSelect.addEventListener('change', updateContentBlocks);
		updateContentBlocks();


		// Запись аудио
		startBtn.addEventListener('click', async () => {
			if (!navigator.mediaDevices?.getUserMedia) {
				alert('getUserMedia не поддерживается');
				return;
			}

			stream = await navigator.mediaDevices.getUserMedia({ audio: true });

			mediaRecorder = new MediaRecorder(stream);
			audioChunks = [];

			mediaRecorder.ondataavailable = e => audioChunks.push(e.data);

			mediaRecorder.onstop = () => {
				const audioBlob = new Blob(audioChunks, { type: 'audio/webm' });
				audioPlayback.src = URL.createObjectURL(audioBlob);
				audioPlayback.style.display = 'block';

				const reader = new FileReader();
				reader.onloadend = () => contentAudioInput.value = reader.result;
				reader.readAsDataURL(audioBlob);
			};

			mediaRecorder.start();

			startBtn.disabled = true;
			stopBtn.disabled = false;
			statusText.textContent = 'Запись...';
		});

		stopBtn.addEventListener('click', () => {
			mediaRecorder.stop();

			// 🔥 ОБЯЗАТЕЛЬНО освобождаем микрофон
			stream.getTracks().forEach(t => t.stop());

			startBtn.disabled = false;
			stopBtn.disabled = true;
			statusText.textContent = 'Записано';
		});

		// Показываем класс, если выбран Parent, Student или Teacher
		function updateClassBlock() {
			const selectedText = roleSelect.options[roleSelect.selectedIndex].text.toLowerCase();
			if (['parent', 'student', 'teacher'].includes(selectedText)) {
				classSelectBlock.classList.remove('d-none');
			} else {
				classSelectBlock.classList.add('d-none');
			}
		}

		roleSelect.addEventListener('change', updateClassBlock);
		updateClassBlock();

		// Контент блоки уже есть
		function updateContentBlocks() {
			const type = mailingTypeSelect.value;

			if (type === 'sms_audio' || type === 'call_audio') {
				audioContentBlock.classList.remove('d-none');
				textContentBlock.classList.add('d-none');
				imageContentBlock.classList.add('d-none');
			} else if (type === 'text_graphic_sms') {
				textContentBlock.classList.remove('d-none');
				imageContentBlock.classList.remove('d-none');
				audioContentBlock.classList.add('d-none');
			} else {
				// sms_text, text_to_speech, email
				textContentBlock.classList.remove('d-none');
				audioContentBlock.classList.add('d-none');
				imageContentBlock.classList.add('d-none');
			}
		}

		mailingTypeSelect.addEventListener('change', updateContentBlocks);
		updateContentBlocks();

		// Валидация формы
		mailingForm.addEventListener('submit', function(e) {
			const type = mailingTypeSelect.value;
			const contentText = mailingForm.querySelector('[name="content_text"]').value.trim();
			const contentAudio = mailingForm.querySelector('[name="content_audio"]').value.trim();
			const role = roleSelect.value;

			if (!type) {
				alert('Выберите тип рассылки!');
				e.preventDefault();
				return false;
			}

			if ((type === 'sms_text' || type === 'text_to_speech' || type === 'email') && !contentText) {
				alert('Введите текст сообщения!');
				e.preventDefault();
				return false;
			}

			if ((type === 'sms_audio' || type === 'call_audio') && !contentAudio) {
				alert('Запишите аудиосообщение!');
				e.preventDefault();
				return false;
			}
/*
			if (!role) {
				alert('Выберите получателей!');
				e.preventDefault();
				return false;
			}*/

			// класс и дата не обязательны
		});
	</script>

	{else}
	<h2>Доступ запрещен</h2>
{/if}