<div class="chart-grid row gap-3">
    <div id="chart-module-statistics" class="chart-container col-5"></div>
    <div id="chart-time-dynamics" class="chart-container col-6"></div>
    <div id="chart-category-statistics" class="chart-container col-3"></div>
    <div id="chart-engagement" class="chart-container col-6"></div>
    <div id="chart-technical-metrics" class="chart-container col-6"></div>
</div>

<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.1/dist/apexcharts.min.js"></script>
<script>
    const moduleStatisticsOptions = {
        series: [{
            name: 'Usage',
            data: [40, 55, 60, 72, 85, 95, 100]
        }],
        chart: {
            type: 'bar',
            height: 250,
            toolbar: { show: false }
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '50%',
                endingShape: 'rounded'
            }
        },
        colors: ['#4CAF50'],
        xaxis: {
            categories: ['Module A', 'Module B', 'Module C', 'Module D', 'Module E', 'Module F', 'Module G']
        },
        title: {
            text: '1. Статистика модулей',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-module-statistics"), moduleStatisticsOptions).render();

    const categoryStatisticsOptions = {
        series: [35, 45, 20],
        chart: {
            type: 'donut',
            height: 250,
            toolbar: { show: false }
        },
        labels: ['Category A', 'Category B', 'Category C'],
        title: {
            text: '2. Статистика категорий',
            align: 'left'
        },
        colors: ['#FF9800', '#2196F3', '#FF5722'],
        dataLabels: {
            enabled: true,
            formatter: function (val, opts) {
                return opts.w.globals.labels[opts.seriesIndex] + ': ' + Math.round(val) + '%';
            }
        },
        legend: {
            position: 'bottom'
        }
    };
    new ApexCharts(document.querySelector("#chart-category-statistics"), categoryStatisticsOptions).render();

    const timeDynamicsOptions = {
        series: [{
            name: 'Performance',
            data: [10, 30, 50, 70, 90, 110, 130, 150, 160, 180]
        }],
        chart: {
            type: 'line',
            height: 250,
            toolbar: { show: false }
        },
        stroke: {
            width: 3,
            curve: 'smooth'
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 0.8,
                opacityFrom: 0.5,
                opacityTo: 0.1,
                stops: [0, 90, 100]
            }
        },
        colors: ['#1E90FF'],
        xaxis: {
            categories: ['W1', 'W2', 'W3', 'W4', 'W5', 'W6', 'W7', 'W8', 'W9', 'W10']
        },
        title: {
            text: '3. Динамика по времени',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-time-dynamics"), timeDynamicsOptions).render();

    const engagementOptions = {
        series: [{
            name: 'User Engagement',
            data: [10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
        }],
        chart: {
            type: 'area',
            height: 250,
            toolbar: { show: false }
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 0.8,
                opacityFrom: 0.5,
                opacityTo: 0.1,
                stops: [0, 90, 100]
            }
        },
        colors: ['#34C38F'],
        xaxis: {
            categories: ['W1', 'W2', 'W3', 'W4', 'W5', 'W6', 'W7', 'W8', 'W9', 'W10']
        },
        title: {
            text: '4. Вовлечённость',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-engagement"), engagementOptions).render();

    const technicalMetricsOptions = {
        series: [{
            name: 'Errors',
            data: [5, 8, 10, 15, 18, 20, 23, 30, 35, 40]
        }],
        chart: {
            type: 'line',
            height: 250,
            toolbar: { show: false }
        },
        stroke: {
            width: 3,
            curve: 'smooth'
        },
        colors: ['#FF5722'],
        xaxis: {
            categories: ['W1', 'W2', 'W3', 'W4', 'W5', 'W6', 'W7', 'W8', 'W9', 'W10']
        },
        title: {
            text: '5. Технические метрики',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-technical-metrics"), technicalMetricsOptions).render();

</script>
