<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/nestable2/1.6.0/jquery.nestable.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/nestable2/1.6.0/jquery.nestable.min.js"></script>

<input type="hidden" id="moduleName" name="moduleName" value="{$moduleName}">

<button class="btn btn-dark mb-0" id="add_parent_cat">
    <i class="fa fa-plus"></i> Добавить корневую категорию
</button><hr>

<div class="modal fade" id="categoryModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalTitle">Категория</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="categoryForm">
                    <input type="hidden" name="id" id="categoryId">
                    <input type="hidden" name="form_key" value="{$form_key}">
                    <div class="row">
                        <div class="col-6">
                            <label class="col-form-label mt-1">Название категории</label>
                            <input type="text" class="form-control" name="name" id="categoryName" required>
                        </div>
                        <div class="col-6">
                            <label class="col-form-label mt-1">Альтернативное имя</label>
                            <input type="text" class="form-control" name="alt_name" id="altName" required>
                        </div>
                        <div class="col-6">
                            <label class="col-form-label mt-1">Язык</label>
                            <select class="form-select" name="language" id="categoryLanguage" required>
                                <option value="" disabled selected>- Выберите язык -</option>
                                {foreach from=$available_languages item=language}
                                    <option value="{$language}">{$language|capitalize}</option>
                                {/foreach}
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="saveCategory" class="btn btn-primary">Сохранить</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
            </div>
        </div>
    </div>
</div>
<div class="dd" id="nestable">
    <ol class="dd-list">
        {if !empty($categories)}

            {foreach $categories as $cat}
                {include file="./category_item.tpl" category=$cat}
            {/foreach}

            {else}
            <p>Нет категорий</p>

        {/if}
    </ol>
</div>
<div id="contextMenu" class="dropdown-menu" style="position:absolute; display:none;">
    <a class="dropdown-item" href="#" id="ctxAdd">Добавить дочернюю</a>
    <a class="dropdown-item" href="#" id="ctxEdit">Редактировать</a>
    <a class="dropdown-item" href="#" id="ctxDelete">Удалить</a>
</div>

{literal}
    <script>
        let nestable = $('#nestable').nestable({ maxDepth: 5, group: 1 }).nestable('collapseAll');

        $(document).ready(function() {
            let currentCategoryId = null;
            let currentAction = null;

            $('#nestable').on('contextmenu', '.dd-handle', function(e){
                e.preventDefault();
                e.stopPropagation();
                currentCategoryId = $(this).closest('.dd-item').data('id');

                const menu = $('#contextMenu');
                menu.css({top: e.pageY, left: e.pageX}).show();
            });

            $(document).on('click', function(){ $('#contextMenu').hide(); });

            $('#ctxAdd').click(function(e){
                e.preventDefault();
                $('#contextMenu').hide();
                openModal('add-child', currentCategoryId);
            });

            $('#add_parent_cat').click(function(e){
                e.preventDefault();
                $('#contextMenu').hide();
                openModal('add-child', {});
            });

            $('#ctxEdit').click(function(e){
                e.preventDefault();
                $('#contextMenu').hide();
               // const name = $('#nestable').find('[data-id="'+currentCategoryId+'"] > .dd-handle > .dd-title').text().trim();


                $.ajax({
                    url: '/engine/ajax/lib/nestedCategories/get_edit_data.php',
                    type: 'POST',
                    data: {categoryId: currentCategoryId, moduleName: $("#moduleName").val()},
                    success: function(res) {
                        debugger;
                        if(res.success) {
                            openModal('edit', res.category);
                        } else {
                            alert('Ошибка при сохранении структуры');
                        }
                    },
                    error: function() {
                        alert('Ошибка соединения с сервером');
                    }
                });

            });

            $('#ctxDelete').click(function(e){
                e.preventDefault();
                $('#contextMenu').hide();
                if(confirm('Удалить категорию?')){
                    $.post('/engine/ajax/lib/nestedCategories/delete_category.php', {id: currentCategoryId, moduleName: $("#moduleName").val()}, function(res){
                        if(res.success){
                            $('.dd-item[data-id="'+currentCategoryId+'"]').remove();
                            alert('Категория удалена');
                        } else alert('Ошибка при удалении');
                    }, 'json');
                }
            });

            // Добавить корневую категорию
            $('#addRootBtn').click(function(){
                openModal('add');
            });

            // Сохранение структуры
            $('#saveStructureBtn').click(function(){
                const serialized = nestable.nestable('serialize');
                $.post('ajax.php?action=save_structure', {structure: JSON.stringify(serialized)}, function(res){
                    if(res.success) alert('Структура сохранена');
                    else alert('Ошибка при сохранении');
                }, 'json');
            });

            // Функция открытия модалки
            function openModal(action, category = {}) {
                currentAction = action;
                $('#categoryId').val(category.id || '');
                $('#categoryName').val(category.name || '');
                $('#altName').val(category.alt_name || '');
                $('#categoryLanguage').val(category.language || '');
                $('#categoryParent').val(category.parentid || '0');

                $('#modalTitle').text(action === 'edit' ? 'Редактировать категорию' : 'Добавить категорию');
                new bootstrap.Modal(document.getElementById('categoryModal')).show();
            }

            $('#saveCategory').click(function(){
                debugger;
                const data = $('#categoryForm').serializeArray();
                const id = $('#categoryId').val();

                data.push({name:'action', value: currentAction});
                data.push({name:'id', value: currentCategoryId});
                data.push({name:'moduleName', value: $("#moduleName").val()});
                $.post('/engine/ajax/lib/nestedCategories/save_category.php', data, function(res){
                    debugger;
                    if(res.success) location.reload(); // или динамически обновить DOM
                    else alert('Ошибка: ' + res.message);
                }, 'json');
            });

            function saveNestableStructure() {
                const data = nestable.nestable('serialize'); // получаем всю структуру
                $.ajax({
                    url: '/engine/ajax/lib/nestedCategories/save_new_structure.php',
                    type: 'POST',
                    data: {structure: JSON.stringify(data), moduleName: $("#moduleName").val()},
                    success: function(res) {
                        if(res.success) {
                            console.log('Структура сохранена');
                        } else {
                            alert('Ошибка при сохранении структуры');
                        }
                    },
                    error: function() {
                        alert('Ошибка соединения с сервером');
                    }
                });
            }

            nestable.on('change', function() {
                debugger;
                saveNestableStructure();
            });
        });
    </script>
{/literal}

<style>
    /* Общие стили для элемента списка */
    .dd-item {
        position: relative;
    }

    /* Стили для области перетаскивания */
    .dd-handle {
        min-height: 30px;          /* Минимальная высота */
        font-size: 17px;           /* Размер шрифта */
        border-radius: 4px;        /* Скругление углов */
    }

    /* Стили для контента внутри области перетаскивания */
    .dd-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        width: 100%;
    }
</style>
