{if $access['modules.create'] || $user.name == 'Demo profile'}
	{if isset($error_message) && $error_message}
		<div class="col-12">
			<div class="alert alert-danger">{$error_message}</div>
		</div>
	{/if}
	<div class="col-12">
		<form method="POST" enctype="multipart/form-data">
			<div class="row">
				<div class="col-12">
					<ul class="nav nav-tabs mb-2" id="myTab" role="tablist">
						<li class="nav-item" role="presentation">
						<button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">Основная информация</button>
						</li>
						<li class="nav-item" role="presentation">
						<button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">SEO</button>
						</li>
					</ul>
					<div class="tab-content" id="myTabContent">
						<div class="tab-pane fade active show" id="home" role="tabpanel" aria-labelledby="home-tab">
							<div class="row">
								<div class="col-6">
									<div class="row">
										<div class="col-6">
											<label class="col-form-label">Дата добавления</label>
											<fieldset class="form-icon-group left-icon position-relative">
												<input type="datetime-local" class="form-control mt-2 mb-2" name="date" id="date">
												<div class="form-icon position-absolute">
													<img src="/system/assets/images/svg/option.svg" alt="">
												</div>
											</fieldset>
										</div>
										<div class="col-6">
											<label class="col-form-label">Автор</label>
											<fieldset class="form-icon-group position-relative">
												<fieldset class="form-icon-group left-icon position-relative">
													<input type="text" class="form-control mt-2 mb-2" name="autor" value="{$user.name}">
													<div class="form-icon position-absolute">
														<img src="/system/assets/images/svg/option.svg" alt="">
													</div>
												</fieldset>
											</fieldset>
										</div>
										<div class="col-12">
											<label class="col-form-label">Заголовок лота</label>
											<div class="input-group">
												<input type="text" name="title" id="title" class="form-control mt-2 mb-2">
												<div class="input-group-prepend">
												<span class="input-group-text mt-2 mb-2" tabindex="0" data-bs-toggle="popover" data-bs-trigger="hover focus" data-bs-content="Заголовок лота. Допустимо использование символов и пробелов">?</span>
												</div>
											</div>
										</div>
										<div class="col-12">
											<label class="col-form-label">URL лота</label>
											<fieldset class="form-icon-group left-icon position-relative">
												<input type="text" class="form-control mt-2 mb-2" name="alt_name" id="alt_name">
												<div class="form-icon position-absolute">
													<img src="/system/assets/images/svg/option.svg" alt="">
												</div>
											</fieldset>
										</div>
									</div>
								</div>
								<div class="col-6">
									<label class="col-form-label">Категория</label>
									<select class="form-select array-select form-control mt-2 mb-2 height-80" name="category[]" id="category" multiple>
										<option selected disabled value="">- не выбрана -</option>
										{foreach from=$categories item=category}
											{if $category.parentid == 0}
												<option value="{$category.name}" style="font-weight: bold;">{$category.name}</option>
												{foreach from=$categories item=subcategory}
													{if $subcategory.parentid == $category.id}
														<option value="{$subcategory.name}">{$subcategory.name}</option>
													{/if}
												{/foreach}
											{/if}
										{/foreach}
									</select>
								</div>
								<div class="col-3">
									<label class="col-form-label">Дата и время начала лота</label>
									<fieldset class="form-icon-group left-icon position-relative">
										<input type="datetime-local" class="form-control mt-2 mb-2" name="start_date" id="start_date">
										<div class="form-icon position-absolute">
											<img src="/system/assets/images/svg/option.svg" alt="">
										</div>
									</fieldset>
								</div>
								<div class="col-3">
									<label class="col-form-label">Дата и время окончания лота</label>
									<fieldset class="form-icon-group left-icon position-relative">
										<input type="datetime-local" class="form-control mt-2 mb-2" name="end_date" id="end_date">
										<div class="form-icon position-absolute">
											<img src="/system/assets/images/svg/option.svg" alt="">
										</div>
									</fieldset>
								</div>
								<div class="col-3">
									<label class="col-form-label">Максимальное количество участников</label>
									<fieldset class="form-icon-group left-icon position-relative">
										<input type="text" class="form-control mt-2 mb-2" name="capacity" id="capacity">
										<div class="form-icon position-absolute">
											<img src="/system/assets/images/svg/option.svg" alt="">
										</div>
									</fieldset>
								</div>
								<div class="col-3">
									<label class="col-form-label">Статус лота</label>
									<select class="form-select array-select form-control mt-2 mb-2" name="status[]" id="status">
										<option selected disabled>- Выберите язык -</option>
										<option value="upcoming">upcoming</option>
										<option value="ongoing">ongoing</option>
										<option value="completed">completed</option>
									</select>
								</div>
							</div>
						</div>
						<div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
							<div class="row">
								<div class="col-12">
									<fieldset class="form-icon-group left-icon position-relative">
										<input type="text" class="form-control mt-2 mb-2" name="meta_keys" id="meta_keys" placeholder="Meta keywords">
										<div class="form-icon position-absolute">
											<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye" viewBox="0 0 16 16">
												<path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
												<path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
											</svg>
										</div>
									</fieldset>
								</div>
								<div class="col-12">
									<fieldset class="form-icon-group left-icon position-relative">
										<input type="text" class="form-control mt-2 mb-2" name="meta_desc" id="meta_desc" placeholder="Meta description">
										<div class="form-icon position-absolute">
											<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye" viewBox="0 0 16 16">
												<path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
												<path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
											</svg>
										</div>
									</fieldset>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-12">
					<h6 class="mt-2">ssss</h6>
					<textarea id="short_desc" name="short_desc"></textarea>
				</div>
				<div class="col-12">
					<h6 class="mt-3">Полное описание:</h6>
					<textarea id="full_desc" name="full_desc"></textarea>
				</div>
				<div class="row">
					{foreach from=$fields item=field key=index}
						<div class="col-12 col-md-4 mt-3">
							<label>{$lang.fields.lots[$index]}</label>
							<input type="text" class="form-control" name="x_value[{$index}]" value="">
							<input type="hidden" name="field_ids[]" value="{$index}">
						</div>
					{/foreach}
				</div>
				<div class="col-12">
					<h6 class="mt-3">Изображение: <input name="image" type="file" /></h6>
				</div>
				<div class="col-3">
					<button type="submit" name="{if $access['modules.update']}addlot{else}addform{/if}" class="btn btn-success mt-2 mb-2" id="submitButton">Добавить</button>
				</div>
				<input type="hidden" name="folder" value="lots">
				<input type="hidden" name="p_id" value="{$page_id}">
			</div>
		</form>
	</div>
	<script>
		var contentSection = document.getElementById('contentSection');
		contentSection.classList.add('active');
		var contentBlock = document.getElementById('contentBlock');
		contentBlock.classList.add('show');
		var currentLink = document.getElementById('addlots');
		currentLink.classList.add('active');
	</script>
{/if}