<div class="col-12">
    {if $error_message}
        <div class="alert alert-danger">{$error_message}</div>
    {/if}

    <div class="col-12">
        <button type="button" class="btn btn-outline-success" onclick="smallModal('addColumn')">Добавить поле</button>
        <hr>
    </div>

    <div id="addColumn" class="hidden">
        <!-- Форма для добавления нового поля -->
        <form method="POST" action="#">
            <input type="hidden" name="form_id" value="add_column">
            <div class="row">
                <div class="col-12 mb-2">
                    <label>Заголовок столбца:</label>
                    <input type="text" class="form-control mb-2" name="x_name" required>
                </div>
                <div class="col-12 mb-2">
                    <label>Тип столбца:</label>
                    <select class="form-control mb-2" name="column_type">
                        <option value="VARCHAR">VARCHAR</option>
                        <option value="INT">INT</option>
                        <option value="TEXT">TEXT</option>
                        <option value="TIMESTAMP">TIMESTAMP</option>
                        <option value="TINYINT">TINYINT</option>
                        <option value="BOOLEAN">BOOLEAN</option>
                        <option value="MEDIUMTEXT">MEDIUMTEXT</option>
                        <option value="DECIMAL">DECIMAL</option>
                    </select>
                </div>
                <div class="col-12 mb-2">
                    <label>Длина:</label>
                    <input type="number" class="form-control mb-2" name="column_length" placeholder="Только для VARCHAR, TINYINT, DECIMAL">
                </div>
                <div class="col-12 mb-0">
                    <button type="submit" class="btn btn-outline-success w-100">Добавить поле</button>
                </div>
            </div>
        </form>
    </div>

    <!-- Таблица для отображения дополнительных полей -->
    <h4 class="mt-3 mb-0">Новые поля</h4>
    <table class="table">
        <thead class="border-success">
            <tr>
                <th class="border-end text-center">Заголовок</th>
                <th class="border-end text-center">Тип</th>
                <th class="border-end text-center">Длина</th>
                <th class="text-center">Действия</th>
            </tr>
        </thead>
        <tbody>
            {foreach from=$columns item=column}
            <tr>
                <td class="border-end text-center">{$column.x_name}</td>
                <td class="border-end text-center">{$column.column_type}</td>
                <td class="border-end text-center">{$column.column_length|default:"-"}</td>
                <td class="border-end text-center">
                    <button type="button" class="no-b mx-1" onclick="smallModal('editColumn{$column.id}')">
                        <i class="fa fa-edit text-warning"></i>
                    </button>
                    <!-- Форма для удаления поля -->
                    <form method="POST" action="#" class="d-inline">
                        <input type="hidden" name="form_id" value="delete_column">
                        <input type="hidden" name="id" value="{$column.id}">
                        <button type="submit" class="no-b mx-1" onclick="return confirm('Удалить поле {$column.x_name}?')">
                            <i class="fa fa-trash text-danger"></i>
                        </button>
                    </form>
                </td>
            </tr>

            <div id="editColumn{$column.id}" class="hidden">
                <!-- Форма для редактирования поля -->
                <form method="POST" action="#">
                    <input type="hidden" name="form_id" value="edit_column">
                    <input type="hidden" name="id" value="{$column.id}">
                    <div class="row">
                        <div class="col-12 mb-2">
                            <label>Заголовок столбца:</label>
                            <input type="text" class="form-control" name="new_x_name" value="{$column.x_name}" required>
                        </div>
                        <div class="col-12 mb-2">
                            <label>Тип столбца:</label>
                            <select class="form-control" name="new_column_type">
                                <option value="VARCHAR" {if $column.column_type == 'VARCHAR'}selected{/if}>VARCHAR</option>
                                <option value="INT" {if $column.column_type == 'INT'}selected{/if}>INT</option>
                                <option value="TEXT" {if $column.column_type == 'TEXT'}selected{/if}>TEXT</option>
                                <option value="TIMESTAMP" {if $column.column_type == 'TIMESTAMP'}selected{/if}>TIMESTAMP</option>
                                <option value="TINYINT" {if $column.column_type == 'TINYINT'}selected{/if}>TINYINT</option>
                                <option value="BOOLEAN" {if $column.column_type == 'BOOLEAN'}selected{/if}>BOOLEAN</option>
                                <option value="MEDIUMTEXT" {if $column.column_type == 'MEDIUMTEXT'}selected{/if}>MEDIUMTEXT</option>
                                <option value="DECIMAL" {if $column.column_type == 'DECIMAL'}selected{/if}>DECIMAL</option>
                            </select>
                        </div>
                        <div class="col-12 mb-2">
                            <label>Длина:</label>
                            <input type="number" class="form-control" name="new_column_length" value="{$column.column_length|default:0}" placeholder="Только для VARCHAR, TINYINT, DECIMAL">
                        </div>
                        <div class="col-12 mb-0">
                            <button type="submit" class="btn btn-outline-success w-100">Сохранить изменения</button>
                        </div>
                    </div>
                </form>
            </div>
            {/foreach}
        </tbody>
    </table>
</div>
<script>
	var fieldsSection = document.getElementById('fieldsSection');
	fieldsSection.classList.add('active');
	var fieldsBlock = document.getElementById('fieldsBlock');
	fieldsBlock.classList.add('show');
	var currentLink = document.getElementById('lotsFields');
	currentLink.classList.add('active');
</script>