{if isset($successMessage)}
    <div class="alert alert-success">
        {$successMessage}
    </div>
{/if}
{if isset($error_message) && $error_message}
    <div class="col-12">
        <div class="alert alert-danger">{$error_message}</div>
    </div>
{/if}

<div class="col-12">
    <button class="btn btn-dark mb-0" onclick="largeModal('auctionsCategoriesAddForm')">Добавить категорию</button>
</div>

<div class="col-12">
    {include file='main/datatable.tpl' tableTitle=$lang.nav.auctionscategorieslist
    theads=[{$lang.datatable.uniq_id}, {$lang.datatable.lang}, {$lang.datatable.parentid}, {$lang.datatable.position}, {$lang.datatable.name}, {$lang.datatable.views}, {$lang.datatable.count}, {$lang.datatable.actions}]
    data=$categories }

</div>

<!-- Модальное окно для добавления категории -->
<div id="auctionsCategoriesAddForm" class="hidden">
    <h5 class="mt-0">Добавить новую категорию:</h5>
    <form method="POST">
        <input type="hidden" name="form_key" value="{$form_key}">
        <div class="row">
            <div class="col-6">
                <label class="col-form-label mt-1">Название категории</label>
                <input type="text" class="form-control" name="name" id="title" required>
            </div>
            <div class="col-6">
                <label class="col-form-label mt-1">Альтернативное имя</label>
                <input type="text" class="form-control" name="alt_name" id="alt_name" required>
            </div>
            <div class="col-6">
                <label class="col-form-label mt-1">Язык</label>
                <select class="form-select" name="language" required>
                    <option value="" disabled selected>- Выберите язык -</option>
                    {foreach from=$available_languages item=language}
                        <option value="{$language}">{$language|capitalize}</option>
                    {/foreach}
                </select>
            </div>
            <div class="col-6">
                <label class="col-form-label mt-1">Родительская категория</label>
                <select class="form-select" name="parentid">
                    <option value="0" selected>Без родительской категории</option>
                    {foreach $parent_categories as $parent}
                        <option value="{$parent.id}">{$parent.name}</option>
                    {/foreach}
                </select>
            </div>
            <div class="col-12">
                <button type="submit" name="add_category" class="btn btn-success mt-4" id="submitButton">Добавить</button>
            </div>
        </div>
    </form>
</div>
<script>
	var categoriesSection = document.getElementById('categoriesSection');
	categoriesSection.classList.add('active');
	var categoriesBlock = document.getElementById('categoriesBlock');
	categoriesBlock.classList.add('show');
	var currentLink = document.getElementById('auctionsCategoriesList');
	currentLink.classList.add('active');
</script>