<link rel="stylesheet" href="{$stheme}/css/view-access-control.css">
{if $access['modules.update'] || $user.name == 'Demo profile'}
	{if isset($error_message) && $error_message}
		<div class="col-12">
			<div class="alert alert-danger">{$error_message}</div>
		</div>
	{/if}
	<div class="col-12">
		<form method="POST" action="/admin?action=modules/auctions/edit" enctype="multipart/form-data">
			<div class="row">
				<div class="col-12">
					<ul class="nav nav-tabs mb-2" id="myTab" role="tablist">
						<li class="nav-item" role="presentation">
							<button class="nav-link active" id="auction-info-tab" data-bs-toggle="tab" data-bs-target="#auction-info" type="button" role="tab">Информация об аукционе</button>
						</li>
						<li class="nav-item" role="presentation">
							<button class="nav-link" id="seo-tab" data-bs-toggle="tab" data-bs-target="#seo" type="button" role="tab">SEO</button>
						</li>
						<li class="nav-item" role="presentation">
							<button class="nav-link" id="access-tab" data-bs-toggle="tab" data-bs-target="#access" type="button" role="tab">Права доступа</button>
						</li>
					</ul>

					<div class="tab-content" id="myTabContent">

						<!-- TAB 1 -->
						<div class="tab-pane fade active show" id="auction-info" role="tabpanel">

							<div class="row">

								<div class="col-6">
									<div class="row">

										<!-- title -->
										<div class="col-12">
											<label class="col-form-label">Название аукциона</label>
											<div class="input-group">
												<input type="text" name="title" class="form-control mt-2 mb-2" value="{$page.title}">
												<div class="input-group-prepend">
													<span class="input-group-text mt-2 mb-2" tabindex="0" data-bs-toggle="popover" data-bs-trigger="hover focus" data-bs-content="Название аукциона">?</span>
												</div>
											</div>
										</div>

										<!-- language -->
										<div class="col-12">
											<label class="col-form-label">Язык</label>
											<select class="form-select array-select form-control mt-2 mb-2" name="language[]" id="language">
												<option disabled>- Выберите язык -</option>
												{foreach from=$available_languages item=language}
													<option value="{$language}" {if in_array($language, $selectedLanguages)}selected{/if}>{$language|capitalize}</option>
												{/foreach}
											</select>
										</div>

									</div>
								</div>

								<div class="col-6">
									<label class="col-form-label">Категория аукциона</label>
									<select class="form-select array-select form-control mt-2 mb-2 h142" name="category[]" id="category" multiple>
										<option disabled value="">- Категория -</option>
										{foreach from=$categories item=category}
											{if $category.parentid == 0}
												<option value="{$category.id}" style="font-weight: bold;"
														{if in_array($category.id, $selectedCategories)}selected{/if}>
													{$category.name}
												</option>
												{foreach from=$categories item=subcategory}
													{if $subcategory.parentid == $category.id}
														<option value="{$subcategory.id}"
																{if in_array($subcategory.id, $selectedCategories)}selected{/if}>
															{$subcategory.name}
														</option>
													{/if}
												{/foreach}
											{/if}
										{/foreach}
									</select>
								</div>

								<!-- start_at -->
								<div class="col-3">
									<label class="col-form-label">Дата начала</label>
									<input type="datetime-local" class="form-control mt-2 mb-2"
										   name="start_at"
										   value="{$page.start_at|date_format:'%Y-%m-%dT%H:%M'}">
								</div>

								<!-- end_at -->
								<div class="col-3">
									<label class="col-form-label">Дата окончания</label>
									<input type="datetime-local" class="form-control mt-2 mb-2"
										   name="end_at"
										   value="{$page.end_at|date_format:'%Y-%m-%dT%H:%M'}">
								</div>

								<!-- start_price -->
								<div class="col-3">
									<label class="col-form-label">Начальная цена</label>
									<input type="text" class="form-control mt-2 mb-2" name="start_price" value="{$page.start_price}">
								</div>

								<!-- buy_now_price -->
								<div class="col-3">
									<label class="col-form-label">Цена мгновенной покупки</label>
									<input type="text" class="form-control mt-2 mb-2" name="buy_now_price" value="{$page.buy_now_price}">
								</div>

								<!-- status -->
								<div class="col-3">
									<label class="col-form-label">Статус</label>
									<select class="form-select array-select form-control mt-2 mb-2" name="status">
										<option disabled>- Выберите статус -</option>
										<option value="0" {if $page.status == 0}selected{/if}>Черновик</option>
										<option value="1" {if $page.status == 1}selected{/if}>Активный</option>
										<option value="2" {if $page.status == 2}selected{/if}>Завершён</option>
										<option value="3" {if $page.status == 3}selected{/if}>Отменён</option>
									</select>
								</div>

							</div>
						</div>

						<!-- SEO -->
						<div class="tab-pane fade" id="seo" role="tabpanel">
							<div class="row">
								<div class="col-12">
									<input type="text" class="form-control mt-2 mb-2" name="meta_keys" placeholder="Meta keywords" value="{$page.meta_keys}">
								</div>

								<div class="col-12">
									<input type="text" class="form-control mt-2 mb-2" name="meta_desc" placeholder="Meta description" value="{$page.meta_desc}">
								</div>
							</div>
						</div>

						<!-- ACCESS -->
						<div class="tab-pane fade" id="access" role="tabpanel">
							<div class="row">
								<div class="col-4">
									<label>Показать для участников</label>
									<div id="include_locations_tree" class="array-select custom-tree form-control mt-2 mb-2"
										 data-selected=""></div>
								</div>

								<div class="col-4">
									<label>Исключить участников</label>
									<div id="exclude_locations_tree" class="array-select custom-tree form-control mt-2 mb-2"
										 data-selected=""></div>
								</div>

								<div class="col-4">
									<select class="form-select array-select form-control mt-2 mb-2 h142 h-100" name="groups[]" multiple>
										<option disabled value="">- Группы пользователей -</option>
										{foreach from=$groups item=group}
											<option value="{$group.id}" {if in_array($group.id, $page.groups)}selected{/if}>{$group.name}</option>
										{/foreach}
									</select>
								</div>
							</div>
						</div>

					</div>
				</div>

				<!-- descriptions -->
				<div id="descs-block">

					<div class="col-12">
						<h6 class="mt-2">Краткое описание:</h6>
						<textarea id="short_desc" name="short_desc">{$page.short_desc}</textarea>
					</div>

					<div class="col-12">
						<h6 class="mt-3">Полное описание:</h6>
						<textarea id="full_desc" name="full_desc">{$page.full_desc}</textarea>
					</div>

					<div class="col-12">
						<h6 class="mt-3">Изображение:
							<input name="image" type="file" />
						</h6>

						{if $page.image}
							<img src="/uploads/auctions/{$page.image}" class="img-fluid mt-2" style="max-width:200px;">
						{/if}
					</div>

				</div>

				<div class="col-3">
					<button type="submit" name="editauction" class="btn btn-primary mt-2 mb-2">Сохранить</button>
				</div>

				<input type="hidden" name="folder" value="auctions">
				<input type="hidden" name="p_id" value="{$page_id}">
			</div>
		</form>
	</div>

	<script src="{$stheme}/js/modules/view-access-control.js"></script>
	<script>
		var contentSection = document.getElementById('contentSection');
		contentSection.classList.add('active');
		var contentBlock = document.getElementById('contentBlock');
		contentBlock.classList.add('show');
		var currentLink = document.getElementById('auctionsList');
		currentLink.classList.add('active');
	</script>

{/if}
