{if $access['modules.create'] || $user.name == 'Demo profile'}

	{if isset($error_message) && $error_message}
		<div class="col-12">
			<div class="alert alert-danger">{$error_message}</div>
		</div>
	{/if}

	<div class="col-12">
		<form method="POST" enctype="multipart/form-data">

			<!-- =================== ТАБЫ =================== -->
			<div class="row">
				<div class="col-12">
					<ul class="nav nav-tabs mb-2" id="couponTabs" role="tablist">

						<li class="nav-item">
							<button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab-main" type="button">
								Основное
							</button>
						</li>

						<li class="nav-item">
							<button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-limits" type="button">
								Ограничения
							</button>
						</li>

						<li class="nav-item">
							<button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-seo" type="button">
								SEO
							</button>
						</li>

					</ul>


					<!-- =================== ТАБЫ КОНТЕНТ =================== -->
					<div class="tab-content">

						<!-- =================== ОСНОВНОЕ =================== -->
						<div class="tab-pane fade active show" id="tab-main">
							<div class="row">

								<!-- ЛЕВАЯ КОЛОНКА -->
								<div class="col-12">

									<!-- Даты -->
									<div class="row g-3">
										<div class="col-md-6">
											<label class="col-form-label">Начало</label>
											<div class="form-icon-group left-icon position-relative">
												<input type="datetime-local" name="start_at" class="form-control">
												<div class="form-icon position-absolute"><img src="/system/assets/images/svg/option.svg"></div>
											</div>
										</div>

										<div class="col-md-6">
											<label class="col-form-label">Окончание</label>
											<div class="form-icon-group left-icon position-relative">
												<input type="datetime-local" name="end_at" class="form-control">
												<div class="form-icon position-absolute"><img src="/system/assets/images/svg/option.svg"></div>
											</div>
										</div>
									</div>

									<!-- Код купона — КОМПАКТНЫЙ -->
									<div class="row mt-3">
										<div class="col-md-6">
											<label class="col-form-label">Код купона</label>
											<div class="input-group">
												<input type="text" name="code" class="form-control">
												<span class="input-group-text"
													  data-bs-toggle="popover" data-bs-trigger="hover focus"
													  data-bs-content="Уникальный код.">?</span>
											</div>
										</div>
									</div>

									<!-- Тип скидки и значение -->
									<div class="row mt-3 g-3">
										<div class="col-md-6">
											<label class="col-form-label">Тип скидки</label>
											<select class="form-select" name="discount_type">
												<option value="1">Процент</option>
												<option value="2">Фиксированная сумма</option>
											</select>
										</div>

										<div class="col-md-6">
											<label class="col-form-label">Размер скидки</label>
											<input type="number" step="0.01" name="discount_value" class="form-control">
										</div>
									</div>

									<!-- Применение и статус -->
									<div class="row mt-3 g-3">
										<div class="col-md-6">
											<label class="col-form-label">Применение</label>
											<select class="form-select" name="apply_to_all">
												<option value="1">На всё</option>
												<option value="0">На определённые товары</option>
											</select>
										</div>

										<div class="col-md-6">
											<label class="col-form-label">Статус</label>
											<select class="form-select" name="status">
												<option value="1">Активен</option>
												<option value="0">Выключен</option>
											</select>
										</div>
									</div>

								</div>

							</div>
						</div>


						<!-- =================== ОГРАНИЧЕНИЯ =================== -->
						<div class="tab-pane fade" id="tab-limits">
							<div class="row">

								<div class="col-4">
									<label class="col-form-label">Минимальная сумма заказа</label>
									<input type="number" step="0.01" name="min_order_sum" class="form-control mt-2 mb-2">
								</div>

								<div class="col-4">
									<label class="col-form-label">Максимальная скидка</label>
									<input type="number" step="0.01" name="max_discount_sum" class="form-control mt-2 mb-2">
								</div>

								<div class="col-4">
									<label class="col-form-label">Лимит использований</label>
									<input type="number" name="usage_limit" class="form-control mt-2 mb-2">
								</div>

								<div class="col-4">
									<label class="col-form-label">Лимит на пользователя</label>
									<input type="number" name="usage_limit_per_user" class="form-control mt-2 mb-2">
								</div>

							</div>
						</div>


						<!-- =================== SEO =================== -->
						<div class="tab-pane fade" id="tab-seo">

							<fieldset class="form-icon-group left-icon position-relative">
								<input type="text" name="meta_keys" class="form-control mt-2 mb-2" placeholder="Meta keywords">
								<div class="form-icon position-absolute"><svg ...></svg></div>
							</fieldset>

							<fieldset class="form-icon-group left-icon position-relative">
								<input type="text" name="meta_desc" class="form-control mt-2 mb-2" placeholder="Meta description">
								<div class="form-icon position-absolute"><svg ...></svg></div>
							</fieldset>

						</div>

					</div> <!-- end tabs -->

				</div>


				<!-- =================== ТЕКСТОВЫЕ ПОЛЯ =================== -->
				<div class="col-12">
					<h6 class="mt-2">Описание:</h6>
					<textarea id="short_desc" name="description"></textarea>
				</div>

				<!-- =================== ДОПОЛНИТЕЛЬНЫЕ ПОЛЯ =================== -->
				<div class="row">
					{foreach from=$fields item=field key=index}
						<div class="col-12 col-md-4 mt-3">
							<label>{$lang.fields.coupons[$index]}</label>
							<input type="text" class="form-control" name="x_value[{$index}]">
							<input type="hidden" name="field_ids[]" value="{$index}">
						</div>
					{/foreach}
				</div>

{*

				<!-- =================== ИЗОБРАЖЕНИЕ =================== -->
				<div class="col-12">
					<h6 class="mt-3">Изображение: <input name="image" type="file" /></h6>
				</div>

*}

				<!-- =================== SUBMIT =================== -->
				<div class="col-3">
					<button type="submit" name="addcoupon" class="btn btn-success mt-2 mb-2">
						Добавить
					</button>
				</div>

				<input type="hidden" name="folder" value="coupons">
				<input type="hidden" name="p_id" value="{$page_id}">
			</div>

		</form>
	</div>
	<script>
		var contentSection = document.getElementById('contentSection');
		contentSection.classList.add('active');
		var contentBlock = document.getElementById('contentBlock');
		contentBlock.classList.add('show');
		var currentLink = document.getElementById('addCoupons');
		currentLink.classList.add('active');
	</script>

{/if}
