{if $access['modules.update'] || $user.name == 'Demo profile'}

	{if isset($error_message) && $error_message}
		<div class="col-12">
			<div class="alert alert-danger">{$error_message}</div>
		</div>
	{/if}

	<div class="col-12">
		<form method="POST" action="/admin?action=modules/coupons/edit&id={$coupon.id}" enctype="multipart/form-data">

			<ul class="nav nav-tabs mb-2">
				<li class="nav-item">
					<button type="button" class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab-main">Основное</button>
				</li>
				<li class="nav-item">
					<button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-limits">Ограничения</button>
				</li>
			</ul>

			<div class="tab-content">

				<div class="tab-pane fade show active" id="tab-main">
					<div class="row">

						<div class="col-6">
							<label>Начало</label>
							<input type="datetime-local" name="start_at" class="form-control"
								   value="{$coupon.start_at|date_format:'%Y-%m-%dT%H:%M'}">
						</div>

						<div class="col-6">
							<label>Окончание</label>
							<input type="datetime-local" name="end_at" class="form-control"
								   value="{$coupon.end_at|date_format:'%Y-%m-%dT%H:%M'}">
						</div>

						<div class="col-12 mt-2">
							<label>Код купона</label>
							<input type="text" name="code" class="form-control" value="{$coupon.code}">
						</div>

						<div class="col-6 mt-2">
							<label>Тип скидки</label>
							<select name="discount_type" class="form-select">
								<option value="1" {if $coupon.discount_type==1}selected{/if}>Процент</option>
								<option value="2" {if $coupon.discount_type==2}selected{/if}>Фикс</option>
							</select>
						</div>

						<div class="col-6 mt-2">
							<label>Размер скидки</label>
							<input type="number" step="0.01" name="discount_value" class="form-control"
								   value="{$coupon.discount_value}">
						</div>

						<div class="col-6 mt-2">
							<label>Применение</label>
							<select name="apply_to_all" class="form-select">
								<option value="1" {if $coupon.apply_to_all==1}selected{/if}>На всё</option>
								<option value="0" {if $coupon.apply_to_all==0}selected{/if}>Выборочно</option>
							</select>
						</div>

						<div class="col-6 mt-2">
							<label>Статус</label>
							<select name="status" class="form-select">
								<option value="1" {if $coupon.status==1}selected{/if}>Активен</option>
								<option value="0" {if $coupon.status==0}selected{/if}>Выключен</option>
							</select>
						</div>

					</div>
				</div>

				<div class="tab-pane fade" id="tab-limits">
					<div class="row">
						<div class="col-4">
							<label>Мин. сумма</label>
							<input type="number" step="0.01" name="min_order_sum" class="form-control"
								   value="{$coupon.min_order_sum}">
						</div>

						<div class="col-4">
							<label>Макс. скидка</label>
							<input type="number" step="0.01" name="max_discount_sum" class="form-control"
								   value="{$coupon.max_discount_sum}">
						</div>

						<div class="col-4">
							<label>Лимит</label>
							<input type="number" name="usage_limit" class="form-control"
								   value="{$coupon.usage_limit}">
						</div>

						<div class="col-4 mt-2">
							<label>Лимит на юзера</label>
							<input type="number" name="usage_limit_per_user" class="form-control"
								   value="{$coupon.usage_limit_per_user}">
						</div>
					</div>
				</div>

			</div>

			<div class="col-12 mt-3">
				<label>Описание</label>
				<textarea name="description" class="form-control" rows="4">{$coupon.description}</textarea>
			</div>

			<div class="row mt-3">
				{foreach from=$fields item=field key=field_id}
					<div class="col-md-4">
						<label>{$lang.fields.coupons[$field_id]}</label>
						<input type="text" class="form-control"
							   name="x_value[{$field_id}]"
							   value="{$field_values[$field_id]|default:''}">
						<input type="hidden" name="field_ids[]" value="{$field_id}">
					</div>
				{/foreach}
			</div>

			<div class="col-3 mt-3">
				<button type="submit" name="editcoupon" class="btn btn-success w-100">
					Сохранить
				</button>
			</div>

		</form>
	</div>

{/if}
