<div class="col-12">
    <table class="table mb-3">
        <thead class="border-success">
            <tr>
                <th class="brow-end text-center" width="60px">id</th>
                <th class="brow-end">event</th>
                <th class="brow-end">username</th>
                <th class="brow-end">phone</th>
                <th class="brow-end">registration</th>
                <th class="brow-end">status</th>
                <th class="brow-end">ip</th>
                <th class="brow-end">city</th>
                <th class="text-center" width="70px">Action</th>
            </tr>
        </thead>
        <tbody>
            {foreach $event_participants as $row}
                <tr>
                    <td class="brow-end text-center">{$row.id}</td>
                    <td class="brow-end">{$row.event_title}</td>
                    <td class="brow-end"><a href="{$row.social_url|default:'#'}" title="user-id={$row.user_id}">{$row.username}</a></td>
                    <td class="brow-end">{$row.phone}</td>
                    <td class="brow-end">{$row.registration_date}</td>
                    <td class="brow-end">{$row.status}</td>
                    <td class="brow-end">{$row.ip}</td>
                    <td class="brow-end">{$row.city}</td>
                    <td class="text-center">
                        <div class="btn-group">
                            <!-- Кнопка открытия модального окна -->
                            <button type="button" class="btn btn-link" onclick="largeModal('participantsEdit{$row.id}')">
                                <i class="fa fa-edit text-warning"></i>
                            </button>
                            <form method="POST" action="#" style="display:inline;">
                                {if $access['modules.del']}<input type="hidden" name="delete_participants_id" value="{$row.id}">{/if}
                                <button type="submit" class="btn btn-link" onclick="return confirm('Вы уверены, что хотите удалить эту заявку?');">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="pb-3">Notes</td>
                    <td class="pb-3" colspan="10">{$row.notes}</td>
                </tr>

                <div id="participantsEdit{$row.id}" class="hidden">
                    <h5 class="mt-0">Редактирование данных участника с ID: {$row.id}</h5>
                    <form method="POST" action="#">
                        <input type="hidden" name="action" value="edit_participant">
                        <input type="hidden" name="participant_id" value="{$row.id}">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-4">
                                    <label class="col-form-label mt-1">Имя пользователя</label>
                                    <input type="text" class="form-control" name="username" value="{$row.username}" required>
                                </div>
                                <div class="col-4">
                                    <label class="col-form-label mt-1">Телефон</label>
                                    <input type="text" class="form-control" name="phone" value="{$row.phone}" required>
                                </div>
                                <div class="col-4">
                                    <label class="col-form-label mt-1">Статус</label>
                                    <select class="form-control" name="status" required>
                                        <option value="pending" {if $row.status == 'pending'}selected{/if}>Pending</option>
                                        <option value="confirmed" {if $row.status == 'confirmed'}selected{/if}>Confirmed</option>
                                        <option value="cancelled" {if $row.status == 'cancelled'}selected{/if}>Cancelled</option>
                                    </select>
                                </div>
                                <div class="col-6">
                                    <label class="col-form-label mt-1">Мероприятие (ID)</label>
                                    <input type="text" class="form-control" name="event_title" value="{$row.event_title}" required>
                                </div>
                                <div class="col-6">
                                    <label class="col-form-label mt-1">Ссылка на соцсеть</label>
                                    <input type="text" class="form-control" name="social_url" value="{$row.social_url}">
                                </div>
                                <div class="col-12">
                                    <label class="col-form-label mt-1">Дополнительные заметки</label>
                                    <textarea class="form-control" name="notes">{$row.notes}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
                            <button type="submit" class="btn btn-success">Сохранить изменения</button>
                        </div>
                    </form>
                </div>                
            {/foreach}
        </tbody>
    </table>
</div>
<script>
	var oaaSection = document.getElementById('oaaSection');
	oaaSection.classList.add('active');
	var ordersAndApplications = document.getElementById('ordersAndApplications');
	ordersAndApplications.classList.add('show');
	var currentLink = document.getElementById('allParticipants');
	currentLink.classList.add('active');
</script>