{if isset($successMessage)}
    <div class="alert alert-success">
        {$successMessage}
    </div>
{/if}
{if isset($error_message) && $error_message}
    <div class="col-12">
        <div class="alert alert-danger">{$error_message}</div>
    </div>
{/if}

<div class="col-12">
    <button class="btn btn-dark mb-0" onclick="largeModal('lotsCategoriesAddForm')">Добавить категорию</button>
</div>

<div class="col-12">
    <table class="table">
        <tbody>
            <tr>
                <th width="70px" class="border-end text-center">id</th>
                <th class="border-end text-center" width="50px">lang</th>
                <th class="border-end text-center" width="90px">parentid</th>
                <th class="border-end text-center" width="90px">position</th>
                <th class="border-end">name</th>
                <th class="border-end text-center" width="50px">views</th>
                <th class="border-end text-center" width="90px">count</th>
                <th class="border-end text-center" width="150px">actions</th>
            </tr>
            {foreach $categories as $category}
                <tr>
                    <td class="border-end text-center">{$category.id}</td>
                    <td class="border-end text-center text-muted">
                        <img src="{$engine}/lang/{$category.language}/icon.png" style="height: 22px;" alt="">
                    </td>
                    <td class="border-end text-center">{$category.parentid}</td>
                    <td class="border-end text-center">{$category.position}</td>
                    <td class="border-end">
                        <a href="/lc/{$category.alt_name}" target="_blank">{$category.name}</a>
                    </td>
                    <td class="border-end text-center">{$category.views}</td>
                    <td class="border-end text-center">{* {$category.lots_count} *}</td>
                    <td class="border-end text-center">
                        <button type="button" class="mx-1 bg-transparent border" onclick="largeModal('lotsCategoriesEditForm')"><i class="fa fa-edit"></i></button>
                        <form method="POST" action="/admin?action=modules/lots/categories" style="display:inline;">
                            <input type="hidden" name="form_key" value="{$form_key}">
                            <input type="hidden" name="id" value="{$category.id}">
                            <input type="hidden" name="delete_lots_category" value="1">
                            <button type="submit" class="no-b mx-1" onclick="return confirm('Вы уверены, что хотите удалить категорию?');">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>
</div>

<!-- Модальное окно для добавления категории -->
<div id="lotsCategoriesAddForm" class="hidden">
    <h5 class="mt-0">Добавить новую категорию:</h5>
    <form method="POST">
        <input type="hidden" name="form_key" value="{$form_key}">
        <div class="row">
            <div class="col-6">
                <label class="col-form-label mt-1">Название категории</label>
                <input type="text" class="form-control" name="name" id="title" required>
            </div>
            <div class="col-6">
                <label class="col-form-label mt-1">Альтернативное имя</label>
                <input type="text" class="form-control" name="alt_name" id="alt_name" required>
            </div>
            <div class="col-6">
                <label class="col-form-label mt-1">Язык</label>
                <select class="form-select" name="language" required>
                    <option value="" disabled selected>- Выберите язык -</option>
                    {foreach from=$available_languages item=language}
                        <option value="{$language}">{$language|capitalize}</option>
                    {/foreach}
                </select>
            </div>
            <div class="col-6">
                <label class="col-form-label mt-1">Родительская категория</label>
                <select class="form-select" name="parentid">
                    <option value="0" selected>Без родительской категории</option>
                    {foreach $parent_categories as $parent}
                        <option value="{$parent.id}">{$parent.name}</option>
                    {/foreach}
                </select>
            </div>
            <div class="col-12">
                <button type="submit" name="add_category" class="btn btn-success mt-4" id="submitButton">Добавить</button>
            </div>
        </div>
    </form>
</div>
<script>
	var categoriesSection = document.getElementById('categoriesSection');
	categoriesSection.classList.add('active');
	var categoriesBlock = document.getElementById('categoriesBlock');
	categoriesBlock.classList.add('show');
	var currentLink = document.getElementById('lotsCategoriesList');
	currentLink.classList.add('active');
</script>