{if $access['mnu.create'] || $user.name == 'Demo profile'}

	<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#bonusModal" onclick="openBonusModal()">Добавить бонус</button>
	<div class="modal fade" id="bonusModal" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog">
			<form id="bonusForm" method="POST">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" id="bonusModalLabel">Добавить бонус</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
					</div>
					<div class="modal-body">
						<input type="hidden" name="id" id="bonusId" value="">
						<div class="mb-3">
							<label for="name" class="form-label">Название бонуса *</label>
							<input type="text" class="form-control" name="name" id="name" required minlength="3" maxlength="100">
						</div>
						<div class="mb-3">

							<label for="payment_system"  class="col-form-label mt-1">Платёжная система *</label>
							<select class="form-select" id="payment_system" name="payment_system" required>
								<option value="stripe" selected>Stripe</option>
								<option value="coinbase">Coinbase</option>
								<option value="balance">Balance</option>
							</select>
						</div>
						<div class="mb-3">
							<label for="type" class="form-label">Тип бонуса</label>
							<select class="form-select" name="type" id="type">
								<option value="percent">Процент</option>
								<option value="fixed">Фиксированная сумма</option>
							</select>
						</div>
						<div class="mb-3">
							<label for="value" class="form-label">Значение бонуса *</label>
							<input type="number" step="0.01" class="form-control" name="value" id="value" required min="0.01">
						</div>
						<div class="mb-3">
							<label for="min_payment" class="form-label">Минимальная сумма</label>
							<input type="number" step="0.01" class="form-control" name="min_payment" id="min_payment" min="0" value="0">
						</div>
						<div class="mb-3">
							<label for="max_uses_per_user" class="form-label">Макс. использований на пользователя</label>
							<input type="number" class="form-control" name="max_uses_per_user" id="max_uses_per_user" min="0" value="0">
						</div>
					</div>
					<div class="modal-footer">
						<button type="submit" name="save_payment_bonus" class="btn btn-success">Сохранить</button>
						<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
					</div>
				</div>
			</form>
		</div>
	</div>
	<div class="col-12">
		{include file='main/datatable.tpl'
		tableTitle="Payment Bonuses"
		theads=["id", "name", "payment_system", "type", "value", "min_payment", "max_uses_per_user", "created_at", "actions"]
		data=$paymentBonuses
		}
	</div>


{/if}

{literal}
<script>
	$(document).ready(function() {

		$(document).on("click", ".delete-ico", function (e) {
			e.preventDefault();

			const dataId = $(this).data("id");

			if (!confirm("Вы уверены, что хотите удалить?")) {
				return;
			}

			$.ajax({
				url: 'engine/ajax/lib/paymentWidget/delete_pay_bonus.php',
				type: 'POST',
				dataType: 'json',
				data: {id: dataId},
				success: function (response) {

					if (response) {
						window.location.reload();
					} else {

					}

				},
				error: function (xhr, status, error) {
					return;
				}
			});
		});

		$(".edit-ico").on("click", function () {
			debugger;

			const dataId = $(this).data("id");

			if (dataId) {
				$.ajax({
					url: 'engine/ajax/lib/paymentWidget/get_bonus_data.php',
					type: 'POST',
					dataType: 'json',
					data: {id: dataId},
					success: function (response) {

						if (response) {
							$("#bonusModal").modal("show");
							$("#bonusId").val(response.id);
							openBonusModal(response);
						} else {

						}

					},
					error: function (xhr, status, error) {
						return;
					}
				});
			}


		})

	});

	function openBonusModal(data = null) {
		debugger;
		$("#bonusId").val("");

		if(data) {
			document.getElementById('bonusModalLabel').innerText = "Редактировать бонус";
			document.getElementById('bonusId').value = data.id;
			document.getElementById('payment_system').value = data.payment_system;
			document.getElementById('name').value = data.name;
			document.getElementById('type').value = data.type;
			document.getElementById('value').value = data.value;
		//	document.getElementById('currency').value = data.currency;
			document.getElementById('min_payment').value = data.min_payment;
			document.getElementById('max_uses_per_user').value = data.max_uses_per_user;
//			document.getElementById('active').checked = data.active == 1;
		} else {
			// добавление
			document.getElementById('bonusModalLabel').innerText = "Добавить бонус";
			document.getElementById('bonusForm').reset();
			document.getElementById('bonusId').value = '';
		//	document.getElementById('active').checked = true;
		}
	}


</script>

{/literal}