<ul class="nav nav-tabs" id="policyTabs">
    <li class="nav-item">
        <a class="nav-link {if $activeTab == 'cookies'}active{/if}" href="#cookies" data-toggle="tab">Cookies</a>
    </li>
    <li class="nav-item">
        <a class="nav-link {if $activeTab == 'policy'}active{/if}" href="#policy" data-toggle="tab">Policy</a>
    </li>
    <li class="nav-item">
        <a class="nav-link {if $activeTab == 'terms'}active{/if}" href="#terms" data-toggle="tab">Terms</a>
    </li>
</ul>

<div class="tab-content">
    <div class="tab-pane fade {if $activeTab == 'cookies'}show active{/if}" id="cookies">
        <form method="post" action="/admin?action=policy-terms-cookies">
            <input type="hidden" name="file" value="cookies">
            <input type="hidden" name="active_tab" value="cookies">
            <textarea name="content" class="form-control" rows="15">{$cookieContent}</textarea>
            <button type="submit" class="btn btn-primary mt-2">{$lang.tools.save}</button>
        </form>
    </div>
    <div class="tab-pane fade {if $activeTab == 'policy'}show active{/if}" id="policy">
        <form method="post" action="/admin?action=policy-terms-cookies">
            <input type="hidden" name="file" value="policy">
            <input type="hidden" name="active_tab" value="policy">
            <textarea name="content" class="form-control" rows="15">{$policyContent}</textarea>
            <button type="submit" class="btn btn-primary mt-2">{$lang.tools.save}</button>
        </form>
    </div>
    <div class="tab-pane fade {if $activeTab == 'terms'}show active{/if}" id="terms">
        <form method="post" action="/admin?action=policy-terms-cookies">
            <input type="hidden" name="file" value="terms">
            <input type="hidden" name="active_tab" value="terms">
            <textarea name="content" class="form-control" rows="15">{$termsContent}</textarea>
            <button type="submit" class="btn btn-primary mt-2">{$lang.tools.save}</button>
        </form>
    </div>
</div>
{literal}
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const tabs = document.querySelectorAll('#policyTabs a.nav-link');
        const urlParams = new URLSearchParams(window.location.search);
        const activeTab = urlParams.get('tab') || 'cookies';
        tabs.forEach(tab => {
            tab.addEventListener('click', (e) => {
                e.preventDefault();
                const targetId = tab.getAttribute('href').substring(1);
                // Обновляем URL
                const newUrl = new URL(window.location.href);
                newUrl.searchParams.set('tab', targetId);
                window.history.pushState(null, '', newUrl);
                // Переключаем активную вкладку
                document.querySelector('.nav-link.active')?.classList.remove('active');
                tab.classList.add('active');
                document.querySelector('.tab-pane.show.active')?.classList.remove('show', 'active');
                document.getElementById(targetId)?.classList.add('show', 'active');
            });
        });
        // Активируем вкладку из URL
        document.querySelector(`#policyTabs a[href="#${activeTab}"]`)?.click();
    });
</script>
{/literal}
<script>
	var toolsSection = document.getElementById('toolsSection');
	toolsSection.classList.add('active');
	var tools = document.getElementById('tools');
	tools.classList.add('show');
	var currentLink = document.getElementById('policyTermsCookies');
	currentLink.classList.add('active');
</script>