<div class="col-12">
	<div class="card">
		<div class="card-header">
			<h4>Запросы на возврат</h4>
		</div>
		<div class="card-body">
			<table class="table table-striped">
				<thead>
				<tr>
					<th>ID</th>
					<th>Транзакция</th>
					<th>Пользователь</th>
					<th>Сумма</th>
					<th>Причина</th>
					<th>Статус</th>
					<th>Дата</th>
					<th>Действия</th>
				</tr>
				</thead>
				<tbody>
				{foreach $refundRequests as $req}
					<tr>
						<td>{$req.uniq_id}</td>
						<td>{$req.transaction_id}</td>
						<td>{$req.user_email}</td>
						<td>{$req.sum}</td>
						<td>{$req.reason}</td>
						<td>{$req.status_label}</td>
						<td>{$req.requested_at}</td>
						<td>
							{if $req.status == 'pending'}
								<button class="btn btn-success btn-sm approve-btn" data-id="{$req.id}">Одобрить</button>
								<button class="btn btn-danger btn-sm reject-btn" data-id="{$req.id}">Отклонить</button>
							{/if}
						</td>
					</tr>
				{/foreach}
				</tbody>
			</table>
		</div>
	</div>

</div>
<script>
	{literal}
	document.querySelectorAll('.approve-btn, .reject-btn').forEach(btn => {
		btn.addEventListener('click', function(){
			const id = this.dataset.id;
			const action = this.classList.contains('approve-btn') ? 'approve' : 'reject';

			if(!confirm('Вы уверены?')) return;

			fetch('/engine/ajax/lib/transactions/refund-action.php', {
				method: 'POST',
				headers: {'Content-Type': 'application/json'},
				body: JSON.stringify({id: id, action: action})
			})
					.then(res => res.json())
					.then(res => {
						if(res.success){
							alert('Действие выполнено!');
							location.reload();
						} else {
							alert('Ошибка: ' + res.message);
						}
					});
		});
	});
	{/literal}

	var toolsSection = document.getElementById('usersSection');
	toolsSection.classList.add('active');
	var tools = document.getElementById('usersBlock');
	tools.classList.add('show');
	var currentLink = document.getElementById('refundRequests');
	currentLink.classList.add('active');
</script>