<div class="col-12">

    {* Выпадающий список вместо табов *}
    <div class="mb-3 col-2">
        <label class="form-label">
            {$lang.datatable.select_group|default:'Выберите группу'}
        </label>
        <select id="groupSelect" class="form-select" onchange="updateRole(this.value)">
            {foreach $groups as $group}
                <option value="{$group.name}" {if $group.name == "User"}selected{/if}>
                    {$group.name}
                </option>
            {/foreach}
        </select>
    </div>

    {* Контейнеры для каждой группы *}
    {foreach $groups as $group}
        <div class="group-pane {if $group.name == "User"}show active{/if}"
             id="group-{$group.name}">

            {assign var="currGroup" value=$group.name}

            <div class="col-12">
                <button class="btn btn-dark mb-0" data-group="{$currGroup}" onclick="largeModal('groupFieldsAddForm')">
                    {$lang.datatable.add_field_from_user} {$currGroup}
                </button>
            </div>

            {include file='main/datatable.tpl'
            tableTitle="$currGroup"
            theads=["id", {$lang.datatable.name}, {$lang.datatable.type}, {$lang.datatable.options}, {$lang.datatable.required}, {$lang.datatable.created_at}]
            data=$fromGroupsData[$group.name]
            id=$group.name
            }
        </div>
    {/foreach}


    <div id="groupFieldsAddForm" class="hidden">
        <h5 class="mt-0">{$lang.datatable.add_new_field}</h5>
        <form method="POST">
            <input type="hidden" name="selected_role" id="selected_role" value="User">
            <input type="hidden" name="form_key" value="{$form_key}">

            <div class="row">
                <div class="col-6">
                    <label class="col-form-label mt-1">{$lang.datatable.field_name}</label>
                    <input type="text" class="form-control" name="name" id="name" required>
                </div>
                <div class="col-md-6 d-grid">
                    <label for="type">{$lang.datatable.field_type}:</label>
                    <select name="type" id="type" class="form-control">
                        <option value="checkbox">Checkbox</option>
                        <option value="date">Date</option>
                        <option value="number">Number</option>
                        <option value="select">Select</option>
                        <option value="text">Text</option>
                    </select>
                </div>
                <div class="col-12 col-md-6 mb-2">
                    <label for="required" class="col-form-label">{$lang.datatable.required_field}:</label>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" role="switch" name="required" id="required" value="false">
                    </div>
                </div>
                <div class="col-12">
                    <button type="submit" name="create_reg_field" class="btn btn-success mt-4" id="submitButton">
                        {$lang.datatable.add}
                    </button>
                </div>
            </div>
        </form>
    </div>


    <style>
        .group-pane {
            display: none;
        }
        .group-pane.show {
            display: block;
        }
    </style>


    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let savedRole = localStorage.getItem('selected_role');

            if(!savedRole) {
                savedRole = document.getElementById("groupSelect").value;
            }

            document.getElementById("groupSelect").value = savedRole;
            updateRole(savedRole);
        });


        function updateRole(role) {
            localStorage.setItem('selected_role', role);
            document.getElementById("selected_role").value = role;

            document.querySelectorAll('.group-pane').forEach(el => el.classList.remove('show'));

            var activePane = document.getElementById('group-' + role);
            if (activePane) {
                activePane.classList.add('show');
            }
        }


        // триггерим при загрузке
        document.addEventListener("DOMContentLoaded", function() {
            updateRole(document.getElementById("groupSelect").value);
        });

        var usersSection = document.getElementById('usersSection');
        usersSection.classList.add('active');
        var usersBlock = document.getElementById('usersBlock');
        usersBlock.classList.add('show');
        var currentLink = document.getElementById('regCustomFields');
        currentLink.classList.add('active');
    </script>
</div>
