{if $access['permissions.manage']}
<button class="btn btn-primary" onclick="openCreatePermissionModal()" data-bs-toggle="modal" data-bs-target="#permissionModal">Добавить разрешение</button>

<div class="modal fade" id="permissionModal" tabindex="-1">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<form id="permissionForm">

				<div class="modal-header">
					<h5 class="modal-title" id="permissionModalTitle">Добавить разрешение</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
				</div>

				<div class="modal-body">

					<input type="hidden" id="permission_id" name="id">

					<div class="mb-3">
						<label class="form-label">Код (user.create)</label>
						<input type="text" name="code" id="permission_code" class="form-control">
						<div class="text-danger small" id="error-code"></div>
					</div>

					<div class="mb-3">
						<label class="form-label">Модуль (users, shop)</label>
						<input type="text" name="module" id="permission_module" class="form-control">
						<div class="text-danger small" id="error-module"></div>
					</div>

					<div class="mb-3">
						<label class="form-label">Описание</label>
						<textarea name="description" id="permission_description" class="form-control"></textarea>
					</div>

				</div>

				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Закрыть</button>
					<button type="submit" class="btn btn-primary">Сохранить</button>
				</div>

			</form>
		</div>
	</div>
</div>
<div class="col-12">
	{include file='main/datatable.tpl' tableTitle="Все права:"
	theads=["id", "code", "module", "description", "created_at", "actions"]
	data=$permissions }
</div>

<script>
	$(document).ready(function() {

		$(document).on("submit", "#permissionForm", function (e) {
			e.preventDefault();

			let formData = $(this).serialize();
			let id = $("#permission_id").val();
			let url = id
					? "engine/ajax/lib/rolesAndRights/update_permission.php"
					: "engine/ajax/lib/rolesAndRights/create_permission.php";

			$(".text-danger.small").text("");

			$.ajax({
				url: url,
				type: "POST",
				data: formData,
				dataType: "json",
				success: function (response) {
					if (response.success) {
						location.reload();
					} else if (response.errors) {
						$.each(response.errors, function (field, msg) {
							$("#error-" + field).text(msg);
						});
					}
				}
			});
		});

		$(document).on("click", ".delete-ico", function (e) {
			e.preventDefault();

			const dataId = $(this).data("id");

			if (!confirm("Вы уверены, что хотите удалить права?")) {
				return;
			}

			$.ajax({
				url: 'engine/ajax/lib/rolesAndRights/delete_perms.php',
				type: 'POST',
				dataType: 'json',
				data: {literal} {id: dataId} {/literal},
				success: function (response) {

					if (response) {
						window.location.reload();
					} else {

					}

				},
				error: function (xhr, status, error) {
					return;
				}
			});
		});

		$(".edit-ico").on("click", function () {
			const id = $(this).data("id");

			$.ajax({
				url: "engine/ajax/lib/rolesAndRights/get_permission.php",
				type: "POST",
				dataType: "json",
				data: {literal} {id: id} {/literal},
				success: function (res) {
					if (res) openEditPermissionModal(res);
				}
			});
		});

		function openEditPermissionModal(item) {
			$("#permissionModalTitle").text("Редактировать разрешение");

			$("#permission_id").val(item.id);
			$("#permission_code").val(item.code);
			$("#permission_module").val(item.module);
			$("#permission_description").val(item.description ?? "");

			$(".text-danger.small").text("");
			$("#permissionModal").modal("show");
		}
	});


	function openCreatePermissionModal() {
		$("#permissionModalTitle").text("Создать разрешение");
		$("#permissionForm")[0].reset();
		$("#permission_id").val("");
		$(".text-danger.small").text("");
		$("#permissionModal").modal("show");
	}


</script>

	{else}
	<h3>Доступ запрещен</h3>
{/if}
<script>
	var usersSection = document.getElementById('usersSection');
	usersSection.classList.add('active');
	var usersBlock = document.getElementById('usersBlock');
	usersBlock.classList.add('show');
	var currentLink = document.getElementById('allPermissions');
	currentLink.classList.add('active');
</script>