{if $access['mnr.create'] || $user.name == 'Demo profile'}
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<style>
		.table_component { overflow: auto; width: 100%; }
		.table_component table { border: 1px solid #dededf; width: 100%; border-collapse: collapse; }
		.table_component th { padding:5px; }
		.table_component td { padding:5px; }
	</style>
	<div class="table_component">
		<table class="table table-bordered">
			<thead>
			<tr>
				<th>Роль</th>
				{foreach from=$columns item=col}
					<th>{$col}</th>
				{/foreach}
			</tr>
			</thead>
			<tbody>
			{foreach from=$roles item=role}
				<tr>
					<td>{$role.name}</td>
					{foreach from=$columns item=col}
					{if $col == "Actions"}
						{*<td>
							<button class="btn btn-sm btn-outline-secondary btn-edit-role-perms" data-id="{$role.id}">
								Редактировать права
							</button>
						</td>*}
					{else}
						<td>
							<button class="btn btn-sm btn-outline-secondary"
									onclick="openPermissions({$role.id}, '{$col}')">
								Права
							</button>
						</td>
					{/if}

					{/foreach}
				</tr>
			{/foreach}
			</tbody>
		</table>
	</div>

	<!-- Модальное окно -->
	<div class="modal fade" id="permissionsModal" tabindex="-1">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Права роли</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
				</div>
				<div class="modal-body" id="permissionsModalBody"></div>
			</div>
		</div>
	</div>
	<script>
		window.matrix = JSON.parse('{$matrixJson|escape:"javascript"}');
		const columnsMap = {
			"C": ["create"],
			"R": ["view"],
			"U": ["edit"],
			"D": ["delete", "del"],
			"P": ["publish"],
			"M": ["manage"],
			"A": ["add"],
			"S": ["settings"],
			"G": ["allmodules"]
		};
		$(document).on("change", ".perm-checkbox", function () {
			let cb = $(this);
			$.post("engine/ajax/lib/rolesAndRights/toggle_perm.php", {
				role_id: cb.data("role"),
				permission_id: cb.data("id"),
				allow: cb.is(":checked") ? 1 : 0
			});
		});


		function openPermissions(roleId, col) {
			$.ajax({
				url: "engine/ajax/lib/rolesAndRights/get_permissions.php",
				type: "GET",
				data: { role_id: roleId, column: col },
				success: function (resp) {

					let data = JSON.parse(resp);

					let html = `<table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Код</th>
                        <th>Описание</th>
                        <th>Разрешено</th>
                    </tr>
                </thead>
                <tbody>
            `;

					{literal}
					data.forEach(p => {
						html += `
                    <tr>
                        <td>${p.code}</td>
                        <td>${p.description ?? ''}</td>
                        <td>
                            <input type="checkbox" class="perm-checkbox"
                                   data-role="${roleId}"
                                   data-id="${p.id}"
                                   ${p.allow ? 'checked' : ''}>
                        </td>
                    </tr>`;
					});
					{/literal}

					html += `</tbody></table>`;
					$("#permissionsModalBody").html(html);

					new bootstrap.Modal(document.getElementById('permissionsModal')).show();
				}
			});
		}
	</script>

	<script>
		var usersSection = document.getElementById('usersSection');
		usersSection.classList.add('active');
		var usersBlock = document.getElementById('usersBlock');
		usersBlock.classList.add('show');
		var currentLink = document.getElementById('rolesAndRights');
		currentLink.classList.add('active');
	</script>

	<style>
		.perm-checkbox[disabled] {
			opacity: 0.4;
			cursor: wait;
		}
	</style>
{/if}

