{if $access['mns.create'] || $user.name == 'Demo profile'}
	<div class="col-12">
		<div class="card d-flex flex-row">
			<ul class="nav nav-tabs tab-card d-flex flex-column p-0 border-end" role="tablist" style="max-width: 350px">
				<li class="nav-item settings-item"><a class="nav-link active border-0" data-bs-toggle="tab" href="#tab2_general">{$lang.sections.settingssection.nav.basic}</a></li>
				<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_cms_install">{$lang.sections.settingssection.nav.cms_install}</a></li>
				<li class="nav-item settings-item"><a class="nav-link border-0 optimization-link" data-bs-toggle="tab" href="#tab2_optimization">{$lang.sections.settingssection.nav.optimization}</a></li>
				{if $adsAvailable && $adsUsed}<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_ads">{$lang.sections.settingssection.nav.ads}</a></li>{/if}
				{if $filesAvailable && $filesUsed}<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_files">{$lang.sections.settingssection.nav.files}</a></li>{/if}
				{if $moviesAvailable && $moviesUsed}<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_movies">{$lang.sections.settingssection.nav.movies}</a></li>{/if}
				{if $newsAvailable && $newsUsed}<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_news">{$lang.sections.settingssection.nav.news}</a></li>{/if}
				{if $productsAvailable && $productsUsed}<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_products">{$lang.sections.settingssection.nav.products}</a></li>{/if}
				{if $eventsAvailable && $eventsUsed}<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_events">{$lang.sections.settingssection.nav.events}</a></li>{/if}
				{if $lotsAvailable && $lotsUsed}<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_lots">{$lang.sections.settingssection.nav.lots}</a></li>{/if}

				<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_email_settings">{$lang.sections.settingssection.nav.email_settings}</a></li>
				<li class="nav-item settings-item"><a class="nav-link border-0" data-bs-toggle="tab" href="#tab2_payment_settings">{$lang.sections.settingssection.nav.payment_settings}</a></li>

			</ul>
			<div class="card-body">
				<form method="post" id="settings-form">
					<input type="hidden" name="form_type" value="{if $access['modules.update']}settings_save{else}addform{/if}">
					<div class="row">
						<div class="tab-content">
							<div class="tab-pane fade active show" id="tab2_general" role="tabpanel">
								<div class="row">
									<div class="col-12 col-md-6 mb-2">
										<label class="col-form-label">{$lang.sections.settingssection.general.title}:</label>
										<fieldset class="form-icon-group left-icon position-relative">
											<input type="text" class="form-control" name="title" value="{htmlspecialchars($config['title'])}">
											<div class="form-icon position-absolute">
												<img src="{$stheme}/images/svg/option.svg" alt="">
											</div>
										</fieldset>
									</div>
									<div class="col-12 col-md-6 mb-2">
										<label class="col-form-label">{$lang.sections.settingssection.general.email}:</label>
										<fieldset class="form-icon-group left-icon position-relative">
											<input type="text" class="form-control" name="feedback_mail" value="{htmlspecialchars($config['feedback_mail'])}">
											<div class="form-icon position-absolute">
												<img src="{$stheme}/images/svg/option.svg" alt="">
											</div>
										</fieldset>
									</div>
									<div class="col-6 col-md-6 mb-2">
										<label class="col-form-label">{$lang.sections.settingssection.general.referral_reward_percentage}:</label>
										<fieldset class="form-icon-group left-icon position-relative">
											<input type="text" class="form-control" name="referral_reward_percentage" value="{htmlspecialchars($config['referral_reward_percentage'])}">
											<div class="form-icon position-absolute">
												<img src="{$stheme}/images/svg/option.svg" alt="">
											</div>
										</fieldset>
									</div>
									<div class="col-6">
										<label class="col-form-label">{$lang.sections.settingssection.general.referral_fix_sum}:</label>
										<fieldset class="form-icon-group left-icon position-relative">
											<input type="text" class="form-control" name="referral_fix_sum" value="{htmlspecialchars($config['referral_fix_sum'])}">
											<div class="form-icon position-absolute">
												<img src="{$stheme}/images/svg/option.svg" alt="">
											</div>
										</fieldset>
									</div>
                                    <div class="col-6">
                                        <label class="col-form-label">Тип БД:</label>
                                        <fieldset class="form-icon-group left-icon position-relative">
                                            <select class="form-select array-select form-control" name="db_type">
                                                <option {if $config.database_settings.enabled_database === "mysql"}selected{/if} value="mysql">MySql</option>
                                                <option {if $config.database_settings.enabled_database === "pgsql"}selected{/if} value="pgsql">PostgreSql</option>
                                            </select>

                                            <div class="form-icon position-absolute">
                                                <img src="{$stheme}/images/svg/option.svg" alt="">
                                            </div>
                                        </fieldset>
                                    </div>
									<div class="col-12 col-md-6 mb-2">
										<label class="col-form-label">{$lang.sections.settingssection.general.utc}:</label>
										<fieldset class="form-icon-group left-icon position-relative">
											<select class="form-select array-select form-control" name="default_timezone">
												{foreach from=$timezones item=timezone}
													<option value="{$timezone|escape}" {if $timezone == $config.default_timezone}selected{/if}>
														{$timezone|escape}
													</option>
												{/foreach}
											</select>
											<div class="form-icon position-absolute">
												<img src="{$stheme}/images/svg/option.svg" alt="">
											</div>
										</fieldset>
									</div>
									<div class="col-12 col-md-6 mb-2">
										<div class="row">
											<div class="col-6">
												<label class="col-form-label">{$lang.sections.settingssection.general.template}:</label>
												<fieldset class="form-icon-group left-icon position-relative">
													<select class="form-select array-select form-control" name="skin">
														{foreach from=$skins item=skin}
															{if $skin == $config.skin}
																<option value="{$skin|escape}" selected>{$skin|escape}</option>
															{else}
																<option value="{$skin|escape}">{$skin|escape}</option>
															{/if}
														{/foreach}
													</select>

													<div class="form-icon position-absolute">
														<img src="{$stheme}/images/svg/option.svg" alt="">
													</div>
												</fieldset>
											</div>
											<div class="col-6">
												<label class="col-form-label">Тип капчи:</label>
												<fieldset class="form-icon-group left-icon position-relative">
													<select class="form-select array-select form-control" name="enabled_captcha">
														<option value="google" {if $config.captcha_settings.enabled_captcha == "google"}selected{/if}>Google Captcha</option>
														<option value="security_question" {if $config.captcha_settings.enabled_captcha != "google"}selected{/if}>Security Question</option>
													</select>

													<div class="form-icon position-absolute">
														<img src="{$stheme}/images/svg/option.svg" alt="">
													</div>
												</fieldset>
											</div>
										</div>
									</div>
									<div class="col-12 col-md-6 mb-2">
										<div class="row">
											<div class="col-6">
												<label class="col-form-label">{$lang.sections.settingssection.general.lang}:</label>
												<fieldset class="form-icon-group left-icon position-relative">
													<select class="form-select array-select form-control" name="default_lang">
														{foreach from=$default_langs item=default_lang}
															{if $default_lang == $config.default_lang}
																<!-- Если язык совпадает с текущим языком конфигурации, он выбран по умолчанию -->
																<option value="{$default_lang|escape}" selected>{$default_lang|escape}</option>
															{else}
																<!-- Все остальные языки выводятся как опции выбора -->
																<option value="{$default_lang|escape}">{$default_lang|escape}</option>
															{/if}
														{/foreach}
													</select>
													<div class="form-icon position-absolute">
														<img src="{$stheme}/images/svg/option.svg" alt="">
													</div>
												</fieldset>
											</div>
											<div class="col-6">
												<label class="col-form-label">Общий язык сессий:</label>
												<div class="form-check form-switch">
													<input type="hidden" name="lang_union" value="false">
													<input class="form-check-input offlineswitcher" type="checkbox" role="switch" name="lang_union" value="true" {if $config.lang_union == 'true'}checked{/if}>
												</div>
											</div>
										</div>


									</div>
									<div class="col-12 col-md-6 mb-2">
										<div class="row">
											<div class="col-12 col-md-6 mb-2">
												<label class="col-form-label">{$lang.sections.settingssection.general.switcher}:</label>
												<div class="form-check form-switch">
													<input type="hidden" name="site_offline" value="false">
													<input class="form-check-input offlineswitcher" type="checkbox" role="switch" name="site_offline" value="true" {if $config.site_offline == 'true'}checked{/if}>
												</div>
											</div>
											<div class="col-12 col-md-6 mb-2">
												<label class="col-form-label">{$lang.sections.settingssection.general.hometpl}:</label>
												<div class="form-check form-switch">
													<input type="hidden" name="home_tpl" value="false">
													<input class="form-check-input offlineswitcher" type="checkbox" role="switch" name="home_tpl" value="true" {if $config.home_tpl == 'true'}checked{/if}>
												</div>
											</div>
										</div>
									</div>
									<div class="col-12 col-md-6 mb-2">
										<label class="col-form-label">{$lang.sections.settingssection.general.description}:</label>
										<fieldset class="form-icon-group position-relative">
											<textarea class="form-control mt-2 mb-2" rows="4" name="description" spellcheck="false">{htmlspecialchars($config['description'])}</textarea>
										</fieldset>
									</div>
									<div class="col-12 col-md-6 mb-2">
										<label class="col-form-label">{$lang.sections.settingssection.general.keywords}:</label>
										<fieldset class="form-icon-group position-relative">
											<textarea class="form-control mt-2 mb-2" rows="4" name="keywords" spellcheck="false">{htmlspecialchars($config['keywords'])}</textarea>
										</fieldset>
									</div>
								</div>
							</div>
							<div class="tab-pane fade" id="tab2_optimization" role="tabpanel">

							{*	<button id="reinstall-cms" type="button" class="btn btn btn-danger">
									Reinstall CMS
								</button>
								<script>
									$("#reinstall-cms").on("click", function () {
										window.location.href = "/admin?action=reinstall-cms";
									})
								</script>*}
							</div>
							<div class="tab-pane fade" id="tab2_cms_install" role="tabpanel">
								<div class="container">
									<div class="row g-4">
										<!-- Блок обновления -->
										<div class="col-lg-6 mt-0">
											<div class="card shadow-lg border-success h-100">
												<div class="card-header bg-success text-white">
													<h3 class="mb-0"><i class="bi bi-cloud-arrow-up-fill me-2"></i>Обновление системы</h3>
												</div>
												<div class="card-body">
													<h2>Выберите исключения</h2>

													<!-- Вертикальный список чекбоксов -->

													<div class="form-check mb-3">
														<input class="form-check-input" type="checkbox" checked="checked" value="" id="exclude_config_file">
														<label class="form-check-label" for="exclude_config_file">
															Не обновить config и .env файл проекта (рекомендуется)
														</label>
													</div>
													<div class="form-check">
														<input class="form-check-input" type="checkbox" value="" id="exclude_templates">
														<label class="form-check-label" for="exclude_templates">
															Не обновить шаблоны
														</label>
													</div>
													<div class="form-check">
														<input class="form-check-input" type="checkbox" value="" id="exclude_lang_files">
														<label class="form-check-label" for="exclude_lang_files">
															Не обновить lang файлы
														</label>
													</div>
													{if !$isLastVersion}
														<div class="alert alert-warning d-flex align-items-center p-3 shadow-lg rounded" role="alert">
															<i class="bi bi-exclamation-triangle-fill me-2 fs-4"></i>
															<div>
																<strong>Доступно новое обновление!</strong>
																Рекомендуется установить последнюю версию для повышения безопасности и производительности.
															</div>
														</div>
													{/if}

													<button type="button" class="btn btn-success w-100" id="check_update">
														<i class="bi bi-rocket-takeoff me-2"></i>Обновить систему
													</button>

													<div class="mt-4 text-muted" style="display:none;" id="version_main">
														<small>Полное обновление до последней версии</small>

														<div class="d-flex justify-content-between align-items-center mt-2">
															<span>Последняя версия:</span>
															<span class="badge bg-success" id="version_block"></span>
														</div>
														<div class="d-flex justify-content-between align-items-center mt-2">
															<span>Ваша версия:</span>
															<span class="badge bg-success" id="client_version_block">{$clientVersion}</span>
														</div>
													</div>
													<a href="{$data.data.update_url}" class="mt-4 link-info" id="">
														<i class="bi bi-rocket-takeoff me-2"></i>Скачать последную версию
													</a>
												</div>
											</div>
										</div>

										<!-- Блок переустановки -->
										<div class="col-lg-6 mt-0">
											<div class="card shadow-lg border-danger h-80">
												<div class="card-header bg-danger text-white">
													<h3 class="mb-0"><i class="bi bi-arrow-repeat me-2"></i>Переустановка</h3>
												</div>
												<div class="card-body">
									{*				<ul class="list-unstyled mb-4">
														<li class="mb-3"><i class="bi bi-database-exclamation text-danger me-2"></i>Вернуть исходное состояние таблиц БД</li>
														<li class="mb-3"><i class="bi bi-translate text-danger me-2"></i>Вернуть исходное состояние lang</li>
														<li><i class="bi bi-files text-danger me-2"></i>Вернуть исходное состояние шаблонов</li>
													</ul>*}

													<div class="alert alert-warning d-flex align-items-center p-3 shadow-lg rounded" role="alert">
														<i class="bi bi-exclamation-triangle-fill me-2 fs-4"></i>
														<div>
															<strong class="mb-3">Предупреждение!</strong>
															Рекомендуется применить сохранение бэкапа БД перед переустановкой.
															<div class="form-check">
																<input class="form-check-input" type="checkbox" value="" id="save_db_backup">
																<label class="form-check-label" for="save_db_backup">
																	Сохранить структуру и данные БД
																</label>
															</div>
														</div>
													</div>


													<div class="form-check">
														<input class="form-check-input" type="checkbox" value="" id="save_system_config">
														<label class="form-check-label" for="save_system_config">
															Запомнить config файл системы
														</label>
													</div>
													<div class="form-check mb-3">
														<input class="form-check-input" type="checkbox" value="" id="full_restore_cms">
														<label class="form-check-label" for="full_restore_cms">
															Вернуть исходное состояние полностью
														</label>
													</div>
													<button class="btn btn-outline-danger w-100 reinstall_cms" type="button">
														<i class="bi bi-exclamation-octagon me-2"></i>Сбросить настройки
													</button>

													<div class="mt-4 text-muted">
														<div class="d-flex justify-content-between align-items-center mt-2">
															<span>Текущая версия:</span>
															<span class="badge bg-secondary">{$clientVersion}</span>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="tab-pane fade" id="tab2_email_settings" role="tabpanel">
								<div class="row">
									<div class="col-6">
										<h3>Email settings</h3>
										<div class="col-12 col-md-6 mb-2">
											<label for="username" class="col-form-label">username:</label>
											<fieldset class="form-icon-group left-icon position-relative">
												<input type="text" class="form-control" id="username" name="email_settings[username]" value="{htmlspecialchars($config['email_settings']['username'])}">
												<div class="form-icon position-absolute">
													<img src="{$stheme}/images/svg/option.svg" alt="">
												</div>
											</fieldset>
										</div>

										<div class="col-12 col-md-6 mb-2">
											<label for="password" class="col-form-label">password:</label>
											<fieldset class="form-icon-group left-icon position-relative">
												<input type="text" class="form-control" id="password" name="email_settings[password]" value="{htmlspecialchars($config['email_settings']['password'])}">
												<div class="form-icon position-absolute">
													<img src="{$stheme}/images/svg/option.svg" alt="">
												</div>
											</fieldset>
										</div>

										<div class="col-12 col-md-6 mb-2">
											<label for="smtp_secure" class="col-form-label">smtp_secure:</label>
											<fieldset class="form-icon-group left-icon position-relative">
												<input type="text" class="form-control" id="smtp_secure" name="email_settings[smtp_secure]" value="{htmlspecialchars($config['email_settings']['smtp_secure'])}">
												<div class="form-icon position-absolute">
													<img src="{$stheme}/images/svg/option.svg" alt="">
												</div>
											</fieldset>
										</div>

										<div class="col-12 col-md-6 mb-2">
											<label for="port" class="col-form-label">port:</label>
											<fieldset class="form-icon-group left-icon position-relative">
												<input type="text" class="form-control" id="port" name="email_settings[port]" value="{htmlspecialchars($config['email_settings']['port'])}">
												<div class="form-icon position-absolute">
													<img src="{$stheme}/images/svg/option.svg" alt="">
												</div>
											</fieldset>
										</div>
										
										<div class="col-12 col-md-6 mb-2">
											<label for="host" class="col-form-label">host:</label>
											<fieldset class="form-icon-group left-icon position-relative">
												<input type="text" class="form-control" id="host" name="email_settings[host]" value="{htmlspecialchars($config['email_settings']['host'])}">
												<div class="form-icon position-absolute">
													<img src="{$stheme}/images/svg/option.svg" alt="">
												</div>
											</fieldset>
										</div>
									</div>
									<div class="col-6">
										<h3>Email templates</h3>
										{if !empty($config["email_template_settings"])}
										{foreach $config["email_template_settings"] as $category => $templateData }
											<label for="{$category}" class="col-form-label">{$category}:</label>

											<fieldset class="form-icon-group left-icon position-relative">
												<select {if empty($templateData)} disabled {/if} class="form-select array-select form-control" id="{$category}" name="emailTemplates[{$category}]">
													{if empty($templateData)}
														<option selected value="">Пусто</option>
													{/if}
													{foreach $config["email_template_settings"][$category] as $key => $templateStatus }
														<option {if $templateStatus === true } selected {/if} value="{$key}">{$key}</option>
														{/foreach}
												</select>
												<div class="form-icon position-absolute">
													<img src="{$stheme}/images/svg/option.svg" alt="">
												</div>
											</fieldset>
											
											{/foreach}
											{/if}
									</div>
								</div>
							</div>
							<div class="tab-pane fade mb-3" id="tab2_payment_settings" role="tabpanel">
								<h3>Payment settings</h3>
								<div class="row">
									<div class="col-12 col-md-4 mb-2">
										<label for="default_currency" class="col-form-label">Default currency:</label>
										<fieldset class="form-icon-group left-icon position-relative">
											<input type="text" class="form-control" id="default_currency" name="payment_settings[default_currency]" value="{htmlspecialchars($config['payment_info']['default_currency'])}">
											<div class="form-icon position-absolute">
												<img src="{$stheme}/images/svg/option.svg" alt="">
											</div>
										</fieldset>
									</div>
									<div class="col-12 col-md-4 mb-2">
										<label for="default_discount_percent" class="col-form-label">Default discount percent:</label>
										<fieldset class="form-icon-group left-icon position-relative">
											<input type="text" class="form-control" id="default_discount_percent" placeholder="Discount percent" name="payment_settings[default_discount_percent]" value="{htmlspecialchars($config['payment_info']['default_discount_percent'])}">
											<div class="form-icon position-absolute">
												<img src="{$stheme}/images/svg/option.svg" alt="">
											</div>
										</fieldset>
									</div>
									<div class="col-12 col-md-4 mb-2">
										<label for="default_discount_sum" class="col-form-label">Default discount sum:</label>
										<fieldset class="form-icon-group left-icon position-relative">
											<input type="text" class="form-control" id="default_discount_sum" placeholder="Discount sum" name="payment_settings[default_discount_sum]" value="{htmlspecialchars($config['payment_info']['default_discount_sum'])}">
											<div class="form-icon position-absolute">
												<img src="{$stheme}/images/svg/option.svg" alt="">
											</div>
										</fieldset>
									</div>
								</div>
								<div class="row">
									<div class="col-3">
										<label class="col-form-label" for="included_currencies">Валюты по умолчанию:</label>
										<fieldset class="form-icon-group left-icon position-relative">
											<input type="text" class="form-control" name="included_currencies" id="included_currencies" value="{htmlspecialchars($config['payment_info']['included_currencies_str'])}">
											<div class="form-icon position-absolute">
												<img src="{$stheme}/images/svg/option.svg" alt="">
											</div>
										</fieldset>
									</div>
									<div class="col-12 col-md-4 mb-2">
										<label class="col-form-label" for="show_all_currencies">{*{$lang.sections.settingssection.general.hometpl}*}Загрузить все валюты:</label>
										<div class="form-check form-switch">
											<input TYPE="hidden" NAME="show_all_currencies" id="show_all_currencies" VALUE="false">
											<input class="form-check-input offlineswitcher" TYPE="checkbox" ROLE="switch" NAME="show_all_currencies" VALUE="true" {if $config.payment_info.show_all_currencies == true}checked{/if}>
										</div>
									</div>
								</div>
{*
								<div class="col-12 col-md-4 mb-2">
									<label for="password" class="col-form-label">password:</label>
									<fieldset class="form-icon-group left-icon position-relative">
										<input type="text" class="form-control" id="password" name="email_settings[password]" value="{htmlspecialchars($config['email_settings']['password'])}">
										<div class="form-icon position-absolute">
											<img src="{$stheme}/images/svg/option.svg" alt="">
										</div>
									</fieldset>
								</div>

								<div class="col-12 col-md-6 mb-2">
									<label for="smtp_secure" class="col-form-label">smtp_secure:</label>
									<fieldset class="form-icon-group left-icon position-relative">
										<input type="text" class="form-control" id="smtp_secure" name="email_settings[smtp_secure]" value="{htmlspecialchars($config['email_settings']['smtp_secure'])}">
										<div class="form-icon position-absolute">
											<img src="{$stheme}/images/svg/option.svg" alt="">
										</div>
									</fieldset>
								</div>

								<div class="col-12 col-md-6 mb-2">
									<label for="port" class="col-form-label">port:</label>
									<fieldset class="form-icon-group left-icon position-relative">
										<input type="text" class="form-control" id="port" name="email_settings[port]" value="{htmlspecialchars($config['email_settings']['port'])}">
										<div class="form-icon position-absolute">
											<img src="{$stheme}/images/svg/option.svg" alt="">
										</div>
									</fieldset>
								</div>

								<div class="col-12 col-md-6 mb-2">
									<label for="host" class="col-form-label">host:</label>
									<fieldset class="form-icon-group left-icon position-relative">
										<input type="text" class="form-control" id="host" name="email_settings[host]" value="{htmlspecialchars($config['email_settings']['host'])}">
										<div class="form-icon position-absolute">
											<img src="{$stheme}/images/svg/option.svg" alt="">
										</div>
									</fieldset>
								</div>*}
							</div>

							{if $adsAvailable && $adsUsed}
								{include file="../tpl/settings/ads.tpl"}
							{/if}
							{if $filesAvailable && $filesUsed}
								{include file="../tpl/settings/files.tpl"}
							{/if}
							{if $moviesAvailable && $moviesUsed}
								{include file="../tpl/settings/movies.tpl"}
							{/if}
							{if $newsAvailable && $newsUsed}
								{include file="../tpl/settings/news.tpl"}
							{/if}
							{if $productsAvailable && $productsUsed}
								{include file="../tpl/settings/products.tpl"}
							{/if}
							{if $eventsAvailable && $eventsUsed}
								{include file="../tpl/settings/events.tpl"}
							{/if}
							{if $lotsAvailable && $lotsUsed}
								{include file="../tpl/settings/lots.tpl"}
							{/if}
						</div>
						<div class="col-6" id="saveSettings">
							<button type="submit" class="btn btn-primary w-100">Сохранить</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
{/if}